package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTrafficMirrorFilterRules invokes the vpc.DeleteTrafficMirrorFilterRules API synchronously
func (client *Client) DeleteTrafficMirrorFilterRules(request *DeleteTrafficMirrorFilterRulesRequest) (response *DeleteTrafficMirrorFilterRulesResponse, err error) {
	response = CreateDeleteTrafficMirrorFilterRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTrafficMirrorFilterRulesWithChan invokes the vpc.DeleteTrafficMirrorFilterRules API asynchronously
func (client *Client) DeleteTrafficMirrorFilterRulesWithChan(request *DeleteTrafficMirrorFilterRulesRequest) (<-chan *DeleteTrafficMirrorFilterRulesResponse, <-chan error) {
	responseChan := make(chan *DeleteTrafficMirrorFilterRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTrafficMirrorFilterRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTrafficMirrorFilterRulesWithCallback invokes the vpc.DeleteTrafficMirrorFilterRules API asynchronously
func (client *Client) DeleteTrafficMirrorFilterRulesWithCallback(request *DeleteTrafficMirrorFilterRulesRequest, callback func(response *DeleteTrafficMirrorFilterRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTrafficMirrorFilterRulesResponse
		var err error
		defer close(result)
		response, err = client.DeleteTrafficMirrorFilterRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTrafficMirrorFilterRulesRequest is the request struct for api DeleteTrafficMirrorFilterRules
type DeleteTrafficMirrorFilterRulesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId            requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                string           `position:"Query" name:"ClientToken"`
	DryRun                     requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount       string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount               string           `position:"Query" name:"OwnerAccount"`
	OwnerId                    requests.Integer `position:"Query" name:"OwnerId"`
	TrafficMirrorFilterId      string           `position:"Query" name:"TrafficMirrorFilterId"`
	TrafficMirrorFilterRuleIds *[]string        `position:"Query" name:"TrafficMirrorFilterRuleIds"  type:"Repeated"`
}

// DeleteTrafficMirrorFilterRulesResponse is the response struct for api DeleteTrafficMirrorFilterRules
type DeleteTrafficMirrorFilterRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTrafficMirrorFilterRulesRequest creates a request to invoke DeleteTrafficMirrorFilterRules API
func CreateDeleteTrafficMirrorFilterRulesRequest() (request *DeleteTrafficMirrorFilterRulesRequest) {
	request = &DeleteTrafficMirrorFilterRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteTrafficMirrorFilterRules", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTrafficMirrorFilterRulesResponse creates a response to parse from DeleteTrafficMirrorFilterRules response
func CreateDeleteTrafficMirrorFilterRulesResponse() (response *DeleteTrafficMirrorFilterRulesResponse) {
	response = &DeleteTrafficMirrorFilterRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
