/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.unix.shell;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.helper.EnvironmentScope;

public abstract class Shell {
    protected String sp = " ";
    protected String sg = "=";
    protected String pr = "\"";
    protected String SETENV = "setenv" + this.sp;
    protected String EXPORT = "export ";
    protected String SET = "set ";

    protected File getShellScript(EnvironmentScope scope) {
        File file = null;
        if (scope != null && EnvironmentScope.PROCESS != scope) {
            if (EnvironmentScope.ALL_USERS == scope) {
                file = this.getSystemShellScript();
            }
            if (EnvironmentScope.CURRENT_USER == scope || file == null) {
                file = this.getUserShellScript();
            }
        }
        LogManager.log(4, "Used shell file for setting environment variable : " + file);
        return file;
    }

    protected abstract String[] getSystemShellFileNames();

    protected abstract String[] getUserShellFileNames();

    public abstract boolean setVar(String var1, String var2, EnvironmentScope var3) throws IOException;

    protected abstract String[] getAvailableNames();

    public boolean isCurrentShell(String name) {
        String[] names = this.getAvailableNames();
        boolean result = false;
        if (names != null && name != null) {
            for (String shname : names) {
                if (!shname.equals(name)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected File getUserShellScript() {
        return this.getSh(this.getUserShellFileNames(), SystemUtils.getUserHomeDirectory().getPath());
    }

    protected File getSystemShellScript() {
        return this.getSh(this.getSystemShellFileNames(), File.separator + "etc");
    }

    protected File getSh(String[] locations, String root) {
        if (locations == null) {
            return null;
        }
        File file = null;
        File firstFile = null;
        for (String loc : locations) {
            if (loc == null) continue;
            file = new File(!loc.startsWith(File.separator) ? root + File.separator + loc : loc);
            if (firstFile == null) {
                firstFile = file;
            }
            if (!file.exists()) continue;
            return file;
        }
        return firstFile;
    }

    protected int getSetEnvIndex(List<String> strings) {
        int idx = 0;
        int index = strings.size();
        for (String str : strings) {
            ++idx;
            if (!str.startsWith(this.SET) && !str.startsWith(this.EXPORT) && !str.startsWith(this.SETENV)) continue;
            index = idx;
        }
        return index;
    }

    protected List<String> getList(File file) throws IOException {
        return file.canRead() ? FileUtils.readStringList(file) : new LinkedList<String>();
    }

    protected boolean writeList(List<String> strings, File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            return false;
        }
        if (file.canWrite()) {
            FileUtils.writeStringList(file, strings);
            return true;
        }
        return false;
    }
}

