/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.openide.text.UndoRedoManager;

final class WrapUndoEdit
implements UndoableEdit {
    final UndoRedoManager undoRedoManager;
    private UndoableEdit delegate;

    WrapUndoEdit(UndoRedoManager undoRedoManager, UndoableEdit undoableEdit) {
        assert (undoableEdit != null) : "Delegate is null";
        this.undoRedoManager = undoRedoManager;
        this.delegate = undoableEdit;
    }

    UndoableEdit delegate() {
        return this.delegate;
    }

    void setDelegate(UndoableEdit undoableEdit) {
        this.delegate = undoableEdit;
    }

    @Override
    public void undo() throws CannotUndoException {
        this.undoRedoManager.checkLogOp("WrapUndoEdit.undo", this);
        boolean bl = this.undoRedoManager.isAtSavepoint();
        if (bl) {
            this.undoRedoManager.beforeUndoAtSavepoint(this);
        }
        boolean bl2 = false;
        try {
            this.delegate.undo();
            bl2 = true;
            this.undoRedoManager.afterUndoCheck(this);
        }
        finally {
            if (!bl2 && bl) {
                this.undoRedoManager.delegateUndoFailedAtSavepoint(this);
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.delegate.canUndo();
    }

    @Override
    public void redo() throws CannotRedoException {
        this.undoRedoManager.checkLogOp("WrapUndoEdit.redo", this);
        boolean bl = this.undoRedoManager.isAtSavepoint();
        if (bl) {
            this.undoRedoManager.beforeRedoAtSavepoint(this);
        }
        boolean bl2 = false;
        try {
            this.delegate.redo();
            bl2 = true;
            this.undoRedoManager.afterRedoCheck(this);
        }
        finally {
            if (!bl2 && bl) {
                this.undoRedoManager.delegateRedoFailedAtSavepoint(this);
            }
        }
    }

    @Override
    public boolean canRedo() {
        return this.delegate.canRedo();
    }

    @Override
    public void die() {
        this.undoRedoManager.checkLogOp("WrapUndoEdit.die", this);
        this.delegate.die();
        this.undoRedoManager.notifyWrapEditDie(this);
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        if (this.undoRedoManager.isAtSavepoint()) {
            this.undoRedoManager.mergeSaveActionsToLastEdit(this);
            return false;
        }
        WrapUndoEdit wrapUndoEdit = (WrapUndoEdit)undoableEdit;
        boolean bl = this.delegate.addEdit(wrapUndoEdit.delegate);
        return bl;
    }

    @Override
    public boolean replaceEdit(UndoableEdit undoableEdit) {
        if (this.undoRedoManager.isAtSavepoint()) {
            return false;
        }
        WrapUndoEdit wrapUndoEdit = (WrapUndoEdit)undoableEdit;
        boolean bl = this.delegate.replaceEdit(wrapUndoEdit.delegate);
        this.undoRedoManager.checkLogOp("WrapUndoEdit.replaceEdit=" + bl, undoableEdit);
        if (bl) {
            this.undoRedoManager.checkReplaceSavepointEdit(wrapUndoEdit, this);
        }
        return bl;
    }

    @Override
    public boolean isSignificant() {
        return this.delegate.isSignificant();
    }

    @Override
    public String getPresentationName() {
        return this.delegate.getPresentationName();
    }

    @Override
    public String getUndoPresentationName() {
        return this.delegate.getUndoPresentationName();
    }

    @Override
    public String getRedoPresentationName() {
        return this.delegate.getRedoPresentationName();
    }
}

