/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ModuleStateSelector
extends BaseExtendSelector {
    private boolean acceptAutoload;
    private boolean acceptEager;
    private boolean acceptEnabled;
    private boolean acceptDisabled;
    private HashMap<String, String> fileToOwningModule;

    public boolean isSelected(File dir, String filename, File file) throws BuildException {
        this.validate();
        Boolean check = this.checkSelected(dir, file);
        if (check == null) {
            return false;
        }
        return check;
    }

    private Boolean checkSelected(File dir, File file) throws BuildException {
        int slash;
        if (file.isDirectory()) {
            this.log("Skipping directory: " + file, 3);
            return null;
        }
        String module = null;
        if (file.getName().endsWith(".jar") && (slash = (module = file.getName().substring(0, file.getName().length() - 4).replace('-', '.')).indexOf(47)) >= 0) {
            module = module.substring(0, slash);
        }
        try {
            return this.readConfig(this.getProject(), module, file);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    static boolean clusterMatch(Collection<String> enabledClusters, String clusterName) {
        String baseName = ModuleStateSelector.clusterBaseName(clusterName);
        for (String c : enabledClusters) {
            if (!ModuleStateSelector.clusterBaseName(c).equals(baseName)) continue;
            return true;
        }
        return false;
    }

    static String clusterBaseName(String clusterName) {
        return clusterName.replaceFirst("[0-9.]+$", "");
    }

    public void verifySettings() {
        Parameter[] arr = this.getParameters();
        if (arr == null) {
            return;
        }
        for (Parameter p : arr) {
            if ("acceptAutoload".equals(p.getName())) {
                this.acceptAutoload = Boolean.valueOf(p.getValue());
                continue;
            }
            if ("acceptEager".equals(p.getName())) {
                this.acceptEager = Boolean.valueOf(p.getValue());
                continue;
            }
            if ("acceptEnabled".equals(p.getName())) {
                this.acceptEnabled = Boolean.valueOf(p.getValue());
                continue;
            }
            if ("acceptDisabled".equals(p.getName())) {
                this.acceptDisabled = Boolean.valueOf(p.getValue());
                continue;
            }
            this.setError("Unknown parameter: " + p.getName());
        }
    }

    private boolean readConfig(Project p, String cnb, File jar) throws SAXException, IOException, ParserConfigurationException {
        File info = new File(new File(new File(jar.getParentFile().getParentFile(), "config"), "Modules"), cnb.replace('.', '-') + ".xml");
        if (!info.exists()) {
            throw new BuildException("Cannot find " + info + " for " + jar);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        class MyHandler
        extends DefaultHandler
        implements EntityResolver {
            Boolean eager;
            Boolean autoload;
            Boolean enabled;
            Boolean lastResult;
            String lastName;

            MyHandler() {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.lastResult = null;
                this.lastName = attributes.getValue("name");
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                String t = new String(ch, start, length).trim();
                if ("true".equals(t)) {
                    this.lastResult = Boolean.TRUE;
                }
                if ("false".equals(t)) {
                    this.lastResult = Boolean.FALSE;
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (this.lastName == null) {
                    return;
                }
                if (this.lastName.equals("eager")) {
                    this.eager = this.lastResult;
                }
                if (this.lastName.equals("autoload")) {
                    this.autoload = this.lastResult;
                }
                if (this.lastName.equals("enabled")) {
                    this.enabled = this.lastResult;
                }
                this.lastName = null;
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        }
        MyHandler handler = new MyHandler();
        parser.parse(info, (DefaultHandler)handler);
        if (this.acceptAutoload && Boolean.TRUE.equals(handler.autoload)) {
            return true;
        }
        if (this.acceptEager && Boolean.TRUE.equals(handler.eager)) {
            return true;
        }
        if (this.acceptEnabled && Boolean.TRUE.equals(handler.enabled)) {
            return true;
        }
        return this.acceptDisabled && Boolean.FALSE.equals(handler.enabled);
    }
}

