#ifndef OPENMITTSU_TASKS_CHECKFEATURELEVELCALLBACKTASK_H_
#define OPENMITTSU_TASKS_CHECKFEATURELEVELCALLBACKTASK_H_

#include "src/messages/MessageWithEncryptedPayload.h"
#include "src/protocol/ContactId.h"
#include "src/protocol/FeatureLevel.h"
#include "src/network/ServerConfiguration.h"
#include "src/crypto/PublicKey.h"

#include "src/tasks/CallbackTask.h"
#include "src/tasks/CertificateBasedCallbackTask.h"

#include <QString>
#include <QByteArray>
#include <QHash>
#include <QList>
#include <QSslCertificate>
#include <memory>

namespace openmittsu {
	namespace tasks {

		class CheckFeatureLevelCallbackTask : public CertificateBasedCallbackTask, public CallbackTask {
		public:
			CheckFeatureLevelCallbackTask(std::shared_ptr<openmittsu::network::ServerConfiguration> const& serverConfiguration, QSet<openmittsu::protocol::ContactId> const& identitiesToCheck);
			virtual ~CheckFeatureLevelCallbackTask();

			QSet<openmittsu::protocol::ContactId> const& getContactIds() const;
			QHash<openmittsu::protocol::ContactId, openmittsu::protocol::FeatureLevel> const& getFetchedFeatureLevels() const;
		protected:
			virtual void taskRun() override;
		private:
			QString const m_urlString;
			QString const m_agentString;
			QSet<openmittsu::protocol::ContactId> const m_identitiesToFetch;

			QHash<openmittsu::protocol::ContactId, openmittsu::protocol::FeatureLevel> m_fetchedFeatureLevels;
		};

	}
}

#endif // OPENMITTSU_TASKS_CHECKFEATURELEVELCALLBACKTASK_H_
