//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "dispatch2")]
use dispatch2::*;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// This is the handle to an open a dynamic store session
/// with the system configuration daemon.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scdynamicstore?language=objc)
#[doc(alias = "SCDynamicStoreRef")]
#[repr(C)]
pub struct SCDynamicStore {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl SCDynamicStore {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__SCDynamicStore"> for SCDynamicStore {}
);

/// Structure containing user-specified data and callbacks for an
/// SCDynamicStore session.
/// Field: version The version number of the structure type being passed
/// in as a parameter to the SCDynamicStore creation function.
/// This structure is version 0.
/// Field: info A C pointer to a user-specified block of data.
/// Field: retain The callback used to add a retain for the info field.
/// If this parameter is not a pointer to a function of the correct
/// prototype, the behavior is undefined.  The value may be NULL.
/// Field: release The calllback used to remove a retain previously added
/// for the info field.  If this parameter is not a pointer to a
/// function of the correct prototype, the behavior is undefined.
/// The value may be NULL.
/// Field: copyDescription The callback used to provide a description of
/// the info field.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scdynamicstorecontext?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct SCDynamicStoreContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> NonNull<c_void>>,
    pub release: Option<unsafe extern "C-unwind" fn(NonNull<c_void>)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> NonNull<CFString>>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for SCDynamicStoreContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> NonNull<c_void>>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(NonNull<c_void>)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> NonNull<CFString>>>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for SCDynamicStoreContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Type of callback function used when notification of
/// changes to the dynamic store is delivered.
///
/// Parameter `store`: The dynamic store session.
///
/// Parameter `changedKeys`: The list of changed keys.
///
/// The list includes any specific SCDynamicStore keys that
/// changed (add, update, remove, notify) since the last call
/// to SCDynamicStoreSetNotificationKeys or since the last
/// notification callback. The list also includes any specific
/// keys matching one of the pattern string(s) that changed.
///
/// An empty list indicates that the SCDynamicStore server
/// restarted and that any assumptions based on prior content
/// of the SCDynamicStore should be discarded.
///
///
/// Parameter `info`: A C pointer to a user-specified block of data.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scdynamicstorecallback?language=objc)
pub type SCDynamicStoreCallBack =
    Option<unsafe extern "C-unwind" fn(NonNull<SCDynamicStore>, NonNull<CFArray>, *mut c_void)>;

unsafe impl ConcreteType for SCDynamicStore {
    /// Returns the type identifier of all SCDynamicStore instances.
    #[doc(alias = "SCDynamicStoreGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn SCDynamicStoreGetTypeID() -> CFTypeID;
        }
        unsafe { SCDynamicStoreGetTypeID() }
    }
}

impl SCDynamicStore {
    /// Creates a new session used to interact with the dynamic
    /// store maintained by the System Configuration server.
    ///
    /// Parameter `allocator`: The CFAllocator that should be used to allocate
    /// memory for the local dynamic store object.
    /// This parameter may be NULL in which case the current
    /// default CFAllocator is used. If this reference is not
    /// a valid CFAllocator, the behavior is undefined.
    ///
    /// Parameter `name`: A string that describes the name of the calling
    /// process or plug-in of the caller.
    ///
    /// Parameter `callout`: The function to be called when a watched value
    /// in the dynamic store is changed.
    /// A NULL value can be specified if no callouts are
    /// desired.
    ///
    /// Parameter `context`: The SCDynamicStoreContext associated with the callout.
    ///
    /// Returns: Returns a reference to the new SCDynamicStore session.
    /// You must release the returned value.
    ///
    /// # Safety
    ///
    /// - `callout` must be implemented correctly.
    /// - `context` must be a valid pointer or null.
    #[doc(alias = "SCDynamicStoreCreate")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        name: &CFString,
        callout: SCDynamicStoreCallBack,
        context: *mut SCDynamicStoreContext,
    ) -> Option<CFRetained<SCDynamicStore>> {
        extern "C-unwind" {
            fn SCDynamicStoreCreate(
                allocator: Option<&CFAllocator>,
                name: &CFString,
                callout: SCDynamicStoreCallBack,
                context: *mut SCDynamicStoreContext,
            ) -> Option<NonNull<SCDynamicStore>>;
        }
        let ret = unsafe { SCDynamicStoreCreate(allocator, name, callout, context) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Creates a new session used to interact with the dynamic
    /// store maintained by the System Configuration server.
    ///
    /// Parameter `allocator`: The CFAllocator that should be used to allocate
    /// memory for the local dynamic store object.
    /// This parameter may be NULL in which case the current
    /// default CFAllocator is used. If this reference is not
    /// a valid CFAllocator, the behavior is undefined.
    ///
    /// Parameter `name`: A string that describes the name of the calling
    /// process or plug-in of the caller.
    ///
    /// Parameter `storeOptions`: A CFDictionary containing options for the
    /// dynamic store session (such as whether all keys added or set
    /// into the dynamic store should be per-session keys).
    ///
    /// Currently available options include:
    ///
    /// <TABLE
    /// BORDER>
    /// <TR
    /// >
    /// <TH
    /// >key
    /// </TD
    /// >
    /// <TH
    /// >value
    /// </TD
    /// >
    /// </TR
    /// >
    /// <TR
    /// >
    /// <TD
    /// >kSCDynamicStoreUseSessionKeys
    /// </TD
    /// >
    /// <TD
    /// >CFBooleanRef
    /// </TD
    /// >
    /// </TR
    /// >
    /// </TABLE
    /// >
    ///
    /// A NULL value can be specified if no options are desired.
    ///
    /// Parameter `callout`: The function to be called when a watched value
    /// in the dynamic store is changed.
    /// A NULL value can be specified if no callouts are
    /// desired.
    ///
    /// Parameter `context`: The SCDynamicStoreContext associated with the callout.
    ///
    /// Returns: Returns a reference to the new SCDynamicStore session.
    /// You must release the returned value.
    ///
    /// # Safety
    ///
    /// - `store_options` generics must be of the correct type.
    /// - `callout` must be implemented correctly.
    /// - `context` must be a valid pointer or null.
    #[doc(alias = "SCDynamicStoreCreateWithOptions")]
    #[inline]
    pub unsafe fn with_options(
        allocator: Option<&CFAllocator>,
        name: &CFString,
        store_options: Option<&CFDictionary>,
        callout: SCDynamicStoreCallBack,
        context: *mut SCDynamicStoreContext,
    ) -> Option<CFRetained<SCDynamicStore>> {
        extern "C-unwind" {
            fn SCDynamicStoreCreateWithOptions(
                allocator: Option<&CFAllocator>,
                name: &CFString,
                store_options: Option<&CFDictionary>,
                callout: SCDynamicStoreCallBack,
                context: *mut SCDynamicStoreContext,
            ) -> Option<NonNull<SCDynamicStore>>;
        }
        let ret = unsafe {
            SCDynamicStoreCreateWithOptions(allocator, name, store_options, callout, context)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscdynamicstoreusesessionkeys?language=objc)
    pub static kSCDynamicStoreUseSessionKeys: &'static CFString;
}

impl SCDynamicStore {
    /// Creates a CFRunLoopSource object that can be added to the
    /// application's run loop.  All dynamic store notifications are
    /// delivered using this run loop source.
    ///
    /// Parameter `allocator`: The CFAllocator that should be used to allocate
    /// memory for this run loop source.
    /// This parameter may be NULL in which case the current
    /// default CFAllocator is used. If this reference is not
    /// a valid CFAllocator, the behavior is undefined.
    ///
    /// Parameter `store`: A reference to the dynamic store session.
    ///
    /// Parameter `order`: On platforms which support it, for source versions
    /// which support it, this parameter determines the order in
    /// which the sources which are ready to be processed are
    /// handled. A lower order number causes processing before
    /// higher order number sources. It is inadvisable to depend
    /// on the order number for any architectural or design aspect
    /// of code. In the absence of any reason to do otherwise,
    /// zero should be used.
    ///
    /// Returns: A reference to the new CFRunLoopSource.
    /// You must release the returned value.
    #[doc(alias = "SCDynamicStoreCreateRunLoopSource")]
    #[inline]
    pub fn new_run_loop_source(
        allocator: Option<&CFAllocator>,
        store: &SCDynamicStore,
        order: CFIndex,
    ) -> Option<CFRetained<CFRunLoopSource>> {
        extern "C-unwind" {
            fn SCDynamicStoreCreateRunLoopSource(
                allocator: Option<&CFAllocator>,
                store: &SCDynamicStore,
                order: CFIndex,
            ) -> Option<NonNull<CFRunLoopSource>>;
        }
        let ret = unsafe { SCDynamicStoreCreateRunLoopSource(allocator, store, order) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Initiates notifications for the Notification
    /// Keys in store to the callback contained in store.
    ///
    /// Parameter `store`: A reference to the dynamic store session.
    ///
    /// Parameter `queue`: The dispatch queue to run the callback function on.
    /// Pass NULL to disable notifications, and release the queue.
    ///
    /// Returns: Returns TRUE on success, FALSE on failure.
    ///
    /// # Safety
    ///
    /// `queue` possibly has additional threading requirements.
    #[doc(alias = "SCDynamicStoreSetDispatchQueue")]
    #[cfg(feature = "dispatch2")]
    #[inline]
    pub unsafe fn set_dispatch_queue(&self, queue: Option<&DispatchQueue>) -> bool {
        extern "C-unwind" {
            fn SCDynamicStoreSetDispatchQueue(
                store: &SCDynamicStore,
                queue: Option<&DispatchQueue>,
            ) -> Boolean;
        }
        let ret = unsafe { SCDynamicStoreSetDispatchQueue(self, queue) };
        ret != 0
    }

    /// Returns an array of CFString keys representing the
    /// current dynamic store entries that match a specified pattern.
    ///
    /// Parameter `store`: The dynamic store session.
    ///
    /// Parameter `pattern`: A regex(3) regular expression pattern
    /// used to match the dynamic store keys.
    ///
    /// Returns: Returns the list of matching keys; NULL if an error was
    /// encountered.
    /// You must release the returned value.
    #[doc(alias = "SCDynamicStoreCopyKeyList")]
    #[inline]
    pub fn key_list(
        store: Option<&SCDynamicStore>,
        pattern: &CFString,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCDynamicStoreCopyKeyList(
                store: Option<&SCDynamicStore>,
                pattern: &CFString,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCDynamicStoreCopyKeyList(store, pattern) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Adds the key-value pair to the dynamic store if no
    /// such key already exists.
    ///
    /// Parameter `store`: The dynamic store session.
    ///
    /// Parameter `key`: The key of the value to add to the dynamic store.
    ///
    /// Parameter `value`: The value to add to the dynamic store.
    ///
    /// Returns: Returns TRUE if the key was added; FALSE if the key was already
    /// present in the dynamic store or if an error was encountered.
    ///
    /// # Safety
    ///
    /// `value` should be of the correct type.
    #[doc(alias = "SCDynamicStoreAddValue")]
    #[inline]
    pub unsafe fn add_value(
        store: Option<&SCDynamicStore>,
        key: &CFString,
        value: &CFPropertyList,
    ) -> bool {
        extern "C-unwind" {
            fn SCDynamicStoreAddValue(
                store: Option<&SCDynamicStore>,
                key: &CFString,
                value: &CFPropertyList,
            ) -> Boolean;
        }
        let ret = unsafe { SCDynamicStoreAddValue(store, key, value) };
        ret != 0
    }

    /// Temporarily adds the key-value pair to the dynamic store
    /// if no such key already exists.  Unless the key is updated by another
    /// session, the key-value pair will be removed automatically when the
    /// session is closed.
    ///
    /// Parameter `store`: The dynamic store session.
    ///
    /// Parameter `key`: The key of the value to add to the dynamic store.
    ///
    /// Parameter `value`: The value to add to the dynamic store.
    ///
    /// Returns: Returns TRUE if the key was added; FALSE if the key was already
    /// present in the dynamic store or if an error was encountered.
    ///
    /// # Safety
    ///
    /// `value` should be of the correct type.
    #[doc(alias = "SCDynamicStoreAddTemporaryValue")]
    #[inline]
    pub unsafe fn add_temporary_value(&self, key: &CFString, value: &CFPropertyList) -> bool {
        extern "C-unwind" {
            fn SCDynamicStoreAddTemporaryValue(
                store: &SCDynamicStore,
                key: &CFString,
                value: &CFPropertyList,
            ) -> Boolean;
        }
        let ret = unsafe { SCDynamicStoreAddTemporaryValue(self, key, value) };
        ret != 0
    }

    /// Gets the value of the specified key from the dynamic store.
    ///
    /// Parameter `store`: The dynamic store session.
    ///
    /// Parameter `key`: The key associated with the value you want to get.
    ///
    /// Returns: Returns the value from the dynamic store that is associated with the given
    /// key; NULL if no value was located or an error was encountered.
    /// You must release the returned value.
    #[doc(alias = "SCDynamicStoreCopyValue")]
    #[inline]
    pub fn value(
        store: Option<&SCDynamicStore>,
        key: &CFString,
    ) -> Option<CFRetained<CFPropertyList>> {
        extern "C-unwind" {
            fn SCDynamicStoreCopyValue(
                store: Option<&SCDynamicStore>,
                key: &CFString,
            ) -> Option<NonNull<CFPropertyList>>;
        }
        let ret = unsafe { SCDynamicStoreCopyValue(store, key) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Gets the values of multiple keys in the dynamic store.
    ///
    /// Parameter `store`: The dynamic store session.
    ///
    /// Parameter `keys`: The keys associated with the values you want to get; NULL if no specific
    /// keys are requested.
    ///
    /// Parameter `patterns`: An array of regex(3) pattern strings used to match the keys; NULL
    /// if no key patterns are requested.
    ///
    /// Returns: Returns a dictionary containing the key-value pairs of specific keys and the
    /// key-value pairs of keys that matched the specified patterns;
    /// NULL if an error was encountered.
    /// You must release the returned value.
    ///
    /// # Safety
    ///
    /// - `keys` generic must be of the correct type.
    /// - `patterns` generic must be of the correct type.
    #[doc(alias = "SCDynamicStoreCopyMultiple")]
    #[inline]
    pub unsafe fn multiple(
        store: Option<&SCDynamicStore>,
        keys: Option<&CFArray>,
        patterns: Option<&CFArray>,
    ) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn SCDynamicStoreCopyMultiple(
                store: Option<&SCDynamicStore>,
                keys: Option<&CFArray>,
                patterns: Option<&CFArray>,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { SCDynamicStoreCopyMultiple(store, keys, patterns) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Adds or replaces a value in the dynamic store for
    /// the specified key.
    ///
    /// Parameter `store`: The dynamic store session.
    ///
    /// Parameter `key`: The key you want to set.
    ///
    /// Parameter `value`: The value to add to or replace in the dynamic store.
    ///
    /// Returns: Returns TRUE if the key was updated; FALSE if an error was encountered.
    ///
    /// # Safety
    ///
    /// `value` should be of the correct type.
    #[doc(alias = "SCDynamicStoreSetValue")]
    #[inline]
    pub unsafe fn set_value(
        store: Option<&SCDynamicStore>,
        key: &CFString,
        value: &CFPropertyList,
    ) -> bool {
        extern "C-unwind" {
            fn SCDynamicStoreSetValue(
                store: Option<&SCDynamicStore>,
                key: &CFString,
                value: &CFPropertyList,
            ) -> Boolean;
        }
        let ret = unsafe { SCDynamicStoreSetValue(store, key, value) };
        ret != 0
    }

    /// Updates multiple values in the dynamic store.
    ///
    /// Parameter `store`: The dynamic store session.
    ///
    /// Parameter `keysToSet`: A dictionary of key-value pairs you want to set into the dynamic store.
    ///
    /// Parameter `keysToRemove`: An array of keys you want to remove from the dynamic store.
    ///
    /// Parameter `keysToNotify`: An array of keys to flag as changed (without changing their values).
    ///
    /// Returns: Returns TRUE if the dynamic store updates were successful; FALSE if an error was encountered.
    ///
    /// # Safety
    ///
    /// - `keys_to_set` generics must be of the correct type.
    /// - `keys_to_remove` generic must be of the correct type.
    /// - `keys_to_notify` generic must be of the correct type.
    #[doc(alias = "SCDynamicStoreSetMultiple")]
    #[inline]
    pub unsafe fn set_multiple(
        store: Option<&SCDynamicStore>,
        keys_to_set: Option<&CFDictionary>,
        keys_to_remove: Option<&CFArray>,
        keys_to_notify: Option<&CFArray>,
    ) -> bool {
        extern "C-unwind" {
            fn SCDynamicStoreSetMultiple(
                store: Option<&SCDynamicStore>,
                keys_to_set: Option<&CFDictionary>,
                keys_to_remove: Option<&CFArray>,
                keys_to_notify: Option<&CFArray>,
            ) -> Boolean;
        }
        let ret = unsafe {
            SCDynamicStoreSetMultiple(store, keys_to_set, keys_to_remove, keys_to_notify)
        };
        ret != 0
    }

    /// Removes the value of the specified key from the
    /// dynamic store.
    ///
    /// Parameter `store`: The dynamic store session.
    ///
    /// Parameter `key`: The key of the value you want to remove.
    ///
    /// Returns: Returns TRUE if the key was removed; FALSE if no value was
    /// located or an error was encountered.
    #[doc(alias = "SCDynamicStoreRemoveValue")]
    #[inline]
    pub fn remove_value(store: Option<&SCDynamicStore>, key: &CFString) -> bool {
        extern "C-unwind" {
            fn SCDynamicStoreRemoveValue(store: Option<&SCDynamicStore>, key: &CFString)
                -> Boolean;
        }
        let ret = unsafe { SCDynamicStoreRemoveValue(store, key) };
        ret != 0
    }

    /// Triggers a notification to be delivered for the
    /// specified key in the dynamic store.
    ///
    /// Parameter `store`: The dynamic store session.
    ///
    /// Parameter `key`: The key that should be flagged as changed.  Any dynamic store sessions
    /// that are monitoring this key will received a notification.  Note that the
    /// key's value is not updated.
    ///
    /// Returns: Returns TRUE if the notification was processed; FALSE if an error was encountered.
    #[doc(alias = "SCDynamicStoreNotifyValue")]
    #[inline]
    pub fn notify_value(store: Option<&SCDynamicStore>, key: &CFString) -> bool {
        extern "C-unwind" {
            fn SCDynamicStoreNotifyValue(store: Option<&SCDynamicStore>, key: &CFString)
                -> Boolean;
        }
        let ret = unsafe { SCDynamicStoreNotifyValue(store, key) };
        ret != 0
    }

    /// Specifies a set of specific keys and key patterns
    /// that should be monitored for changes.
    ///
    /// Parameter `store`: The dynamic store session being watched.
    ///
    /// Parameter `keys`: An array of keys to be monitored; NULL if no specific keys
    /// are to be monitored.
    ///
    /// Parameter `patterns`: An array of regex(3) pattern strings used to match keys to be monitored;
    /// NULL if no key patterns are to be monitored.
    ///
    /// Returns: Returns TRUE if the set of notification keys and patterns was successfully
    /// updated; FALSE if an error was encountered.
    ///
    /// # Safety
    ///
    /// - `keys` generic must be of the correct type.
    /// - `patterns` generic must be of the correct type.
    #[doc(alias = "SCDynamicStoreSetNotificationKeys")]
    #[inline]
    pub unsafe fn set_notification_keys(
        &self,
        keys: Option<&CFArray>,
        patterns: Option<&CFArray>,
    ) -> bool {
        extern "C-unwind" {
            fn SCDynamicStoreSetNotificationKeys(
                store: &SCDynamicStore,
                keys: Option<&CFArray>,
                patterns: Option<&CFArray>,
            ) -> Boolean;
        }
        let ret = unsafe { SCDynamicStoreSetNotificationKeys(self, keys, patterns) };
        ret != 0
    }

    /// Returns an array of CFString keys representing the
    /// dynamic store entries that have changed since this
    /// function was last called.  If possible, your application should
    /// use the notification functions instead of polling for the list
    /// of changed keys returned by this function.
    ///
    /// Parameter `store`: The dynamic store session.
    ///
    /// Returns: Returns the list of changed keys;
    /// NULL if an error was encountered.
    /// You must release the returned value.
    #[doc(alias = "SCDynamicStoreCopyNotifiedKeys")]
    #[inline]
    pub fn notified_keys(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCDynamicStoreCopyNotifiedKeys(store: &SCDynamicStore) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCDynamicStoreCopyNotifiedKeys(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

#[deprecated = "renamed to `SCDynamicStore::new`"]
#[inline]
pub unsafe extern "C-unwind" fn SCDynamicStoreCreate(
    allocator: Option<&CFAllocator>,
    name: &CFString,
    callout: SCDynamicStoreCallBack,
    context: *mut SCDynamicStoreContext,
) -> Option<CFRetained<SCDynamicStore>> {
    extern "C-unwind" {
        fn SCDynamicStoreCreate(
            allocator: Option<&CFAllocator>,
            name: &CFString,
            callout: SCDynamicStoreCallBack,
            context: *mut SCDynamicStoreContext,
        ) -> Option<NonNull<SCDynamicStore>>;
    }
    let ret = unsafe { SCDynamicStoreCreate(allocator, name, callout, context) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCDynamicStore::with_options`"]
#[inline]
pub unsafe extern "C-unwind" fn SCDynamicStoreCreateWithOptions(
    allocator: Option<&CFAllocator>,
    name: &CFString,
    store_options: Option<&CFDictionary>,
    callout: SCDynamicStoreCallBack,
    context: *mut SCDynamicStoreContext,
) -> Option<CFRetained<SCDynamicStore>> {
    extern "C-unwind" {
        fn SCDynamicStoreCreateWithOptions(
            allocator: Option<&CFAllocator>,
            name: &CFString,
            store_options: Option<&CFDictionary>,
            callout: SCDynamicStoreCallBack,
            context: *mut SCDynamicStoreContext,
        ) -> Option<NonNull<SCDynamicStore>>;
    }
    let ret = unsafe {
        SCDynamicStoreCreateWithOptions(allocator, name, store_options, callout, context)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCDynamicStore::new_run_loop_source`"]
#[inline]
pub extern "C-unwind" fn SCDynamicStoreCreateRunLoopSource(
    allocator: Option<&CFAllocator>,
    store: &SCDynamicStore,
    order: CFIndex,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn SCDynamicStoreCreateRunLoopSource(
            allocator: Option<&CFAllocator>,
            store: &SCDynamicStore,
            order: CFIndex,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe { SCDynamicStoreCreateRunLoopSource(allocator, store, order) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "dispatch2")]
#[deprecated = "renamed to `SCDynamicStore::set_dispatch_queue`"]
#[inline]
pub unsafe extern "C-unwind" fn SCDynamicStoreSetDispatchQueue(
    store: &SCDynamicStore,
    queue: Option<&DispatchQueue>,
) -> bool {
    extern "C-unwind" {
        fn SCDynamicStoreSetDispatchQueue(
            store: &SCDynamicStore,
            queue: Option<&DispatchQueue>,
        ) -> Boolean;
    }
    let ret = unsafe { SCDynamicStoreSetDispatchQueue(store, queue) };
    ret != 0
}

#[deprecated = "renamed to `SCDynamicStore::key_list`"]
#[inline]
pub extern "C-unwind" fn SCDynamicStoreCopyKeyList(
    store: Option<&SCDynamicStore>,
    pattern: &CFString,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCDynamicStoreCopyKeyList(
            store: Option<&SCDynamicStore>,
            pattern: &CFString,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCDynamicStoreCopyKeyList(store, pattern) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCDynamicStore::add_value`"]
#[inline]
pub unsafe extern "C-unwind" fn SCDynamicStoreAddValue(
    store: Option<&SCDynamicStore>,
    key: &CFString,
    value: &CFPropertyList,
) -> bool {
    extern "C-unwind" {
        fn SCDynamicStoreAddValue(
            store: Option<&SCDynamicStore>,
            key: &CFString,
            value: &CFPropertyList,
        ) -> Boolean;
    }
    let ret = unsafe { SCDynamicStoreAddValue(store, key, value) };
    ret != 0
}

#[deprecated = "renamed to `SCDynamicStore::add_temporary_value`"]
#[inline]
pub unsafe extern "C-unwind" fn SCDynamicStoreAddTemporaryValue(
    store: &SCDynamicStore,
    key: &CFString,
    value: &CFPropertyList,
) -> bool {
    extern "C-unwind" {
        fn SCDynamicStoreAddTemporaryValue(
            store: &SCDynamicStore,
            key: &CFString,
            value: &CFPropertyList,
        ) -> Boolean;
    }
    let ret = unsafe { SCDynamicStoreAddTemporaryValue(store, key, value) };
    ret != 0
}

#[deprecated = "renamed to `SCDynamicStore::value`"]
#[inline]
pub extern "C-unwind" fn SCDynamicStoreCopyValue(
    store: Option<&SCDynamicStore>,
    key: &CFString,
) -> Option<CFRetained<CFPropertyList>> {
    extern "C-unwind" {
        fn SCDynamicStoreCopyValue(
            store: Option<&SCDynamicStore>,
            key: &CFString,
        ) -> Option<NonNull<CFPropertyList>>;
    }
    let ret = unsafe { SCDynamicStoreCopyValue(store, key) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCDynamicStore::multiple`"]
#[inline]
pub unsafe extern "C-unwind" fn SCDynamicStoreCopyMultiple(
    store: Option<&SCDynamicStore>,
    keys: Option<&CFArray>,
    patterns: Option<&CFArray>,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCDynamicStoreCopyMultiple(
            store: Option<&SCDynamicStore>,
            keys: Option<&CFArray>,
            patterns: Option<&CFArray>,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCDynamicStoreCopyMultiple(store, keys, patterns) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCDynamicStore::set_value`"]
#[inline]
pub unsafe extern "C-unwind" fn SCDynamicStoreSetValue(
    store: Option<&SCDynamicStore>,
    key: &CFString,
    value: &CFPropertyList,
) -> bool {
    extern "C-unwind" {
        fn SCDynamicStoreSetValue(
            store: Option<&SCDynamicStore>,
            key: &CFString,
            value: &CFPropertyList,
        ) -> Boolean;
    }
    let ret = unsafe { SCDynamicStoreSetValue(store, key, value) };
    ret != 0
}

#[deprecated = "renamed to `SCDynamicStore::set_multiple`"]
#[inline]
pub unsafe extern "C-unwind" fn SCDynamicStoreSetMultiple(
    store: Option<&SCDynamicStore>,
    keys_to_set: Option<&CFDictionary>,
    keys_to_remove: Option<&CFArray>,
    keys_to_notify: Option<&CFArray>,
) -> bool {
    extern "C-unwind" {
        fn SCDynamicStoreSetMultiple(
            store: Option<&SCDynamicStore>,
            keys_to_set: Option<&CFDictionary>,
            keys_to_remove: Option<&CFArray>,
            keys_to_notify: Option<&CFArray>,
        ) -> Boolean;
    }
    let ret =
        unsafe { SCDynamicStoreSetMultiple(store, keys_to_set, keys_to_remove, keys_to_notify) };
    ret != 0
}

#[deprecated = "renamed to `SCDynamicStore::remove_value`"]
#[inline]
pub extern "C-unwind" fn SCDynamicStoreRemoveValue(
    store: Option<&SCDynamicStore>,
    key: &CFString,
) -> bool {
    extern "C-unwind" {
        fn SCDynamicStoreRemoveValue(store: Option<&SCDynamicStore>, key: &CFString) -> Boolean;
    }
    let ret = unsafe { SCDynamicStoreRemoveValue(store, key) };
    ret != 0
}

#[deprecated = "renamed to `SCDynamicStore::notify_value`"]
#[inline]
pub extern "C-unwind" fn SCDynamicStoreNotifyValue(
    store: Option<&SCDynamicStore>,
    key: &CFString,
) -> bool {
    extern "C-unwind" {
        fn SCDynamicStoreNotifyValue(store: Option<&SCDynamicStore>, key: &CFString) -> Boolean;
    }
    let ret = unsafe { SCDynamicStoreNotifyValue(store, key) };
    ret != 0
}

#[deprecated = "renamed to `SCDynamicStore::set_notification_keys`"]
#[inline]
pub unsafe extern "C-unwind" fn SCDynamicStoreSetNotificationKeys(
    store: &SCDynamicStore,
    keys: Option<&CFArray>,
    patterns: Option<&CFArray>,
) -> bool {
    extern "C-unwind" {
        fn SCDynamicStoreSetNotificationKeys(
            store: &SCDynamicStore,
            keys: Option<&CFArray>,
            patterns: Option<&CFArray>,
        ) -> Boolean;
    }
    let ret = unsafe { SCDynamicStoreSetNotificationKeys(store, keys, patterns) };
    ret != 0
}

#[deprecated = "renamed to `SCDynamicStore::notified_keys`"]
#[inline]
pub extern "C-unwind" fn SCDynamicStoreCopyNotifiedKeys(
    store: &SCDynamicStore,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCDynamicStoreCopyNotifiedKeys(store: &SCDynamicStore) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCDynamicStoreCopyNotifiedKeys(store) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
