---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab auth login`

Authenticate with a GitLab instance.

## Synopsis

Authenticate with a GitLab instance.
You can pass in a token on standard input by using `--stdin`.
The minimum required scopes for the token are: `api`, `write_repository`.
Configuration and credentials are stored in the global configuration file (default `~/.config/glab-cli/config.yml`)

```plaintext
glab auth login [flags]
```

## Examples

```console
# Start interactive setup
$ glab auth login

# Authenticate against `gitlab.com` by reading the token from a file
$ glab auth login --stdin < myaccesstoken.txt

# Authenticate with GitLab Self-Managed or GitLab Dedicated
$ glab auth login --hostname salsa.debian.org

# Non-interactive setup
$ glab auth login --hostname gitlab.example.org --token glpat-xxx --api-host gitlab.example.org:3443 --api-protocol https --git-protocol ssh

# Non-interactive setup reading token from a file
$ glab auth login --hostname gitlab.example.org --api-host gitlab.example.org:3443 --api-protocol https --git-protocol ssh  --stdin < myaccesstoken.txt

# Non-interactive CI/CD setup
$ glab auth login --hostname $CI_SERVER_HOST --job-token $CI_JOB_TOKEN

```

## Options

```plaintext
  -a, --api-host string       API host url.
  -p, --api-protocol string   API protocol: https, http
  -g, --git-protocol string   Git protocol: ssh, https, http
  -h, --hostname string       The hostname of the GitLab instance to authenticate with.
  -j, --job-token string      CI job token.
      --stdin                 Read token from standard input.
  -t, --token string          Your GitLab access token.
      --use-keyring           Store token in your operating system's keyring.
```

## Options inherited from parent commands

```plaintext
      --help   Show help for this command.
```
