// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appfabric

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchGetUserAccessTasks = "BatchGetUserAccessTasks"

// BatchGetUserAccessTasksRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetUserAccessTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetUserAccessTasks for more information on using the BatchGetUserAccessTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetUserAccessTasksRequest method.
//	req, resp := client.BatchGetUserAccessTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/BatchGetUserAccessTasks
func (c *AppFabric) BatchGetUserAccessTasksRequest(input *BatchGetUserAccessTasksInput) (req *request.Request, output *BatchGetUserAccessTasksOutput) {
	op := &request.Operation{
		Name:       opBatchGetUserAccessTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/useraccess/batchget",
	}

	if input == nil {
		input = &BatchGetUserAccessTasksInput{}
	}

	output = &BatchGetUserAccessTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetUserAccessTasks API operation for AppFabric.
//
// Gets user access details in a batch request.
//
// This action polls data from the tasks that are kicked off by the StartUserAccessTasks
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation BatchGetUserAccessTasks for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/BatchGetUserAccessTasks
func (c *AppFabric) BatchGetUserAccessTasks(input *BatchGetUserAccessTasksInput) (*BatchGetUserAccessTasksOutput, error) {
	req, out := c.BatchGetUserAccessTasksRequest(input)
	return out, req.Send()
}

// BatchGetUserAccessTasksWithContext is the same as BatchGetUserAccessTasks with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetUserAccessTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) BatchGetUserAccessTasksWithContext(ctx aws.Context, input *BatchGetUserAccessTasksInput, opts ...request.Option) (*BatchGetUserAccessTasksOutput, error) {
	req, out := c.BatchGetUserAccessTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConnectAppAuthorization = "ConnectAppAuthorization"

// ConnectAppAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the ConnectAppAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConnectAppAuthorization for more information on using the ConnectAppAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ConnectAppAuthorizationRequest method.
//	req, resp := client.ConnectAppAuthorizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ConnectAppAuthorization
func (c *AppFabric) ConnectAppAuthorizationRequest(input *ConnectAppAuthorizationInput) (req *request.Request, output *ConnectAppAuthorizationOutput) {
	op := &request.Operation{
		Name:       opConnectAppAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/appauthorizations/{appAuthorizationIdentifier}/connect",
	}

	if input == nil {
		input = &ConnectAppAuthorizationInput{}
	}

	output = &ConnectAppAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConnectAppAuthorization API operation for AppFabric.
//
// Establishes a connection between Amazon Web Services AppFabric and an application,
// which allows AppFabric to call the APIs of the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation ConnectAppAuthorization for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ConnectAppAuthorization
func (c *AppFabric) ConnectAppAuthorization(input *ConnectAppAuthorizationInput) (*ConnectAppAuthorizationOutput, error) {
	req, out := c.ConnectAppAuthorizationRequest(input)
	return out, req.Send()
}

// ConnectAppAuthorizationWithContext is the same as ConnectAppAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See ConnectAppAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) ConnectAppAuthorizationWithContext(ctx aws.Context, input *ConnectAppAuthorizationInput, opts ...request.Option) (*ConnectAppAuthorizationOutput, error) {
	req, out := c.ConnectAppAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppAuthorization = "CreateAppAuthorization"

// CreateAppAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppAuthorization for more information on using the CreateAppAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAppAuthorizationRequest method.
//	req, resp := client.CreateAppAuthorizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateAppAuthorization
func (c *AppFabric) CreateAppAuthorizationRequest(input *CreateAppAuthorizationInput) (req *request.Request, output *CreateAppAuthorizationOutput) {
	op := &request.Operation{
		Name:       opCreateAppAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/appauthorizations",
	}

	if input == nil {
		input = &CreateAppAuthorizationInput{}
	}

	output = &CreateAppAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppAuthorization API operation for AppFabric.
//
// Creates an app authorization within an app bundle, which allows AppFabric
// to connect to an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation CreateAppAuthorization for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ConflictException
//     The request has created a conflict. Check the request parameters and try
//     again.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateAppAuthorization
func (c *AppFabric) CreateAppAuthorization(input *CreateAppAuthorizationInput) (*CreateAppAuthorizationOutput, error) {
	req, out := c.CreateAppAuthorizationRequest(input)
	return out, req.Send()
}

// CreateAppAuthorizationWithContext is the same as CreateAppAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) CreateAppAuthorizationWithContext(ctx aws.Context, input *CreateAppAuthorizationInput, opts ...request.Option) (*CreateAppAuthorizationOutput, error) {
	req, out := c.CreateAppAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppBundle = "CreateAppBundle"

// CreateAppBundleRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppBundle for more information on using the CreateAppBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAppBundleRequest method.
//	req, resp := client.CreateAppBundleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateAppBundle
func (c *AppFabric) CreateAppBundleRequest(input *CreateAppBundleInput) (req *request.Request, output *CreateAppBundleOutput) {
	op := &request.Operation{
		Name:       opCreateAppBundle,
		HTTPMethod: "POST",
		HTTPPath:   "/appbundles",
	}

	if input == nil {
		input = &CreateAppBundleInput{}
	}

	output = &CreateAppBundleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppBundle API operation for AppFabric.
//
// Creates an app bundle to collect data from an application using AppFabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation CreateAppBundle for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ConflictException
//     The request has created a conflict. Check the request parameters and try
//     again.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateAppBundle
func (c *AppFabric) CreateAppBundle(input *CreateAppBundleInput) (*CreateAppBundleOutput, error) {
	req, out := c.CreateAppBundleRequest(input)
	return out, req.Send()
}

// CreateAppBundleWithContext is the same as CreateAppBundle with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) CreateAppBundleWithContext(ctx aws.Context, input *CreateAppBundleInput, opts ...request.Option) (*CreateAppBundleOutput, error) {
	req, out := c.CreateAppBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIngestion = "CreateIngestion"

// CreateIngestionRequest generates a "aws/request.Request" representing the
// client's request for the CreateIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIngestion for more information on using the CreateIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIngestionRequest method.
//	req, resp := client.CreateIngestionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateIngestion
func (c *AppFabric) CreateIngestionRequest(input *CreateIngestionInput) (req *request.Request, output *CreateIngestionOutput) {
	op := &request.Operation{
		Name:       opCreateIngestion,
		HTTPMethod: "POST",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/ingestions",
	}

	if input == nil {
		input = &CreateIngestionInput{}
	}

	output = &CreateIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIngestion API operation for AppFabric.
//
// Creates a data ingestion for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation CreateIngestion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ConflictException
//     The request has created a conflict. Check the request parameters and try
//     again.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateIngestion
func (c *AppFabric) CreateIngestion(input *CreateIngestionInput) (*CreateIngestionOutput, error) {
	req, out := c.CreateIngestionRequest(input)
	return out, req.Send()
}

// CreateIngestionWithContext is the same as CreateIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) CreateIngestionWithContext(ctx aws.Context, input *CreateIngestionInput, opts ...request.Option) (*CreateIngestionOutput, error) {
	req, out := c.CreateIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIngestionDestination = "CreateIngestionDestination"

// CreateIngestionDestinationRequest generates a "aws/request.Request" representing the
// client's request for the CreateIngestionDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIngestionDestination for more information on using the CreateIngestionDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIngestionDestinationRequest method.
//	req, resp := client.CreateIngestionDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateIngestionDestination
func (c *AppFabric) CreateIngestionDestinationRequest(input *CreateIngestionDestinationInput) (req *request.Request, output *CreateIngestionDestinationOutput) {
	op := &request.Operation{
		Name:       opCreateIngestionDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/ingestiondestinations",
	}

	if input == nil {
		input = &CreateIngestionDestinationInput{}
	}

	output = &CreateIngestionDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIngestionDestination API operation for AppFabric.
//
// Creates an ingestion destination, which specifies how an application's ingested
// data is processed by Amazon Web Services AppFabric and where it's delivered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation CreateIngestionDestination for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ConflictException
//     The request has created a conflict. Check the request parameters and try
//     again.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateIngestionDestination
func (c *AppFabric) CreateIngestionDestination(input *CreateIngestionDestinationInput) (*CreateIngestionDestinationOutput, error) {
	req, out := c.CreateIngestionDestinationRequest(input)
	return out, req.Send()
}

// CreateIngestionDestinationWithContext is the same as CreateIngestionDestination with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIngestionDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) CreateIngestionDestinationWithContext(ctx aws.Context, input *CreateIngestionDestinationInput, opts ...request.Option) (*CreateIngestionDestinationOutput, error) {
	req, out := c.CreateIngestionDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppAuthorization = "DeleteAppAuthorization"

// DeleteAppAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppAuthorization for more information on using the DeleteAppAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppAuthorizationRequest method.
//	req, resp := client.DeleteAppAuthorizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteAppAuthorization
func (c *AppFabric) DeleteAppAuthorizationRequest(input *DeleteAppAuthorizationInput) (req *request.Request, output *DeleteAppAuthorizationOutput) {
	op := &request.Operation{
		Name:       opDeleteAppAuthorization,
		HTTPMethod: "DELETE",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/appauthorizations/{appAuthorizationIdentifier}",
	}

	if input == nil {
		input = &DeleteAppAuthorizationInput{}
	}

	output = &DeleteAppAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppAuthorization API operation for AppFabric.
//
// Deletes an app authorization. You must delete the associated ingestion before
// you can delete an app authorization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation DeleteAppAuthorization for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteAppAuthorization
func (c *AppFabric) DeleteAppAuthorization(input *DeleteAppAuthorizationInput) (*DeleteAppAuthorizationOutput, error) {
	req, out := c.DeleteAppAuthorizationRequest(input)
	return out, req.Send()
}

// DeleteAppAuthorizationWithContext is the same as DeleteAppAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) DeleteAppAuthorizationWithContext(ctx aws.Context, input *DeleteAppAuthorizationInput, opts ...request.Option) (*DeleteAppAuthorizationOutput, error) {
	req, out := c.DeleteAppAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppBundle = "DeleteAppBundle"

// DeleteAppBundleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppBundle for more information on using the DeleteAppBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppBundleRequest method.
//	req, resp := client.DeleteAppBundleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteAppBundle
func (c *AppFabric) DeleteAppBundleRequest(input *DeleteAppBundleInput) (req *request.Request, output *DeleteAppBundleOutput) {
	op := &request.Operation{
		Name:       opDeleteAppBundle,
		HTTPMethod: "DELETE",
		HTTPPath:   "/appbundles/{appBundleIdentifier}",
	}

	if input == nil {
		input = &DeleteAppBundleInput{}
	}

	output = &DeleteAppBundleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppBundle API operation for AppFabric.
//
// Deletes an app bundle. You must delete all associated app authorizations
// before you can delete an app bundle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation DeleteAppBundle for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ConflictException
//     The request has created a conflict. Check the request parameters and try
//     again.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteAppBundle
func (c *AppFabric) DeleteAppBundle(input *DeleteAppBundleInput) (*DeleteAppBundleOutput, error) {
	req, out := c.DeleteAppBundleRequest(input)
	return out, req.Send()
}

// DeleteAppBundleWithContext is the same as DeleteAppBundle with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) DeleteAppBundleWithContext(ctx aws.Context, input *DeleteAppBundleInput, opts ...request.Option) (*DeleteAppBundleOutput, error) {
	req, out := c.DeleteAppBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIngestion = "DeleteIngestion"

// DeleteIngestionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIngestion for more information on using the DeleteIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIngestionRequest method.
//	req, resp := client.DeleteIngestionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestion
func (c *AppFabric) DeleteIngestionRequest(input *DeleteIngestionInput) (req *request.Request, output *DeleteIngestionOutput) {
	op := &request.Operation{
		Name:       opDeleteIngestion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}",
	}

	if input == nil {
		input = &DeleteIngestionInput{}
	}

	output = &DeleteIngestionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIngestion API operation for AppFabric.
//
// Deletes an ingestion. You must stop (disable) the ingestion and you must
// delete all associated ingestion destinations before you can delete an app
// ingestion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation DeleteIngestion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestion
func (c *AppFabric) DeleteIngestion(input *DeleteIngestionInput) (*DeleteIngestionOutput, error) {
	req, out := c.DeleteIngestionRequest(input)
	return out, req.Send()
}

// DeleteIngestionWithContext is the same as DeleteIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) DeleteIngestionWithContext(ctx aws.Context, input *DeleteIngestionInput, opts ...request.Option) (*DeleteIngestionOutput, error) {
	req, out := c.DeleteIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIngestionDestination = "DeleteIngestionDestination"

// DeleteIngestionDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIngestionDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIngestionDestination for more information on using the DeleteIngestionDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIngestionDestinationRequest method.
//	req, resp := client.DeleteIngestionDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestionDestination
func (c *AppFabric) DeleteIngestionDestinationRequest(input *DeleteIngestionDestinationInput) (req *request.Request, output *DeleteIngestionDestinationOutput) {
	op := &request.Operation{
		Name:       opDeleteIngestionDestination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/ingestiondestinations/{ingestionDestinationIdentifier}",
	}

	if input == nil {
		input = &DeleteIngestionDestinationInput{}
	}

	output = &DeleteIngestionDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIngestionDestination API operation for AppFabric.
//
// Deletes an ingestion destination.
//
// This deletes the association between an ingestion and it's destination. It
// doesn't delete previously ingested data or the storage destination, such
// as the Amazon S3 bucket where the data is delivered. If the ingestion destination
// is deleted while the associated ingestion is enabled, the ingestion will
// fail and is eventually disabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation DeleteIngestionDestination for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestionDestination
func (c *AppFabric) DeleteIngestionDestination(input *DeleteIngestionDestinationInput) (*DeleteIngestionDestinationOutput, error) {
	req, out := c.DeleteIngestionDestinationRequest(input)
	return out, req.Send()
}

// DeleteIngestionDestinationWithContext is the same as DeleteIngestionDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIngestionDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) DeleteIngestionDestinationWithContext(ctx aws.Context, input *DeleteIngestionDestinationInput, opts ...request.Option) (*DeleteIngestionDestinationOutput, error) {
	req, out := c.DeleteIngestionDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppAuthorization = "GetAppAuthorization"

// GetAppAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the GetAppAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppAuthorization for more information on using the GetAppAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAppAuthorizationRequest method.
//	req, resp := client.GetAppAuthorizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetAppAuthorization
func (c *AppFabric) GetAppAuthorizationRequest(input *GetAppAuthorizationInput) (req *request.Request, output *GetAppAuthorizationOutput) {
	op := &request.Operation{
		Name:       opGetAppAuthorization,
		HTTPMethod: "GET",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/appauthorizations/{appAuthorizationIdentifier}",
	}

	if input == nil {
		input = &GetAppAuthorizationInput{}
	}

	output = &GetAppAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppAuthorization API operation for AppFabric.
//
// Returns information about an app authorization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation GetAppAuthorization for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetAppAuthorization
func (c *AppFabric) GetAppAuthorization(input *GetAppAuthorizationInput) (*GetAppAuthorizationOutput, error) {
	req, out := c.GetAppAuthorizationRequest(input)
	return out, req.Send()
}

// GetAppAuthorizationWithContext is the same as GetAppAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) GetAppAuthorizationWithContext(ctx aws.Context, input *GetAppAuthorizationInput, opts ...request.Option) (*GetAppAuthorizationOutput, error) {
	req, out := c.GetAppAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppBundle = "GetAppBundle"

// GetAppBundleRequest generates a "aws/request.Request" representing the
// client's request for the GetAppBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppBundle for more information on using the GetAppBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAppBundleRequest method.
//	req, resp := client.GetAppBundleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetAppBundle
func (c *AppFabric) GetAppBundleRequest(input *GetAppBundleInput) (req *request.Request, output *GetAppBundleOutput) {
	op := &request.Operation{
		Name:       opGetAppBundle,
		HTTPMethod: "GET",
		HTTPPath:   "/appbundles/{appBundleIdentifier}",
	}

	if input == nil {
		input = &GetAppBundleInput{}
	}

	output = &GetAppBundleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppBundle API operation for AppFabric.
//
// Returns information about an app bundle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation GetAppBundle for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetAppBundle
func (c *AppFabric) GetAppBundle(input *GetAppBundleInput) (*GetAppBundleOutput, error) {
	req, out := c.GetAppBundleRequest(input)
	return out, req.Send()
}

// GetAppBundleWithContext is the same as GetAppBundle with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) GetAppBundleWithContext(ctx aws.Context, input *GetAppBundleInput, opts ...request.Option) (*GetAppBundleOutput, error) {
	req, out := c.GetAppBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIngestion = "GetIngestion"

// GetIngestionRequest generates a "aws/request.Request" representing the
// client's request for the GetIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIngestion for more information on using the GetIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIngestionRequest method.
//	req, resp := client.GetIngestionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetIngestion
func (c *AppFabric) GetIngestionRequest(input *GetIngestionInput) (req *request.Request, output *GetIngestionOutput) {
	op := &request.Operation{
		Name:       opGetIngestion,
		HTTPMethod: "GET",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}",
	}

	if input == nil {
		input = &GetIngestionInput{}
	}

	output = &GetIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIngestion API operation for AppFabric.
//
// Returns information about an ingestion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation GetIngestion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetIngestion
func (c *AppFabric) GetIngestion(input *GetIngestionInput) (*GetIngestionOutput, error) {
	req, out := c.GetIngestionRequest(input)
	return out, req.Send()
}

// GetIngestionWithContext is the same as GetIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See GetIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) GetIngestionWithContext(ctx aws.Context, input *GetIngestionInput, opts ...request.Option) (*GetIngestionOutput, error) {
	req, out := c.GetIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIngestionDestination = "GetIngestionDestination"

// GetIngestionDestinationRequest generates a "aws/request.Request" representing the
// client's request for the GetIngestionDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIngestionDestination for more information on using the GetIngestionDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIngestionDestinationRequest method.
//	req, resp := client.GetIngestionDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetIngestionDestination
func (c *AppFabric) GetIngestionDestinationRequest(input *GetIngestionDestinationInput) (req *request.Request, output *GetIngestionDestinationOutput) {
	op := &request.Operation{
		Name:       opGetIngestionDestination,
		HTTPMethod: "GET",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/ingestiondestinations/{ingestionDestinationIdentifier}",
	}

	if input == nil {
		input = &GetIngestionDestinationInput{}
	}

	output = &GetIngestionDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIngestionDestination API operation for AppFabric.
//
// Returns information about an ingestion destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation GetIngestionDestination for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetIngestionDestination
func (c *AppFabric) GetIngestionDestination(input *GetIngestionDestinationInput) (*GetIngestionDestinationOutput, error) {
	req, out := c.GetIngestionDestinationRequest(input)
	return out, req.Send()
}

// GetIngestionDestinationWithContext is the same as GetIngestionDestination with the addition of
// the ability to pass a context and additional request options.
//
// See GetIngestionDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) GetIngestionDestinationWithContext(ctx aws.Context, input *GetIngestionDestinationInput, opts ...request.Option) (*GetIngestionDestinationOutput, error) {
	req, out := c.GetIngestionDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAppAuthorizations = "ListAppAuthorizations"

// ListAppAuthorizationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppAuthorizations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppAuthorizations for more information on using the ListAppAuthorizations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppAuthorizationsRequest method.
//	req, resp := client.ListAppAuthorizationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppAuthorizations
func (c *AppFabric) ListAppAuthorizationsRequest(input *ListAppAuthorizationsInput) (req *request.Request, output *ListAppAuthorizationsOutput) {
	op := &request.Operation{
		Name:       opListAppAuthorizations,
		HTTPMethod: "GET",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/appauthorizations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppAuthorizationsInput{}
	}

	output = &ListAppAuthorizationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppAuthorizations API operation for AppFabric.
//
// Returns a list of all app authorizations configured for an app bundle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation ListAppAuthorizations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppAuthorizations
func (c *AppFabric) ListAppAuthorizations(input *ListAppAuthorizationsInput) (*ListAppAuthorizationsOutput, error) {
	req, out := c.ListAppAuthorizationsRequest(input)
	return out, req.Send()
}

// ListAppAuthorizationsWithContext is the same as ListAppAuthorizations with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppAuthorizations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) ListAppAuthorizationsWithContext(ctx aws.Context, input *ListAppAuthorizationsInput, opts ...request.Option) (*ListAppAuthorizationsOutput, error) {
	req, out := c.ListAppAuthorizationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppAuthorizationsPages iterates over the pages of a ListAppAuthorizations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppAuthorizations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppAuthorizations operation.
//	pageNum := 0
//	err := client.ListAppAuthorizationsPages(params,
//	    func(page *appfabric.ListAppAuthorizationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppFabric) ListAppAuthorizationsPages(input *ListAppAuthorizationsInput, fn func(*ListAppAuthorizationsOutput, bool) bool) error {
	return c.ListAppAuthorizationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppAuthorizationsPagesWithContext same as ListAppAuthorizationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) ListAppAuthorizationsPagesWithContext(ctx aws.Context, input *ListAppAuthorizationsInput, fn func(*ListAppAuthorizationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppAuthorizationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppAuthorizationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppAuthorizationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppBundles = "ListAppBundles"

// ListAppBundlesRequest generates a "aws/request.Request" representing the
// client's request for the ListAppBundles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppBundles for more information on using the ListAppBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppBundlesRequest method.
//	req, resp := client.ListAppBundlesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppBundles
func (c *AppFabric) ListAppBundlesRequest(input *ListAppBundlesInput) (req *request.Request, output *ListAppBundlesOutput) {
	op := &request.Operation{
		Name:       opListAppBundles,
		HTTPMethod: "GET",
		HTTPPath:   "/appbundles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppBundlesInput{}
	}

	output = &ListAppBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppBundles API operation for AppFabric.
//
// Returns a list of app bundles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation ListAppBundles for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppBundles
func (c *AppFabric) ListAppBundles(input *ListAppBundlesInput) (*ListAppBundlesOutput, error) {
	req, out := c.ListAppBundlesRequest(input)
	return out, req.Send()
}

// ListAppBundlesWithContext is the same as ListAppBundles with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) ListAppBundlesWithContext(ctx aws.Context, input *ListAppBundlesInput, opts ...request.Option) (*ListAppBundlesOutput, error) {
	req, out := c.ListAppBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppBundlesPages iterates over the pages of a ListAppBundles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppBundles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppBundles operation.
//	pageNum := 0
//	err := client.ListAppBundlesPages(params,
//	    func(page *appfabric.ListAppBundlesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppFabric) ListAppBundlesPages(input *ListAppBundlesInput, fn func(*ListAppBundlesOutput, bool) bool) error {
	return c.ListAppBundlesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppBundlesPagesWithContext same as ListAppBundlesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) ListAppBundlesPagesWithContext(ctx aws.Context, input *ListAppBundlesInput, fn func(*ListAppBundlesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppBundlesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppBundlesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppBundlesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIngestionDestinations = "ListIngestionDestinations"

// ListIngestionDestinationsRequest generates a "aws/request.Request" representing the
// client's request for the ListIngestionDestinations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIngestionDestinations for more information on using the ListIngestionDestinations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIngestionDestinationsRequest method.
//	req, resp := client.ListIngestionDestinationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestionDestinations
func (c *AppFabric) ListIngestionDestinationsRequest(input *ListIngestionDestinationsInput) (req *request.Request, output *ListIngestionDestinationsOutput) {
	op := &request.Operation{
		Name:       opListIngestionDestinations,
		HTTPMethod: "GET",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/ingestiondestinations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIngestionDestinationsInput{}
	}

	output = &ListIngestionDestinationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIngestionDestinations API operation for AppFabric.
//
// Returns a list of all ingestion destinations configured for an ingestion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation ListIngestionDestinations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestionDestinations
func (c *AppFabric) ListIngestionDestinations(input *ListIngestionDestinationsInput) (*ListIngestionDestinationsOutput, error) {
	req, out := c.ListIngestionDestinationsRequest(input)
	return out, req.Send()
}

// ListIngestionDestinationsWithContext is the same as ListIngestionDestinations with the addition of
// the ability to pass a context and additional request options.
//
// See ListIngestionDestinations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) ListIngestionDestinationsWithContext(ctx aws.Context, input *ListIngestionDestinationsInput, opts ...request.Option) (*ListIngestionDestinationsOutput, error) {
	req, out := c.ListIngestionDestinationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIngestionDestinationsPages iterates over the pages of a ListIngestionDestinations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIngestionDestinations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIngestionDestinations operation.
//	pageNum := 0
//	err := client.ListIngestionDestinationsPages(params,
//	    func(page *appfabric.ListIngestionDestinationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppFabric) ListIngestionDestinationsPages(input *ListIngestionDestinationsInput, fn func(*ListIngestionDestinationsOutput, bool) bool) error {
	return c.ListIngestionDestinationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIngestionDestinationsPagesWithContext same as ListIngestionDestinationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) ListIngestionDestinationsPagesWithContext(ctx aws.Context, input *ListIngestionDestinationsInput, fn func(*ListIngestionDestinationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIngestionDestinationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIngestionDestinationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIngestionDestinationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIngestions = "ListIngestions"

// ListIngestionsRequest generates a "aws/request.Request" representing the
// client's request for the ListIngestions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIngestions for more information on using the ListIngestions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIngestionsRequest method.
//	req, resp := client.ListIngestionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestions
func (c *AppFabric) ListIngestionsRequest(input *ListIngestionsInput) (req *request.Request, output *ListIngestionsOutput) {
	op := &request.Operation{
		Name:       opListIngestions,
		HTTPMethod: "GET",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/ingestions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIngestionsInput{}
	}

	output = &ListIngestionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIngestions API operation for AppFabric.
//
// Returns a list of all ingestions configured for an app bundle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation ListIngestions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestions
func (c *AppFabric) ListIngestions(input *ListIngestionsInput) (*ListIngestionsOutput, error) {
	req, out := c.ListIngestionsRequest(input)
	return out, req.Send()
}

// ListIngestionsWithContext is the same as ListIngestions with the addition of
// the ability to pass a context and additional request options.
//
// See ListIngestions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) ListIngestionsWithContext(ctx aws.Context, input *ListIngestionsInput, opts ...request.Option) (*ListIngestionsOutput, error) {
	req, out := c.ListIngestionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIngestionsPages iterates over the pages of a ListIngestions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIngestions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIngestions operation.
//	pageNum := 0
//	err := client.ListIngestionsPages(params,
//	    func(page *appfabric.ListIngestionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppFabric) ListIngestionsPages(input *ListIngestionsInput, fn func(*ListIngestionsOutput, bool) bool) error {
	return c.ListIngestionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIngestionsPagesWithContext same as ListIngestionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) ListIngestionsPagesWithContext(ctx aws.Context, input *ListIngestionsInput, fn func(*ListIngestionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIngestionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIngestionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIngestionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListTagsForResource
func (c *AppFabric) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AppFabric.
//
// Returns a list of tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListTagsForResource
func (c *AppFabric) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartIngestion = "StartIngestion"

// StartIngestionRequest generates a "aws/request.Request" representing the
// client's request for the StartIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartIngestion for more information on using the StartIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartIngestionRequest method.
//	req, resp := client.StartIngestionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StartIngestion
func (c *AppFabric) StartIngestionRequest(input *StartIngestionInput) (req *request.Request, output *StartIngestionOutput) {
	op := &request.Operation{
		Name:       opStartIngestion,
		HTTPMethod: "POST",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/start",
	}

	if input == nil {
		input = &StartIngestionInput{}
	}

	output = &StartIngestionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartIngestion API operation for AppFabric.
//
// Starts (enables) an ingestion, which collects data from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation StartIngestion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ConflictException
//     The request has created a conflict. Check the request parameters and try
//     again.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StartIngestion
func (c *AppFabric) StartIngestion(input *StartIngestionInput) (*StartIngestionOutput, error) {
	req, out := c.StartIngestionRequest(input)
	return out, req.Send()
}

// StartIngestionWithContext is the same as StartIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See StartIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) StartIngestionWithContext(ctx aws.Context, input *StartIngestionInput, opts ...request.Option) (*StartIngestionOutput, error) {
	req, out := c.StartIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartUserAccessTasks = "StartUserAccessTasks"

// StartUserAccessTasksRequest generates a "aws/request.Request" representing the
// client's request for the StartUserAccessTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartUserAccessTasks for more information on using the StartUserAccessTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartUserAccessTasksRequest method.
//	req, resp := client.StartUserAccessTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StartUserAccessTasks
func (c *AppFabric) StartUserAccessTasksRequest(input *StartUserAccessTasksInput) (req *request.Request, output *StartUserAccessTasksOutput) {
	op := &request.Operation{
		Name:       opStartUserAccessTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/useraccess/start",
	}

	if input == nil {
		input = &StartUserAccessTasksInput{}
	}

	output = &StartUserAccessTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartUserAccessTasks API operation for AppFabric.
//
// Starts the tasks to search user access status for a specific email address.
//
// The tasks are stopped when the user access status data is found. The tasks
// are terminated when the API calls to the application time out.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation StartUserAccessTasks for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StartUserAccessTasks
func (c *AppFabric) StartUserAccessTasks(input *StartUserAccessTasksInput) (*StartUserAccessTasksOutput, error) {
	req, out := c.StartUserAccessTasksRequest(input)
	return out, req.Send()
}

// StartUserAccessTasksWithContext is the same as StartUserAccessTasks with the addition of
// the ability to pass a context and additional request options.
//
// See StartUserAccessTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) StartUserAccessTasksWithContext(ctx aws.Context, input *StartUserAccessTasksInput, opts ...request.Option) (*StartUserAccessTasksOutput, error) {
	req, out := c.StartUserAccessTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopIngestion = "StopIngestion"

// StopIngestionRequest generates a "aws/request.Request" representing the
// client's request for the StopIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopIngestion for more information on using the StopIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopIngestionRequest method.
//	req, resp := client.StopIngestionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StopIngestion
func (c *AppFabric) StopIngestionRequest(input *StopIngestionInput) (req *request.Request, output *StopIngestionOutput) {
	op := &request.Operation{
		Name:       opStopIngestion,
		HTTPMethod: "POST",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/stop",
	}

	if input == nil {
		input = &StopIngestionInput{}
	}

	output = &StopIngestionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopIngestion API operation for AppFabric.
//
// Stops (disables) an ingestion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation StopIngestion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ConflictException
//     The request has created a conflict. Check the request parameters and try
//     again.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StopIngestion
func (c *AppFabric) StopIngestion(input *StopIngestionInput) (*StopIngestionOutput, error) {
	req, out := c.StopIngestionRequest(input)
	return out, req.Send()
}

// StopIngestionWithContext is the same as StopIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See StopIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) StopIngestionWithContext(ctx aws.Context, input *StopIngestionInput, opts ...request.Option) (*StopIngestionOutput, error) {
	req, out := c.StopIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/TagResource
func (c *AppFabric) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AppFabric.
//
// Assigns one or more tags (key-value pairs) to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/TagResource
func (c *AppFabric) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UntagResource
func (c *AppFabric) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AppFabric.
//
// Removes a tag or tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UntagResource
func (c *AppFabric) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppAuthorization = "UpdateAppAuthorization"

// UpdateAppAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppAuthorization for more information on using the UpdateAppAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAppAuthorizationRequest method.
//	req, resp := client.UpdateAppAuthorizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateAppAuthorization
func (c *AppFabric) UpdateAppAuthorizationRequest(input *UpdateAppAuthorizationInput) (req *request.Request, output *UpdateAppAuthorizationOutput) {
	op := &request.Operation{
		Name:       opUpdateAppAuthorization,
		HTTPMethod: "PATCH",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/appauthorizations/{appAuthorizationIdentifier}",
	}

	if input == nil {
		input = &UpdateAppAuthorizationInput{}
	}

	output = &UpdateAppAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAppAuthorization API operation for AppFabric.
//
// Updates an app authorization within an app bundle, which allows AppFabric
// to connect to an application.
//
// If the app authorization was in a connected state, updating the app authorization
// will set it back to a PendingConnect state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation UpdateAppAuthorization for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateAppAuthorization
func (c *AppFabric) UpdateAppAuthorization(input *UpdateAppAuthorizationInput) (*UpdateAppAuthorizationOutput, error) {
	req, out := c.UpdateAppAuthorizationRequest(input)
	return out, req.Send()
}

// UpdateAppAuthorizationWithContext is the same as UpdateAppAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) UpdateAppAuthorizationWithContext(ctx aws.Context, input *UpdateAppAuthorizationInput, opts ...request.Option) (*UpdateAppAuthorizationOutput, error) {
	req, out := c.UpdateAppAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIngestionDestination = "UpdateIngestionDestination"

// UpdateIngestionDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIngestionDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIngestionDestination for more information on using the UpdateIngestionDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIngestionDestinationRequest method.
//	req, resp := client.UpdateIngestionDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateIngestionDestination
func (c *AppFabric) UpdateIngestionDestinationRequest(input *UpdateIngestionDestinationInput) (req *request.Request, output *UpdateIngestionDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateIngestionDestination,
		HTTPMethod: "PATCH",
		HTTPPath:   "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/ingestiondestinations/{ingestionDestinationIdentifier}",
	}

	if input == nil {
		input = &UpdateIngestionDestinationInput{}
	}

	output = &UpdateIngestionDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIngestionDestination API operation for AppFabric.
//
// Updates an ingestion destination, which specifies how an application's ingested
// data is processed by Amazon Web Services AppFabric and where it's delivered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AppFabric's
// API operation UpdateIngestionDestination for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request rate exceeds the limit.
//
//   - ConflictException
//     The request has created a conflict. Check the request parameters and try
//     again.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateIngestionDestination
func (c *AppFabric) UpdateIngestionDestination(input *UpdateIngestionDestinationInput) (*UpdateIngestionDestinationOutput, error) {
	req, out := c.UpdateIngestionDestinationRequest(input)
	return out, req.Send()
}

// UpdateIngestionDestinationWithContext is the same as UpdateIngestionDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIngestionDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppFabric) UpdateIngestionDestinationWithContext(ctx aws.Context, input *UpdateIngestionDestinationInput, opts ...request.Option) (*UpdateIngestionDestinationOutput, error) {
	req, out := c.UpdateIngestionDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You are not authorized to perform this operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains API key credential information.
type ApiKeyCredential struct {
	_ struct{} `type:"structure"`

	// An API key for an application.
	//
	// ApiKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ApiKeyCredential's
	// String and GoString methods.
	//
	// ApiKey is a required field
	ApiKey *string `locationName:"apiKey" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiKeyCredential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiKeyCredential) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApiKeyCredential) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApiKeyCredential"}
	if s.ApiKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKey"))
	}
	if s.ApiKey != nil && len(*s.ApiKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKey sets the ApiKey field's value.
func (s *ApiKeyCredential) SetApiKey(v string) *ApiKeyCredential {
	s.ApiKey = &v
	return s
}

// Contains information about an app authorization.
type AppAuthorization struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// App is a required field
	App *string `locationName:"app" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the app authorization.
	//
	// AppAuthorizationArn is a required field
	AppAuthorizationArn *string `locationName:"appAuthorizationArn" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the app bundle for the app authorization.
	//
	// AppBundleArn is a required field
	AppBundleArn *string `locationName:"appBundleArn" min:"1" type:"string" required:"true"`

	// The authorization type.
	//
	// AuthType is a required field
	AuthType *string `locationName:"authType" type:"string" required:"true" enum:"AuthType"`

	// The application URL for the OAuth flow.
	AuthUrl *string `locationName:"authUrl" type:"string"`

	// The timestamp of when the app authorization was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user persona of the app authorization.
	//
	// This field should always be admin.
	Persona *string `locationName:"persona" type:"string" enum:"Persona"`

	// The state of the app authorization.
	//
	// The following states are possible:
	//
	//    * PendingConnect: The initial state of the app authorization. The app
	//    authorization is created but not yet connected.
	//
	//    * Connected: The app authorization is connected to the application, and
	//    is ready to be used.
	//
	//    * ConnectionValidationFailed: The app authorization received a validation
	//    exception when trying to connect to the application. If the app authorization
	//    is in this state, you should verify the configured credentials and try
	//    to connect the app authorization again.
	//
	//    * TokenAutoRotationFailed: AppFabric failed to refresh the access token.
	//    If the app authorization is in this state, you should try to reconnect
	//    the app authorization.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AppAuthorizationStatus"`

	// Contains information about an application tenant, such as the application
	// display name and identifier.
	//
	// Tenant is a required field
	Tenant *Tenant `locationName:"tenant" type:"structure" required:"true"`

	// The timestamp of when the app authorization was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppAuthorization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppAuthorization) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *AppAuthorization) SetApp(v string) *AppAuthorization {
	s.App = &v
	return s
}

// SetAppAuthorizationArn sets the AppAuthorizationArn field's value.
func (s *AppAuthorization) SetAppAuthorizationArn(v string) *AppAuthorization {
	s.AppAuthorizationArn = &v
	return s
}

// SetAppBundleArn sets the AppBundleArn field's value.
func (s *AppAuthorization) SetAppBundleArn(v string) *AppAuthorization {
	s.AppBundleArn = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *AppAuthorization) SetAuthType(v string) *AppAuthorization {
	s.AuthType = &v
	return s
}

// SetAuthUrl sets the AuthUrl field's value.
func (s *AppAuthorization) SetAuthUrl(v string) *AppAuthorization {
	s.AuthUrl = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AppAuthorization) SetCreatedAt(v time.Time) *AppAuthorization {
	s.CreatedAt = &v
	return s
}

// SetPersona sets the Persona field's value.
func (s *AppAuthorization) SetPersona(v string) *AppAuthorization {
	s.Persona = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AppAuthorization) SetStatus(v string) *AppAuthorization {
	s.Status = &v
	return s
}

// SetTenant sets the Tenant field's value.
func (s *AppAuthorization) SetTenant(v *Tenant) *AppAuthorization {
	s.Tenant = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AppAuthorization) SetUpdatedAt(v time.Time) *AppAuthorization {
	s.UpdatedAt = &v
	return s
}

// Contains a summary of an app authorization.
type AppAuthorizationSummary struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// App is a required field
	App *string `locationName:"app" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the app authorization.
	//
	// AppAuthorizationArn is a required field
	AppAuthorizationArn *string `locationName:"appAuthorizationArn" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the app bundle for the app authorization.
	//
	// AppBundleArn is a required field
	AppBundleArn *string `locationName:"appBundleArn" min:"1" type:"string" required:"true"`

	// The state of the app authorization.
	//
	// The following states are possible:
	//
	//    * PendingConnect: The initial state of the app authorization. The app
	//    authorization is created but not yet connected.
	//
	//    * Connected: The app authorization is connected to the application, and
	//    is ready to be used.
	//
	//    * ConnectionValidationFailed: The app authorization received a validation
	//    exception when trying to connect to the application. If the app authorization
	//    is in this state, you should verify the configured credentials and try
	//    to connect the app authorization again.
	//
	//    * TokenAutoRotationFailed: AppFabric failed to refresh the access token.
	//    If the app authorization is in this state, you should try to reconnect
	//    the app authorization.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AppAuthorizationStatus"`

	// Contains information about an application tenant, such as the application
	// display name and identifier.
	//
	// Tenant is a required field
	Tenant *Tenant `locationName:"tenant" type:"structure" required:"true"`

	// Timestamp for when the app authorization was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppAuthorizationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppAuthorizationSummary) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *AppAuthorizationSummary) SetApp(v string) *AppAuthorizationSummary {
	s.App = &v
	return s
}

// SetAppAuthorizationArn sets the AppAuthorizationArn field's value.
func (s *AppAuthorizationSummary) SetAppAuthorizationArn(v string) *AppAuthorizationSummary {
	s.AppAuthorizationArn = &v
	return s
}

// SetAppBundleArn sets the AppBundleArn field's value.
func (s *AppAuthorizationSummary) SetAppBundleArn(v string) *AppAuthorizationSummary {
	s.AppBundleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AppAuthorizationSummary) SetStatus(v string) *AppAuthorizationSummary {
	s.Status = &v
	return s
}

// SetTenant sets the Tenant field's value.
func (s *AppAuthorizationSummary) SetTenant(v *Tenant) *AppAuthorizationSummary {
	s.Tenant = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AppAuthorizationSummary) SetUpdatedAt(v time.Time) *AppAuthorizationSummary {
	s.UpdatedAt = &v
	return s
}

// Contains information about an app bundle.
type AppBundle struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the app bundle.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used
	// to encrypt the application data.
	CustomerManagedKeyArn *string `locationName:"customerManagedKeyArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppBundle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppBundle) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AppBundle) SetArn(v string) *AppBundle {
	s.Arn = &v
	return s
}

// SetCustomerManagedKeyArn sets the CustomerManagedKeyArn field's value.
func (s *AppBundle) SetCustomerManagedKeyArn(v string) *AppBundle {
	s.CustomerManagedKeyArn = &v
	return s
}

// Contains a summary of an app bundle.
type AppBundleSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the app bundle.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppBundleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppBundleSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AppBundleSummary) SetArn(v string) *AppBundleSummary {
	s.Arn = &v
	return s
}

// Contains information about an audit log destination configuration.
type AuditLogDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains information about an audit log destination.
	//
	// Destination is a required field
	Destination *Destination `locationName:"destination" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuditLogDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuditLogDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuditLogDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuditLogDestinationConfiguration"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *AuditLogDestinationConfiguration) SetDestination(v *Destination) *AuditLogDestinationConfiguration {
	s.Destination = v
	return s
}

// Contains information about an audit log processing configuration.
type AuditLogProcessingConfiguration struct {
	_ struct{} `type:"structure"`

	// The format in which the audit logs need to be formatted.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"Format"`

	// The event schema in which the audit logs need to be formatted.
	//
	// Schema is a required field
	Schema *string `locationName:"schema" type:"string" required:"true" enum:"Schema"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuditLogProcessingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuditLogProcessingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuditLogProcessingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuditLogProcessingConfiguration"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Schema == nil {
		invalidParams.Add(request.NewErrParamRequired("Schema"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormat sets the Format field's value.
func (s *AuditLogProcessingConfiguration) SetFormat(v string) *AuditLogProcessingConfiguration {
	s.Format = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *AuditLogProcessingConfiguration) SetSchema(v string) *AuditLogProcessingConfiguration {
	s.Schema = &v
	return s
}

// Contains authorization request information, which is required for Amazon
// Web Services AppFabric to get the OAuth2 access token for an application.
type AuthRequest struct {
	_ struct{} `type:"structure"`

	// The authorization code returned by the application after permission is granted
	// in the application OAuth page (after clicking on the AuthURL).
	//
	// Code is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AuthRequest's
	// String and GoString methods.
	//
	// Code is a required field
	Code *string `locationName:"code" min:"1" type:"string" required:"true" sensitive:"true"`

	// The redirect URL that is specified in the AuthURL and the application client.
	//
	// RedirectUri is a required field
	RedirectUri *string `locationName:"redirectUri" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthRequest"}
	if s.Code == nil {
		invalidParams.Add(request.NewErrParamRequired("Code"))
	}
	if s.Code != nil && len(*s.Code) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Code", 1))
	}
	if s.RedirectUri == nil {
		invalidParams.Add(request.NewErrParamRequired("RedirectUri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCode sets the Code field's value.
func (s *AuthRequest) SetCode(v string) *AuthRequest {
	s.Code = &v
	return s
}

// SetRedirectUri sets the RedirectUri field's value.
func (s *AuthRequest) SetRedirectUri(v string) *AuthRequest {
	s.RedirectUri = &v
	return s
}

type BatchGetUserAccessTasksInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// The tasks IDs to use for the request.
	//
	// TaskIdList is a required field
	TaskIdList []*string `locationName:"taskIdList" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetUserAccessTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetUserAccessTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetUserAccessTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetUserAccessTasksInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.TaskIdList == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskIdList"))
	}
	if s.TaskIdList != nil && len(s.TaskIdList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskIdList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *BatchGetUserAccessTasksInput) SetAppBundleIdentifier(v string) *BatchGetUserAccessTasksInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetTaskIdList sets the TaskIdList field's value.
func (s *BatchGetUserAccessTasksInput) SetTaskIdList(v []*string) *BatchGetUserAccessTasksInput {
	s.TaskIdList = v
	return s
}

type BatchGetUserAccessTasksOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of user access results.
	UserAccessResultsList []*UserAccessResultItem `locationName:"userAccessResultsList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetUserAccessTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetUserAccessTasksOutput) GoString() string {
	return s.String()
}

// SetUserAccessResultsList sets the UserAccessResultsList field's value.
func (s *BatchGetUserAccessTasksOutput) SetUserAccessResultsList(v []*UserAccessResultItem) *BatchGetUserAccessTasksOutput {
	s.UserAccessResultsList = v
	return s
}

// The request has created a conflict. Check the request parameters and try
// again.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The resource ID.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ConnectAppAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app authorization to use for the request.
	//
	// AppAuthorizationIdentifier is a required field
	AppAuthorizationIdentifier *string `location:"uri" locationName:"appAuthorizationIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle that contains the app authorization to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// Contains OAuth2 authorization information.
	//
	// This is required if the app authorization for the request is configured with
	// an OAuth2 (oauth2) authorization type.
	AuthRequest *AuthRequest `locationName:"authRequest" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectAppAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectAppAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectAppAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectAppAuthorizationInput"}
	if s.AppAuthorizationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppAuthorizationIdentifier"))
	}
	if s.AppAuthorizationIdentifier != nil && len(*s.AppAuthorizationIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppAuthorizationIdentifier", 1))
	}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.AuthRequest != nil {
		if err := s.AuthRequest.Validate(); err != nil {
			invalidParams.AddNested("AuthRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppAuthorizationIdentifier sets the AppAuthorizationIdentifier field's value.
func (s *ConnectAppAuthorizationInput) SetAppAuthorizationIdentifier(v string) *ConnectAppAuthorizationInput {
	s.AppAuthorizationIdentifier = &v
	return s
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *ConnectAppAuthorizationInput) SetAppBundleIdentifier(v string) *ConnectAppAuthorizationInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetAuthRequest sets the AuthRequest field's value.
func (s *ConnectAppAuthorizationInput) SetAuthRequest(v *AuthRequest) *ConnectAppAuthorizationInput {
	s.AuthRequest = v
	return s
}

type ConnectAppAuthorizationOutput struct {
	_ struct{} `type:"structure"`

	// Contains a summary of the app authorization.
	//
	// AppAuthorizationSummary is a required field
	AppAuthorizationSummary *AppAuthorizationSummary `locationName:"appAuthorizationSummary" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectAppAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectAppAuthorizationOutput) GoString() string {
	return s.String()
}

// SetAppAuthorizationSummary sets the AppAuthorizationSummary field's value.
func (s *ConnectAppAuthorizationOutput) SetAppAuthorizationSummary(v *AppAuthorizationSummary) *ConnectAppAuthorizationOutput {
	s.AppAuthorizationSummary = v
	return s
}

type CreateAppAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// Valid values are:
	//
	//    * SLACK
	//
	//    * ASANA
	//
	//    * JIRA
	//
	//    * M365
	//
	//    * M365AUDITLOGS
	//
	//    * ZOOM
	//
	//    * ZENDESK
	//
	//    * OKTA
	//
	//    * GOOGLE
	//
	//    * DROPBOX
	//
	//    * SMARTSHEET
	//
	//    * CISCO
	//
	// App is a required field
	App *string `locationName:"app" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// The authorization type for the app authorization.
	//
	// AuthType is a required field
	AuthType *string `locationName:"authType" type:"string" required:"true" enum:"AuthType"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Contains credentials for the application, such as an API key or OAuth2 client
	// ID and secret.
	//
	// Specify credentials that match the authorization type for your request. For
	// example, if the authorization type for your request is OAuth2 (oauth2), then
	// you should provide only the OAuth2 credentials.
	//
	// Credential is a required field
	Credential *Credential `locationName:"credential" type:"structure" required:"true"`

	// A map of the key-value pairs of the tag or tags to assign to the resource.
	Tags []*Tag `locationName:"tags" type:"list"`

	// Contains information about an application tenant, such as the application
	// display name and identifier.
	//
	// Tenant is a required field
	Tenant *Tenant `locationName:"tenant" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppAuthorizationInput"}
	if s.App == nil {
		invalidParams.Add(request.NewErrParamRequired("App"))
	}
	if s.App != nil && len(*s.App) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("App", 1))
	}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.AuthType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthType"))
	}
	if s.Credential == nil {
		invalidParams.Add(request.NewErrParamRequired("Credential"))
	}
	if s.Tenant == nil {
		invalidParams.Add(request.NewErrParamRequired("Tenant"))
	}
	if s.Credential != nil {
		if err := s.Credential.Validate(); err != nil {
			invalidParams.AddNested("Credential", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tenant != nil {
		if err := s.Tenant.Validate(); err != nil {
			invalidParams.AddNested("Tenant", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApp sets the App field's value.
func (s *CreateAppAuthorizationInput) SetApp(v string) *CreateAppAuthorizationInput {
	s.App = &v
	return s
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *CreateAppAuthorizationInput) SetAppBundleIdentifier(v string) *CreateAppAuthorizationInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *CreateAppAuthorizationInput) SetAuthType(v string) *CreateAppAuthorizationInput {
	s.AuthType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAppAuthorizationInput) SetClientToken(v string) *CreateAppAuthorizationInput {
	s.ClientToken = &v
	return s
}

// SetCredential sets the Credential field's value.
func (s *CreateAppAuthorizationInput) SetCredential(v *Credential) *CreateAppAuthorizationInput {
	s.Credential = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppAuthorizationInput) SetTags(v []*Tag) *CreateAppAuthorizationInput {
	s.Tags = v
	return s
}

// SetTenant sets the Tenant field's value.
func (s *CreateAppAuthorizationInput) SetTenant(v *Tenant) *CreateAppAuthorizationInput {
	s.Tenant = v
	return s
}

type CreateAppAuthorizationOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an app authorization.
	//
	// AppAuthorization is a required field
	AppAuthorization *AppAuthorization `locationName:"appAuthorization" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppAuthorizationOutput) GoString() string {
	return s.String()
}

// SetAppAuthorization sets the AppAuthorization field's value.
func (s *CreateAppAuthorizationOutput) SetAppAuthorization(v *AppAuthorization) *CreateAppAuthorizationOutput {
	s.AppAuthorization = v
	return s
}

type CreateAppBundleInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to
	// use to encrypt the application data. If this is not specified, an Amazon
	// Web Services owned key is used for encryption.
	CustomerManagedKeyIdentifier *string `locationName:"customerManagedKeyIdentifier" min:"1" type:"string"`

	// A map of the key-value pairs of the tag or tags to assign to the resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppBundleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppBundleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppBundleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppBundleInput"}
	if s.CustomerManagedKeyIdentifier != nil && len(*s.CustomerManagedKeyIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerManagedKeyIdentifier", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAppBundleInput) SetClientToken(v string) *CreateAppBundleInput {
	s.ClientToken = &v
	return s
}

// SetCustomerManagedKeyIdentifier sets the CustomerManagedKeyIdentifier field's value.
func (s *CreateAppBundleInput) SetCustomerManagedKeyIdentifier(v string) *CreateAppBundleInput {
	s.CustomerManagedKeyIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppBundleInput) SetTags(v []*Tag) *CreateAppBundleInput {
	s.Tags = v
	return s
}

type CreateAppBundleOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an app bundle.
	//
	// AppBundle is a required field
	AppBundle *AppBundle `locationName:"appBundle" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppBundleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppBundleOutput) GoString() string {
	return s.String()
}

// SetAppBundle sets the AppBundle field's value.
func (s *CreateAppBundleOutput) SetAppBundle(v *AppBundle) *CreateAppBundleOutput {
	s.AppBundle = v
	return s
}

type CreateIngestionDestinationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Contains information about the destination of ingested data.
	//
	// DestinationConfiguration is a required field
	DestinationConfiguration *DestinationConfiguration `locationName:"destinationConfiguration" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// ingestion to use for the request.
	//
	// IngestionIdentifier is a required field
	IngestionIdentifier *string `location:"uri" locationName:"ingestionIdentifier" min:"1" type:"string" required:"true"`

	// Contains information about how ingested data is processed.
	//
	// ProcessingConfiguration is a required field
	ProcessingConfiguration *ProcessingConfiguration `locationName:"processingConfiguration" type:"structure" required:"true"`

	// A map of the key-value pairs of the tag or tags to assign to the resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIngestionDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIngestionDestinationInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.DestinationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationConfiguration"))
	}
	if s.IngestionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionIdentifier"))
	}
	if s.IngestionIdentifier != nil && len(*s.IngestionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionIdentifier", 1))
	}
	if s.ProcessingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ProcessingConfiguration"))
	}
	if s.DestinationConfiguration != nil {
		if err := s.DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *CreateIngestionDestinationInput) SetAppBundleIdentifier(v string) *CreateIngestionDestinationInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateIngestionDestinationInput) SetClientToken(v string) *CreateIngestionDestinationInput {
	s.ClientToken = &v
	return s
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *CreateIngestionDestinationInput) SetDestinationConfiguration(v *DestinationConfiguration) *CreateIngestionDestinationInput {
	s.DestinationConfiguration = v
	return s
}

// SetIngestionIdentifier sets the IngestionIdentifier field's value.
func (s *CreateIngestionDestinationInput) SetIngestionIdentifier(v string) *CreateIngestionDestinationInput {
	s.IngestionIdentifier = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *CreateIngestionDestinationInput) SetProcessingConfiguration(v *ProcessingConfiguration) *CreateIngestionDestinationInput {
	s.ProcessingConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIngestionDestinationInput) SetTags(v []*Tag) *CreateIngestionDestinationInput {
	s.Tags = v
	return s
}

type CreateIngestionDestinationOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an ingestion destination.
	//
	// IngestionDestination is a required field
	IngestionDestination *IngestionDestination `locationName:"ingestionDestination" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionDestinationOutput) GoString() string {
	return s.String()
}

// SetIngestionDestination sets the IngestionDestination field's value.
func (s *CreateIngestionDestinationOutput) SetIngestionDestination(v *IngestionDestination) *CreateIngestionDestinationOutput {
	s.IngestionDestination = v
	return s
}

type CreateIngestionInput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// Valid values are:
	//
	//    * SLACK
	//
	//    * ASANA
	//
	//    * JIRA
	//
	//    * M365
	//
	//    * M365AUDITLOGS
	//
	//    * ZOOM
	//
	//    * ZENDESK
	//
	//    * OKTA
	//
	//    * GOOGLE
	//
	//    * DROPBOX
	//
	//    * SMARTSHEET
	//
	//    * CISCO
	//
	// App is a required field
	App *string `locationName:"app" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The ingestion type.
	//
	// IngestionType is a required field
	IngestionType *string `locationName:"ingestionType" type:"string" required:"true" enum:"IngestionType"`

	// A map of the key-value pairs of the tag or tags to assign to the resource.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The ID of the application tenant.
	//
	// TenantId is a required field
	TenantId *string `locationName:"tenantId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIngestionInput"}
	if s.App == nil {
		invalidParams.Add(request.NewErrParamRequired("App"))
	}
	if s.App != nil && len(*s.App) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("App", 1))
	}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.IngestionType == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionType"))
	}
	if s.TenantId == nil {
		invalidParams.Add(request.NewErrParamRequired("TenantId"))
	}
	if s.TenantId != nil && len(*s.TenantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TenantId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApp sets the App field's value.
func (s *CreateIngestionInput) SetApp(v string) *CreateIngestionInput {
	s.App = &v
	return s
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *CreateIngestionInput) SetAppBundleIdentifier(v string) *CreateIngestionInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateIngestionInput) SetClientToken(v string) *CreateIngestionInput {
	s.ClientToken = &v
	return s
}

// SetIngestionType sets the IngestionType field's value.
func (s *CreateIngestionInput) SetIngestionType(v string) *CreateIngestionInput {
	s.IngestionType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIngestionInput) SetTags(v []*Tag) *CreateIngestionInput {
	s.Tags = v
	return s
}

// SetTenantId sets the TenantId field's value.
func (s *CreateIngestionInput) SetTenantId(v string) *CreateIngestionInput {
	s.TenantId = &v
	return s
}

type CreateIngestionOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an ingestion.
	//
	// Ingestion is a required field
	Ingestion *Ingestion `locationName:"ingestion" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionOutput) GoString() string {
	return s.String()
}

// SetIngestion sets the Ingestion field's value.
func (s *CreateIngestionOutput) SetIngestion(v *Ingestion) *CreateIngestionOutput {
	s.Ingestion = v
	return s
}

// Contains credential information for an application.
type Credential struct {
	_ struct{} `type:"structure"`

	// Contains API key credential information.
	ApiKeyCredential *ApiKeyCredential `locationName:"apiKeyCredential" type:"structure"`

	// Contains OAuth2 client credential information.
	Oauth2Credential *Oauth2Credential `locationName:"oauth2Credential" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Credential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Credential) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Credential) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Credential"}
	if s.ApiKeyCredential != nil {
		if err := s.ApiKeyCredential.Validate(); err != nil {
			invalidParams.AddNested("ApiKeyCredential", err.(request.ErrInvalidParams))
		}
	}
	if s.Oauth2Credential != nil {
		if err := s.Oauth2Credential.Validate(); err != nil {
			invalidParams.AddNested("Oauth2Credential", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKeyCredential sets the ApiKeyCredential field's value.
func (s *Credential) SetApiKeyCredential(v *ApiKeyCredential) *Credential {
	s.ApiKeyCredential = v
	return s
}

// SetOauth2Credential sets the Oauth2Credential field's value.
func (s *Credential) SetOauth2Credential(v *Oauth2Credential) *Credential {
	s.Oauth2Credential = v
	return s
}

type DeleteAppAuthorizationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app authorization to use for the request.
	//
	// AppAuthorizationIdentifier is a required field
	AppAuthorizationIdentifier *string `location:"uri" locationName:"appAuthorizationIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppAuthorizationInput"}
	if s.AppAuthorizationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppAuthorizationIdentifier"))
	}
	if s.AppAuthorizationIdentifier != nil && len(*s.AppAuthorizationIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppAuthorizationIdentifier", 1))
	}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppAuthorizationIdentifier sets the AppAuthorizationIdentifier field's value.
func (s *DeleteAppAuthorizationInput) SetAppAuthorizationIdentifier(v string) *DeleteAppAuthorizationInput {
	s.AppAuthorizationIdentifier = &v
	return s
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *DeleteAppAuthorizationInput) SetAppBundleIdentifier(v string) *DeleteAppAuthorizationInput {
	s.AppBundleIdentifier = &v
	return s
}

type DeleteAppAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppAuthorizationOutput) GoString() string {
	return s.String()
}

type DeleteAppBundleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the app bundle that needs to be deleted.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppBundleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppBundleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppBundleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppBundleInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *DeleteAppBundleInput) SetAppBundleIdentifier(v string) *DeleteAppBundleInput {
	s.AppBundleIdentifier = &v
	return s
}

type DeleteAppBundleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppBundleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppBundleOutput) GoString() string {
	return s.String()
}

type DeleteIngestionDestinationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// ingestion destination to use for the request.
	//
	// IngestionDestinationIdentifier is a required field
	IngestionDestinationIdentifier *string `location:"uri" locationName:"ingestionDestinationIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// ingestion to use for the request.
	//
	// IngestionIdentifier is a required field
	IngestionIdentifier *string `location:"uri" locationName:"ingestionIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIngestionDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIngestionDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIngestionDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIngestionDestinationInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.IngestionDestinationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionDestinationIdentifier"))
	}
	if s.IngestionDestinationIdentifier != nil && len(*s.IngestionDestinationIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionDestinationIdentifier", 1))
	}
	if s.IngestionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionIdentifier"))
	}
	if s.IngestionIdentifier != nil && len(*s.IngestionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *DeleteIngestionDestinationInput) SetAppBundleIdentifier(v string) *DeleteIngestionDestinationInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetIngestionDestinationIdentifier sets the IngestionDestinationIdentifier field's value.
func (s *DeleteIngestionDestinationInput) SetIngestionDestinationIdentifier(v string) *DeleteIngestionDestinationInput {
	s.IngestionDestinationIdentifier = &v
	return s
}

// SetIngestionIdentifier sets the IngestionIdentifier field's value.
func (s *DeleteIngestionDestinationInput) SetIngestionIdentifier(v string) *DeleteIngestionDestinationInput {
	s.IngestionIdentifier = &v
	return s
}

type DeleteIngestionDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIngestionDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIngestionDestinationOutput) GoString() string {
	return s.String()
}

type DeleteIngestionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// ingestion to use for the request.
	//
	// IngestionIdentifier is a required field
	IngestionIdentifier *string `location:"uri" locationName:"ingestionIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIngestionInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.IngestionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionIdentifier"))
	}
	if s.IngestionIdentifier != nil && len(*s.IngestionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *DeleteIngestionInput) SetAppBundleIdentifier(v string) *DeleteIngestionInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetIngestionIdentifier sets the IngestionIdentifier field's value.
func (s *DeleteIngestionInput) SetIngestionIdentifier(v string) *DeleteIngestionInput {
	s.IngestionIdentifier = &v
	return s
}

type DeleteIngestionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIngestionOutput) GoString() string {
	return s.String()
}

// Contains information about an audit log destination.
type Destination struct {
	_ struct{} `type:"structure"`

	// Contains information about an Amazon Kinesis Data Firehose delivery stream.
	FirehoseStream *FirehoseStream `locationName:"firehoseStream" type:"structure"`

	// Contains information about an Amazon S3 bucket.
	S3Bucket *S3Bucket `locationName:"s3Bucket" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Destination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Destination"}
	if s.FirehoseStream != nil {
		if err := s.FirehoseStream.Validate(); err != nil {
			invalidParams.AddNested("FirehoseStream", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Bucket != nil {
		if err := s.S3Bucket.Validate(); err != nil {
			invalidParams.AddNested("S3Bucket", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirehoseStream sets the FirehoseStream field's value.
func (s *Destination) SetFirehoseStream(v *FirehoseStream) *Destination {
	s.FirehoseStream = v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *Destination) SetS3Bucket(v *S3Bucket) *Destination {
	s.S3Bucket = v
	return s
}

// Contains information about the destination of ingested data.
type DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains information about an audit log destination configuration.
	AuditLog *AuditLogDestinationConfiguration `locationName:"auditLog" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationConfiguration"}
	if s.AuditLog != nil {
		if err := s.AuditLog.Validate(); err != nil {
			invalidParams.AddNested("AuditLog", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuditLog sets the AuditLog field's value.
func (s *DestinationConfiguration) SetAuditLog(v *AuditLogDestinationConfiguration) *DestinationConfiguration {
	s.AuditLog = v
	return s
}

// Contains information about an Amazon Kinesis Data Firehose delivery stream.
type FirehoseStream struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Kinesis Data Firehose delivery stream.
	//
	// StreamName is a required field
	StreamName *string `locationName:"streamName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirehoseStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirehoseStream) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FirehoseStream) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FirehoseStream"}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamName sets the StreamName field's value.
func (s *FirehoseStream) SetStreamName(v string) *FirehoseStream {
	s.StreamName = &v
	return s
}

type GetAppAuthorizationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app authorization to use for the request.
	//
	// AppAuthorizationIdentifier is a required field
	AppAuthorizationIdentifier *string `location:"uri" locationName:"appAuthorizationIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppAuthorizationInput"}
	if s.AppAuthorizationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppAuthorizationIdentifier"))
	}
	if s.AppAuthorizationIdentifier != nil && len(*s.AppAuthorizationIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppAuthorizationIdentifier", 1))
	}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppAuthorizationIdentifier sets the AppAuthorizationIdentifier field's value.
func (s *GetAppAuthorizationInput) SetAppAuthorizationIdentifier(v string) *GetAppAuthorizationInput {
	s.AppAuthorizationIdentifier = &v
	return s
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *GetAppAuthorizationInput) SetAppBundleIdentifier(v string) *GetAppAuthorizationInput {
	s.AppBundleIdentifier = &v
	return s
}

type GetAppAuthorizationOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an app authorization.
	//
	// AppAuthorization is a required field
	AppAuthorization *AppAuthorization `locationName:"appAuthorization" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppAuthorizationOutput) GoString() string {
	return s.String()
}

// SetAppAuthorization sets the AppAuthorization field's value.
func (s *GetAppAuthorizationOutput) SetAppAuthorization(v *AppAuthorization) *GetAppAuthorizationOutput {
	s.AppAuthorization = v
	return s
}

type GetAppBundleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppBundleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppBundleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppBundleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppBundleInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *GetAppBundleInput) SetAppBundleIdentifier(v string) *GetAppBundleInput {
	s.AppBundleIdentifier = &v
	return s
}

type GetAppBundleOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an app bundle.
	//
	// AppBundle is a required field
	AppBundle *AppBundle `locationName:"appBundle" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppBundleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppBundleOutput) GoString() string {
	return s.String()
}

// SetAppBundle sets the AppBundle field's value.
func (s *GetAppBundleOutput) SetAppBundle(v *AppBundle) *GetAppBundleOutput {
	s.AppBundle = v
	return s
}

type GetIngestionDestinationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// ingestion destination to use for the request.
	//
	// IngestionDestinationIdentifier is a required field
	IngestionDestinationIdentifier *string `location:"uri" locationName:"ingestionDestinationIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// ingestion to use for the request.
	//
	// IngestionIdentifier is a required field
	IngestionIdentifier *string `location:"uri" locationName:"ingestionIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIngestionDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIngestionDestinationInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.IngestionDestinationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionDestinationIdentifier"))
	}
	if s.IngestionDestinationIdentifier != nil && len(*s.IngestionDestinationIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionDestinationIdentifier", 1))
	}
	if s.IngestionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionIdentifier"))
	}
	if s.IngestionIdentifier != nil && len(*s.IngestionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *GetIngestionDestinationInput) SetAppBundleIdentifier(v string) *GetIngestionDestinationInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetIngestionDestinationIdentifier sets the IngestionDestinationIdentifier field's value.
func (s *GetIngestionDestinationInput) SetIngestionDestinationIdentifier(v string) *GetIngestionDestinationInput {
	s.IngestionDestinationIdentifier = &v
	return s
}

// SetIngestionIdentifier sets the IngestionIdentifier field's value.
func (s *GetIngestionDestinationInput) SetIngestionIdentifier(v string) *GetIngestionDestinationInput {
	s.IngestionIdentifier = &v
	return s
}

type GetIngestionDestinationOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an ingestion destination.
	//
	// IngestionDestination is a required field
	IngestionDestination *IngestionDestination `locationName:"ingestionDestination" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionDestinationOutput) GoString() string {
	return s.String()
}

// SetIngestionDestination sets the IngestionDestination field's value.
func (s *GetIngestionDestinationOutput) SetIngestionDestination(v *IngestionDestination) *GetIngestionDestinationOutput {
	s.IngestionDestination = v
	return s
}

type GetIngestionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// ingestion to use for the request.
	//
	// IngestionIdentifier is a required field
	IngestionIdentifier *string `location:"uri" locationName:"ingestionIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIngestionInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.IngestionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionIdentifier"))
	}
	if s.IngestionIdentifier != nil && len(*s.IngestionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *GetIngestionInput) SetAppBundleIdentifier(v string) *GetIngestionInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetIngestionIdentifier sets the IngestionIdentifier field's value.
func (s *GetIngestionInput) SetIngestionIdentifier(v string) *GetIngestionInput {
	s.IngestionIdentifier = &v
	return s
}

type GetIngestionOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an ingestion.
	//
	// Ingestion is a required field
	Ingestion *Ingestion `locationName:"ingestion" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionOutput) GoString() string {
	return s.String()
}

// SetIngestion sets the Ingestion field's value.
func (s *GetIngestionOutput) SetIngestion(v *Ingestion) *GetIngestionOutput {
	s.Ingestion = v
	return s
}

// Contains information about an ingestion.
type Ingestion struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// App is a required field
	App *string `locationName:"app" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the app bundle for the ingestion.
	//
	// AppBundleArn is a required field
	AppBundleArn *string `locationName:"appBundleArn" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the ingestion.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The timestamp of when the ingestion was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The type of the ingestion.
	//
	// IngestionType is a required field
	IngestionType *string `locationName:"ingestionType" type:"string" required:"true" enum:"IngestionType"`

	// The status of the ingestion.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"IngestionState"`

	// The ID of the application tenant.
	//
	// TenantId is a required field
	TenantId *string `locationName:"tenantId" min:"1" type:"string" required:"true"`

	// The timestamp of when the ingestion was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ingestion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ingestion) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *Ingestion) SetApp(v string) *Ingestion {
	s.App = &v
	return s
}

// SetAppBundleArn sets the AppBundleArn field's value.
func (s *Ingestion) SetAppBundleArn(v string) *Ingestion {
	s.AppBundleArn = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Ingestion) SetArn(v string) *Ingestion {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Ingestion) SetCreatedAt(v time.Time) *Ingestion {
	s.CreatedAt = &v
	return s
}

// SetIngestionType sets the IngestionType field's value.
func (s *Ingestion) SetIngestionType(v string) *Ingestion {
	s.IngestionType = &v
	return s
}

// SetState sets the State field's value.
func (s *Ingestion) SetState(v string) *Ingestion {
	s.State = &v
	return s
}

// SetTenantId sets the TenantId field's value.
func (s *Ingestion) SetTenantId(v string) *Ingestion {
	s.TenantId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Ingestion) SetUpdatedAt(v time.Time) *Ingestion {
	s.UpdatedAt = &v
	return s
}

// Contains information about an ingestion destination.
type IngestionDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the ingestion destination.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The timestamp of when the ingestion destination was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// Contains information about the destination of ingested data.
	//
	// DestinationConfiguration is a required field
	DestinationConfiguration *DestinationConfiguration `locationName:"destinationConfiguration" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the ingestion.
	//
	// IngestionArn is a required field
	IngestionArn *string `locationName:"ingestionArn" min:"1" type:"string" required:"true"`

	// Contains information about how ingested data is processed.
	//
	// ProcessingConfiguration is a required field
	ProcessingConfiguration *ProcessingConfiguration `locationName:"processingConfiguration" type:"structure" required:"true"`

	// The state of the ingestion destination.
	//
	// The following states are possible:
	//
	//    * Active: The ingestion destination is active and is ready to be used.
	//
	//    * Failed: The ingestion destination has failed. If the ingestion destination
	//    is in this state, you should verify the ingestion destination configuration
	//    and try again.
	Status *string `locationName:"status" type:"string" enum:"IngestionDestinationStatus"`

	// The reason for the current status of the ingestion destination.
	//
	// Only present when the status of ingestion destination is Failed.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The timestamp of when the ingestion destination was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionDestination) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *IngestionDestination) SetArn(v string) *IngestionDestination {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *IngestionDestination) SetCreatedAt(v time.Time) *IngestionDestination {
	s.CreatedAt = &v
	return s
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *IngestionDestination) SetDestinationConfiguration(v *DestinationConfiguration) *IngestionDestination {
	s.DestinationConfiguration = v
	return s
}

// SetIngestionArn sets the IngestionArn field's value.
func (s *IngestionDestination) SetIngestionArn(v string) *IngestionDestination {
	s.IngestionArn = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *IngestionDestination) SetProcessingConfiguration(v *ProcessingConfiguration) *IngestionDestination {
	s.ProcessingConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *IngestionDestination) SetStatus(v string) *IngestionDestination {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *IngestionDestination) SetStatusReason(v string) *IngestionDestination {
	s.StatusReason = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *IngestionDestination) SetUpdatedAt(v time.Time) *IngestionDestination {
	s.UpdatedAt = &v
	return s
}

// Contains a summary of an ingestion destination.
type IngestionDestinationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the ingestion destination.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionDestinationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionDestinationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *IngestionDestinationSummary) SetArn(v string) *IngestionDestinationSummary {
	s.Arn = &v
	return s
}

// Contains a summary of an ingestion.
type IngestionSummary struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// App is a required field
	App *string `locationName:"app" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the ingestion.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The status of the ingestion.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"IngestionState"`

	// The ID of the application tenant.
	//
	// TenantId is a required field
	TenantId *string `locationName:"tenantId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionSummary) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *IngestionSummary) SetApp(v string) *IngestionSummary {
	s.App = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *IngestionSummary) SetArn(v string) *IngestionSummary {
	s.Arn = &v
	return s
}

// SetState sets the State field's value.
func (s *IngestionSummary) SetState(v string) *IngestionSummary {
	s.State = &v
	return s
}

// SetTenantId sets the TenantId field's value.
func (s *IngestionSummary) SetTenantId(v string) *IngestionSummary {
	s.TenantId = &v
	return s
}

// The request processing has failed because of an unknown error, exception,
// or failure with an internal server.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The period of time after which you should retry your request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAppAuthorizationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// The maximum number of results that are returned per call. You can use nextToken
	// to obtain further pages of results.
	//
	// This is only an upper limit. The actual number of results returned per call
	// might be fewer than the specified maximum.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAuthorizationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAuthorizationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppAuthorizationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppAuthorizationsInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *ListAppAuthorizationsInput) SetAppBundleIdentifier(v string) *ListAppAuthorizationsInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppAuthorizationsInput) SetMaxResults(v int64) *ListAppAuthorizationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppAuthorizationsInput) SetNextToken(v string) *ListAppAuthorizationsInput {
	s.NextToken = &v
	return s
}

type ListAppAuthorizationsOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of app authorization summaries.
	//
	// AppAuthorizationSummaryList is a required field
	AppAuthorizationSummaryList []*AppAuthorizationSummary `locationName:"appAuthorizationSummaryList" type:"list" required:"true"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAuthorizationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAuthorizationsOutput) GoString() string {
	return s.String()
}

// SetAppAuthorizationSummaryList sets the AppAuthorizationSummaryList field's value.
func (s *ListAppAuthorizationsOutput) SetAppAuthorizationSummaryList(v []*AppAuthorizationSummary) *ListAppAuthorizationsOutput {
	s.AppAuthorizationSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppAuthorizationsOutput) SetNextToken(v string) *ListAppAuthorizationsOutput {
	s.NextToken = &v
	return s
}

type ListAppBundlesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned per call. You can use nextToken
	// to obtain further pages of results.
	//
	// This is only an upper limit. The actual number of results returned per call
	// might be fewer than the specified maximum.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppBundlesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppBundlesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppBundlesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppBundlesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppBundlesInput) SetMaxResults(v int64) *ListAppBundlesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppBundlesInput) SetNextToken(v string) *ListAppBundlesInput {
	s.NextToken = &v
	return s
}

type ListAppBundlesOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of app bundle summaries.
	//
	// AppBundleSummaryList is a required field
	AppBundleSummaryList []*AppBundleSummary `locationName:"appBundleSummaryList" type:"list" required:"true"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppBundlesOutput) GoString() string {
	return s.String()
}

// SetAppBundleSummaryList sets the AppBundleSummaryList field's value.
func (s *ListAppBundlesOutput) SetAppBundleSummaryList(v []*AppBundleSummary) *ListAppBundlesOutput {
	s.AppBundleSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppBundlesOutput) SetNextToken(v string) *ListAppBundlesOutput {
	s.NextToken = &v
	return s
}

type ListIngestionDestinationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// ingestion to use for the request.
	//
	// IngestionIdentifier is a required field
	IngestionIdentifier *string `location:"uri" locationName:"ingestionIdentifier" min:"1" type:"string" required:"true"`

	// The maximum number of results that are returned per call. You can use nextToken
	// to obtain further pages of results.
	//
	// This is only an upper limit. The actual number of results returned per call
	// might be fewer than the specified maximum.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionDestinationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionDestinationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIngestionDestinationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIngestionDestinationsInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.IngestionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionIdentifier"))
	}
	if s.IngestionIdentifier != nil && len(*s.IngestionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionIdentifier", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *ListIngestionDestinationsInput) SetAppBundleIdentifier(v string) *ListIngestionDestinationsInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetIngestionIdentifier sets the IngestionIdentifier field's value.
func (s *ListIngestionDestinationsInput) SetIngestionIdentifier(v string) *ListIngestionDestinationsInput {
	s.IngestionIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIngestionDestinationsInput) SetMaxResults(v int64) *ListIngestionDestinationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIngestionDestinationsInput) SetNextToken(v string) *ListIngestionDestinationsInput {
	s.NextToken = &v
	return s
}

type ListIngestionDestinationsOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of ingestion destination summaries.
	//
	// IngestionDestinations is a required field
	IngestionDestinations []*IngestionDestinationSummary `locationName:"ingestionDestinations" type:"list" required:"true"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionDestinationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionDestinationsOutput) GoString() string {
	return s.String()
}

// SetIngestionDestinations sets the IngestionDestinations field's value.
func (s *ListIngestionDestinationsOutput) SetIngestionDestinations(v []*IngestionDestinationSummary) *ListIngestionDestinationsOutput {
	s.IngestionDestinations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIngestionDestinationsOutput) SetNextToken(v string) *ListIngestionDestinationsOutput {
	s.NextToken = &v
	return s
}

type ListIngestionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// The maximum number of results that are returned per call. You can use nextToken
	// to obtain further pages of results.
	//
	// This is only an upper limit. The actual number of results returned per call
	// might be fewer than the specified maximum.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIngestionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIngestionsInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *ListIngestionsInput) SetAppBundleIdentifier(v string) *ListIngestionsInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIngestionsInput) SetMaxResults(v int64) *ListIngestionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIngestionsInput) SetNextToken(v string) *ListIngestionsInput {
	s.NextToken = &v
	return s
}

type ListIngestionsOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of ingestion summaries.
	//
	// Ingestions is a required field
	Ingestions []*IngestionSummary `locationName:"ingestions" type:"list" required:"true"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionsOutput) GoString() string {
	return s.String()
}

// SetIngestions sets the Ingestions field's value.
func (s *ListIngestionsOutput) SetIngestions(v []*IngestionSummary) *ListIngestionsOutput {
	s.Ingestions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIngestionsOutput) SetNextToken(v string) *ListIngestionsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource for which you want to retrieve
	// tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A map of the key-value pairs for the tag or tags assigned to the specified
	// resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Contains OAuth2 client credential information.
type Oauth2Credential struct {
	_ struct{} `type:"structure"`

	// The client ID of the client application.
	//
	// ClientId is a required field
	ClientId *string `locationName:"clientId" min:"1" type:"string" required:"true"`

	// The client secret of the client application.
	//
	// ClientSecret is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Oauth2Credential's
	// String and GoString methods.
	//
	// ClientSecret is a required field
	ClientSecret *string `locationName:"clientSecret" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Oauth2Credential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Oauth2Credential) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Oauth2Credential) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Oauth2Credential"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.ClientSecret == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientSecret"))
	}
	if s.ClientSecret != nil && len(*s.ClientSecret) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientSecret", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *Oauth2Credential) SetClientId(v string) *Oauth2Credential {
	s.ClientId = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *Oauth2Credential) SetClientSecret(v string) *Oauth2Credential {
	s.ClientSecret = &v
	return s
}

// Contains information about how ingested data is processed.
type ProcessingConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains information about an audit log processing configuration.
	AuditLog *AuditLogProcessingConfiguration `locationName:"auditLog" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProcessingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProcessingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProcessingConfiguration"}
	if s.AuditLog != nil {
		if err := s.AuditLog.Validate(); err != nil {
			invalidParams.AddNested("AuditLog", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuditLog sets the AuditLog field's value.
func (s *ProcessingConfiguration) SetAuditLog(v *AuditLogProcessingConfiguration) *ProcessingConfiguration {
	s.AuditLog = v
	return s
}

// The specified resource does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The resource ID.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about an Amazon S3 bucket.
type S3Bucket struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`

	// The object key to use.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Bucket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Bucket) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Bucket) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Bucket"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Bucket) SetBucketName(v string) *S3Bucket {
	s.BucketName = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3Bucket) SetPrefix(v string) *S3Bucket {
	s.Prefix = &v
	return s
}

// The request exceeds a service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The code for the quota exceeded.
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The resource ID.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// The code of the service.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartIngestionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// ingestion to use for the request.
	//
	// IngestionIdentifier is a required field
	IngestionIdentifier *string `location:"uri" locationName:"ingestionIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartIngestionInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.IngestionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionIdentifier"))
	}
	if s.IngestionIdentifier != nil && len(*s.IngestionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *StartIngestionInput) SetAppBundleIdentifier(v string) *StartIngestionInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetIngestionIdentifier sets the IngestionIdentifier field's value.
func (s *StartIngestionInput) SetIngestionIdentifier(v string) *StartIngestionInput {
	s.IngestionIdentifier = &v
	return s
}

type StartIngestionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIngestionOutput) GoString() string {
	return s.String()
}

type StartUserAccessTasksInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// The email address of the target user.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartUserAccessTasksInput's
	// String and GoString methods.
	//
	// Email is a required field
	Email *string `locationName:"email" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartUserAccessTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartUserAccessTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartUserAccessTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartUserAccessTasksInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *StartUserAccessTasksInput) SetAppBundleIdentifier(v string) *StartUserAccessTasksInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *StartUserAccessTasksInput) SetEmail(v string) *StartUserAccessTasksInput {
	s.Email = &v
	return s
}

type StartUserAccessTasksOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of user access task information.
	UserAccessTasksList []*UserAccessTaskItem `locationName:"userAccessTasksList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartUserAccessTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartUserAccessTasksOutput) GoString() string {
	return s.String()
}

// SetUserAccessTasksList sets the UserAccessTasksList field's value.
func (s *StartUserAccessTasksOutput) SetUserAccessTasksList(v []*UserAccessTaskItem) *StartUserAccessTasksOutput {
	s.UserAccessTasksList = v
	return s
}

type StopIngestionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// ingestion to use for the request.
	//
	// IngestionIdentifier is a required field
	IngestionIdentifier *string `location:"uri" locationName:"ingestionIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopIngestionInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.IngestionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionIdentifier"))
	}
	if s.IngestionIdentifier != nil && len(*s.IngestionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *StopIngestionInput) SetAppBundleIdentifier(v string) *StopIngestionInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetIngestionIdentifier sets the IngestionIdentifier field's value.
func (s *StopIngestionInput) SetIngestionIdentifier(v string) *StopIngestionInput {
	s.IngestionIdentifier = &v
	return s
}

type StopIngestionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopIngestionOutput) GoString() string {
	return s.String()
}

// The key or keys of the key-value pairs for the tag or tags assigned to a
// resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// Tag key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// Tag value.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A map of the key-value pairs of the tag or tags to assign to the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Contains information about an error returned from a user access task.
type TaskError struct {
	_ struct{} `type:"structure"`

	// The code of the error.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The message of the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *TaskError) SetErrorCode(v string) *TaskError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *TaskError) SetErrorMessage(v string) *TaskError {
	s.ErrorMessage = &v
	return s
}

// Contains information about an application tenant.
type Tenant struct {
	_ struct{} `type:"structure"`

	// The display name of the tenant.
	//
	// TenantDisplayName is a required field
	TenantDisplayName *string `locationName:"tenantDisplayName" min:"1" type:"string" required:"true"`

	// The ID of the application tenant.
	//
	// TenantIdentifier is a required field
	TenantIdentifier *string `locationName:"tenantIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tenant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tenant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tenant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tenant"}
	if s.TenantDisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("TenantDisplayName"))
	}
	if s.TenantDisplayName != nil && len(*s.TenantDisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TenantDisplayName", 1))
	}
	if s.TenantIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TenantIdentifier"))
	}
	if s.TenantIdentifier != nil && len(*s.TenantIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TenantIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTenantDisplayName sets the TenantDisplayName field's value.
func (s *Tenant) SetTenantDisplayName(v string) *Tenant {
	s.TenantDisplayName = &v
	return s
}

// SetTenantIdentifier sets the TenantIdentifier field's value.
func (s *Tenant) SetTenantIdentifier(v string) *Tenant {
	s.TenantIdentifier = &v
	return s
}

// The request rate exceeds the limit.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The code for the quota exceeded.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The period of time after which you should retry your request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The code of the service.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource that you want to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The keys of the key-value pairs for the tag or tags you want to remove from
	// the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAppAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app authorization to use for the request.
	//
	// AppAuthorizationIdentifier is a required field
	AppAuthorizationIdentifier *string `location:"uri" locationName:"appAuthorizationIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// Contains credentials for the application, such as an API key or OAuth2 client
	// ID and secret.
	//
	// Specify credentials that match the authorization type of the app authorization
	// to update. For example, if the authorization type of the app authorization
	// is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
	Credential *Credential `locationName:"credential" type:"structure"`

	// Contains information about an application tenant, such as the application
	// display name and identifier.
	Tenant *Tenant `locationName:"tenant" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppAuthorizationInput"}
	if s.AppAuthorizationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppAuthorizationIdentifier"))
	}
	if s.AppAuthorizationIdentifier != nil && len(*s.AppAuthorizationIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppAuthorizationIdentifier", 1))
	}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.Credential != nil {
		if err := s.Credential.Validate(); err != nil {
			invalidParams.AddNested("Credential", err.(request.ErrInvalidParams))
		}
	}
	if s.Tenant != nil {
		if err := s.Tenant.Validate(); err != nil {
			invalidParams.AddNested("Tenant", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppAuthorizationIdentifier sets the AppAuthorizationIdentifier field's value.
func (s *UpdateAppAuthorizationInput) SetAppAuthorizationIdentifier(v string) *UpdateAppAuthorizationInput {
	s.AppAuthorizationIdentifier = &v
	return s
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *UpdateAppAuthorizationInput) SetAppBundleIdentifier(v string) *UpdateAppAuthorizationInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetCredential sets the Credential field's value.
func (s *UpdateAppAuthorizationInput) SetCredential(v *Credential) *UpdateAppAuthorizationInput {
	s.Credential = v
	return s
}

// SetTenant sets the Tenant field's value.
func (s *UpdateAppAuthorizationInput) SetTenant(v *Tenant) *UpdateAppAuthorizationInput {
	s.Tenant = v
	return s
}

type UpdateAppAuthorizationOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an app authorization.
	//
	// AppAuthorization is a required field
	AppAuthorization *AppAuthorization `locationName:"appAuthorization" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppAuthorizationOutput) GoString() string {
	return s.String()
}

// SetAppAuthorization sets the AppAuthorization field's value.
func (s *UpdateAppAuthorizationOutput) SetAppAuthorization(v *AppAuthorization) *UpdateAppAuthorizationOutput {
	s.AppAuthorization = v
	return s
}

type UpdateIngestionDestinationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// app bundle to use for the request.
	//
	// AppBundleIdentifier is a required field
	AppBundleIdentifier *string `location:"uri" locationName:"appBundleIdentifier" min:"1" type:"string" required:"true"`

	// Contains information about the destination of ingested data.
	//
	// DestinationConfiguration is a required field
	DestinationConfiguration *DestinationConfiguration `locationName:"destinationConfiguration" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// ingestion destination to use for the request.
	//
	// IngestionDestinationIdentifier is a required field
	IngestionDestinationIdentifier *string `location:"uri" locationName:"ingestionDestinationIdentifier" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
	// ingestion to use for the request.
	//
	// IngestionIdentifier is a required field
	IngestionIdentifier *string `location:"uri" locationName:"ingestionIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIngestionDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIngestionDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIngestionDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIngestionDestinationInput"}
	if s.AppBundleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBundleIdentifier"))
	}
	if s.AppBundleIdentifier != nil && len(*s.AppBundleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBundleIdentifier", 1))
	}
	if s.DestinationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationConfiguration"))
	}
	if s.IngestionDestinationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionDestinationIdentifier"))
	}
	if s.IngestionDestinationIdentifier != nil && len(*s.IngestionDestinationIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionDestinationIdentifier", 1))
	}
	if s.IngestionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionIdentifier"))
	}
	if s.IngestionIdentifier != nil && len(*s.IngestionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionIdentifier", 1))
	}
	if s.DestinationConfiguration != nil {
		if err := s.DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBundleIdentifier sets the AppBundleIdentifier field's value.
func (s *UpdateIngestionDestinationInput) SetAppBundleIdentifier(v string) *UpdateIngestionDestinationInput {
	s.AppBundleIdentifier = &v
	return s
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *UpdateIngestionDestinationInput) SetDestinationConfiguration(v *DestinationConfiguration) *UpdateIngestionDestinationInput {
	s.DestinationConfiguration = v
	return s
}

// SetIngestionDestinationIdentifier sets the IngestionDestinationIdentifier field's value.
func (s *UpdateIngestionDestinationInput) SetIngestionDestinationIdentifier(v string) *UpdateIngestionDestinationInput {
	s.IngestionDestinationIdentifier = &v
	return s
}

// SetIngestionIdentifier sets the IngestionIdentifier field's value.
func (s *UpdateIngestionDestinationInput) SetIngestionIdentifier(v string) *UpdateIngestionDestinationInput {
	s.IngestionIdentifier = &v
	return s
}

type UpdateIngestionDestinationOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an ingestion destination.
	//
	// IngestionDestination is a required field
	IngestionDestination *IngestionDestination `locationName:"ingestionDestination" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIngestionDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIngestionDestinationOutput) GoString() string {
	return s.String()
}

// SetIngestionDestination sets the IngestionDestination field's value.
func (s *UpdateIngestionDestinationOutput) SetIngestionDestination(v *IngestionDestination) *UpdateIngestionDestinationOutput {
	s.IngestionDestination = v
	return s
}

// Contains information about a user's access to an application.
type UserAccessResultItem struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	App *string `locationName:"app" min:"1" type:"string"`

	// The email address of the target user.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UserAccessResultItem's
	// String and GoString methods.
	Email *string `locationName:"email" type:"string" sensitive:"true"`

	// The status of the user access result item.
	//
	// The following states are possible:
	//
	//    * IN_PROGRESS: The user access task is in progress.
	//
	//    * COMPLETED: The user access task completed successfully.
	//
	//    * FAILED: The user access task failed.
	//
	//    * EXPIRED: The user access task expired.
	ResultStatus *string `locationName:"resultStatus" type:"string" enum:"ResultStatus"`

	// Contains information about an error returned from a user access task.
	TaskError *TaskError `locationName:"taskError" type:"structure"`

	// The unique ID of the task.
	TaskId *string `locationName:"taskId" type:"string"`

	// The display name of the tenant.
	TenantDisplayName *string `locationName:"tenantDisplayName" min:"1" type:"string"`

	// The ID of the application tenant.
	TenantId *string `locationName:"tenantId" min:"1" type:"string"`

	// The first name of the user.
	//
	// UserFirstName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UserAccessResultItem's
	// String and GoString methods.
	UserFirstName *string `locationName:"userFirstName" min:"1" type:"string" sensitive:"true"`

	// The full name of the user.
	//
	// UserFullName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UserAccessResultItem's
	// String and GoString methods.
	UserFullName *string `locationName:"userFullName" min:"1" type:"string" sensitive:"true"`

	// The unique ID of user.
	//
	// UserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UserAccessResultItem's
	// String and GoString methods.
	UserId *string `locationName:"userId" min:"1" type:"string" sensitive:"true"`

	// The last name of the user.
	//
	// UserLastName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UserAccessResultItem's
	// String and GoString methods.
	UserLastName *string `locationName:"userLastName" min:"1" type:"string" sensitive:"true"`

	// The status of the user returned by the application.
	UserStatus *string `locationName:"userStatus" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAccessResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAccessResultItem) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *UserAccessResultItem) SetApp(v string) *UserAccessResultItem {
	s.App = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *UserAccessResultItem) SetEmail(v string) *UserAccessResultItem {
	s.Email = &v
	return s
}

// SetResultStatus sets the ResultStatus field's value.
func (s *UserAccessResultItem) SetResultStatus(v string) *UserAccessResultItem {
	s.ResultStatus = &v
	return s
}

// SetTaskError sets the TaskError field's value.
func (s *UserAccessResultItem) SetTaskError(v *TaskError) *UserAccessResultItem {
	s.TaskError = v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *UserAccessResultItem) SetTaskId(v string) *UserAccessResultItem {
	s.TaskId = &v
	return s
}

// SetTenantDisplayName sets the TenantDisplayName field's value.
func (s *UserAccessResultItem) SetTenantDisplayName(v string) *UserAccessResultItem {
	s.TenantDisplayName = &v
	return s
}

// SetTenantId sets the TenantId field's value.
func (s *UserAccessResultItem) SetTenantId(v string) *UserAccessResultItem {
	s.TenantId = &v
	return s
}

// SetUserFirstName sets the UserFirstName field's value.
func (s *UserAccessResultItem) SetUserFirstName(v string) *UserAccessResultItem {
	s.UserFirstName = &v
	return s
}

// SetUserFullName sets the UserFullName field's value.
func (s *UserAccessResultItem) SetUserFullName(v string) *UserAccessResultItem {
	s.UserFullName = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UserAccessResultItem) SetUserId(v string) *UserAccessResultItem {
	s.UserId = &v
	return s
}

// SetUserLastName sets the UserLastName field's value.
func (s *UserAccessResultItem) SetUserLastName(v string) *UserAccessResultItem {
	s.UserLastName = &v
	return s
}

// SetUserStatus sets the UserStatus field's value.
func (s *UserAccessResultItem) SetUserStatus(v string) *UserAccessResultItem {
	s.UserStatus = &v
	return s
}

// Contains information about a user access task.
type UserAccessTaskItem struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// App is a required field
	App *string `locationName:"app" min:"1" type:"string" required:"true"`

	// Error from the task, if any.
	Error *TaskError `locationName:"error" type:"structure"`

	// The unique ID of the task.
	TaskId *string `locationName:"taskId" type:"string"`

	// The ID of the application tenant.
	//
	// TenantId is a required field
	TenantId *string `locationName:"tenantId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAccessTaskItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAccessTaskItem) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *UserAccessTaskItem) SetApp(v string) *UserAccessTaskItem {
	s.App = &v
	return s
}

// SetError sets the Error field's value.
func (s *UserAccessTaskItem) SetError(v *TaskError) *UserAccessTaskItem {
	s.Error = v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *UserAccessTaskItem) SetTaskId(v string) *UserAccessTaskItem {
	s.TaskId = &v
	return s
}

// SetTenantId sets the TenantId field's value.
func (s *UserAccessTaskItem) SetTenantId(v string) *UserAccessTaskItem {
	s.TenantId = &v
	return s
}

// The request has invalid or missing parameters.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The field list.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the exception.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input failed to meet the constraints specified by the Amazon Web Services
// service in a specified field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message about the validation exception.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The field name where the invalid entry was detected.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AppAuthorizationStatusPendingConnect is a AppAuthorizationStatus enum value
	AppAuthorizationStatusPendingConnect = "PendingConnect"

	// AppAuthorizationStatusConnected is a AppAuthorizationStatus enum value
	AppAuthorizationStatusConnected = "Connected"

	// AppAuthorizationStatusConnectionValidationFailed is a AppAuthorizationStatus enum value
	AppAuthorizationStatusConnectionValidationFailed = "ConnectionValidationFailed"

	// AppAuthorizationStatusTokenAutoRotationFailed is a AppAuthorizationStatus enum value
	AppAuthorizationStatusTokenAutoRotationFailed = "TokenAutoRotationFailed"
)

// AppAuthorizationStatus_Values returns all elements of the AppAuthorizationStatus enum
func AppAuthorizationStatus_Values() []string {
	return []string{
		AppAuthorizationStatusPendingConnect,
		AppAuthorizationStatusConnected,
		AppAuthorizationStatusConnectionValidationFailed,
		AppAuthorizationStatusTokenAutoRotationFailed,
	}
}

const (
	// AuthTypeOauth2 is a AuthType enum value
	AuthTypeOauth2 = "oauth2"

	// AuthTypeApiKey is a AuthType enum value
	AuthTypeApiKey = "apiKey"
)

// AuthType_Values returns all elements of the AuthType enum
func AuthType_Values() []string {
	return []string{
		AuthTypeOauth2,
		AuthTypeApiKey,
	}
}

const (
	// FormatJson is a Format enum value
	FormatJson = "json"

	// FormatParquet is a Format enum value
	FormatParquet = "parquet"
)

// Format_Values returns all elements of the Format enum
func Format_Values() []string {
	return []string{
		FormatJson,
		FormatParquet,
	}
}

const (
	// IngestionDestinationStatusActive is a IngestionDestinationStatus enum value
	IngestionDestinationStatusActive = "Active"

	// IngestionDestinationStatusFailed is a IngestionDestinationStatus enum value
	IngestionDestinationStatusFailed = "Failed"
)

// IngestionDestinationStatus_Values returns all elements of the IngestionDestinationStatus enum
func IngestionDestinationStatus_Values() []string {
	return []string{
		IngestionDestinationStatusActive,
		IngestionDestinationStatusFailed,
	}
}

const (
	// IngestionStateEnabled is a IngestionState enum value
	IngestionStateEnabled = "enabled"

	// IngestionStateDisabled is a IngestionState enum value
	IngestionStateDisabled = "disabled"
)

// IngestionState_Values returns all elements of the IngestionState enum
func IngestionState_Values() []string {
	return []string{
		IngestionStateEnabled,
		IngestionStateDisabled,
	}
}

const (
	// IngestionTypeAuditLog is a IngestionType enum value
	IngestionTypeAuditLog = "auditLog"
)

// IngestionType_Values returns all elements of the IngestionType enum
func IngestionType_Values() []string {
	return []string{
		IngestionTypeAuditLog,
	}
}

const (
	// PersonaAdmin is a Persona enum value
	PersonaAdmin = "admin"

	// PersonaEndUser is a Persona enum value
	PersonaEndUser = "endUser"
)

// Persona_Values returns all elements of the Persona enum
func Persona_Values() []string {
	return []string{
		PersonaAdmin,
		PersonaEndUser,
	}
}

const (
	// ResultStatusInProgress is a ResultStatus enum value
	ResultStatusInProgress = "IN_PROGRESS"

	// ResultStatusCompleted is a ResultStatus enum value
	ResultStatusCompleted = "COMPLETED"

	// ResultStatusFailed is a ResultStatus enum value
	ResultStatusFailed = "FAILED"

	// ResultStatusExpired is a ResultStatus enum value
	ResultStatusExpired = "EXPIRED"
)

// ResultStatus_Values returns all elements of the ResultStatus enum
func ResultStatus_Values() []string {
	return []string{
		ResultStatusInProgress,
		ResultStatusCompleted,
		ResultStatusFailed,
		ResultStatusExpired,
	}
}

const (
	// SchemaOcsf is a Schema enum value
	SchemaOcsf = "ocsf"

	// SchemaRaw is a Schema enum value
	SchemaRaw = "raw"
)

// Schema_Values returns all elements of the Schema enum
func Schema_Values() []string {
	return []string{
		SchemaOcsf,
		SchemaRaw,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
