/* recursive-decent parser
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __PARSER_H__
#define __PARSER_H__

typedef struct {
    boolean keep_page;
    boolean keep_bank;
    boolean pass_in_w;
} block_options_t;

/* forwards */
tree parse_statement_list(void);
void parse_assembler_list(void);
tree parse_expression(void);
extern tree current_subprogram;

/* usefull macros */
#define if_advance_return( x, y ) { \
   if( scanner_is_like_advance( x ) ){ \
      y; return true; } }
#define if_return( x, y ) { \
   if( scanner_is_like( x ) ){ \
      y; return true; } }

#define log_parse( s ){ \
   if( verbose_parser ) log(( m, "%s line=%d token='%s'", s, \
      ( ( ( scanner_context != NULL ) && ( scanner_here() != NULL ) ) \
        ? scanner_here()->line_nr : -1 ), \
      ( ( ( scanner_context != NULL ) && ( scanner_context->token != NULL ) ) \
         ? scanner_context->token : "<no context>" ) )); \
}

void force_type(tree p, tree t);

tree parse_op(loc_t loc, tree left, int op, tree f(void));

tree parse_constant(void);

tree parse_expect_constant(void);

void parse_procedure_call(loc_t loc, tree d);
tree f_parse_procedure_call(loc_t loc, tree d);
extern boolean procedure_is_constant;
extern boolean is_now_actual;
tree parse_primitive(void);

tree parse_primary(void);

#define parse_try_op( loc, left, op, lower ){ \
   loc_t loc = scanner_here(); \
   if( scanner_is_like( op_name[ op ] ) ){ \
     tree p; \
     log_parse( "parse_try_op 1" ) \
     p = parse_op( loc, left, op, lower ); \
     log_parse( "parse_try_op 2" ) \
     return p; \
   } \
}

tree parse_factor(void);

tree parse_term(void);

tree parse_simple(void);

tree parse_relation(void);

tree parse_expression(void);

void parse_assign(tree d);

tree parse_type(boolean universal_allowed);

void parse_optional_address(tree p);

void parse_var(void);

void parse_const(void);


/* if statement */
tree parse_if(loc_t loc);

void old_parse_if(loc_t loc);

tree create_while(loc_t loc, tree condition, tree body);

/* while statement */
void parse_while(loc_t loc, tree condition);

/* for statement */
void parse_for(loc_t loc);

/* procedure call */
tree f_parse_procedure_call(loc_t loc, tree d);

void parse_procedure_call(loc_t loc, tree d);


tree parse_argument(void);

void parse_formal_parameters(boolean * has_out);

/* subprogram declaration */
extern tree last_subprogram;
void parse_subprogram_declaration2(tree p, boolean is_function, boolean is_operator,
                                   tree surrounding_subprogram);

void parse_subprogram_declaration(boolean is_function, boolean is_operator);

void parse_return(void);


/* function declaration */
void parse_function_declaration(void);

/* operator declaration */
void parse_operator_declaration(void);

/* procedure declaration */
void parse_procedure_declaration(void);

void parse_test_assert(loc_t loc);

void parse_pragma_test(loc_t loc);

void parse_pragma_name(loc_t loc);

boolean parse_on_off(void);


/* old int eeprom_start = 0x2100; */
#define eeprom_start ( ( target_cpu != pic_16 ) ? 0x2100 : 0xF00000 )
extern int eeprom_index;
extern int eeprom_data[2048];
extern int eeprom_last;
boolean parse_pragma_eedata(void);

void parse_pragma_target(loc_t loc);

boolean parse_pragma_keep_var(void);

boolean parse_pragma_keep(void);


boolean parse_pragma_optimize(boolean polarity);

/* a possible interrupt routine */
extern tree interrupt_service_routine;

void parse_pragma(loc_t loc);

void parse_include(void);

int get_opcode_index(char *s);

void set_sacred(tree p);


tree parse_expression_from_asm(void);

boolean parse_asm(void);

/* parse one statement, return false iff no more appropriate input */
boolean parse_statement(void);

/* check whether all labels in a block have a value */
void check_labels(tree p);

/* parse a list of assembler statements */
void parse_assembler_list(void);

/* parse list of statements without block context */
void parse_statement_sequence(void);

/* parse a list of normal statements */
tree parse_statement_list(void);

/* parse all input */
void parse(tree * dummy);

/* check whether the sources are OK */
void parse_done(void);

#endif
