import { ISanitizer } from './tokens';
/**
 * A class to sanitize HTML strings.
 */
export declare class Sanitizer implements ISanitizer {
    constructor();
    /**
     * Sanitize an HTML string.
     *
     * @param dirty - The dirty text.
     *
     * @param options - The optional sanitization options.
     *
     * @returns The sanitized string.
     */
    sanitize(dirty: string, options?: ISanitizer.IOptions): string;
    /**
     * Set the allowed schemes
     *
     * @param scheme Allowed schemes
     */
    setAllowedSchemes(scheme: Array<string>): void;
    /**
     * Set the whether to allow `name` and `id` attributes.
     */
    setAllowNamedProperties(allowNamedProperties: boolean): void;
    private _allowNamedProperties;
    private _options;
    private _generateOptions;
}
/**
 * The default instance of an `ISanitizer` meant for use by user code.
 *
 * @deprecated It will be removed in JupyterLab v4. You should request the `ISanitizer` in
 * your plugin instead.
 */
export declare const defaultSanitizer: ISanitizer;
