## RabbitMQ 4.1.7

RabbitMQ `4.1.7` is a maintenance release in the `4.1.x` [release series](https://www.rabbitmq.com/release-information).

It is **strongly recommended** that you read [4.1.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.1.0)
in detail if upgrading from a version prior to `4.1.0`.


### Minimum Supported Erlang Version

[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.1.x/release-notes).


### Core Server

#### Enhancements

 * Stream replication: IP address family (IPv4 or IPv6) can now be configured via `rabbitmq.conf`.

   GitHub issue: [#15013](https://github.com/rabbitmq/rabbitmq-server/pull/15013)


### Management Plugin

#### Bug Fixes

 * `GET /api/deprecated-features/used` no longer returns an empty `state` field.

   GitHub issue: [#15059](https://github.com/rabbitmq/rabbitmq-server/pull/15059)

 * Feature flag icons now contrast well when the dark mode is used in the UI.

   GitHub issue: [#15070](https://github.com/rabbitmq/rabbitmq-server/pull/15070)


### Web MQTT Plugin

#### Bug Fixes

 * The plugin now supports the `mqttv3.1` WebSocket subprotocol in addition to `mqtt`,
   improving compatibility with older MQTT clients.

   GitHub issue: [#15010](https://github.com/rabbitmq/rabbitmq-server/pull/15010)


### AWS Peer Discovery Plugin

#### Bug Fixes

 * The plugin now uses IPv6 discovery endpoints in IPv6-only environments.

   GitHub issue: [#14987](https://github.com/rabbitmq/rabbitmq-server/pull/14987)


### Tracing Plugin

#### Bug Fixes

 * Trace files served via the management UI now include proper UTF-8 charset specification.

   GitHub issue: [#14972](https://github.com/rabbitmq/rabbitmq-server/pull/14972)
