/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFileActionFtpReply;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MKD
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(MKD.class);

    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        String fileName = request.getArgument();
        if (fileName == null) {
            session.write((Object)LocalizedFileActionFtpReply.translate(session, request, context, 501, "MKD", null, null));
            return;
        }
        FtpFile file = null;
        try {
            file = session.getFileSystemView().getFile(fileName);
        }
        catch (Exception ex) {
            this.LOG.debug("Exception getting file object", (Throwable)ex);
        }
        if (file == null) {
            session.write((Object)LocalizedFileActionFtpReply.translate(session, request, context, 550, "MKD.invalid", fileName, file));
            return;
        }
        fileName = file.getAbsolutePath();
        if (!file.isWritable()) {
            session.write((Object)LocalizedFileActionFtpReply.translate(session, request, context, 550, "MKD.permission", fileName, file));
            return;
        }
        if (file.doesExist()) {
            session.write((Object)LocalizedFileActionFtpReply.translate(session, request, context, 550, "MKD.exists", fileName, file));
            return;
        }
        if (file.mkdir()) {
            session.write((Object)LocalizedFileActionFtpReply.translate(session, request, context, 257, "MKD", fileName, file));
            String userName = session.getUser().getName();
            this.LOG.info("Directory create : " + userName + " - " + fileName);
            ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
            ftpStat.setMkdir(session, file);
        } else {
            session.write((Object)LocalizedFileActionFtpReply.translate(session, request, context, 550, "MKD", fileName, file));
        }
    }
}

