# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the iosxr_ospf_interfaces module
"""


class Ospf_interfacesArgs(object):  # pylint: disable=R0903
    """The arg spec for the iosxr_ospf_interfaces module"""

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "running_config": {"type": "str"},
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"type": "str", "required": True},
                "type": {"type": "str", "required": True},
                "address_family": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "afi": {
                            "type": "str",
                            "choices": ["ipv4", "ipv6"],
                            "required": True,
                        },
                        "processes": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "process_id": {
                                    "type": "str",
                                    "required": True,
                                },
                                "area": {
                                    "type": "dict",
                                    "options": {"area_id": {"type": "str"}},
                                },
                            },
                        },
                        "apply_group_option": {
                            "type": "dict",
                            "options": {
                                "group_name": {"type": "str"},
                                "operation": {
                                    "type": "str",
                                    "choices": ["add", "remove", "append"],
                                },
                            },
                        },
                        "authentication": {
                            "no_log": False,
                            "type": "dict",
                            "options": {
                                "message_digest": {
                                    "no_log": False,
                                    "type": "dict",
                                    "options": {
                                        "keychain": {
                                            "type": "str",
                                            "no_log": False,
                                        },
                                    },
                                },
                                "null_auth": {"type": "bool"},
                            },
                        },
                        "authentication_key": {
                            "type": "dict",
                            "no_log": True,
                            "options": {
                                "password": {"type": "str", "no_log": True},
                                "clear": {"type": "str"},
                                "encrypted": {"type": "str"},
                            },
                        },
                        "bfd": {
                            "type": "dict",
                            "options": {
                                "fast_detect": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "strict_mode": {"type": "bool"},
                                    },
                                },
                                "minimum_interval": {"type": "int"},
                                "multiplier": {"type": "int"},
                            },
                        },
                        "cost": {"type": "int"},
                        "cost_fallback": {
                            "type": "dict",
                            "options": {
                                "cost": {"type": "int"},
                                "threshold": {"type": "int"},
                            },
                        },
                        "database_filter": {
                            "type": "dict",
                            "options": {"all_outgoing_lsa": {"type": "bool"}},
                        },
                        "dead_interval": {"type": "int"},
                        "demand_circuit": {"type": "bool"},
                        "fast_reroute": {
                            "type": "dict",
                            "options": {
                                "disabled": {"type": "bool"},
                                "per_link": {
                                    "type": "dict",
                                    "options": {
                                        "information_type": {
                                            "type": "str",
                                            "choices": [
                                                "exclude",
                                                "lfa_candidate",
                                            ],
                                        },
                                        "use_candidate_only": {"type": "bool"},
                                        "interface": {
                                            "type": "dict",
                                            "options": {
                                                "bvi": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "int",
                                                        },
                                                    },
                                                },
                                                "bundle_ether": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "int",
                                                        },
                                                    },
                                                },
                                                "pos_int": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "int",
                                                        },
                                                    },
                                                },
                                                "fast_ethernet": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "fiftygige": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "fortygige": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "fourhundredgige": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "gigabitethernet": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "hundredgige": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "mgmteth": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "multilink": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "pw_ether": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "int",
                                                        },
                                                    },
                                                },
                                                "pw_iw": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "int",
                                                        },
                                                    },
                                                },
                                                "srp": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "serial": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "tengige": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "twentyfivegige": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "twohundredgige": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "nve": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "int",
                                                        },
                                                    },
                                                },
                                                "tunnel_ip": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "int",
                                                        },
                                                    },
                                                },
                                                "tunnel_ipsec": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "int",
                                                        },
                                                    },
                                                },
                                                "tunnel_mte": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "int",
                                                        },
                                                    },
                                                },
                                                "tunnel_mpls": {
                                                    "type": "list",
                                                    "elements": "dict",
                                                    "options": {
                                                        "name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "flood_reduction": {"type": "bool"},
                        "hello_interval": {"type": "int"},
                        "link_down_fast_detect": {"type": "bool"},
                        "message_digest_key": {
                            "type": "dict",
                            "no_log": False,
                            "options": {
                                "id": {"type": "int", "required": True},
                                "md5": {
                                    "type": "dict",
                                    "required": True,
                                    "options": {
                                        "password": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                        "clear": {"type": "bool"},
                                        "encrypted": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "mpls_ldp_sync": {"type": "bool"},
                        "mtu_ignore": {"type": "bool"},
                        "network": {
                            "type": "str",
                            "choices": [
                                "broadcast",
                                "non-broadcast",
                                "point-to-multipoint",
                                "point-to-point",
                            ],
                        },
                        "neighbors": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "neighbor_id": {"type": "str"},
                                "cost": {"type": "int"},
                                "db_filter_all_out": {"type": "bool"},
                                "poll_interval": {"type": "int"},
                                "priority": {"type": "int"},
                            },
                        },
                        "packet_size": {"type": "int"},
                        "passive": {"type": "bool"},
                        "prefix_suppression": {"type": "bool"},
                        "priority": {"type": "int"},
                        "retransmit_interval": {"type": "int"},
                        "security_ttl": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "hops": {"type": "int"},
                            },
                        },
                        "transmit_delay": {"type": "int"},
                    },
                },
            },
        },
        "state": {
            "type": "str",
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "parsed",
                "rendered",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
