/*
 * rarian.h
 * This file is part of Rarian
 *
 * Copyright (C) 2006 - Don Scorgie
 *
 * Rarian is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rarian is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* This file is the main header for the rarian library.
 * If you include this file, you should get everything you
 * need to work with rarian.
 */

#ifndef __RARIAN_H
#define __RARIAN_H

#ifndef I_KNOW_RARIAN_0_8_IS_UNSTABLE
#error Rarian is unstable.  To use it, you must acknowledge that
#endif

#ifndef FALSE
#define FALSE 0
#define TRUE !FALSE
#endif

#include "rarian-info.h"
#include "rarian-main.h"
#include "rarian-man.h"
#include "rarian-reg-utils.h"

#endif /*__RARIAN_H */
