/*
 * Copyright (C) 2021 BlueKitchen GmbH
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 * 4. Any redistribution, use, or modification is done solely for
 *    personal benefit and not for any commercial purpose or for
 *    monetary gain.
 *
 * THIS SOFTWARE IS PROVIDED BY BLUEKITCHEN GMBH AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BLUEKITCHEN
 * GMBH OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Please inquire about commercial licensing options at
 * contact@bluekitchen-gmbh.com
 *
 */

#define BTSTACK_FILE__ "btstack_signal.c"

// enable System V signal API
#define _POSIX_C_SOURCE 200809

#include "btstack_signal.h"

#include <pthread.h>
#include <signal.h>
#include <string.h>

#include "btstack_run_loop.h"

static void signal_callback(void * arg){
    void (*callback)(void) = (void (*)(void)) arg;
    (*callback)();
}

static void * signal_thread(void *arg) {
    // prepare registration
    btstack_context_callback_registration_t registration;
    memset(&registration, 0, sizeof(btstack_context_callback_registration_t));
    registration.callback = &signal_callback;
    registration.context  = arg;

    while (1){
        // wait for signal
        sigset_t sigset;
        sigemptyset(&sigset);
        sigaddset(&sigset, SIGINT);
        int sig = 0;
        (void) sigwait(&sigset, &sig);

        // execute callback on main thread
        btstack_run_loop_execute_on_main_thread(&registration);
    }
    return NULL;
}

void btstack_signal_register_callback(int signal, void (*callback)(void)) {
    // block signal
    sigset_t base_mask;
    sigemptyset (&base_mask);
    sigaddset (&base_mask, signal);
    sigprocmask (SIG_SETMASK, &base_mask, NULL);

    // start thread to receive signal
    pthread_t thread;
    pthread_create(&thread, NULL, signal_thread, (void*) callback);
}
