// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: introspection.proto

package pb

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// The status of a connection or stream.
type Status int32

const (
	Status_ACTIVE  Status = 0
	Status_CLOSED  Status = 1
	Status_OPENING Status = 2
	Status_CLOSING Status = 3
	Status_ERROR   Status = 4
)

var Status_name = map[int32]string{
	0: "ACTIVE",
	1: "CLOSED",
	2: "OPENING",
	3: "CLOSING",
	4: "ERROR",
}

var Status_value = map[string]int32{
	"ACTIVE":  0,
	"CLOSED":  1,
	"OPENING": 2,
	"CLOSING": 3,
	"ERROR":   4,
}

func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}

func (Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{0}
}

// Our role in a connection or stream.
type Role int32

const (
	Role_INITIATOR Role = 0
	Role_RESPONDER Role = 1
)

var Role_name = map[int32]string{
	0: "INITIATOR",
	1: "RESPONDER",
}

var Role_value = map[string]int32{
	"INITIATOR": 0,
	"RESPONDER": 1,
}

func (x Role) String() string {
	return proto.EnumName(Role_name, int32(x))
}

func (Role) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{1}
}

// tells client how to sort, filter or display known content properties
type EventType_EventProperty_PropertyType int32

const (
	// for properties to treat as a simple primitive
	EventType_EventProperty_STRING EventType_EventProperty_PropertyType = 0
	EventType_EventProperty_NUMBER EventType_EventProperty_PropertyType = 1
	// for properties with special human-readable formatting
	EventType_EventProperty_TIME      EventType_EventProperty_PropertyType = 10
	EventType_EventProperty_PEERID    EventType_EventProperty_PropertyType = 11
	EventType_EventProperty_MULTIADDR EventType_EventProperty_PropertyType = 12
	// for complex structures like nested arrays, object trees etc
	EventType_EventProperty_JSON EventType_EventProperty_PropertyType = 90
)

var EventType_EventProperty_PropertyType_name = map[int32]string{
	0:  "STRING",
	1:  "NUMBER",
	10: "TIME",
	11: "PEERID",
	12: "MULTIADDR",
	90: "JSON",
}

var EventType_EventProperty_PropertyType_value = map[string]int32{
	"STRING":    0,
	"NUMBER":    1,
	"TIME":      10,
	"PEERID":    11,
	"MULTIADDR": 12,
	"JSON":      90,
}

func (x EventType_EventProperty_PropertyType) String() string {
	return proto.EnumName(EventType_EventProperty_PropertyType_name, int32(x))
}

func (EventType_EventProperty_PropertyType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{4, 0, 0}
}

// The DHT's relationship with this peer
type DHT_PeerInDHT_Status int32

const (
	// Connected, in a bucket, ready to send/receive queries
	DHT_PeerInDHT_ACTIVE DHT_PeerInDHT_Status = 0
	// Not currently connected, still "in" a bucket (e.g. temporarily disconnected)
	DHT_PeerInDHT_MISSING DHT_PeerInDHT_Status = 1
	// Removed from a bucket or candidate list (e.g. connection lost or too slow)
	DHT_PeerInDHT_REJECTED DHT_PeerInDHT_Status = 2
	// Was reachable when last checked, waiting to join a currently-full bucket
	DHT_PeerInDHT_CANDIDATE DHT_PeerInDHT_Status = 3
)

var DHT_PeerInDHT_Status_name = map[int32]string{
	0: "ACTIVE",
	1: "MISSING",
	2: "REJECTED",
	3: "CANDIDATE",
}

var DHT_PeerInDHT_Status_value = map[string]int32{
	"ACTIVE":    0,
	"MISSING":   1,
	"REJECTED":  2,
	"CANDIDATE": 3,
}

func (x DHT_PeerInDHT_Status) String() string {
	return proto.EnumName(DHT_PeerInDHT_Status_name, int32(x))
}

func (DHT_PeerInDHT_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{11, 1, 0}
}

type ClientCommand_Source int32

const (
	ClientCommand_STATE   ClientCommand_Source = 0
	ClientCommand_RUNTIME ClientCommand_Source = 1
	ClientCommand_EVENTS  ClientCommand_Source = 2
)

var ClientCommand_Source_name = map[int32]string{
	0: "STATE",
	1: "RUNTIME",
	2: "EVENTS",
}

var ClientCommand_Source_value = map[string]int32{
	"STATE":   0,
	"RUNTIME": 1,
	"EVENTS":  2,
}

func (x ClientCommand_Source) String() string {
	return proto.EnumName(ClientCommand_Source_name, int32(x))
}

func (ClientCommand_Source) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{17, 0}
}

type ClientCommand_Command int32

const (
	// HELLO is the first command that a client must send to greet the server.
	// Connections that do not respect this invariant will be terminated.
	ClientCommand_HELLO ClientCommand_Command = 0
	// REQUEST is applicable to STATE and RUNTIME sources.
	ClientCommand_REQUEST ClientCommand_Command = 1
	// PUSH streams can only be started for STATE and EVENTS sources.
	ClientCommand_PUSH_ENABLE  ClientCommand_Command = 2
	ClientCommand_PUSH_DISABLE ClientCommand_Command = 3
	ClientCommand_PUSH_PAUSE   ClientCommand_Command = 4
	ClientCommand_PUSH_RESUME  ClientCommand_Command = 5
	// UPDATE_CONFIG requests a configuration update. The config field is
	// compulsory.
	//
	// The server reserves the right to override the requested values, and
	// will return the effective configuration in the response.
	ClientCommand_UPDATE_CONFIG ClientCommand_Command = 7
)

var ClientCommand_Command_name = map[int32]string{
	0: "HELLO",
	1: "REQUEST",
	2: "PUSH_ENABLE",
	3: "PUSH_DISABLE",
	4: "PUSH_PAUSE",
	5: "PUSH_RESUME",
	7: "UPDATE_CONFIG",
}

var ClientCommand_Command_value = map[string]int32{
	"HELLO":         0,
	"REQUEST":       1,
	"PUSH_ENABLE":   2,
	"PUSH_DISABLE":  3,
	"PUSH_PAUSE":    4,
	"PUSH_RESUME":   5,
	"UPDATE_CONFIG": 7,
}

func (x ClientCommand_Command) String() string {
	return proto.EnumName(ClientCommand_Command_name, int32(x))
}

func (ClientCommand_Command) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{17, 1}
}

type CommandResponse_Result int32

const (
	CommandResponse_OK  CommandResponse_Result = 0
	CommandResponse_ERR CommandResponse_Result = 1
)

var CommandResponse_Result_name = map[int32]string{
	0: "OK",
	1: "ERR",
}

var CommandResponse_Result_value = map[string]int32{
	"OK":  0,
	"ERR": 1,
}

func (x CommandResponse_Result) String() string {
	return proto.EnumName(CommandResponse_Result_name, int32(x))
}

func (CommandResponse_Result) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{18, 0}
}

type ServerNotice_Kind int32

const (
	ServerNotice_DISCARDING_EVENTS ServerNotice_Kind = 0
)

var ServerNotice_Kind_name = map[int32]string{
	0: "DISCARDING_EVENTS",
}

var ServerNotice_Kind_value = map[string]int32{
	"DISCARDING_EVENTS": 0,
}

func (x ServerNotice_Kind) String() string {
	return proto.EnumName(ServerNotice_Kind_name, int32(x))
}

func (ServerNotice_Kind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{19, 0}
}

// Version of schema
type Version struct {
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (m *Version) Reset()         { *m = Version{} }
func (m *Version) String() string { return proto.CompactTextString(m) }
func (*Version) ProtoMessage()    {}
func (*Version) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{0}
}
func (m *Version) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Version) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Version.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Version) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Version.Merge(m, src)
}
func (m *Version) XXX_Size() int {
	return m.Size()
}
func (m *Version) XXX_DiscardUnknown() {
	xxx_messageInfo_Version.DiscardUnknown(m)
}

var xxx_messageInfo_Version proto.InternalMessageInfo

func (m *Version) GetVersion() uint32 {
	if m != nil {
		return m.Version
	}
	return 0
}

// ResultCounter is a monotonically increasing counter that reports an ok/err breakdown of the total.
type ResultCounter struct {
	Total uint32 `protobuf:"varint,1,opt,name=total,proto3" json:"total,omitempty"`
	Ok    uint32 `protobuf:"varint,2,opt,name=ok,proto3" json:"ok,omitempty"`
	Err   uint32 `protobuf:"varint,3,opt,name=err,proto3" json:"err,omitempty"`
}

func (m *ResultCounter) Reset()         { *m = ResultCounter{} }
func (m *ResultCounter) String() string { return proto.CompactTextString(m) }
func (*ResultCounter) ProtoMessage()    {}
func (*ResultCounter) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{1}
}
func (m *ResultCounter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResultCounter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResultCounter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResultCounter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResultCounter.Merge(m, src)
}
func (m *ResultCounter) XXX_Size() int {
	return m.Size()
}
func (m *ResultCounter) XXX_DiscardUnknown() {
	xxx_messageInfo_ResultCounter.DiscardUnknown(m)
}

var xxx_messageInfo_ResultCounter proto.InternalMessageInfo

func (m *ResultCounter) GetTotal() uint32 {
	if m != nil {
		return m.Total
	}
	return 0
}

func (m *ResultCounter) GetOk() uint32 {
	if m != nil {
		return m.Ok
	}
	return 0
}

func (m *ResultCounter) GetErr() uint32 {
	if m != nil {
		return m.Err
	}
	return 0
}

// Moving totals over sliding time windows. Models sensible time windows,
// we don't have to populate them all at once.
//
// Graphical example:
//
// time     past -> present                              an event 16 min ago
// ======================================================X================>>
//                                                       |               | 1m
//                                                       |           |---| 5m
//                                                       | |-------------| 15m
//                                          |------------X---------------| 30m
//            |------------------------------------------X---------------| 60m
type SlidingCounter struct {
	Over_1M   uint32 `protobuf:"varint,1,opt,name=over_1m,json=over1m,proto3" json:"over_1m,omitempty"`
	Over_5M   uint32 `protobuf:"varint,2,opt,name=over_5m,json=over5m,proto3" json:"over_5m,omitempty"`
	Over_15M  uint32 `protobuf:"varint,3,opt,name=over_15m,json=over15m,proto3" json:"over_15m,omitempty"`
	Over_30M  uint32 `protobuf:"varint,4,opt,name=over_30m,json=over30m,proto3" json:"over_30m,omitempty"`
	Over_1Hr  uint32 `protobuf:"varint,5,opt,name=over_1hr,json=over1hr,proto3" json:"over_1hr,omitempty"`
	Over_2Hr  uint32 `protobuf:"varint,6,opt,name=over_2hr,json=over2hr,proto3" json:"over_2hr,omitempty"`
	Over_4Hr  uint32 `protobuf:"varint,7,opt,name=over_4hr,json=over4hr,proto3" json:"over_4hr,omitempty"`
	Over_8Hr  uint32 `protobuf:"varint,8,opt,name=over_8hr,json=over8hr,proto3" json:"over_8hr,omitempty"`
	Over_12Hr uint32 `protobuf:"varint,9,opt,name=over_12hr,json=over12hr,proto3" json:"over_12hr,omitempty"`
	Over_24Hr uint32 `protobuf:"varint,10,opt,name=over_24hr,json=over24hr,proto3" json:"over_24hr,omitempty"`
}

func (m *SlidingCounter) Reset()         { *m = SlidingCounter{} }
func (m *SlidingCounter) String() string { return proto.CompactTextString(m) }
func (*SlidingCounter) ProtoMessage()    {}
func (*SlidingCounter) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{2}
}
func (m *SlidingCounter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SlidingCounter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SlidingCounter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SlidingCounter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SlidingCounter.Merge(m, src)
}
func (m *SlidingCounter) XXX_Size() int {
	return m.Size()
}
func (m *SlidingCounter) XXX_DiscardUnknown() {
	xxx_messageInfo_SlidingCounter.DiscardUnknown(m)
}

var xxx_messageInfo_SlidingCounter proto.InternalMessageInfo

func (m *SlidingCounter) GetOver_1M() uint32 {
	if m != nil {
		return m.Over_1M
	}
	return 0
}

func (m *SlidingCounter) GetOver_5M() uint32 {
	if m != nil {
		return m.Over_5M
	}
	return 0
}

func (m *SlidingCounter) GetOver_15M() uint32 {
	if m != nil {
		return m.Over_15M
	}
	return 0
}

func (m *SlidingCounter) GetOver_30M() uint32 {
	if m != nil {
		return m.Over_30M
	}
	return 0
}

func (m *SlidingCounter) GetOver_1Hr() uint32 {
	if m != nil {
		return m.Over_1Hr
	}
	return 0
}

func (m *SlidingCounter) GetOver_2Hr() uint32 {
	if m != nil {
		return m.Over_2Hr
	}
	return 0
}

func (m *SlidingCounter) GetOver_4Hr() uint32 {
	if m != nil {
		return m.Over_4Hr
	}
	return 0
}

func (m *SlidingCounter) GetOver_8Hr() uint32 {
	if m != nil {
		return m.Over_8Hr
	}
	return 0
}

func (m *SlidingCounter) GetOver_12Hr() uint32 {
	if m != nil {
		return m.Over_12Hr
	}
	return 0
}

func (m *SlidingCounter) GetOver_24Hr() uint32 {
	if m != nil {
		return m.Over_24Hr
	}
	return 0
}

// DataGauge reports stats for data traffic in a given direction.
type DataGauge struct {
	// Cumulative bytes.
	CumBytes uint64 `protobuf:"varint,1,opt,name=cum_bytes,json=cumBytes,proto3" json:"cum_bytes,omitempty"`
	// Cumulative packets.
	CumPackets uint64 `protobuf:"varint,2,opt,name=cum_packets,json=cumPackets,proto3" json:"cum_packets,omitempty"`
	// Instantaneous bandwidth measurement (bytes/second).
	InstBw uint64 `protobuf:"varint,3,opt,name=inst_bw,json=instBw,proto3" json:"inst_bw,omitempty"`
}

func (m *DataGauge) Reset()         { *m = DataGauge{} }
func (m *DataGauge) String() string { return proto.CompactTextString(m) }
func (*DataGauge) ProtoMessage()    {}
func (*DataGauge) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{3}
}
func (m *DataGauge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataGauge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataGauge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DataGauge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataGauge.Merge(m, src)
}
func (m *DataGauge) XXX_Size() int {
	return m.Size()
}
func (m *DataGauge) XXX_DiscardUnknown() {
	xxx_messageInfo_DataGauge.DiscardUnknown(m)
}

var xxx_messageInfo_DataGauge proto.InternalMessageInfo

func (m *DataGauge) GetCumBytes() uint64 {
	if m != nil {
		return m.CumBytes
	}
	return 0
}

func (m *DataGauge) GetCumPackets() uint64 {
	if m != nil {
		return m.CumPackets
	}
	return 0
}

func (m *DataGauge) GetInstBw() uint64 {
	if m != nil {
		return m.InstBw
	}
	return 0
}

// describes a type of event
type EventType struct {
	// name of event type, e.g. PeerConnecting
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// for runtime, send property_types for all events already seen in events list
	// for events, only send property_types in the first event of a type not in runtime
	PropertyTypes []*EventType_EventProperty `protobuf:"bytes,2,rep,name=property_types,json=propertyTypes,proto3" json:"property_types,omitempty"`
}

func (m *EventType) Reset()         { *m = EventType{} }
func (m *EventType) String() string { return proto.CompactTextString(m) }
func (*EventType) ProtoMessage()    {}
func (*EventType) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{4}
}
func (m *EventType) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EventType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EventType.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EventType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventType.Merge(m, src)
}
func (m *EventType) XXX_Size() int {
	return m.Size()
}
func (m *EventType) XXX_DiscardUnknown() {
	xxx_messageInfo_EventType.DiscardUnknown(m)
}

var xxx_messageInfo_EventType proto.InternalMessageInfo

func (m *EventType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EventType) GetPropertyTypes() []*EventType_EventProperty {
	if m != nil {
		return m.PropertyTypes
	}
	return nil
}

// metadata about content types in event's top-level content JSON
type EventType_EventProperty struct {
	// property name of content e.g. openTs
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// type to interpret content value as
	Type EventType_EventProperty_PropertyType `protobuf:"varint,2,opt,name=type,proto3,enum=pb.EventType_EventProperty_PropertyType" json:"type,omitempty"`
	// if true, expect an array of values of `type`; else, singular
	HasMultiple bool `protobuf:"varint,3,opt,name=has_multiple,json=hasMultiple,proto3" json:"has_multiple,omitempty"`
}

func (m *EventType_EventProperty) Reset()         { *m = EventType_EventProperty{} }
func (m *EventType_EventProperty) String() string { return proto.CompactTextString(m) }
func (*EventType_EventProperty) ProtoMessage()    {}
func (*EventType_EventProperty) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{4, 0}
}
func (m *EventType_EventProperty) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EventType_EventProperty) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EventType_EventProperty.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EventType_EventProperty) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventType_EventProperty.Merge(m, src)
}
func (m *EventType_EventProperty) XXX_Size() int {
	return m.Size()
}
func (m *EventType_EventProperty) XXX_DiscardUnknown() {
	xxx_messageInfo_EventType_EventProperty.DiscardUnknown(m)
}

var xxx_messageInfo_EventType_EventProperty proto.InternalMessageInfo

func (m *EventType_EventProperty) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EventType_EventProperty) GetType() EventType_EventProperty_PropertyType {
	if m != nil {
		return m.Type
	}
	return EventType_EventProperty_STRING
}

func (m *EventType_EventProperty) GetHasMultiple() bool {
	if m != nil {
		return m.HasMultiple
	}
	return false
}

// Runtime encapsulates runtime info about a node.
type Runtime struct {
	// e.g. go-libp2p, js-libp2p, rust-libp2p, etc.
	Implementation string `protobuf:"bytes,1,opt,name=implementation,proto3" json:"implementation,omitempty"`
	// e.g. 1.2.3.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// e.g. Windows, Unix, macOS, Chrome, Mozilla, etc.
	Platform string `protobuf:"bytes,3,opt,name=platform,proto3" json:"platform,omitempty"`
	// our peer id - the peer id of the host system
	PeerId string `protobuf:"bytes,4,opt,name=peer_id,json=peerId,proto3" json:"peer_id,omitempty"`
	// metadata describing configured event types
	EventTypes []*EventType `protobuf:"bytes,7,rep,name=event_types,json=eventTypes,proto3" json:"event_types,omitempty"`
}

func (m *Runtime) Reset()         { *m = Runtime{} }
func (m *Runtime) String() string { return proto.CompactTextString(m) }
func (*Runtime) ProtoMessage()    {}
func (*Runtime) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{5}
}
func (m *Runtime) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Runtime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Runtime.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Runtime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Runtime.Merge(m, src)
}
func (m *Runtime) XXX_Size() int {
	return m.Size()
}
func (m *Runtime) XXX_DiscardUnknown() {
	xxx_messageInfo_Runtime.DiscardUnknown(m)
}

var xxx_messageInfo_Runtime proto.InternalMessageInfo

func (m *Runtime) GetImplementation() string {
	if m != nil {
		return m.Implementation
	}
	return ""
}

func (m *Runtime) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Runtime) GetPlatform() string {
	if m != nil {
		return m.Platform
	}
	return ""
}

func (m *Runtime) GetPeerId() string {
	if m != nil {
		return m.PeerId
	}
	return ""
}

func (m *Runtime) GetEventTypes() []*EventType {
	if m != nil {
		return m.EventTypes
	}
	return nil
}

// EndpointPair is a pair of multiaddrs.
type EndpointPair struct {
	// the source multiaddr.
	SrcMultiaddr string `protobuf:"bytes,1,opt,name=src_multiaddr,json=srcMultiaddr,proto3" json:"src_multiaddr,omitempty"`
	// the destination multiaddr.
	DstMultiaddr string `protobuf:"bytes,2,opt,name=dst_multiaddr,json=dstMultiaddr,proto3" json:"dst_multiaddr,omitempty"`
}

func (m *EndpointPair) Reset()         { *m = EndpointPair{} }
func (m *EndpointPair) String() string { return proto.CompactTextString(m) }
func (*EndpointPair) ProtoMessage()    {}
func (*EndpointPair) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{6}
}
func (m *EndpointPair) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EndpointPair) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EndpointPair.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EndpointPair) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EndpointPair.Merge(m, src)
}
func (m *EndpointPair) XXX_Size() int {
	return m.Size()
}
func (m *EndpointPair) XXX_DiscardUnknown() {
	xxx_messageInfo_EndpointPair.DiscardUnknown(m)
}

var xxx_messageInfo_EndpointPair proto.InternalMessageInfo

func (m *EndpointPair) GetSrcMultiaddr() string {
	if m != nil {
		return m.SrcMultiaddr
	}
	return ""
}

func (m *EndpointPair) GetDstMultiaddr() string {
	if m != nil {
		return m.DstMultiaddr
	}
	return ""
}

// Traffic encloses data transfer statistics.
type Traffic struct {
	// snapshot of the data in metrics.
	TrafficIn *DataGauge `protobuf:"bytes,1,opt,name=traffic_in,json=trafficIn,proto3" json:"traffic_in,omitempty"`
	// snapshot of the data out metrics.
	TrafficOut *DataGauge `protobuf:"bytes,2,opt,name=traffic_out,json=trafficOut,proto3" json:"traffic_out,omitempty"`
}

func (m *Traffic) Reset()         { *m = Traffic{} }
func (m *Traffic) String() string { return proto.CompactTextString(m) }
func (*Traffic) ProtoMessage()    {}
func (*Traffic) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{7}
}
func (m *Traffic) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Traffic) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Traffic.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Traffic) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Traffic.Merge(m, src)
}
func (m *Traffic) XXX_Size() int {
	return m.Size()
}
func (m *Traffic) XXX_DiscardUnknown() {
	xxx_messageInfo_Traffic.DiscardUnknown(m)
}

var xxx_messageInfo_Traffic proto.InternalMessageInfo

func (m *Traffic) GetTrafficIn() *DataGauge {
	if m != nil {
		return m.TrafficIn
	}
	return nil
}

func (m *Traffic) GetTrafficOut() *DataGauge {
	if m != nil {
		return m.TrafficOut
	}
	return nil
}

// a list of streams, by reference or inlined.
type StreamList struct {
	// NOTE: only one of the next 2 fields can appear, but proto3
	// doesn't support combining oneof and repeated.
	//
	// streams within this connection by reference.
	StreamIds [][]byte `protobuf:"bytes,1,rep,name=stream_ids,json=streamIds,proto3" json:"stream_ids,omitempty"`
	// streams within this connection by inlining.
	Streams []*Stream `protobuf:"bytes,2,rep,name=streams,proto3" json:"streams,omitempty"`
}

func (m *StreamList) Reset()         { *m = StreamList{} }
func (m *StreamList) String() string { return proto.CompactTextString(m) }
func (*StreamList) ProtoMessage()    {}
func (*StreamList) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{8}
}
func (m *StreamList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StreamList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StreamList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StreamList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamList.Merge(m, src)
}
func (m *StreamList) XXX_Size() int {
	return m.Size()
}
func (m *StreamList) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamList.DiscardUnknown(m)
}

var xxx_messageInfo_StreamList proto.InternalMessageInfo

func (m *StreamList) GetStreamIds() [][]byte {
	if m != nil {
		return m.StreamIds
	}
	return nil
}

func (m *StreamList) GetStreams() []*Stream {
	if m != nil {
		return m.Streams
	}
	return nil
}

// Connection reports metrics and state of a libp2p connection.
type Connection struct {
	// the id of this connection, not to be shown in user tooling,
	// used for (cross)referencing connections (e.g. relay).
	Id []byte `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// the peer id of the other party.
	PeerId string `protobuf:"bytes,2,opt,name=peer_id,json=peerId,proto3" json:"peer_id,omitempty"`
	// the status of this connection.
	Status Status `protobuf:"varint,3,opt,name=status,proto3,enum=pb.Status" json:"status,omitempty"`
	// a reference to the transport managing this connection.
	TransportId []byte `protobuf:"bytes,4,opt,name=transport_id,json=transportId,proto3" json:"transport_id,omitempty"`
	// the endpoints participating in this connection.
	Endpoints *EndpointPair `protobuf:"bytes,5,opt,name=endpoints,proto3" json:"endpoints,omitempty"`
	// the timeline of the connection, see Connection.Timeline.
	Timeline *Connection_Timeline `protobuf:"bytes,6,opt,name=timeline,proto3" json:"timeline,omitempty"`
	// our role in this connection.
	Role Role `protobuf:"varint,7,opt,name=role,proto3,enum=pb.Role" json:"role,omitempty"`
	// traffic statistics.
	Traffic *Traffic `protobuf:"bytes,8,opt,name=traffic,proto3" json:"traffic,omitempty"`
	// properties of this connection.
	Attribs *Connection_Attributes `protobuf:"bytes,9,opt,name=attribs,proto3" json:"attribs,omitempty"`
	// the instantaneous latency of this connection in nanoseconds.
	LatencyNs uint64 `protobuf:"varint,10,opt,name=latency_ns,json=latencyNs,proto3" json:"latency_ns,omitempty"`
	// streams within this connection.
	Streams *StreamList `protobuf:"bytes,11,opt,name=streams,proto3" json:"streams,omitempty"`
	// if this is a relayed connection, this points to the relaying connection.
	// a default value here (empty bytes) indicates this is not a relayed connection.
	//
	// Types that are valid to be assigned to RelayedOver:
	//	*Connection_ConnId
	//	*Connection_Conn
	RelayedOver isConnection_RelayedOver `protobuf_oneof:"relayed_over"`
	// user provided tags.
	UserProvidedTags []string `protobuf:"bytes,99,rep,name=user_provided_tags,json=userProvidedTags,proto3" json:"user_provided_tags,omitempty"`
}

func (m *Connection) Reset()         { *m = Connection{} }
func (m *Connection) String() string { return proto.CompactTextString(m) }
func (*Connection) ProtoMessage()    {}
func (*Connection) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{9}
}
func (m *Connection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Connection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Connection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Connection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Connection.Merge(m, src)
}
func (m *Connection) XXX_Size() int {
	return m.Size()
}
func (m *Connection) XXX_DiscardUnknown() {
	xxx_messageInfo_Connection.DiscardUnknown(m)
}

var xxx_messageInfo_Connection proto.InternalMessageInfo

type isConnection_RelayedOver interface {
	isConnection_RelayedOver()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Connection_ConnId struct {
	ConnId []byte `protobuf:"bytes,16,opt,name=conn_id,json=connId,proto3,oneof" json:"conn_id,omitempty"`
}
type Connection_Conn struct {
	Conn *Connection `protobuf:"bytes,17,opt,name=conn,proto3,oneof" json:"conn,omitempty"`
}

func (*Connection_ConnId) isConnection_RelayedOver() {}
func (*Connection_Conn) isConnection_RelayedOver()   {}

func (m *Connection) GetRelayedOver() isConnection_RelayedOver {
	if m != nil {
		return m.RelayedOver
	}
	return nil
}

func (m *Connection) GetId() []byte {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Connection) GetPeerId() string {
	if m != nil {
		return m.PeerId
	}
	return ""
}

func (m *Connection) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_ACTIVE
}

func (m *Connection) GetTransportId() []byte {
	if m != nil {
		return m.TransportId
	}
	return nil
}

func (m *Connection) GetEndpoints() *EndpointPair {
	if m != nil {
		return m.Endpoints
	}
	return nil
}

func (m *Connection) GetTimeline() *Connection_Timeline {
	if m != nil {
		return m.Timeline
	}
	return nil
}

func (m *Connection) GetRole() Role {
	if m != nil {
		return m.Role
	}
	return Role_INITIATOR
}

func (m *Connection) GetTraffic() *Traffic {
	if m != nil {
		return m.Traffic
	}
	return nil
}

func (m *Connection) GetAttribs() *Connection_Attributes {
	if m != nil {
		return m.Attribs
	}
	return nil
}

func (m *Connection) GetLatencyNs() uint64 {
	if m != nil {
		return m.LatencyNs
	}
	return 0
}

func (m *Connection) GetStreams() *StreamList {
	if m != nil {
		return m.Streams
	}
	return nil
}

func (m *Connection) GetConnId() []byte {
	if x, ok := m.GetRelayedOver().(*Connection_ConnId); ok {
		return x.ConnId
	}
	return nil
}

func (m *Connection) GetConn() *Connection {
	if x, ok := m.GetRelayedOver().(*Connection_Conn); ok {
		return x.Conn
	}
	return nil
}

func (m *Connection) GetUserProvidedTags() []string {
	if m != nil {
		return m.UserProvidedTags
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Connection) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Connection_ConnId)(nil),
		(*Connection_Conn)(nil),
	}
}

// Timeline contains the timestamps (ms since epoch) of the well-known milestones of a connection.
type Connection_Timeline struct {
	// the instant when a connection was opened on the wire.
	OpenTs uint64 `protobuf:"varint,1,opt,name=open_ts,json=openTs,proto3" json:"open_ts,omitempty"`
	// the instant when the upgrade process (handshake, security, multiplexing) finished.
	UpgradedTs uint64 `protobuf:"varint,2,opt,name=upgraded_ts,json=upgradedTs,proto3" json:"upgraded_ts,omitempty"`
	// the instant when this connection was terminated.
	CloseTs uint64 `protobuf:"varint,3,opt,name=close_ts,json=closeTs,proto3" json:"close_ts,omitempty"`
}

func (m *Connection_Timeline) Reset()         { *m = Connection_Timeline{} }
func (m *Connection_Timeline) String() string { return proto.CompactTextString(m) }
func (*Connection_Timeline) ProtoMessage()    {}
func (*Connection_Timeline) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{9, 0}
}
func (m *Connection_Timeline) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Connection_Timeline) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Connection_Timeline.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Connection_Timeline) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Connection_Timeline.Merge(m, src)
}
func (m *Connection_Timeline) XXX_Size() int {
	return m.Size()
}
func (m *Connection_Timeline) XXX_DiscardUnknown() {
	xxx_messageInfo_Connection_Timeline.DiscardUnknown(m)
}

var xxx_messageInfo_Connection_Timeline proto.InternalMessageInfo

func (m *Connection_Timeline) GetOpenTs() uint64 {
	if m != nil {
		return m.OpenTs
	}
	return 0
}

func (m *Connection_Timeline) GetUpgradedTs() uint64 {
	if m != nil {
		return m.UpgradedTs
	}
	return 0
}

func (m *Connection_Timeline) GetCloseTs() uint64 {
	if m != nil {
		return m.CloseTs
	}
	return 0
}

// Attributes encapsulates the attributes of this connection.
type Connection_Attributes struct {
	// the multiplexer being used.
	Multiplexer string `protobuf:"bytes,1,opt,name=multiplexer,proto3" json:"multiplexer,omitempty"`
	// the encryption method being used.
	Encryption string `protobuf:"bytes,2,opt,name=encryption,proto3" json:"encryption,omitempty"`
}

func (m *Connection_Attributes) Reset()         { *m = Connection_Attributes{} }
func (m *Connection_Attributes) String() string { return proto.CompactTextString(m) }
func (*Connection_Attributes) ProtoMessage()    {}
func (*Connection_Attributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{9, 1}
}
func (m *Connection_Attributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Connection_Attributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Connection_Attributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Connection_Attributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Connection_Attributes.Merge(m, src)
}
func (m *Connection_Attributes) XXX_Size() int {
	return m.Size()
}
func (m *Connection_Attributes) XXX_DiscardUnknown() {
	xxx_messageInfo_Connection_Attributes.DiscardUnknown(m)
}

var xxx_messageInfo_Connection_Attributes proto.InternalMessageInfo

func (m *Connection_Attributes) GetMultiplexer() string {
	if m != nil {
		return m.Multiplexer
	}
	return ""
}

func (m *Connection_Attributes) GetEncryption() string {
	if m != nil {
		return m.Encryption
	}
	return ""
}

// Stream reports metrics and state of a libp2p stream.
type Stream struct {
	// the id of this stream, not to be shown in user tooling,
	// used for (cross)referencing streams.
	Id []byte `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// the protocol pinned to this stream.
	Protocol string `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// our role in this stream.
	Role Role `protobuf:"varint,3,opt,name=role,proto3,enum=pb.Role" json:"role,omitempty"`
	// traffic statistics.
	Traffic *Traffic `protobuf:"bytes,4,opt,name=traffic,proto3" json:"traffic,omitempty"`
	// the connection this stream is hosted under.
	Conn *Stream_ConnectionRef `protobuf:"bytes,5,opt,name=conn,proto3" json:"conn,omitempty"`
	// the timeline of the stream, see Stream.Timeline.
	Timeline *Stream_Timeline `protobuf:"bytes,6,opt,name=timeline,proto3" json:"timeline,omitempty"`
	// the status of this stream.
	Status Status `protobuf:"varint,7,opt,name=status,proto3,enum=pb.Status" json:"status,omitempty"`
	// the instantaneous latency of this stream in nanoseconds.
	// TODO: this is hard to calculate.
	LatencyNs uint64 `protobuf:"varint,16,opt,name=latency_ns,json=latencyNs,proto3" json:"latency_ns,omitempty"`
	// user provided tags.
	UserProvidedTags []string `protobuf:"bytes,99,rep,name=user_provided_tags,json=userProvidedTags,proto3" json:"user_provided_tags,omitempty"`
}

func (m *Stream) Reset()         { *m = Stream{} }
func (m *Stream) String() string { return proto.CompactTextString(m) }
func (*Stream) ProtoMessage()    {}
func (*Stream) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{10}
}
func (m *Stream) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Stream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Stream.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Stream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stream.Merge(m, src)
}
func (m *Stream) XXX_Size() int {
	return m.Size()
}
func (m *Stream) XXX_DiscardUnknown() {
	xxx_messageInfo_Stream.DiscardUnknown(m)
}

var xxx_messageInfo_Stream proto.InternalMessageInfo

func (m *Stream) GetId() []byte {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Stream) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *Stream) GetRole() Role {
	if m != nil {
		return m.Role
	}
	return Role_INITIATOR
}

func (m *Stream) GetTraffic() *Traffic {
	if m != nil {
		return m.Traffic
	}
	return nil
}

func (m *Stream) GetConn() *Stream_ConnectionRef {
	if m != nil {
		return m.Conn
	}
	return nil
}

func (m *Stream) GetTimeline() *Stream_Timeline {
	if m != nil {
		return m.Timeline
	}
	return nil
}

func (m *Stream) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_ACTIVE
}

func (m *Stream) GetLatencyNs() uint64 {
	if m != nil {
		return m.LatencyNs
	}
	return 0
}

func (m *Stream) GetUserProvidedTags() []string {
	if m != nil {
		return m.UserProvidedTags
	}
	return nil
}

type Stream_ConnectionRef struct {
	// Types that are valid to be assigned to Connection:
	//	*Stream_ConnectionRef_Conn
	//	*Stream_ConnectionRef_ConnId
	Connection isStream_ConnectionRef_Connection `protobuf_oneof:"connection"`
}

func (m *Stream_ConnectionRef) Reset()         { *m = Stream_ConnectionRef{} }
func (m *Stream_ConnectionRef) String() string { return proto.CompactTextString(m) }
func (*Stream_ConnectionRef) ProtoMessage()    {}
func (*Stream_ConnectionRef) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{10, 0}
}
func (m *Stream_ConnectionRef) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Stream_ConnectionRef) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Stream_ConnectionRef.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Stream_ConnectionRef) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stream_ConnectionRef.Merge(m, src)
}
func (m *Stream_ConnectionRef) XXX_Size() int {
	return m.Size()
}
func (m *Stream_ConnectionRef) XXX_DiscardUnknown() {
	xxx_messageInfo_Stream_ConnectionRef.DiscardUnknown(m)
}

var xxx_messageInfo_Stream_ConnectionRef proto.InternalMessageInfo

type isStream_ConnectionRef_Connection interface {
	isStream_ConnectionRef_Connection()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Stream_ConnectionRef_Conn struct {
	Conn *Connection `protobuf:"bytes,1,opt,name=conn,proto3,oneof" json:"conn,omitempty"`
}
type Stream_ConnectionRef_ConnId struct {
	ConnId []byte `protobuf:"bytes,2,opt,name=conn_id,json=connId,proto3,oneof" json:"conn_id,omitempty"`
}

func (*Stream_ConnectionRef_Conn) isStream_ConnectionRef_Connection()   {}
func (*Stream_ConnectionRef_ConnId) isStream_ConnectionRef_Connection() {}

func (m *Stream_ConnectionRef) GetConnection() isStream_ConnectionRef_Connection {
	if m != nil {
		return m.Connection
	}
	return nil
}

func (m *Stream_ConnectionRef) GetConn() *Connection {
	if x, ok := m.GetConnection().(*Stream_ConnectionRef_Conn); ok {
		return x.Conn
	}
	return nil
}

func (m *Stream_ConnectionRef) GetConnId() []byte {
	if x, ok := m.GetConnection().(*Stream_ConnectionRef_ConnId); ok {
		return x.ConnId
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Stream_ConnectionRef) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Stream_ConnectionRef_Conn)(nil),
		(*Stream_ConnectionRef_ConnId)(nil),
	}
}

// Timeline contains the timestamps (ms since epoch) of the well-known milestones of a stream.
type Stream_Timeline struct {
	// the instant when the stream was opened.
	OpenTs uint64 `protobuf:"varint,1,opt,name=open_ts,json=openTs,proto3" json:"open_ts,omitempty"`
	// the instant when the stream was terminated.
	CloseTs uint64 `protobuf:"varint,2,opt,name=close_ts,json=closeTs,proto3" json:"close_ts,omitempty"`
}

func (m *Stream_Timeline) Reset()         { *m = Stream_Timeline{} }
func (m *Stream_Timeline) String() string { return proto.CompactTextString(m) }
func (*Stream_Timeline) ProtoMessage()    {}
func (*Stream_Timeline) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{10, 1}
}
func (m *Stream_Timeline) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Stream_Timeline) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Stream_Timeline.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Stream_Timeline) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stream_Timeline.Merge(m, src)
}
func (m *Stream_Timeline) XXX_Size() int {
	return m.Size()
}
func (m *Stream_Timeline) XXX_DiscardUnknown() {
	xxx_messageInfo_Stream_Timeline.DiscardUnknown(m)
}

var xxx_messageInfo_Stream_Timeline proto.InternalMessageInfo

func (m *Stream_Timeline) GetOpenTs() uint64 {
	if m != nil {
		return m.OpenTs
	}
	return 0
}

func (m *Stream_Timeline) GetCloseTs() uint64 {
	if m != nil {
		return m.CloseTs
	}
	return 0
}

// DHT metrics and state.
type DHT struct {
	// DHT protocol name
	Protocol string `protobuf:"bytes,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// protocol enabled.
	Enabled bool `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// timestamp (ms since epoch) of start up.
	StartTs uint64 `protobuf:"varint,3,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	// params of the dht.
	Params *DHT_Params `protobuf:"bytes,4,opt,name=params,proto3" json:"params,omitempty"`
	// existing, intantiated buckets and their contents
	Buckets []*DHT_Bucket `protobuf:"bytes,5,rep,name=buckets,proto3" json:"buckets,omitempty"`
	// counts inbound queries received from other peers
	IncomingQueries *DHT_QueryGauge `protobuf:"bytes,6,opt,name=incoming_queries,json=incomingQueries,proto3" json:"incoming_queries,omitempty"`
	// counts outbound queries dispatched by this peer
	OutgoingQueries *DHT_QueryGauge `protobuf:"bytes,7,opt,name=outgoing_queries,json=outgoingQueries,proto3" json:"outgoing_queries,omitempty"`
}

func (m *DHT) Reset()         { *m = DHT{} }
func (m *DHT) String() string { return proto.CompactTextString(m) }
func (*DHT) ProtoMessage()    {}
func (*DHT) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{11}
}
func (m *DHT) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DHT) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DHT.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DHT) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DHT.Merge(m, src)
}
func (m *DHT) XXX_Size() int {
	return m.Size()
}
func (m *DHT) XXX_DiscardUnknown() {
	xxx_messageInfo_DHT.DiscardUnknown(m)
}

var xxx_messageInfo_DHT proto.InternalMessageInfo

func (m *DHT) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *DHT) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *DHT) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *DHT) GetParams() *DHT_Params {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *DHT) GetBuckets() []*DHT_Bucket {
	if m != nil {
		return m.Buckets
	}
	return nil
}

func (m *DHT) GetIncomingQueries() *DHT_QueryGauge {
	if m != nil {
		return m.IncomingQueries
	}
	return nil
}

func (m *DHT) GetOutgoingQueries() *DHT_QueryGauge {
	if m != nil {
		return m.OutgoingQueries
	}
	return nil
}

type DHT_Params struct {
	// routing table bucket size.
	K uint64 `protobuf:"varint,1,opt,name=k,proto3" json:"k,omitempty"`
	// concurrency of asynchronous requests.
	Alpha uint64 `protobuf:"varint,2,opt,name=alpha,proto3" json:"alpha,omitempty"`
	// number of disjoint paths to use.
	DisjointPaths uint64 `protobuf:"varint,3,opt,name=disjoint_paths,json=disjointPaths,proto3" json:"disjoint_paths,omitempty"`
	// number of peers closest to a target that must have responded
	// in order for a given query path to complete
	Beta uint64 `protobuf:"varint,4,opt,name=beta,proto3" json:"beta,omitempty"`
}

func (m *DHT_Params) Reset()         { *m = DHT_Params{} }
func (m *DHT_Params) String() string { return proto.CompactTextString(m) }
func (*DHT_Params) ProtoMessage()    {}
func (*DHT_Params) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{11, 0}
}
func (m *DHT_Params) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DHT_Params) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DHT_Params.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DHT_Params) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DHT_Params.Merge(m, src)
}
func (m *DHT_Params) XXX_Size() int {
	return m.Size()
}
func (m *DHT_Params) XXX_DiscardUnknown() {
	xxx_messageInfo_DHT_Params.DiscardUnknown(m)
}

var xxx_messageInfo_DHT_Params proto.InternalMessageInfo

func (m *DHT_Params) GetK() uint64 {
	if m != nil {
		return m.K
	}
	return 0
}

func (m *DHT_Params) GetAlpha() uint64 {
	if m != nil {
		return m.Alpha
	}
	return 0
}

func (m *DHT_Params) GetDisjointPaths() uint64 {
	if m != nil {
		return m.DisjointPaths
	}
	return 0
}

func (m *DHT_Params) GetBeta() uint64 {
	if m != nil {
		return m.Beta
	}
	return 0
}

// Peer in DHT
type DHT_PeerInDHT struct {
	// the peer id of the host system
	PeerId string `protobuf:"bytes,1,opt,name=peer_id,json=peerId,proto3" json:"peer_id,omitempty"`
	// the peer's status when data snapshot is taken
	Status DHT_PeerInDHT_Status `protobuf:"varint,2,opt,name=status,proto3,enum=pb.DHT_PeerInDHT_Status" json:"status,omitempty"`
	// age in bucket (ms)
	AgeInBucket uint32 `protobuf:"varint,3,opt,name=age_in_bucket,json=ageInBucket,proto3" json:"age_in_bucket,omitempty"`
}

func (m *DHT_PeerInDHT) Reset()         { *m = DHT_PeerInDHT{} }
func (m *DHT_PeerInDHT) String() string { return proto.CompactTextString(m) }
func (*DHT_PeerInDHT) ProtoMessage()    {}
func (*DHT_PeerInDHT) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{11, 1}
}
func (m *DHT_PeerInDHT) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DHT_PeerInDHT) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DHT_PeerInDHT.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DHT_PeerInDHT) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DHT_PeerInDHT.Merge(m, src)
}
func (m *DHT_PeerInDHT) XXX_Size() int {
	return m.Size()
}
func (m *DHT_PeerInDHT) XXX_DiscardUnknown() {
	xxx_messageInfo_DHT_PeerInDHT.DiscardUnknown(m)
}

var xxx_messageInfo_DHT_PeerInDHT proto.InternalMessageInfo

func (m *DHT_PeerInDHT) GetPeerId() string {
	if m != nil {
		return m.PeerId
	}
	return ""
}

func (m *DHT_PeerInDHT) GetStatus() DHT_PeerInDHT_Status {
	if m != nil {
		return m.Status
	}
	return DHT_PeerInDHT_ACTIVE
}

func (m *DHT_PeerInDHT) GetAgeInBucket() uint32 {
	if m != nil {
		return m.AgeInBucket
	}
	return 0
}

// A "k-bucket" containing peers of a certain kadamelia distance
type DHT_Bucket struct {
	// CPL (Common Prefix Length) is the length of the common prefix
	// between the ids of every peer in this bucket and the DHT peer id
	Cpl uint32 `protobuf:"varint,1,opt,name=cpl,proto3" json:"cpl,omitempty"`
	// Peers associated with this bucket
	Peers []*DHT_PeerInDHT `protobuf:"bytes,2,rep,name=peers,proto3" json:"peers,omitempty"`
}

func (m *DHT_Bucket) Reset()         { *m = DHT_Bucket{} }
func (m *DHT_Bucket) String() string { return proto.CompactTextString(m) }
func (*DHT_Bucket) ProtoMessage()    {}
func (*DHT_Bucket) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{11, 2}
}
func (m *DHT_Bucket) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DHT_Bucket) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DHT_Bucket.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DHT_Bucket) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DHT_Bucket.Merge(m, src)
}
func (m *DHT_Bucket) XXX_Size() int {
	return m.Size()
}
func (m *DHT_Bucket) XXX_DiscardUnknown() {
	xxx_messageInfo_DHT_Bucket.DiscardUnknown(m)
}

var xxx_messageInfo_DHT_Bucket proto.InternalMessageInfo

func (m *DHT_Bucket) GetCpl() uint32 {
	if m != nil {
		return m.Cpl
	}
	return 0
}

func (m *DHT_Bucket) GetPeers() []*DHT_PeerInDHT {
	if m != nil {
		return m.Peers
	}
	return nil
}

// Counters of query events, by status
type DHT_QueryGauge struct {
	// Cumulative counter of queries with "SUCCESS" status
	Success uint64 `protobuf:"varint,1,opt,name=success,proto3" json:"success,omitempty"`
	// Cumulative counter of queries with "ERROR" status
	Error uint64 `protobuf:"varint,2,opt,name=error,proto3" json:"error,omitempty"`
	// Cumulative counter of queries with "TIMEOUT" status
	Timeout uint64 `protobuf:"varint,3,opt,name=timeout,proto3" json:"timeout,omitempty"`
}

func (m *DHT_QueryGauge) Reset()         { *m = DHT_QueryGauge{} }
func (m *DHT_QueryGauge) String() string { return proto.CompactTextString(m) }
func (*DHT_QueryGauge) ProtoMessage()    {}
func (*DHT_QueryGauge) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{11, 3}
}
func (m *DHT_QueryGauge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DHT_QueryGauge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DHT_QueryGauge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DHT_QueryGauge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DHT_QueryGauge.Merge(m, src)
}
func (m *DHT_QueryGauge) XXX_Size() int {
	return m.Size()
}
func (m *DHT_QueryGauge) XXX_DiscardUnknown() {
	xxx_messageInfo_DHT_QueryGauge.DiscardUnknown(m)
}

var xxx_messageInfo_DHT_QueryGauge proto.InternalMessageInfo

func (m *DHT_QueryGauge) GetSuccess() uint64 {
	if m != nil {
		return m.Success
	}
	return 0
}

func (m *DHT_QueryGauge) GetError() uint64 {
	if m != nil {
		return m.Error
	}
	return 0
}

func (m *DHT_QueryGauge) GetTimeout() uint64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

// Subsystems encapsulates all instrumented subsystems for a libp2p host.
type Subsystems struct {
	// connections data, source agnostic but currently only supports the Swarm subsystem
	Connections []*Connection `protobuf:"bytes,1,rep,name=connections,proto3" json:"connections,omitempty"`
	// the DHT subsystem.
	Dht *DHT `protobuf:"bytes,2,opt,name=dht,proto3" json:"dht,omitempty"`
}

func (m *Subsystems) Reset()         { *m = Subsystems{} }
func (m *Subsystems) String() string { return proto.CompactTextString(m) }
func (*Subsystems) ProtoMessage()    {}
func (*Subsystems) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{12}
}
func (m *Subsystems) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Subsystems) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Subsystems.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Subsystems) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subsystems.Merge(m, src)
}
func (m *Subsystems) XXX_Size() int {
	return m.Size()
}
func (m *Subsystems) XXX_DiscardUnknown() {
	xxx_messageInfo_Subsystems.DiscardUnknown(m)
}

var xxx_messageInfo_Subsystems proto.InternalMessageInfo

func (m *Subsystems) GetConnections() []*Connection {
	if m != nil {
		return m.Connections
	}
	return nil
}

func (m *Subsystems) GetDht() *DHT {
	if m != nil {
		return m.Dht
	}
	return nil
}

// Connections and streams output for a time interval is one of these.
type State struct {
	// list of connections
	Subsystems *Subsystems `protobuf:"bytes,1,opt,name=subsystems,proto3" json:"subsystems,omitempty"`
	// overall traffic for this peer
	Traffic *Traffic `protobuf:"bytes,2,opt,name=traffic,proto3" json:"traffic,omitempty"`
	// moment this data snapshot and instantaneous values were taken
	InstantTs uint64 `protobuf:"varint,3,opt,name=instant_ts,json=instantTs,proto3" json:"instant_ts,omitempty"`
	// start of included data collection (cumulative values counted from here)
	StartTs uint64 `protobuf:"varint,4,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	// length of time up to instant_ts covered by this data snapshot
	SnapshotDurationMs uint32 `protobuf:"varint,5,opt,name=snapshot_duration_ms,json=snapshotDurationMs,proto3" json:"snapshot_duration_ms,omitempty"`
}

func (m *State) Reset()         { *m = State{} }
func (m *State) String() string { return proto.CompactTextString(m) }
func (*State) ProtoMessage()    {}
func (*State) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{13}
}
func (m *State) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *State) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_State.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *State) XXX_Merge(src proto.Message) {
	xxx_messageInfo_State.Merge(m, src)
}
func (m *State) XXX_Size() int {
	return m.Size()
}
func (m *State) XXX_DiscardUnknown() {
	xxx_messageInfo_State.DiscardUnknown(m)
}

var xxx_messageInfo_State proto.InternalMessageInfo

func (m *State) GetSubsystems() *Subsystems {
	if m != nil {
		return m.Subsystems
	}
	return nil
}

func (m *State) GetTraffic() *Traffic {
	if m != nil {
		return m.Traffic
	}
	return nil
}

func (m *State) GetInstantTs() uint64 {
	if m != nil {
		return m.InstantTs
	}
	return 0
}

func (m *State) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *State) GetSnapshotDurationMs() uint32 {
	if m != nil {
		return m.SnapshotDurationMs
	}
	return 0
}

// Event
type Event struct {
	// definition of event type, containing only `name` unless this is first encounter of novel event
	Type *EventType `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// time this event occurred (ms since epoch)
	Ts uint64 `protobuf:"varint,2,opt,name=ts,proto3" json:"ts,omitempty"`
	// stringified json; top-level keys and value types match EventProperty definitions
	Content string `protobuf:"bytes,3,opt,name=content,proto3" json:"content,omitempty"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{14}
}
func (m *Event) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Event.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return m.Size()
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func (m *Event) GetType() *EventType {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *Event) GetTs() uint64 {
	if m != nil {
		return m.Ts
	}
	return 0
}

func (m *Event) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

// ServerMessage wraps messages to be sent to clients to allow extension
// based on new types of data sources
type ServerMessage struct {
	// Version of this protobuf.
	Version *Version `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The payload this message contains.
	//
	// Types that are valid to be assigned to Payload:
	//	*ServerMessage_State
	//	*ServerMessage_Runtime
	//	*ServerMessage_Event
	//	*ServerMessage_Response
	//	*ServerMessage_Notice
	Payload isServerMessage_Payload `protobuf_oneof:"payload"`
}

func (m *ServerMessage) Reset()         { *m = ServerMessage{} }
func (m *ServerMessage) String() string { return proto.CompactTextString(m) }
func (*ServerMessage) ProtoMessage()    {}
func (*ServerMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{15}
}
func (m *ServerMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServerMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServerMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServerMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerMessage.Merge(m, src)
}
func (m *ServerMessage) XXX_Size() int {
	return m.Size()
}
func (m *ServerMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerMessage.DiscardUnknown(m)
}

var xxx_messageInfo_ServerMessage proto.InternalMessageInfo

type isServerMessage_Payload interface {
	isServerMessage_Payload()
	MarshalTo([]byte) (int, error)
	Size() int
}

type ServerMessage_State struct {
	State *State `protobuf:"bytes,2,opt,name=state,proto3,oneof" json:"state,omitempty"`
}
type ServerMessage_Runtime struct {
	Runtime *Runtime `protobuf:"bytes,3,opt,name=runtime,proto3,oneof" json:"runtime,omitempty"`
}
type ServerMessage_Event struct {
	Event *Event `protobuf:"bytes,4,opt,name=event,proto3,oneof" json:"event,omitempty"`
}
type ServerMessage_Response struct {
	Response *CommandResponse `protobuf:"bytes,5,opt,name=response,proto3,oneof" json:"response,omitempty"`
}
type ServerMessage_Notice struct {
	Notice *ServerNotice `protobuf:"bytes,6,opt,name=notice,proto3,oneof" json:"notice,omitempty"`
}

func (*ServerMessage_State) isServerMessage_Payload()    {}
func (*ServerMessage_Runtime) isServerMessage_Payload()  {}
func (*ServerMessage_Event) isServerMessage_Payload()    {}
func (*ServerMessage_Response) isServerMessage_Payload() {}
func (*ServerMessage_Notice) isServerMessage_Payload()   {}

func (m *ServerMessage) GetPayload() isServerMessage_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *ServerMessage) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *ServerMessage) GetState() *State {
	if x, ok := m.GetPayload().(*ServerMessage_State); ok {
		return x.State
	}
	return nil
}

func (m *ServerMessage) GetRuntime() *Runtime {
	if x, ok := m.GetPayload().(*ServerMessage_Runtime); ok {
		return x.Runtime
	}
	return nil
}

func (m *ServerMessage) GetEvent() *Event {
	if x, ok := m.GetPayload().(*ServerMessage_Event); ok {
		return x.Event
	}
	return nil
}

func (m *ServerMessage) GetResponse() *CommandResponse {
	if x, ok := m.GetPayload().(*ServerMessage_Response); ok {
		return x.Response
	}
	return nil
}

func (m *ServerMessage) GetNotice() *ServerNotice {
	if x, ok := m.GetPayload().(*ServerMessage_Notice); ok {
		return x.Notice
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ServerMessage) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ServerMessage_State)(nil),
		(*ServerMessage_Runtime)(nil),
		(*ServerMessage_Event)(nil),
		(*ServerMessage_Response)(nil),
		(*ServerMessage_Notice)(nil),
	}
}

// Configuration encapsulates configuration fields for the protocol and commands.
type Configuration struct {
	RetentionPeriodMs       uint64 `protobuf:"varint,1,opt,name=retention_period_ms,json=retentionPeriodMs,proto3" json:"retention_period_ms,omitempty"`
	StateSnapshotIntervalMs uint64 `protobuf:"varint,2,opt,name=state_snapshot_interval_ms,json=stateSnapshotIntervalMs,proto3" json:"state_snapshot_interval_ms,omitempty"`
}

func (m *Configuration) Reset()         { *m = Configuration{} }
func (m *Configuration) String() string { return proto.CompactTextString(m) }
func (*Configuration) ProtoMessage()    {}
func (*Configuration) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{16}
}
func (m *Configuration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Configuration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Configuration.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Configuration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Configuration.Merge(m, src)
}
func (m *Configuration) XXX_Size() int {
	return m.Size()
}
func (m *Configuration) XXX_DiscardUnknown() {
	xxx_messageInfo_Configuration.DiscardUnknown(m)
}

var xxx_messageInfo_Configuration proto.InternalMessageInfo

func (m *Configuration) GetRetentionPeriodMs() uint64 {
	if m != nil {
		return m.RetentionPeriodMs
	}
	return 0
}

func (m *Configuration) GetStateSnapshotIntervalMs() uint64 {
	if m != nil {
		return m.StateSnapshotIntervalMs
	}
	return 0
}

// ClientCommand is a command sent from the client to the server.
type ClientCommand struct {
	Version *Version              `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	Id      uint64                `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	Command ClientCommand_Command `protobuf:"varint,3,opt,name=command,proto3,enum=pb.ClientCommand_Command" json:"command,omitempty"`
	Source  ClientCommand_Source  `protobuf:"varint,4,opt,name=source,proto3,enum=pb.ClientCommand_Source" json:"source,omitempty"`
	Config  *Configuration        `protobuf:"bytes,5,opt,name=config,proto3" json:"config,omitempty"`
}

func (m *ClientCommand) Reset()         { *m = ClientCommand{} }
func (m *ClientCommand) String() string { return proto.CompactTextString(m) }
func (*ClientCommand) ProtoMessage()    {}
func (*ClientCommand) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{17}
}
func (m *ClientCommand) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClientCommand) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClientCommand.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClientCommand) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClientCommand.Merge(m, src)
}
func (m *ClientCommand) XXX_Size() int {
	return m.Size()
}
func (m *ClientCommand) XXX_DiscardUnknown() {
	xxx_messageInfo_ClientCommand.DiscardUnknown(m)
}

var xxx_messageInfo_ClientCommand proto.InternalMessageInfo

func (m *ClientCommand) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *ClientCommand) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *ClientCommand) GetCommand() ClientCommand_Command {
	if m != nil {
		return m.Command
	}
	return ClientCommand_HELLO
}

func (m *ClientCommand) GetSource() ClientCommand_Source {
	if m != nil {
		return m.Source
	}
	return ClientCommand_STATE
}

func (m *ClientCommand) GetConfig() *Configuration {
	if m != nil {
		return m.Config
	}
	return nil
}

// CommandResponse is a response to a command sent by the client.
type CommandResponse struct {
	Id     uint64                 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Result CommandResponse_Result `protobuf:"varint,2,opt,name=result,proto3,enum=pb.CommandResponse_Result" json:"result,omitempty"`
	Error  string                 `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	// effective_config is the effective configuration the server holds for
	// this connection. It is returned in response to HELLO and UPDATE_CONFIG
	// commands.
	EffectiveConfig *Configuration `protobuf:"bytes,4,opt,name=effective_config,json=effectiveConfig,proto3" json:"effective_config,omitempty"`
}

func (m *CommandResponse) Reset()         { *m = CommandResponse{} }
func (m *CommandResponse) String() string { return proto.CompactTextString(m) }
func (*CommandResponse) ProtoMessage()    {}
func (*CommandResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{18}
}
func (m *CommandResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandResponse.Merge(m, src)
}
func (m *CommandResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandResponse proto.InternalMessageInfo

func (m *CommandResponse) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *CommandResponse) GetResult() CommandResponse_Result {
	if m != nil {
		return m.Result
	}
	return CommandResponse_OK
}

func (m *CommandResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *CommandResponse) GetEffectiveConfig() *Configuration {
	if m != nil {
		return m.EffectiveConfig
	}
	return nil
}

// ServerNotice represents a NOTICE sent from the server to the client.
type ServerNotice struct {
	Kind ServerNotice_Kind `protobuf:"varint,1,opt,name=kind,proto3,enum=pb.ServerNotice_Kind" json:"kind,omitempty"`
}

func (m *ServerNotice) Reset()         { *m = ServerNotice{} }
func (m *ServerNotice) String() string { return proto.CompactTextString(m) }
func (*ServerNotice) ProtoMessage()    {}
func (*ServerNotice) Descriptor() ([]byte, []int) {
	return fileDescriptor_53a8bedf9a75e10a, []int{19}
}
func (m *ServerNotice) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServerNotice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServerNotice.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServerNotice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerNotice.Merge(m, src)
}
func (m *ServerNotice) XXX_Size() int {
	return m.Size()
}
func (m *ServerNotice) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerNotice.DiscardUnknown(m)
}

var xxx_messageInfo_ServerNotice proto.InternalMessageInfo

func (m *ServerNotice) GetKind() ServerNotice_Kind {
	if m != nil {
		return m.Kind
	}
	return ServerNotice_DISCARDING_EVENTS
}

func init() {
	proto.RegisterEnum("pb.Status", Status_name, Status_value)
	proto.RegisterEnum("pb.Role", Role_name, Role_value)
	proto.RegisterEnum("pb.EventType_EventProperty_PropertyType", EventType_EventProperty_PropertyType_name, EventType_EventProperty_PropertyType_value)
	proto.RegisterEnum("pb.DHT_PeerInDHT_Status", DHT_PeerInDHT_Status_name, DHT_PeerInDHT_Status_value)
	proto.RegisterEnum("pb.ClientCommand_Source", ClientCommand_Source_name, ClientCommand_Source_value)
	proto.RegisterEnum("pb.ClientCommand_Command", ClientCommand_Command_name, ClientCommand_Command_value)
	proto.RegisterEnum("pb.CommandResponse_Result", CommandResponse_Result_name, CommandResponse_Result_value)
	proto.RegisterEnum("pb.ServerNotice_Kind", ServerNotice_Kind_name, ServerNotice_Kind_value)
	proto.RegisterType((*Version)(nil), "pb.Version")
	proto.RegisterType((*ResultCounter)(nil), "pb.ResultCounter")
	proto.RegisterType((*SlidingCounter)(nil), "pb.SlidingCounter")
	proto.RegisterType((*DataGauge)(nil), "pb.DataGauge")
	proto.RegisterType((*EventType)(nil), "pb.EventType")
	proto.RegisterType((*EventType_EventProperty)(nil), "pb.EventType.EventProperty")
	proto.RegisterType((*Runtime)(nil), "pb.Runtime")
	proto.RegisterType((*EndpointPair)(nil), "pb.EndpointPair")
	proto.RegisterType((*Traffic)(nil), "pb.Traffic")
	proto.RegisterType((*StreamList)(nil), "pb.StreamList")
	proto.RegisterType((*Connection)(nil), "pb.Connection")
	proto.RegisterType((*Connection_Timeline)(nil), "pb.Connection.Timeline")
	proto.RegisterType((*Connection_Attributes)(nil), "pb.Connection.Attributes")
	proto.RegisterType((*Stream)(nil), "pb.Stream")
	proto.RegisterType((*Stream_ConnectionRef)(nil), "pb.Stream.ConnectionRef")
	proto.RegisterType((*Stream_Timeline)(nil), "pb.Stream.Timeline")
	proto.RegisterType((*DHT)(nil), "pb.DHT")
	proto.RegisterType((*DHT_Params)(nil), "pb.DHT.Params")
	proto.RegisterType((*DHT_PeerInDHT)(nil), "pb.DHT.PeerInDHT")
	proto.RegisterType((*DHT_Bucket)(nil), "pb.DHT.Bucket")
	proto.RegisterType((*DHT_QueryGauge)(nil), "pb.DHT.QueryGauge")
	proto.RegisterType((*Subsystems)(nil), "pb.Subsystems")
	proto.RegisterType((*State)(nil), "pb.State")
	proto.RegisterType((*Event)(nil), "pb.Event")
	proto.RegisterType((*ServerMessage)(nil), "pb.ServerMessage")
	proto.RegisterType((*Configuration)(nil), "pb.Configuration")
	proto.RegisterType((*ClientCommand)(nil), "pb.ClientCommand")
	proto.RegisterType((*CommandResponse)(nil), "pb.CommandResponse")
	proto.RegisterType((*ServerNotice)(nil), "pb.ServerNotice")
}

func init() { proto.RegisterFile("introspection.proto", fileDescriptor_53a8bedf9a75e10a) }

var fileDescriptor_53a8bedf9a75e10a = []byte{
	// 2207 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x58, 0x5b, 0x6f, 0x1b, 0xc7,
	0x15, 0xe6, 0xfd, 0x72, 0x78, 0xf1, 0x6a, 0x9c, 0x20, 0xb4, 0x52, 0xab, 0xf6, 0xc6, 0x49, 0x14,
	0xc3, 0x50, 0x6d, 0x3a, 0x06, 0x02, 0x34, 0x0d, 0x20, 0x89, 0x5b, 0x8b, 0x8e, 0x44, 0xd1, 0x43,
	0xca, 0x68, 0xfb, 0xd0, 0xc5, 0x8a, 0x3b, 0x22, 0xb7, 0x22, 0x77, 0xb7, 0x33, 0x43, 0x25, 0x02,
	0xfa, 0xd0, 0x7f, 0xd0, 0xfe, 0x82, 0xfe, 0x86, 0x3e, 0xf7, 0xad, 0x40, 0x1f, 0x8a, 0x3e, 0xe5,
	0xb1, 0x68, 0x5f, 0x0a, 0xfb, 0x29, 0xff, 0xa2, 0x38, 0x33, 0xb3, 0x17, 0xc9, 0x97, 0xa6, 0x6f,
	0x7b, 0xce, 0xf7, 0x9d, 0xb3, 0xb3, 0xe7, 0x36, 0x87, 0x84, 0x9b, 0x41, 0x28, 0x79, 0x24, 0x62,
	0x36, 0x93, 0x41, 0x14, 0xee, 0xc4, 0x3c, 0x92, 0x11, 0x29, 0xc5, 0xa7, 0xf6, 0x47, 0x50, 0x7f,
	0xc1, 0xb8, 0x08, 0xa2, 0x90, 0xf4, 0xa0, 0x7e, 0xa1, 0x1f, 0x7b, 0xc5, 0x3b, 0xc5, 0xed, 0x0e,
	0x4d, 0x44, 0xfb, 0x29, 0x74, 0x28, 0x13, 0xeb, 0xa5, 0xdc, 0x8f, 0xd6, 0xa1, 0x64, 0x9c, 0xbc,
	0x07, 0x55, 0x19, 0x49, 0x6f, 0x69, 0x88, 0x5a, 0x20, 0x5d, 0x28, 0x45, 0xe7, 0xbd, 0x92, 0x52,
	0x95, 0xa2, 0x73, 0x62, 0x41, 0x99, 0x71, 0xde, 0x2b, 0x2b, 0x05, 0x3e, 0xda, 0x7f, 0x2a, 0x41,
	0x77, 0xb2, 0x0c, 0xfc, 0x20, 0x9c, 0x27, 0xae, 0x3e, 0x80, 0x7a, 0x74, 0xc1, 0xb8, 0xfb, 0x68,
	0x65, 0x9c, 0xd5, 0x50, 0x7c, 0xb4, 0x4a, 0x81, 0x27, 0x2b, 0xe3, 0x52, 0x01, 0x4f, 0x56, 0xe4,
	0x16, 0x34, 0xb4, 0xc5, 0x93, 0x95, 0xf1, 0xad, 0x88, 0x8f, 0x72, 0xd0, 0xe3, 0x87, 0xab, 0x5e,
	0x25, 0x83, 0x1e, 0x3f, 0xcc, 0x59, 0x2d, 0x78, 0xaf, 0x9a, 0xb3, 0x5a, 0xf0, 0x14, 0xea, 0x2f,
	0x78, 0xaf, 0x96, 0x41, 0xfd, 0x1c, 0xf4, 0xf9, 0x82, 0xf7, 0xea, 0x19, 0xf4, 0x79, 0x0e, 0xfa,
	0x62, 0xc1, 0x7b, 0x8d, 0x0c, 0xfa, 0x62, 0xc1, 0xc9, 0x87, 0xd0, 0xd4, 0xef, 0x42, 0x8f, 0x4d,
	0x85, 0x29, 0x2e, 0xca, 0x29, 0xd8, 0x47, 0x9f, 0x90, 0x81, 0x28, 0xdb, 0xa7, 0xd0, 0x1c, 0x78,
	0xd2, 0x7b, 0xea, 0xad, 0xe7, 0x0c, 0x99, 0xb3, 0xf5, 0xca, 0x3d, 0xbd, 0x94, 0x4c, 0xa8, 0xe0,
	0x54, 0x68, 0x63, 0xb6, 0x5e, 0xed, 0xa1, 0x4c, 0x7e, 0x0c, 0x2d, 0x04, 0x63, 0x6f, 0x76, 0xce,
	0xa4, 0x50, 0x21, 0xaa, 0x50, 0x98, 0xad, 0x57, 0x63, 0xad, 0xc1, 0xf8, 0x05, 0xa1, 0x90, 0xee,
	0xe9, 0x37, 0x2a, 0x4a, 0x15, 0x5a, 0x43, 0x71, 0xef, 0x1b, 0xfb, 0xaf, 0x25, 0x68, 0x3a, 0x17,
	0x2c, 0x94, 0xd3, 0xcb, 0x98, 0x11, 0x02, 0x95, 0xd0, 0x5b, 0x31, 0xe5, 0xbf, 0x49, 0xd5, 0x33,
	0xd9, 0x83, 0x6e, 0xcc, 0xa3, 0x98, 0x71, 0x79, 0xe9, 0xca, 0xcb, 0x98, 0xa1, 0xfb, 0xf2, 0x76,
	0xab, 0xff, 0xe1, 0x4e, 0x7c, 0xba, 0x93, 0x9a, 0xea, 0xa7, 0xb1, 0x21, 0xd2, 0x4e, 0x62, 0x82,
	0x98, 0xd8, 0xfc, 0x77, 0x11, 0x3a, 0x57, 0x08, 0x6f, 0x7c, 0xd3, 0x97, 0x50, 0xc1, 0x17, 0xa8,
	0xe3, 0x77, 0xfb, 0xdb, 0xef, 0xf0, 0xbf, 0x33, 0xce, 0xb9, 0xa7, 0xca, 0x8a, 0xdc, 0x85, 0xf6,
	0xc2, 0x13, 0xee, 0x6a, 0xbd, 0x94, 0x41, 0xbc, 0x64, 0xea, 0x3b, 0x1b, 0xb4, 0xb5, 0xf0, 0xc4,
	0x91, 0x51, 0xd9, 0x27, 0xd0, 0xce, 0x1b, 0x12, 0x80, 0xda, 0x64, 0x4a, 0x87, 0xa3, 0xa7, 0x56,
	0x01, 0x9f, 0x47, 0x27, 0x47, 0x7b, 0x0e, 0xb5, 0x8a, 0xa4, 0x01, 0x95, 0xe9, 0xf0, 0xc8, 0xb1,
	0x00, 0xb5, 0x63, 0xc7, 0xa1, 0xc3, 0x81, 0xd5, 0x22, 0x1d, 0x68, 0x1e, 0x9d, 0x1c, 0x4e, 0x87,
	0xbb, 0x83, 0x01, 0xb5, 0xda, 0x48, 0x7a, 0x36, 0x39, 0x1e, 0x59, 0xbf, 0xb2, 0xff, 0x5c, 0x84,
	0x3a, 0x5d, 0x87, 0x32, 0x58, 0x31, 0xf2, 0x09, 0x74, 0x83, 0x55, 0xbc, 0x64, 0x2b, 0x16, 0x4a,
	0x4f, 0x26, 0xed, 0xd3, 0xa4, 0xd7, 0xb4, 0xf9, 0xfe, 0x2a, 0x29, 0x42, 0x22, 0x92, 0x4d, 0x68,
	0xc4, 0x4b, 0x4f, 0x9e, 0x45, 0x5c, 0x57, 0x74, 0x93, 0xa6, 0x32, 0xa6, 0x31, 0x66, 0x8c, 0xbb,
	0x81, 0xaf, 0x2a, 0xba, 0x49, 0x6b, 0x28, 0x0e, 0x7d, 0xb2, 0x03, 0x2d, 0x86, 0x01, 0x32, 0x19,
	0xaa, 0xab, 0x0c, 0x75, 0xae, 0x44, 0x90, 0x02, 0x4b, 0x1e, 0x85, 0xfd, 0x0b, 0x68, 0x3b, 0xa1,
	0x1f, 0x47, 0x41, 0x28, 0xc7, 0x5e, 0xc0, 0xc9, 0x47, 0xd0, 0x11, 0x7c, 0xa6, 0x83, 0xe7, 0xf9,
	0x3e, 0x37, 0xa7, 0x6e, 0x0b, 0x3e, 0x3b, 0x4a, 0x74, 0x48, 0xf2, 0x85, 0xcc, 0x91, 0xf4, 0xc9,
	0xdb, 0xbe, 0x90, 0x29, 0xc9, 0x9e, 0x43, 0x7d, 0xca, 0xbd, 0xb3, 0xb3, 0x60, 0x46, 0x1e, 0x00,
	0x48, 0xfd, 0xe8, 0x06, 0x3a, 0x0e, 0xe6, 0x4c, 0x69, 0x55, 0xd3, 0xa6, 0x21, 0x0c, 0x43, 0xfc,
	0x84, 0x84, 0x1d, 0xad, 0xa5, 0xf2, 0xfd, 0x1a, 0x3d, 0xf1, 0x77, 0xbc, 0x96, 0xf6, 0x73, 0x80,
	0x89, 0xe4, 0xcc, 0x5b, 0x1d, 0x06, 0x42, 0x92, 0xdb, 0x00, 0x42, 0x49, 0x6e, 0xe0, 0x63, 0x7f,
	0x94, 0xb7, 0xdb, 0xb4, 0xa9, 0x35, 0x43, 0x5f, 0x90, 0x7b, 0x50, 0xd7, 0x42, 0x52, 0xbd, 0x80,
	0x8e, 0xb5, 0x3d, 0x4d, 0x20, 0xfb, 0x5f, 0x55, 0x80, 0xfd, 0x28, 0x0c, 0xf5, 0x60, 0xc4, 0x11,
	0x16, 0xf8, 0xea, 0xdc, 0x6d, 0x5a, 0x0a, 0xfc, 0x7c, 0xf4, 0x4b, 0x57, 0xa2, 0x6f, 0x43, 0x4d,
	0x48, 0x4f, 0xae, 0x85, 0x4a, 0x58, 0x37, 0x71, 0x8e, 0x1a, 0x6a, 0x10, 0x2c, 0x4f, 0xc9, 0xbd,
	0x50, 0xc4, 0x11, 0x97, 0x49, 0xfe, 0xda, 0xb4, 0x95, 0xea, 0x54, 0x12, 0x9b, 0xcc, 0x24, 0x45,
	0xa8, 0xb1, 0xd4, 0xea, 0x5b, 0x2a, 0x85, 0xb9, 0x4c, 0xd1, 0x8c, 0x42, 0x1e, 0x43, 0x03, 0x6b,
	0x6e, 0x19, 0x84, 0x4c, 0x8d, 0xaa, 0x56, 0xff, 0x03, 0xa4, 0x67, 0x5f, 0xb0, 0x33, 0x35, 0x30,
	0x4d, 0x89, 0xe4, 0x47, 0x50, 0xe1, 0xd1, 0x92, 0xa9, 0x01, 0xd6, 0xed, 0x37, 0xd0, 0x80, 0x46,
	0x4b, 0x46, 0x95, 0x96, 0x7c, 0x0c, 0x75, 0x13, 0x62, 0x35, 0xc6, 0x5a, 0xfd, 0x16, 0x12, 0x4c,
	0x42, 0x69, 0x82, 0x91, 0xc7, 0x50, 0xf7, 0xa4, 0xe4, 0xc1, 0xa9, 0x50, 0x13, 0xad, 0xd5, 0xbf,
	0x75, 0xed, 0xc5, 0xbb, 0x0a, 0x5d, 0x4b, 0x26, 0x68, 0xc2, 0xc4, 0x14, 0x2d, 0x3d, 0xc9, 0xc2,
	0xd9, 0xa5, 0x1b, 0x0a, 0x35, 0xec, 0x2a, 0xb4, 0x69, 0x34, 0x23, 0x41, 0xb6, 0xb3, 0x14, 0xb5,
	0x94, 0xcf, 0x6e, 0x96, 0x22, 0x4c, 0x71, 0x9a, 0x26, 0x72, 0x0b, 0xea, 0xb3, 0x28, 0x0c, 0x31,
	0x8a, 0x16, 0x46, 0xf1, 0xa0, 0x40, 0x6b, 0xa8, 0x18, 0xfa, 0xe4, 0x1e, 0x54, 0xf0, 0xa9, 0xb7,
	0x91, 0x79, 0xc8, 0x4e, 0x75, 0x50, 0xa0, 0x0a, 0x25, 0x0f, 0x80, 0xac, 0x05, 0xe3, 0x6e, 0xcc,
	0xa3, 0x8b, 0xc0, 0x67, 0xbe, 0x2b, 0xbd, 0xb9, 0xe8, 0xcd, 0xee, 0x94, 0xb7, 0x9b, 0xd4, 0x42,
	0x64, 0x6c, 0x80, 0xa9, 0x37, 0x17, 0x9b, 0x2e, 0x34, 0x92, 0x38, 0xaa, 0x7b, 0x28, 0x66, 0xa1,
	0x2b, 0x93, 0x19, 0x5c, 0x43, 0x71, 0xaa, 0x26, 0xf0, 0x3a, 0x9e, 0x73, 0x4f, 0x79, 0x4b, 0x27,
	0x70, 0xa2, 0x9a, 0xe2, 0xa1, 0x1b, 0xb3, 0x65, 0x24, 0x18, 0xa2, 0x7a, 0x04, 0xd7, 0x95, 0x3c,
	0x15, 0x9b, 0x23, 0x80, 0x2c, 0x5e, 0xe4, 0x0e, 0xb4, 0x92, 0x19, 0xf6, 0x2d, 0x4b, 0x1a, 0x31,
	0xaf, 0x22, 0x5b, 0x00, 0x2c, 0x9c, 0xf1, 0xcb, 0x58, 0x66, 0xe3, 0x23, 0xa7, 0xd9, 0xeb, 0x42,
	0x9b, 0xb3, 0xa5, 0x77, 0xc9, 0x7c, 0x17, 0xef, 0x92, 0x67, 0x95, 0x46, 0xdb, 0xb2, 0xec, 0xef,
	0xcb, 0x50, 0xd3, 0xd1, 0x7c, 0xad, 0xb0, 0x71, 0xe4, 0xe0, 0x12, 0x30, 0x8b, 0x96, 0xc6, 0x5d,
	0x2a, 0xa7, 0xf5, 0x52, 0xfe, 0x5f, 0xf5, 0x52, 0x79, 0x47, 0xbd, 0x3c, 0x30, 0x69, 0xd1, 0x45,
	0xdd, 0xcb, 0x12, 0x9b, 0xcb, 0x0e, 0x65, 0x67, 0x26, 0x3d, 0x3f, 0x79, 0xad, 0xae, 0x6f, 0xe6,
	0x2c, 0xde, 0x50, 0xd3, 0x59, 0xff, 0xd5, 0xdf, 0xda, 0x7f, 0x57, 0xab, 0xcf, 0xba, 0x5e, 0x7d,
	0xff, 0x5f, 0x49, 0xfc, 0x1a, 0x3a, 0x57, 0x0e, 0x9e, 0xd6, 0x5d, 0xf1, 0x9d, 0x75, 0x97, 0x2b,
	0xdc, 0xd2, 0xd5, 0xc2, 0xdd, 0x6b, 0x03, 0xcc, 0x52, 0x83, 0xcd, 0xaf, 0x7e, 0x48, 0xc9, 0xe5,
	0x2b, 0xaa, 0x74, 0xa5, 0xa2, 0xec, 0xef, 0xab, 0x50, 0x1e, 0x1c, 0x4c, 0xaf, 0x24, 0xb6, 0x78,
	0x2d, 0xb1, 0x3d, 0xa8, 0xb3, 0xd0, 0x3b, 0x5d, 0x32, 0x7d, 0x98, 0x06, 0x4d, 0x44, 0x74, 0x2c,
	0xa4, 0xc7, 0x65, 0xae, 0x54, 0x95, 0x3c, 0x15, 0xe4, 0x13, 0xa8, 0xc5, 0x1e, 0xc7, 0x1e, 0xad,
	0x64, 0x5f, 0x3a, 0x38, 0x98, 0xee, 0x8c, 0x95, 0x96, 0x1a, 0x14, 0x9b, 0xf9, 0x74, 0xad, 0x97,
	0x91, 0xaa, 0x9a, 0xb7, 0x29, 0x71, 0x4f, 0xa9, 0x69, 0x02, 0x93, 0x9f, 0x81, 0x15, 0x84, 0xb3,
	0x68, 0x15, 0x84, 0x73, 0xf7, 0xb7, 0x6b, 0xc6, 0x03, 0x26, 0x4c, 0xd2, 0x49, 0x62, 0xf2, 0x7c,
	0xcd, 0xf8, 0xa5, 0xbe, 0x00, 0x6e, 0x24, 0xdc, 0xe7, 0x9a, 0x8a, 0xe6, 0xd1, 0x5a, 0xce, 0xa3,
	0xbc, 0x79, 0xfd, 0xed, 0xe6, 0x09, 0xd7, 0x98, 0x6f, 0xce, 0xa1, 0xa6, 0x4f, 0x4e, 0xda, 0x50,
	0x3c, 0x37, 0x01, 0x2e, 0x9e, 0xe3, 0x4e, 0xeb, 0x2d, 0xe3, 0x85, 0x67, 0x02, 0xab, 0x05, 0xf2,
	0x31, 0x74, 0xfd, 0x40, 0xfc, 0x06, 0xa7, 0xaf, 0x1b, 0x7b, 0x72, 0x91, 0x84, 0xa7, 0x93, 0x68,
	0xc7, 0xa8, 0xc4, 0xdd, 0xe6, 0x94, 0x49, 0x4f, 0x85, 0xa8, 0x42, 0xd5, 0xf3, 0xe6, 0x5f, 0x8a,
	0xd0, 0x1c, 0xe3, 0x6d, 0x11, 0x62, 0x5e, 0x72, 0x37, 0x49, 0xf1, 0xca, 0x4d, 0xf2, 0x30, 0xad,
	0x64, 0xbd, 0x04, 0xf5, 0xd2, 0xf8, 0x26, 0xb6, 0xd7, 0xeb, 0xda, 0x86, 0x8e, 0x37, 0x67, 0x6e,
	0x10, 0xba, 0x3a, 0xa2, 0x66, 0x0b, 0x6e, 0x79, 0x73, 0x36, 0x0c, 0x75, 0xb0, 0xed, 0xaf, 0xb0,
	0xf3, 0x15, 0x1b, 0xa0, 0xb6, 0xbb, 0x3f, 0x1d, 0xbe, 0x70, 0xac, 0x02, 0x69, 0x41, 0xfd, 0x68,
	0x38, 0x99, 0xe0, 0xfa, 0x53, 0x24, 0x6d, 0x68, 0x50, 0xe7, 0x99, 0xb3, 0x3f, 0x75, 0x06, 0x56,
	0x09, 0x57, 0x9d, 0xfd, 0xdd, 0xd1, 0x60, 0x38, 0xd8, 0x9d, 0x3a, 0x56, 0x79, 0x73, 0x1f, 0x6a,
	0xda, 0x13, 0x6e, 0xf1, 0xb3, 0x38, 0xd9, 0xf4, 0xf1, 0x91, 0x7c, 0x0a, 0x55, 0x3c, 0x7b, 0x72,
	0xaf, 0x6e, 0xbc, 0x76, 0x60, 0xaa, 0xf1, 0xcd, 0x17, 0x00, 0x59, 0x26, 0xb0, 0xfa, 0xc4, 0x7a,
	0x36, 0x63, 0x22, 0xa9, 0xea, 0x44, 0xc4, 0xd0, 0x33, 0xce, 0x23, 0x9e, 0x84, 0x5e, 0x09, 0xc8,
	0xc7, 0x76, 0xc7, 0xcd, 0xc0, 0x94, 0xa4, 0x11, 0xed, 0x5f, 0x02, 0x4c, 0xd6, 0xa7, 0xe2, 0x52,
	0x48, 0xb6, 0x12, 0xe4, 0x21, 0xb4, 0xb2, 0x3e, 0xd2, 0x8b, 0xc0, 0x6b, 0xfd, 0x48, 0xf3, 0x14,
	0x72, 0x0b, 0xca, 0xfe, 0x22, 0xd9, 0x37, 0xea, 0xe6, 0xf8, 0x14, 0x75, 0xf6, 0x3f, 0x8a, 0x50,
	0xc5, 0xc0, 0x31, 0xb2, 0x03, 0x20, 0xd2, 0x97, 0xe4, 0xbb, 0x3c, 0x7b, 0x35, 0xcd, 0x31, 0xf2,
	0x73, 0xb1, 0xf4, 0x8e, 0xb9, 0x78, 0x1b, 0x00, 0xf7, 0x70, 0x2f, 0xcc, 0xf5, 0x5a, 0xd3, 0x68,
	0x74, 0x87, 0xa7, 0x8d, 0x58, 0xb9, 0xda, 0x88, 0x0f, 0xe1, 0x3d, 0x11, 0x7a, 0xb1, 0x58, 0x44,
	0xd2, 0xf5, 0xd7, 0x5c, 0x2d, 0x95, 0xee, 0x4a, 0x98, 0x5f, 0x33, 0x24, 0xc1, 0x06, 0x06, 0x3a,
	0x12, 0xf6, 0x14, 0xaa, 0x6a, 0x17, 0x24, 0x77, 0xcd, 0x9a, 0x9d, 0x5b, 0xc8, 0xb2, 0x25, 0x51,
	0xef, 0xd2, 0x5d, 0x28, 0xa5, 0x43, 0xa5, 0x24, 0x05, 0x46, 0x7f, 0x16, 0x85, 0x92, 0x85, 0xd2,
	0xac, 0xa4, 0x89, 0x68, 0xff, 0xa1, 0x04, 0x9d, 0x09, 0xe3, 0x17, 0x8c, 0x1f, 0x31, 0x21, 0xbc,
	0xb9, 0xba, 0x12, 0xf2, 0xbf, 0x1c, 0xcd, 0xa7, 0x9b, 0xdf, 0x95, 0xd9, 0x9a, 0x7b, 0x17, 0xaa,
	0x58, 0xc1, 0xcc, 0xc4, 0xa7, 0x99, 0x8c, 0x6c, 0x76, 0x50, 0xa0, 0x1a, 0x21, 0x9f, 0x42, 0x9d,
	0xeb, 0xb5, 0x5a, 0xbd, 0xd5, 0x78, 0x32, 0x9b, 0xf6, 0x41, 0x81, 0x26, 0x28, 0xfa, 0x52, 0xbb,
	0xad, 0x19, 0x4a, 0xcd, 0xf4, 0x93, 0xd0, 0x97, 0x42, 0xc8, 0x23, 0x68, 0x70, 0x26, 0xe2, 0x28,
	0x14, 0xcc, 0xdc, 0x42, 0x37, 0x75, 0x51, 0xac, 0x56, 0x5e, 0xe8, 0x53, 0x03, 0x1d, 0x14, 0x68,
	0x4a, 0x23, 0xf7, 0xa1, 0x16, 0x46, 0x32, 0x98, 0x25, 0x97, 0x90, 0xda, 0xc5, 0xf4, 0xb7, 0x8e,
	0x94, 0x1e, 0xc7, 0xb7, 0x66, 0xec, 0x35, 0xa1, 0x1e, 0x7b, 0x97, 0xcb, 0xc8, 0xf3, 0xed, 0xdf,
	0xa9, 0xbb, 0xe1, 0x2c, 0x98, 0x9b, 0xd0, 0x93, 0x1d, 0xb8, 0xc9, 0x19, 0x06, 0x0b, 0x53, 0x14,
	0x33, 0x1e, 0x44, 0xbe, 0xbb, 0x4a, 0xca, 0x7e, 0x23, 0x85, 0xc6, 0x0a, 0x39, 0x12, 0xe4, 0xa7,
	0xb0, 0xa9, 0xbe, 0xdf, 0x4d, 0x13, 0x1c, 0xe0, 0x8f, 0xe3, 0x0b, 0x6f, 0xe9, 0xae, 0x92, 0xa4,
	0x7c, 0xa0, 0x18, 0x13, 0x43, 0x18, 0x1a, 0xfc, 0x48, 0xd8, 0xbf, 0x2f, 0x43, 0x67, 0x7f, 0x19,
	0xb0, 0x50, 0x9a, 0x4f, 0xfb, 0xa1, 0xf9, 0xd0, 0x3b, 0x81, 0x49, 0x79, 0xe0, 0xe3, 0x8a, 0x37,
	0xd3, 0x1e, 0xcc, 0xd5, 0xaf, 0x57, 0xbc, 0xbc, 0xeb, 0x34, 0x7a, 0x09, 0x53, 0x8d, 0xaf, 0x68,
	0xcd, 0x67, 0x4c, 0x65, 0xc2, 0x8c, 0xaf, 0xab, 0x36, 0x13, 0x85, 0x53, 0xc3, 0x23, 0x9f, 0x01,
	0xde, 0x80, 0x67, 0xc1, 0xdc, 0x64, 0x65, 0xc3, 0xb4, 0x6a, 0x16, 0x3f, 0x6a, 0x08, 0xf6, 0x03,
	0xa8, 0x69, 0x63, 0xd2, 0x84, 0xea, 0x64, 0x8a, 0xa3, 0x49, 0x0d, 0x31, 0x7a, 0x32, 0x52, 0xbf,
	0xd6, 0x8a, 0x38, 0xdd, 0x9c, 0x17, 0xce, 0x68, 0x3a, 0xb1, 0x4a, 0xf6, 0xb7, 0x50, 0x4f, 0x22,
	0xd0, 0x84, 0xea, 0x81, 0x73, 0x78, 0x78, 0x6c, 0xe8, 0xce, 0xf3, 0x13, 0x67, 0x32, 0xb5, 0x8a,
	0xe4, 0x06, 0xb4, 0xc6, 0x27, 0x93, 0x03, 0xd7, 0x19, 0xed, 0xee, 0x1d, 0x3a, 0x56, 0x89, 0x58,
	0xd0, 0x56, 0x8a, 0xc1, 0x70, 0xa2, 0x34, 0x65, 0xd2, 0x05, 0x50, 0x9a, 0xf1, 0xee, 0xc9, 0xc4,
	0xb1, 0x2a, 0xa9, 0x09, 0x75, 0x26, 0x27, 0x47, 0x8e, 0x55, 0x25, 0x1b, 0xd0, 0x39, 0x19, 0xe3,
	0x98, 0x74, 0xf7, 0x8f, 0x47, 0x3f, 0x1f, 0x3e, 0xb5, 0xea, 0xf6, 0xdf, 0x8a, 0x70, 0xe3, 0x5a,
	0x5d, 0xe5, 0x36, 0x2e, 0x1d, 0xdd, 0x3e, 0xd4, 0xb8, 0xfa, 0x13, 0xc5, 0xcc, 0xf9, 0xcd, 0x37,
	0x14, 0xe3, 0x8e, 0xfe, 0x9b, 0x85, 0x1a, 0x66, 0x36, 0x18, 0x75, 0x0b, 0x9a, 0xc1, 0xf8, 0x25,
	0x58, 0xec, 0xec, 0x0c, 0x87, 0xd9, 0x05, 0x73, 0x4d, 0x28, 0x2b, 0x6f, 0x0b, 0xe5, 0x8d, 0x94,
	0xaa, 0xf5, 0xf6, 0x2d, 0xa8, 0xe9, 0xb7, 0x90, 0x1a, 0x94, 0x8e, 0xbf, 0xb6, 0x0a, 0xa4, 0x0e,
	0x65, 0x87, 0x52, 0xab, 0x88, 0x3f, 0x11, 0xf3, 0xc5, 0x4e, 0x3e, 0x83, 0xca, 0x79, 0x10, 0xea,
	0x8f, 0xe8, 0xf6, 0xdf, 0xbf, 0xde, 0x0c, 0x3b, 0x5f, 0x07, 0xa1, 0x4f, 0x15, 0xc5, 0xbe, 0x0d,
	0x15, 0x94, 0xc8, 0xfb, 0xb0, 0x31, 0x18, 0x4e, 0xf6, 0x77, 0xe9, 0x60, 0x38, 0x7a, 0xea, 0x9a,
	0xd4, 0x14, 0xee, 0x3b, 0x6f, 0xbc, 0x8e, 0x00, 0x6a, 0xfb, 0x87, 0xc7, 0x13, 0x67, 0x60, 0x15,
	0x31, 0x4d, 0xc7, 0x63, 0x67, 0x84, 0x57, 0x53, 0x09, 0x05, 0x04, 0x50, 0x28, 0x63, 0x2e, 0x1d,
	0x4a, 0x8f, 0xa9, 0x55, 0xb9, 0x7f, 0x0f, 0x2a, 0xb8, 0x89, 0xe2, 0x65, 0x35, 0x1c, 0x0d, 0xa7,
	0xc3, 0xdd, 0xe9, 0x31, 0xb5, 0x0a, 0x28, 0x52, 0x67, 0x32, 0x3e, 0x1e, 0x0d, 0xf0, 0xb7, 0xfc,
	0x5e, 0xef, 0xef, 0x2f, 0xb7, 0x8a, 0xdf, 0xbd, 0xdc, 0x2a, 0xfe, 0xe7, 0xe5, 0x56, 0xf1, 0x8f,
	0xaf, 0xb6, 0x0a, 0xdf, 0xbd, 0xda, 0x2a, 0xfc, 0xf3, 0xd5, 0x56, 0xe1, 0xb4, 0xa6, 0x56, 0xa1,
	0xc7, 0xff, 0x0d, 0x00, 0x00, 0xff, 0xff, 0x54, 0x4b, 0x9d, 0x7a, 0x0f, 0x13, 0x00, 0x00,
}

func (m *Version) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Version) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Version) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Version != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ResultCounter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResultCounter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResultCounter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Err != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Err))
		i--
		dAtA[i] = 0x18
	}
	if m.Ok != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Ok))
		i--
		dAtA[i] = 0x10
	}
	if m.Total != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Total))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SlidingCounter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SlidingCounter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SlidingCounter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Over_24Hr != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Over_24Hr))
		i--
		dAtA[i] = 0x50
	}
	if m.Over_12Hr != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Over_12Hr))
		i--
		dAtA[i] = 0x48
	}
	if m.Over_8Hr != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Over_8Hr))
		i--
		dAtA[i] = 0x40
	}
	if m.Over_4Hr != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Over_4Hr))
		i--
		dAtA[i] = 0x38
	}
	if m.Over_2Hr != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Over_2Hr))
		i--
		dAtA[i] = 0x30
	}
	if m.Over_1Hr != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Over_1Hr))
		i--
		dAtA[i] = 0x28
	}
	if m.Over_30M != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Over_30M))
		i--
		dAtA[i] = 0x20
	}
	if m.Over_15M != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Over_15M))
		i--
		dAtA[i] = 0x18
	}
	if m.Over_5M != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Over_5M))
		i--
		dAtA[i] = 0x10
	}
	if m.Over_1M != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Over_1M))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DataGauge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataGauge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DataGauge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InstBw != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.InstBw))
		i--
		dAtA[i] = 0x18
	}
	if m.CumPackets != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.CumPackets))
		i--
		dAtA[i] = 0x10
	}
	if m.CumBytes != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.CumBytes))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EventType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventType) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EventType) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PropertyTypes) > 0 {
		for iNdEx := len(m.PropertyTypes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PropertyTypes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIntrospection(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EventType_EventProperty) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventType_EventProperty) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EventType_EventProperty) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.HasMultiple {
		i--
		if m.HasMultiple {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Type != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Runtime) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Runtime) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Runtime) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.EventTypes) > 0 {
		for iNdEx := len(m.EventTypes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.EventTypes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIntrospection(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.PeerId) > 0 {
		i -= len(m.PeerId)
		copy(dAtA[i:], m.PeerId)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.PeerId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Platform) > 0 {
		i -= len(m.Platform)
		copy(dAtA[i:], m.Platform)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Platform)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Implementation) > 0 {
		i -= len(m.Implementation)
		copy(dAtA[i:], m.Implementation)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Implementation)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EndpointPair) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointPair) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EndpointPair) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DstMultiaddr) > 0 {
		i -= len(m.DstMultiaddr)
		copy(dAtA[i:], m.DstMultiaddr)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.DstMultiaddr)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SrcMultiaddr) > 0 {
		i -= len(m.SrcMultiaddr)
		copy(dAtA[i:], m.SrcMultiaddr)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.SrcMultiaddr)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Traffic) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Traffic) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Traffic) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TrafficOut != nil {
		{
			size, err := m.TrafficOut.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.TrafficIn != nil {
		{
			size, err := m.TrafficIn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StreamList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StreamList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StreamList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Streams) > 0 {
		for iNdEx := len(m.Streams) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Streams[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIntrospection(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.StreamIds) > 0 {
		for iNdEx := len(m.StreamIds) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.StreamIds[iNdEx])
			copy(dAtA[i:], m.StreamIds[iNdEx])
			i = encodeVarintIntrospection(dAtA, i, uint64(len(m.StreamIds[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Connection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Connection) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Connection) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.UserProvidedTags) > 0 {
		for iNdEx := len(m.UserProvidedTags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.UserProvidedTags[iNdEx])
			copy(dAtA[i:], m.UserProvidedTags[iNdEx])
			i = encodeVarintIntrospection(dAtA, i, uint64(len(m.UserProvidedTags[iNdEx])))
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0x9a
		}
	}
	if m.RelayedOver != nil {
		{
			size := m.RelayedOver.Size()
			i -= size
			if _, err := m.RelayedOver.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Streams != nil {
		{
			size, err := m.Streams.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.LatencyNs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.LatencyNs))
		i--
		dAtA[i] = 0x50
	}
	if m.Attribs != nil {
		{
			size, err := m.Attribs.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.Traffic != nil {
		{
			size, err := m.Traffic.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.Role != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Role))
		i--
		dAtA[i] = 0x38
	}
	if m.Timeline != nil {
		{
			size, err := m.Timeline.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Endpoints != nil {
		{
			size, err := m.Endpoints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.TransportId) > 0 {
		i -= len(m.TransportId)
		copy(dAtA[i:], m.TransportId)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.TransportId)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x18
	}
	if len(m.PeerId) > 0 {
		i -= len(m.PeerId)
		copy(dAtA[i:], m.PeerId)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.PeerId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Connection_ConnId) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Connection_ConnId) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ConnId != nil {
		i -= len(m.ConnId)
		copy(dAtA[i:], m.ConnId)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.ConnId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	return len(dAtA) - i, nil
}
func (m *Connection_Conn) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Connection_Conn) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Conn != nil {
		{
			size, err := m.Conn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	return len(dAtA) - i, nil
}
func (m *Connection_Timeline) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Connection_Timeline) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Connection_Timeline) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CloseTs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.CloseTs))
		i--
		dAtA[i] = 0x18
	}
	if m.UpgradedTs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.UpgradedTs))
		i--
		dAtA[i] = 0x10
	}
	if m.OpenTs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.OpenTs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Connection_Attributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Connection_Attributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Connection_Attributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Encryption) > 0 {
		i -= len(m.Encryption)
		copy(dAtA[i:], m.Encryption)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Encryption)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Multiplexer) > 0 {
		i -= len(m.Multiplexer)
		copy(dAtA[i:], m.Multiplexer)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Multiplexer)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Stream) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Stream) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Stream) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.UserProvidedTags) > 0 {
		for iNdEx := len(m.UserProvidedTags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.UserProvidedTags[iNdEx])
			copy(dAtA[i:], m.UserProvidedTags[iNdEx])
			i = encodeVarintIntrospection(dAtA, i, uint64(len(m.UserProvidedTags[iNdEx])))
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0x9a
		}
	}
	if m.LatencyNs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.LatencyNs))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.Status != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x38
	}
	if m.Timeline != nil {
		{
			size, err := m.Timeline.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Conn != nil {
		{
			size, err := m.Conn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Traffic != nil {
		{
			size, err := m.Traffic.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Role != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Role))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Stream_ConnectionRef) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Stream_ConnectionRef) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Stream_ConnectionRef) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Connection != nil {
		{
			size := m.Connection.Size()
			i -= size
			if _, err := m.Connection.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Stream_ConnectionRef_Conn) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Stream_ConnectionRef_Conn) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Conn != nil {
		{
			size, err := m.Conn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Stream_ConnectionRef_ConnId) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Stream_ConnectionRef_ConnId) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ConnId != nil {
		i -= len(m.ConnId)
		copy(dAtA[i:], m.ConnId)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.ConnId)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Stream_Timeline) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Stream_Timeline) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Stream_Timeline) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CloseTs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.CloseTs))
		i--
		dAtA[i] = 0x10
	}
	if m.OpenTs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.OpenTs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DHT) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DHT) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DHT) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.OutgoingQueries != nil {
		{
			size, err := m.OutgoingQueries.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.IncomingQueries != nil {
		{
			size, err := m.IncomingQueries.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Buckets) > 0 {
		for iNdEx := len(m.Buckets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Buckets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIntrospection(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.Params != nil {
		{
			size, err := m.Params.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.StartTs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x18
	}
	if m.Enabled {
		i--
		if m.Enabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DHT_Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DHT_Params) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DHT_Params) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Beta != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Beta))
		i--
		dAtA[i] = 0x20
	}
	if m.DisjointPaths != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.DisjointPaths))
		i--
		dAtA[i] = 0x18
	}
	if m.Alpha != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Alpha))
		i--
		dAtA[i] = 0x10
	}
	if m.K != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.K))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DHT_PeerInDHT) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DHT_PeerInDHT) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DHT_PeerInDHT) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgeInBucket != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.AgeInBucket))
		i--
		dAtA[i] = 0x18
	}
	if m.Status != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x10
	}
	if len(m.PeerId) > 0 {
		i -= len(m.PeerId)
		copy(dAtA[i:], m.PeerId)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.PeerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DHT_Bucket) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DHT_Bucket) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DHT_Bucket) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Peers) > 0 {
		for iNdEx := len(m.Peers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Peers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIntrospection(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Cpl != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Cpl))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DHT_QueryGauge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DHT_QueryGauge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DHT_QueryGauge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Timeout != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x18
	}
	if m.Error != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Error))
		i--
		dAtA[i] = 0x10
	}
	if m.Success != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Success))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Subsystems) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Subsystems) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Subsystems) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Dht != nil {
		{
			size, err := m.Dht.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Connections) > 0 {
		for iNdEx := len(m.Connections) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Connections[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIntrospection(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *State) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *State) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *State) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SnapshotDurationMs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.SnapshotDurationMs))
		i--
		dAtA[i] = 0x28
	}
	if m.StartTs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x20
	}
	if m.InstantTs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.InstantTs))
		i--
		dAtA[i] = 0x18
	}
	if m.Traffic != nil {
		{
			size, err := m.Traffic.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Subsystems != nil {
		{
			size, err := m.Subsystems.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Event) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Content) > 0 {
		i -= len(m.Content)
		copy(dAtA[i:], m.Content)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Content)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Ts != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Ts))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != nil {
		{
			size, err := m.Type.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServerMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServerMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServerMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Payload != nil {
		{
			size := m.Payload.Size()
			i -= size
			if _, err := m.Payload.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Version != nil {
		{
			size, err := m.Version.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServerMessage_State) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServerMessage_State) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.State != nil {
		{
			size, err := m.State.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *ServerMessage_Runtime) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServerMessage_Runtime) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Runtime != nil {
		{
			size, err := m.Runtime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *ServerMessage_Event) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServerMessage_Event) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Event != nil {
		{
			size, err := m.Event.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *ServerMessage_Response) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServerMessage_Response) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Response != nil {
		{
			size, err := m.Response.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *ServerMessage_Notice) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServerMessage_Notice) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Notice != nil {
		{
			size, err := m.Notice.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *Configuration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Configuration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Configuration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.StateSnapshotIntervalMs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.StateSnapshotIntervalMs))
		i--
		dAtA[i] = 0x10
	}
	if m.RetentionPeriodMs != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.RetentionPeriodMs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ClientCommand) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClientCommand) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClientCommand) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Source != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Source))
		i--
		dAtA[i] = 0x20
	}
	if m.Command != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Command))
		i--
		dAtA[i] = 0x18
	}
	if m.Id != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != nil {
		{
			size, err := m.Version.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommandResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.EffectiveConfig != nil {
		{
			size, err := m.EffectiveConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntrospection(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintIntrospection(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Result != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Result))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ServerNotice) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServerNotice) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServerNotice) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Kind != 0 {
		i = encodeVarintIntrospection(dAtA, i, uint64(m.Kind))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintIntrospection(dAtA []byte, offset int, v uint64) int {
	offset -= sovIntrospection(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Version) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovIntrospection(uint64(m.Version))
	}
	return n
}

func (m *ResultCounter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Total != 0 {
		n += 1 + sovIntrospection(uint64(m.Total))
	}
	if m.Ok != 0 {
		n += 1 + sovIntrospection(uint64(m.Ok))
	}
	if m.Err != 0 {
		n += 1 + sovIntrospection(uint64(m.Err))
	}
	return n
}

func (m *SlidingCounter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Over_1M != 0 {
		n += 1 + sovIntrospection(uint64(m.Over_1M))
	}
	if m.Over_5M != 0 {
		n += 1 + sovIntrospection(uint64(m.Over_5M))
	}
	if m.Over_15M != 0 {
		n += 1 + sovIntrospection(uint64(m.Over_15M))
	}
	if m.Over_30M != 0 {
		n += 1 + sovIntrospection(uint64(m.Over_30M))
	}
	if m.Over_1Hr != 0 {
		n += 1 + sovIntrospection(uint64(m.Over_1Hr))
	}
	if m.Over_2Hr != 0 {
		n += 1 + sovIntrospection(uint64(m.Over_2Hr))
	}
	if m.Over_4Hr != 0 {
		n += 1 + sovIntrospection(uint64(m.Over_4Hr))
	}
	if m.Over_8Hr != 0 {
		n += 1 + sovIntrospection(uint64(m.Over_8Hr))
	}
	if m.Over_12Hr != 0 {
		n += 1 + sovIntrospection(uint64(m.Over_12Hr))
	}
	if m.Over_24Hr != 0 {
		n += 1 + sovIntrospection(uint64(m.Over_24Hr))
	}
	return n
}

func (m *DataGauge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CumBytes != 0 {
		n += 1 + sovIntrospection(uint64(m.CumBytes))
	}
	if m.CumPackets != 0 {
		n += 1 + sovIntrospection(uint64(m.CumPackets))
	}
	if m.InstBw != 0 {
		n += 1 + sovIntrospection(uint64(m.InstBw))
	}
	return n
}

func (m *EventType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if len(m.PropertyTypes) > 0 {
		for _, e := range m.PropertyTypes {
			l = e.Size()
			n += 1 + l + sovIntrospection(uint64(l))
		}
	}
	return n
}

func (m *EventType_EventProperty) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovIntrospection(uint64(m.Type))
	}
	if m.HasMultiple {
		n += 2
	}
	return n
}

func (m *Runtime) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Implementation)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	l = len(m.Platform)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	l = len(m.PeerId)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if len(m.EventTypes) > 0 {
		for _, e := range m.EventTypes {
			l = e.Size()
			n += 1 + l + sovIntrospection(uint64(l))
		}
	}
	return n
}

func (m *EndpointPair) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SrcMultiaddr)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	l = len(m.DstMultiaddr)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}

func (m *Traffic) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TrafficIn != nil {
		l = m.TrafficIn.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.TrafficOut != nil {
		l = m.TrafficOut.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}

func (m *StreamList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.StreamIds) > 0 {
		for _, b := range m.StreamIds {
			l = len(b)
			n += 1 + l + sovIntrospection(uint64(l))
		}
	}
	if len(m.Streams) > 0 {
		for _, e := range m.Streams {
			l = e.Size()
			n += 1 + l + sovIntrospection(uint64(l))
		}
	}
	return n
}

func (m *Connection) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	l = len(m.PeerId)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovIntrospection(uint64(m.Status))
	}
	l = len(m.TransportId)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Endpoints != nil {
		l = m.Endpoints.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Timeline != nil {
		l = m.Timeline.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Role != 0 {
		n += 1 + sovIntrospection(uint64(m.Role))
	}
	if m.Traffic != nil {
		l = m.Traffic.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Attribs != nil {
		l = m.Attribs.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.LatencyNs != 0 {
		n += 1 + sovIntrospection(uint64(m.LatencyNs))
	}
	if m.Streams != nil {
		l = m.Streams.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.RelayedOver != nil {
		n += m.RelayedOver.Size()
	}
	if len(m.UserProvidedTags) > 0 {
		for _, s := range m.UserProvidedTags {
			l = len(s)
			n += 2 + l + sovIntrospection(uint64(l))
		}
	}
	return n
}

func (m *Connection_ConnId) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConnId != nil {
		l = len(m.ConnId)
		n += 2 + l + sovIntrospection(uint64(l))
	}
	return n
}
func (m *Connection_Conn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Conn != nil {
		l = m.Conn.Size()
		n += 2 + l + sovIntrospection(uint64(l))
	}
	return n
}
func (m *Connection_Timeline) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OpenTs != 0 {
		n += 1 + sovIntrospection(uint64(m.OpenTs))
	}
	if m.UpgradedTs != 0 {
		n += 1 + sovIntrospection(uint64(m.UpgradedTs))
	}
	if m.CloseTs != 0 {
		n += 1 + sovIntrospection(uint64(m.CloseTs))
	}
	return n
}

func (m *Connection_Attributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Multiplexer)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	l = len(m.Encryption)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}

func (m *Stream) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	l = len(m.Protocol)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Role != 0 {
		n += 1 + sovIntrospection(uint64(m.Role))
	}
	if m.Traffic != nil {
		l = m.Traffic.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Conn != nil {
		l = m.Conn.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Timeline != nil {
		l = m.Timeline.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovIntrospection(uint64(m.Status))
	}
	if m.LatencyNs != 0 {
		n += 2 + sovIntrospection(uint64(m.LatencyNs))
	}
	if len(m.UserProvidedTags) > 0 {
		for _, s := range m.UserProvidedTags {
			l = len(s)
			n += 2 + l + sovIntrospection(uint64(l))
		}
	}
	return n
}

func (m *Stream_ConnectionRef) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Connection != nil {
		n += m.Connection.Size()
	}
	return n
}

func (m *Stream_ConnectionRef_Conn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Conn != nil {
		l = m.Conn.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}
func (m *Stream_ConnectionRef_ConnId) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConnId != nil {
		l = len(m.ConnId)
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}
func (m *Stream_Timeline) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OpenTs != 0 {
		n += 1 + sovIntrospection(uint64(m.OpenTs))
	}
	if m.CloseTs != 0 {
		n += 1 + sovIntrospection(uint64(m.CloseTs))
	}
	return n
}

func (m *DHT) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Protocol)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Enabled {
		n += 2
	}
	if m.StartTs != 0 {
		n += 1 + sovIntrospection(uint64(m.StartTs))
	}
	if m.Params != nil {
		l = m.Params.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if len(m.Buckets) > 0 {
		for _, e := range m.Buckets {
			l = e.Size()
			n += 1 + l + sovIntrospection(uint64(l))
		}
	}
	if m.IncomingQueries != nil {
		l = m.IncomingQueries.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.OutgoingQueries != nil {
		l = m.OutgoingQueries.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}

func (m *DHT_Params) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.K != 0 {
		n += 1 + sovIntrospection(uint64(m.K))
	}
	if m.Alpha != 0 {
		n += 1 + sovIntrospection(uint64(m.Alpha))
	}
	if m.DisjointPaths != 0 {
		n += 1 + sovIntrospection(uint64(m.DisjointPaths))
	}
	if m.Beta != 0 {
		n += 1 + sovIntrospection(uint64(m.Beta))
	}
	return n
}

func (m *DHT_PeerInDHT) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PeerId)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovIntrospection(uint64(m.Status))
	}
	if m.AgeInBucket != 0 {
		n += 1 + sovIntrospection(uint64(m.AgeInBucket))
	}
	return n
}

func (m *DHT_Bucket) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cpl != 0 {
		n += 1 + sovIntrospection(uint64(m.Cpl))
	}
	if len(m.Peers) > 0 {
		for _, e := range m.Peers {
			l = e.Size()
			n += 1 + l + sovIntrospection(uint64(l))
		}
	}
	return n
}

func (m *DHT_QueryGauge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Success != 0 {
		n += 1 + sovIntrospection(uint64(m.Success))
	}
	if m.Error != 0 {
		n += 1 + sovIntrospection(uint64(m.Error))
	}
	if m.Timeout != 0 {
		n += 1 + sovIntrospection(uint64(m.Timeout))
	}
	return n
}

func (m *Subsystems) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Connections) > 0 {
		for _, e := range m.Connections {
			l = e.Size()
			n += 1 + l + sovIntrospection(uint64(l))
		}
	}
	if m.Dht != nil {
		l = m.Dht.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}

func (m *State) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Subsystems != nil {
		l = m.Subsystems.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Traffic != nil {
		l = m.Traffic.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.InstantTs != 0 {
		n += 1 + sovIntrospection(uint64(m.InstantTs))
	}
	if m.StartTs != 0 {
		n += 1 + sovIntrospection(uint64(m.StartTs))
	}
	if m.SnapshotDurationMs != 0 {
		n += 1 + sovIntrospection(uint64(m.SnapshotDurationMs))
	}
	return n
}

func (m *Event) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != nil {
		l = m.Type.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Ts != 0 {
		n += 1 + sovIntrospection(uint64(m.Ts))
	}
	l = len(m.Content)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}

func (m *ServerMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != nil {
		l = m.Version.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Payload != nil {
		n += m.Payload.Size()
	}
	return n
}

func (m *ServerMessage_State) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.State != nil {
		l = m.State.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}
func (m *ServerMessage_Runtime) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Runtime != nil {
		l = m.Runtime.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}
func (m *ServerMessage_Event) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Event != nil {
		l = m.Event.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}
func (m *ServerMessage_Response) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Response != nil {
		l = m.Response.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}
func (m *ServerMessage_Notice) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Notice != nil {
		l = m.Notice.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}
func (m *Configuration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RetentionPeriodMs != 0 {
		n += 1 + sovIntrospection(uint64(m.RetentionPeriodMs))
	}
	if m.StateSnapshotIntervalMs != 0 {
		n += 1 + sovIntrospection(uint64(m.StateSnapshotIntervalMs))
	}
	return n
}

func (m *ClientCommand) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != nil {
		l = m.Version.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.Id != 0 {
		n += 1 + sovIntrospection(uint64(m.Id))
	}
	if m.Command != 0 {
		n += 1 + sovIntrospection(uint64(m.Command))
	}
	if m.Source != 0 {
		n += 1 + sovIntrospection(uint64(m.Source))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}

func (m *CommandResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovIntrospection(uint64(m.Id))
	}
	if m.Result != 0 {
		n += 1 + sovIntrospection(uint64(m.Result))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovIntrospection(uint64(l))
	}
	if m.EffectiveConfig != nil {
		l = m.EffectiveConfig.Size()
		n += 1 + l + sovIntrospection(uint64(l))
	}
	return n
}

func (m *ServerNotice) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Kind != 0 {
		n += 1 + sovIntrospection(uint64(m.Kind))
	}
	return n
}

func sovIntrospection(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozIntrospection(x uint64) (n int) {
	return sovIntrospection(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Version) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Version: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Version: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResultCounter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResultCounter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResultCounter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Total", wireType)
			}
			m.Total = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Total |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ok", wireType)
			}
			m.Ok = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ok |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Err", wireType)
			}
			m.Err = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Err |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SlidingCounter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SlidingCounter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SlidingCounter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Over_1M", wireType)
			}
			m.Over_1M = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Over_1M |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Over_5M", wireType)
			}
			m.Over_5M = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Over_5M |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Over_15M", wireType)
			}
			m.Over_15M = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Over_15M |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Over_30M", wireType)
			}
			m.Over_30M = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Over_30M |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Over_1Hr", wireType)
			}
			m.Over_1Hr = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Over_1Hr |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Over_2Hr", wireType)
			}
			m.Over_2Hr = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Over_2Hr |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Over_4Hr", wireType)
			}
			m.Over_4Hr = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Over_4Hr |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Over_8Hr", wireType)
			}
			m.Over_8Hr = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Over_8Hr |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Over_12Hr", wireType)
			}
			m.Over_12Hr = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Over_12Hr |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Over_24Hr", wireType)
			}
			m.Over_24Hr = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Over_24Hr |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataGauge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataGauge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataGauge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CumBytes", wireType)
			}
			m.CumBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CumBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CumPackets", wireType)
			}
			m.CumPackets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CumPackets |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstBw", wireType)
			}
			m.InstBw = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InstBw |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PropertyTypes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PropertyTypes = append(m.PropertyTypes, &EventType_EventProperty{})
			if err := m.PropertyTypes[len(m.PropertyTypes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventType_EventProperty) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventProperty: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventProperty: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= EventType_EventProperty_PropertyType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasMultiple", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasMultiple = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Runtime) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Runtime: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Runtime: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Implementation", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Implementation = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Platform", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Platform = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventTypes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EventTypes = append(m.EventTypes, &EventType{})
			if err := m.EventTypes[len(m.EventTypes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndpointPair) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndpointPair: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndpointPair: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SrcMultiaddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SrcMultiaddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DstMultiaddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DstMultiaddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Traffic) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Traffic: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Traffic: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrafficIn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TrafficIn == nil {
				m.TrafficIn = &DataGauge{}
			}
			if err := m.TrafficIn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrafficOut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TrafficOut == nil {
				m.TrafficOut = &DataGauge{}
			}
			if err := m.TrafficOut.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StreamList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StreamList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StreamList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreamIds", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StreamIds = append(m.StreamIds, make([]byte, postIndex-iNdEx))
			copy(m.StreamIds[len(m.StreamIds)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Streams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Streams = append(m.Streams, &Stream{})
			if err := m.Streams[len(m.Streams)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Connection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Connection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Connection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = append(m.Id[:0], dAtA[iNdEx:postIndex]...)
			if m.Id == nil {
				m.Id = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= Status(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransportId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TransportId = append(m.TransportId[:0], dAtA[iNdEx:postIndex]...)
			if m.TransportId == nil {
				m.TransportId = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Endpoints == nil {
				m.Endpoints = &EndpointPair{}
			}
			if err := m.Endpoints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeline", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeline == nil {
				m.Timeline = &Connection_Timeline{}
			}
			if err := m.Timeline.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Role |= Role(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Traffic", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Traffic == nil {
				m.Traffic = &Traffic{}
			}
			if err := m.Traffic.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attribs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attribs == nil {
				m.Attribs = &Connection_Attributes{}
			}
			if err := m.Attribs.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LatencyNs", wireType)
			}
			m.LatencyNs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LatencyNs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Streams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Streams == nil {
				m.Streams = &StreamList{}
			}
			if err := m.Streams.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.RelayedOver = &Connection_ConnId{v}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Connection{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.RelayedOver = &Connection_Conn{v}
			iNdEx = postIndex
		case 99:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserProvidedTags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserProvidedTags = append(m.UserProvidedTags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Connection_Timeline) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Timeline: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Timeline: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpenTs", wireType)
			}
			m.OpenTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OpenTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpgradedTs", wireType)
			}
			m.UpgradedTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UpgradedTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloseTs", wireType)
			}
			m.CloseTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CloseTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Connection_Attributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Attributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Attributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Multiplexer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Multiplexer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Encryption", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Encryption = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Stream) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Stream: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Stream: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = append(m.Id[:0], dAtA[iNdEx:postIndex]...)
			if m.Id == nil {
				m.Id = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Protocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Role |= Role(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Traffic", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Traffic == nil {
				m.Traffic = &Traffic{}
			}
			if err := m.Traffic.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Conn == nil {
				m.Conn = &Stream_ConnectionRef{}
			}
			if err := m.Conn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeline", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeline == nil {
				m.Timeline = &Stream_Timeline{}
			}
			if err := m.Timeline.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= Status(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LatencyNs", wireType)
			}
			m.LatencyNs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LatencyNs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 99:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserProvidedTags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserProvidedTags = append(m.UserProvidedTags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Stream_ConnectionRef) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectionRef: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectionRef: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Connection{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Connection = &Stream_ConnectionRef_Conn{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Connection = &Stream_ConnectionRef_ConnId{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Stream_Timeline) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Timeline: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Timeline: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpenTs", wireType)
			}
			m.OpenTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OpenTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloseTs", wireType)
			}
			m.CloseTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CloseTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DHT) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DHT: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DHT: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Protocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Enabled = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Params", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Params == nil {
				m.Params = &DHT_Params{}
			}
			if err := m.Params.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Buckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Buckets = append(m.Buckets, &DHT_Bucket{})
			if err := m.Buckets[len(m.Buckets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncomingQueries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IncomingQueries == nil {
				m.IncomingQueries = &DHT_QueryGauge{}
			}
			if err := m.IncomingQueries.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutgoingQueries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutgoingQueries == nil {
				m.OutgoingQueries = &DHT_QueryGauge{}
			}
			if err := m.OutgoingQueries.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DHT_Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field K", wireType)
			}
			m.K = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.K |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alpha", wireType)
			}
			m.Alpha = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Alpha |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisjointPaths", wireType)
			}
			m.DisjointPaths = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DisjointPaths |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Beta", wireType)
			}
			m.Beta = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Beta |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DHT_PeerInDHT) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PeerInDHT: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PeerInDHT: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= DHT_PeerInDHT_Status(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgeInBucket", wireType)
			}
			m.AgeInBucket = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AgeInBucket |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DHT_Bucket) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Bucket: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Bucket: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cpl", wireType)
			}
			m.Cpl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Cpl |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Peers = append(m.Peers, &DHT_PeerInDHT{})
			if err := m.Peers[len(m.Peers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DHT_QueryGauge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryGauge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryGauge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Success", wireType)
			}
			m.Success = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Success |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			m.Error = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Error |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			m.Timeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timeout |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Subsystems) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subsystems: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subsystems: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Connections", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Connections = append(m.Connections, &Connection{})
			if err := m.Connections[len(m.Connections)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dht", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dht == nil {
				m.Dht = &DHT{}
			}
			if err := m.Dht.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *State) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: State: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: State: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subsystems", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subsystems == nil {
				m.Subsystems = &Subsystems{}
			}
			if err := m.Subsystems.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Traffic", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Traffic == nil {
				m.Traffic = &Traffic{}
			}
			if err := m.Traffic.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstantTs", wireType)
			}
			m.InstantTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InstantTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotDurationMs", wireType)
			}
			m.SnapshotDurationMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SnapshotDurationMs |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Type == nil {
				m.Type = &EventType{}
			}
			if err := m.Type.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ts", wireType)
			}
			m.Ts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ts |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Content", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Content = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Version == nil {
				m.Version = &Version{}
			}
			if err := m.Version.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &State{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &ServerMessage_State{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Runtime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Runtime{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &ServerMessage_Runtime{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Event", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Event{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &ServerMessage_Event{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CommandResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &ServerMessage_Response{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Notice", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ServerNotice{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &ServerMessage_Notice{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Configuration) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Configuration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Configuration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetentionPeriodMs", wireType)
			}
			m.RetentionPeriodMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RetentionPeriodMs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StateSnapshotIntervalMs", wireType)
			}
			m.StateSnapshotIntervalMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StateSnapshotIntervalMs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClientCommand) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClientCommand: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClientCommand: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Version == nil {
				m.Version = &Version{}
			}
			if err := m.Version.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			m.Command = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Command |= ClientCommand_Command(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			m.Source = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Source |= ClientCommand_Source(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &Configuration{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			m.Result = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Result |= CommandResponse_Result(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EffectiveConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntrospection
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntrospection
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EffectiveConfig == nil {
				m.EffectiveConfig = &Configuration{}
			}
			if err := m.EffectiveConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerNotice) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerNotice: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerNotice: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			m.Kind = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Kind |= ServerNotice_Kind(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIntrospection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIntrospection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipIntrospection(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowIntrospection
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIntrospection
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthIntrospection
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupIntrospection
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthIntrospection
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthIntrospection        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowIntrospection          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupIntrospection = fmt.Errorf("proto: unexpected end of group")
)
