/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.auth.ServiceAccountTokenSupplier;
import com.oracle.bmc.auth.internal.JwtClaimsSet;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;

public abstract class AbstractServiceAccountTokenSupplier
implements ServiceAccountTokenSupplier {
    @Override
    public String getServiceAccountToken() {
        try {
            String currentToken = this.getTokenInner();
            if (!this.isValidServiceAccountToken(currentToken).booleanValue()) {
                throw new IllegalArgumentException("Kubernetes service account token expired.");
            }
            return currentToken;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Kubernetes service account token doesn't exist.", e);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Fail to parse Kubernetes service account token.", e);
        }
    }

    protected abstract String getTokenInner() throws IOException;

    private Boolean isValidServiceAccountToken(String token) throws ParseException {
        JwtClaimsSet jwtClaims = new JwtClaimsSet(token);
        Date expirationTime = jwtClaims.getExpirationTime();
        if (expirationTime != null && expirationTime.toInstant().isAfter(Instant.now())) {
            return true;
        }
        return false;
    }
}

