/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.http.client.Serializer;
import com.oracle.bmc.util.internal.Validate;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class JwtClaimsSet {
    private static final Serializer OBJECT_MAPPER = Serializer.getDefault();
    private final Map<String, Object> header;
    private final Map<String, Object> payload;
    private final String signature;

    public JwtClaimsSet(String token) {
        Validate.notBlank(token, "token must not be null or empty", new Object[0]);
        String[] parts = token.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Malformed JWT, only " + parts.length + " parts instead of 3");
        }
        try {
            Map h = (Map)OBJECT_MAPPER.readValue(AuthUtils.base64Decode(parts[0]), Map.class);
            Map p = (Map)OBJECT_MAPPER.readValue(AuthUtils.base64Decode(parts[1]), Map.class);
            this.signature = parts[2];
            if (this.signature.isEmpty()) {
                throw new IllegalArgumentException("The token doesn't have a signature");
            }
            JwtClaimsSet.convertToDate(p, "exp");
            JwtClaimsSet.convertToDate(p, "nbf");
            JwtClaimsSet.convertToDate(p, "iat");
            this.header = Collections.unmodifiableMap(h);
            this.payload = Collections.unmodifiableMap(p);
        }
        catch (IOException | ClassCastException e) {
            throw new IllegalArgumentException("Malformed JWT", e);
        }
    }

    private static void convertToDate(Map<String, Object> m, String key) {
        Object o = m.get(key);
        if (o != null) {
            m.put(key, new Date(TimeUnit.SECONDS.toMillis(Long.valueOf(o.toString()))));
        }
    }

    public Map<String, Object> getHeader() {
        return this.header;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public String getSignature() {
        return this.signature;
    }

    public Date getExpirationTime() {
        return (Date)this.getClaim("exp");
    }

    public Date getIssueTime() {
        return (Date)this.getClaim("iat");
    }

    public String getStringClaim(String name) throws ParseException {
        Object claim = this.payload.get(name);
        if (claim == null) {
            return null;
        }
        if (claim instanceof String) {
            return (String)claim;
        }
        throw new ParseException("Malformed JWT, claim '" + name + "' is not a string, was '" + claim.getClass().getName() + "'", 0);
    }

    public Object getClaim(String name) {
        return this.payload.get(name);
    }
}

