from collections import OrderedDict

from .. import Provider as PersonProvider


class Provider(PersonProvider):
    formats_female = OrderedDict(
        (
            ("{{first_name_female}} {{last_name}}", 0.9),
            ("{{first_name_female}} {{last_name}}-{{last_name}}", 0.06),
            ("{{first_name_female}} {{first_name_female}} {{last_name}}", 0.04),
        )
    )

    formats_male = OrderedDict(
        (
            ("{{first_name_male}} {{last_name}}", 0.95),
            ("{{first_name_male}} {{last_name}}-{{last_name}}", 0.025),
            ("{{first_name_male}} {{first_name_male}} {{last_name}}", 0.025),
        )
    )

    # Using random_element's dictionary weighting means that the
    #     formats = formats_male + formats_female
    # has to be replaced with something dict and python 2.x compatible

    formats = formats_male.copy()
    formats.update(formats_female)

    # Top names given in Israel in 2015
    # http://www.cbs.gov.il/reader/newhodaot/tables_template.html?hodaa=201611401

    first_names_female = OrderedDict(
        (
            ("אביב", 0.002782860042127),
            ("אביגיל", 0.017542780707554),
            ("אביה", 0.00339785673652),
            ("אביטל", 0.002644485785889),
            ("אבישג", 0.005288971571778),
            ("אגם", 0.0085330791347),
            ("אדוה", 0.001030119463108),
            ("אדל", 0.016512661244446),
            ("אדר", 0.000968619793669),
            ("אהובה", 0.000737996033271),
            ("אודיה", 0.000799495702711),
            ("אודל", 0.003059608554604),
            ("אודליה", 0.000999369628388),
            ("אווה", 0.00081487062007),
            ("אופיר", 0.004535600621147),
            ("אופל", 0.000568871942313),
            ("אופק", 0.000476622438154),
            ("אור", 0.004643225042665),
            ("אוראל", 0.000538122107594),
            ("אורה", 0.000784120785351),
            ("אורטל", 0.000322873264556),
            ("אורי", 0.004858473885703),
            ("אוריאן", 0.002198613182454),
            ("אוריה", 0.005688719423133),
            ("אורין", 0.002890484463646),
            ("אורן", 0.000461247520795),
            ("אושר", 0.000737996033271),
            ("אחינועם", 0.000999369628388),
            ("איה", 0.001091619132547),
            ("איה", 0.002936609215725),
            ("איטה", 0.000538122107594),
            ("איידל", 0.000307498347196),
            ("איילה", 0.015959164219492),
            ("איילת", 0.001506741901262),
            ("איימי", 0.000676496363832),
            ("אילין", 0.000153749173598),
            ("אילין", 0.001921864669977),
            ("אילת", 0.000461247520795),
            ("אימאן", 0.001030119463108),
            ("אלה", 0.009809197275565),
            ("אלומה", 0.000445872603435),
            ("אלונה", 0.002029489091496),
            ("אלטע", 0.000415122768715),
            ("אלי", 0.000799495702711),
            ("אליאן", 0.0017219907443),
            ("אליאנה", 0.000368998016636),
            ("אליה", 0.004443351116988),
            ("אלין", 0.000122999338879),
            ("אלין", 0.000538122107594),
            ("אלין", 0.003290232315001),
            ("אלין", 0.003982103596193),
            ("אלינור", 0.001030119463108),
            ("אליס", 0.000430497686075),
            ("אליסה", 0.000399747851355),
            ("אליענה", 0.00081487062007),
            ("אלישבע", 0.005319721406497),
            ("אלכס", 0.00086099537215),
            ("אלמא", 0.001106994049907),
            ("אלמה", 0.0033671069018),
            ("אלמוג", 0.00086099537215),
            ("אמה", 0.007748958349349),
            ("אמונה", 0.001199243554066),
            ("אמור", 0.000322873264556),
            ("אמי", 0.000538122107594),
            ("אמילי", 0.000153749173598),
            ("אמילי", 0.005873218431451),
            ("אמיליה", 0.00084562045479),
            ("אמל", 0.001967989422057),
            ("אמלי", 0.000737996033271),
            ("אן", 0.000661121446472),
            ("אנאבל", 0.000522747190234),
            ("אנאל", 0.00338248181916),
            ("אנה", 0.001229993388786),
            ("אסיל", 0.000169124090958),
            ("אסיל", 0.002075613843576),
            ("אסנת", 0.000322873264556),
            ("אסתר", 0.010639442812995),
            ("אפרת", 0.007041712150797),
            ("ארבל", 0.002213988099814),
            ("אריאל", 0.008287080456943),
            ("בארי", 0.000322873264556),
            ("ביאן", 0.001229993388786),
            ("בילא", 0.000784120785351),
            ("ביסאן", 0.002629110868529),
            ("בלומה", 0.001030119463108),
            ("בר", 0.002336987438693),
            ("ברכה", 0.002613735951169),
            ("בת", 0.001568241570702),
            ("בתיה", 0.002290862686613),
            ("בת שבע", 0.003259482480282),
            ("גאיה", 0.006672714134162),
            ("ג'ואל", 0.000138374256238),
            ("ג'וד", 0.001076244215187),
            ("ג'ויל", 0.000122999338879),
            ("גולדה", 0.000707246198552),
            ("ג'ולי", 0.000184499008318),
            ("ג'ולין", 0.000138374256238),
            ("גוני", 0.000368998016636),
            ("ג'ורי", 0.000138374256238),
            ("גורי", 0.00255223628173),
            ("ג'ורי", 0.002598361033809),
            ("גזל", 0.001752740579019),
            ("גיטל", 0.001368367645024),
            ("גיל", 0.000707246198552),
            ("גילה", 0.000691871281192),
            ("גילי", 0.003259482480282),
            ("גל", 0.001537491735982),
            ("גלי", 0.002967359050445),
            ("גליה", 0.00084562045479),
            ("ג'נא", 0.005688719423133),
            ("גפן", 0.00424347719131),
            ("דבורה", 0.00425885210867),
            ("דור", 0.000430497686075),
            ("דורון", 0.000722621115912),
            ("דורין", 0.000384372933995),
            ("דימא", 0.001337617810304),
            ("דינה", 0.00084562045479),
            ("דנה", 0.000753370950631),
            ("דני", 0.000445872603435),
            ("דניאל", 0.00427422702603),
            ("דניאלה", 0.003213357728202),
            ("דפנה", 0.000753370950631),
            ("דרור", 0.000491997355514),
            ("דריה", 0.001752740579019),
            ("הדס", 0.004950723389862),
            ("הדסה", 0.004643225042665),
            ("הדר", 0.005596469918974),
            ("הודיה", 0.009855322027644),
            ("היילי", 0.000322873264556),
            ("הילה", 0.007795083101428),
            ("הילי", 0.002798234959487),
            ("הינדא", 0.000584246859673),
            ("הלל", 0.006349840869605),
            ("הללי", 0.002029489091496),
            ("הניה", 0.000338248181916),
            ("הענא", 0.000384372933995),
            ("זהבה", 0.000522747190234),
            ("זואי", 0.001076244215187),
            ("זוהר", 0.003028858719884),
            ("זיו", 0.001645116157501),
            ("זינב", 0.0017219907443),
            ("זינה", 0.002998108885165),
            ("חגית", 0.000322873264556),
            ("חוה", 0.002090988760935),
            ("חיה", 0.008948201903415),
            ("חלא", 0.000261373595117),
            ("חלא", 0.003305607232361),
            ("חן", 0.001091619132547),
            ("חנה", 0.011577312771944),
            ("טובה", 0.001322242892944),
            ("טוהר", 0.005473470580096),
            ("טל", 0.001937239587337),
            ("טלי", 0.000599621777033),
            ("טליה", 0.016620285665965),
            ("יארא", 0.000169124090958),
            ("יהב", 0.001091619132547),
            ("יהודית", 0.004966098307222),
            ("יהל", 0.001337617810304),
            ("יהלי", 0.005734844175213),
            ("יובל", 0.009701572854046),
            ("יוטא", 0.000538122107594),
            ("יוכבד", 0.001276118140865),
            ("יולי", 0.002429236942851),
            ("ים", 0.000553497024953),
            ("יסכה", 0.001491366983902),
            ("יסמין", 0.000261373595117),
            ("יסמין", 0.001076244215187),
            ("יסמין", 0.003090358389324),
            ("יעל", 0.015713165541735),
            ("יעלה", 0.001291493058225),
            ("יערה", 0.002890484463646),
            ("יפה", 0.000691871281192),
            ("ירדן", 0.004105102935072),
            ("ירין", 0.000599621777033),
            ("כליל", 0.000399747851355),
            ("כנרת", 0.000368998016636),
            ("כרמל", 0.002752110207408),
            ("לאה", 0.005903968266171),
            ("לארא", 0.000122999338879),
            ("לוטם", 0.00084562045479),
            ("לור", 0.000122999338879),
            ("לורן", 0.001337617810304),
            ("לי", 0.000691871281192),
            ("ליאה", 0.000953244876309),
            ("ליאור", 0.002921234298366),
            ("ליאורה", 0.000538122107594),
            ("ליאל", 0.004489475869067),
            ("ליאם", 0.001475992066543),
            ("ליאן", 0.000169124090958),
            ("ליאן", 0.000384372933995),
            ("ליאן", 0.004889223720423),
            ("ליאן", 0.007010962316078),
            ("ליב", 0.000322873264556),
            ("ליבא", 0.00087637028951),
            ("ליבי", 0.004520225703787),
            ("ליה", 0.011285189342107),
            ("ליהי", 0.00167586599222),
            ("ליהיא", 0.001199243554066),
            ("ליטל", 0.000445872603435),
            ("לייה", 0.000907120124229),
            ("לילי", 0.000983994711028),
            ("לילך", 0.000476622438154),
            ("לין", 0.000153749173598),
            ("לין", 0.000384372933995),
            ("לין", 0.000691871281192),
            ("לין", 0.005427345828016),
            ("לינוי", 0.002075613843576),
            ("ליעד", 0.000368998016636),
            ("לירון", 0.000799495702711),
            ("לירז", 0.000553497024953),
            ("לירי", 0.001076244215187),
            ("למאר", 0.001491366983902),
            ("לנא", 0.000138374256238),
            ("לנא", 0.001245368306145),
            ("לני", 0.001429867314463),
            ("מאור", 0.00081487062007),
            ("מאורי", 0.000353623099276),
            ("מאי", 0.003459356405959),
            ("מאיה", 0.000153749173598),
            ("מאיה", 0.000245998677757),
            ("מאיה", 0.017588905459633),
            ("מור", 0.000522747190234),
            ("מוריה", 0.00428960194339),
            ("מיאל", 0.000599621777033),
            ("מיאר", 0.001383742562384),
            ("מיטל", 0.000430497686075),
            ("מייה", 0.000676496363832),
            ("מיכאלה", 0.0017219907443),
            ("מיכל", 0.010870066573392),
            ("מילא", 0.000169124090958),
            ("מילא", 0.000322873264556),
            ("מילה", 0.001245368306145),
            ("מילי", 0.000522747190234),
            ("מיקה", 0.004996848141941),
            ("מירא", 0.000138374256238),
            ("מירא", 0.00173736566166),
            ("מיראל", 0.000184499008318),
            ("מיראל", 0.000184499008318),
            ("מיראל", 0.001506741901262),
            ("מיריל", 0.000153749173598),
            ("מישל", 0.000937869958949),
            ("מיתר", 0.000676496363832),
            ("מלאק", 0.000169124090958),
            ("מלאק", 0.000169124090958),
            ("מלאק", 0.003874479174674),
            ("מלכה", 0.00513522239818),
            ("מנוחה", 0.000415122768715),
            ("מנור", 0.000645746529112),
            ("מעיין", 0.006503590043204),
            ("מרגלית", 0.000430497686075),
            ("מריה", 0.000399747851355),
            ("מריה", 0.001875739917898),
            ("מרים", 0.000184499008318),
            ("מרים", 0.007379960332713),
            ("מרים", 0.009424824341569),
            ("משי", 0.000707246198552),
            ("נאוה", 0.000399747851355),
            ("נאי", 0.000322873264556),
            ("נאי", 0.001183868636706),
            ("נאיא", 0.000184499008318),
            ("נאיא", 0.001475992066543),
            ("נאיה", 0.000169124090958),
            ("נאיה", 0.000322873264556),
            ("נגה", 0.007825832936148),
            ("נוי", 0.001399117479744),
            ("נויה", 0.010639442812995),
            ("נועה", 0.022216755584939),
            ("נועם", 0.005365846158577),
            ("נופר", 0.000645746529112),
            ("נור", 0.000153749173598),
            ("נור", 0.000261373595117),
            ("נור", 0.003720730001076),
            ("נחמה", 0.003843729339955),
            ("נטלי", 0.000276748512477),
            ("נטלי", 0.000553497024953),
            ("נטע", 0.005350471241217),
            ("נילי", 0.000722621115912),
            ("נינה", 0.001106994049907),
            ("ניצן", 0.001445242231823),
            ("ניקה", 0.000322873264556),
            ("ניקול", 0.000753370950631),
            ("נעמה", 0.005565720084255),
            ("נעמי", 0.008333205209022),
            ("סארה", 0.003905229009394),
            ("סהר", 0.000753370950631),
            ("סול", 0.00086099537215),
            ("סופי", 0.000322873264556),
            ("סופיה", 0.000907120124229),
            ("סיון", 0.000599621777033),
            ("סילא", 0.000169124090958),
            ("סילין", 0.000169124090958),
            ("סימה", 0.000430497686075),
            ("סלמא", 0.001460617149183),
            ("סמא", 0.000199873925678),
            ("ספיר", 0.001091619132547),
            ("סתיו", 0.00086099537215),
            ("עדי", 0.007118586737596),
            ("עדיה", 0.000553497024953),
            ("עדינה", 0.000691871281192),
            ("עדן", 0.001460617149183),
            ("עדן", 0.003812979505235),
            ("עומר", 0.0034439814886),
            ("עופרי", 0.005642594671054),
            ("עטרה", 0.000599621777033),
            ("עטרת", 0.000338248181916),
            ("עידן", 0.000384372933995),
            ("עלמה", 0.00847157946526),
            ("עמית", 0.004904598637782),
            ("עמליה", 0.001183868636706),
            ("עמנואל", 0.001552866653342),
            ("ענאל", 0.000322873264556),
            ("ענבל", 0.000384372933995),
            ("ענבר", 0.001937239587337),
            ("ענהאל", 0.002075613843576),
            ("פאטמה", 0.003305607232361),
            ("פאר", 0.000430497686075),
            ("פיגא", 0.001967989422057),
            ("פלג", 0.000445872603435),
            ("פנינה", 0.001122368967267),
            ("פערל", 0.000645746529112),
            ("פרח", 0.001552866653342),
            ("פריאל", 0.000691871281192),
            ("פריידא", 0.000445872603435),
            ("צביה", 0.00087637028951),
            ("צופיה", 0.001183868636706),
            ("צפורה", 0.002413862025492),
            ("קארין", 0.000399747851355),
            ("קורל", 0.000753370950631),
            ("קים", 0.000614996694393),
            ("קרן", 0.000507372272874),
            ("קרני", 0.000599621777033),
            ("ראשית", 0.000322873264556),
            ("רבקה", 0.009824572192924),
            ("רהף", 0.002828984794207),
            ("רוחמה", 0.000507372272874),
            ("רומי", 0.000722621115912),
            ("רומי", 0.011669562276103),
            ("רון", 0.000507372272874),
            ("רונה", 0.001998739256777),
            ("רוני", 0.012407558309374),
            ("רות", 0.008102581448625),
            ("רותם", 0.002475361694931),
            ("רז", 0.000753370950631),
            ("רחל", 0.009501698928368),
            ("רייזל", 0.000507372272874),
            ("רים", 0.001199243554066),
            ("רימא", 0.001060869297828),
            ("רימאס", 0.001629741240141),
            ("רינה", 0.000491997355514),
            ("ריתאג'", 0.001106994049907),
            ("ריתאל", 0.003643855414277),
            ("רני", 0.000968619793669),
            ("רננה", 0.001260743223505),
            ("רעות", 0.001368367645024),
            ("רעיה", 0.000338248181916),
            ("רפיף", 0.001537491735982),
            ("שאם", 0.000153749173598),
            ("שאם", 0.006196091696007),
            ("שהד", 0.002490736612291),
            ("שובל", 0.000645746529112),
            ("שוהם", 0.001952614504697),
            ("שולמית", 0.001829615165818),
            ("שושנה", 0.002213988099814),
            ("שחר", 0.004012853430913),
            ("שטערנא", 0.000353623099276),
            ("שי", 0.00338248181916),
            ("שיינא", 0.001168493719346),
            ("שיינדל", 0.000491997355514),
            ("שי לי", 0.002044864008856),
            ("שי-לי", 0.003244107562922),
            ("שילת", 0.002367737273412),
            ("שיר", 0.005534970249535),
            ("שיראל", 0.001921864669977),
            ("שירה", 0.016266662566689),
            ("שירי", 0.00087637028951),
            ("שלי", 0.00089174520687),
            ("שני", 0.003474731323319),
            ("שפרה", 0.00083024553743),
            ("שקד", 0.005488845497455),
            ("שרה", 0.000245998677757),
            ("שרה", 0.002167863347735),
            ("שרה", 0.014944419673744),
            ("תאיר", 0.00169124090958),
            ("תאלא", 0.000276748512477),
            ("תאלא", 0.002705985455328),
            ("תאלין", 0.002629110868529),
            ("תבל", 0.000476622438154),
            ("תהילה", 0.006303716117526),
            ("תהל", 0.008041081779185),
            ("תהלה", 0.000415122768715),
            ("תולין", 0.000322873264556),
            ("תולין", 0.001491366983902),
            ("תום", 0.000630371611753),
            ("תיא", 0.000199873925678),
            ("תיא", 0.000230623760397),
            ("תמר", 0.020341015667041),
            ("תמרה", 0.001060869297828),
            ("תפארת", 0.00083024553743),
        )
    )

    first_names_male = OrderedDict(
        (
            ("אביאל", 0.004307179574083),
            ("אביב", 0.003911766367282),
            ("אביהו", 0.000395413206801),
            ("אביחי", 0.000762582613116),
            ("אבינועם", 0.00043777890753),
            ("אביעד", 0.001256849121618),
            ("אבישי", 0.002188894537649),
            ("אביתר", 0.004603739479184),
            ("אבראהים", 0.000155340902672),
            ("אבראהים", 0.004759080381856),
            ("אברהם", 0.012130712308648),
            ("אדיר", 0.002400723041292),
            ("אדם", 0.000225950403886),
            ("אדם", 0.000607241710445),
            ("אדם", 0.005846466700559),
            ("אדם", 0.007569338530193),
            ("אדר", 0.00107326441846),
            ("אהרון", 0.006453708411004),
            ("אוהד", 0.001454555725018),
            ("אופיר", 0.003756425464611),
            ("אופק", 0.003007964751737),
            ("אור", 0.005959441902502),
            ("אוראל", 0.003064452352709),
            ("אורון", 0.000466022708016),
            ("אורי", 0.018640908320624),
            ("אוריאל", 0.003417499858781),
            ("אוריה", 0.002598429644693),
            ("אורין", 0.000522510308987),
            ("אורן", 0.001143873919675),
            ("אושר", 0.00238660114105),
            ("אושרי", 0.001440433824775),
            ("אחיה", 0.001256849121618),
            ("אחמד", 0.011918883805005),
            ("איאן", 0.000381291306558),
            ("איהאם", 0.001553409026719),
            ("אייל", 0.003671694063153),
            ("אילון", 0.001059142518217),
            ("איליי", 0.001708749929391),
            ("אילן", 0.000607241710445),
            ("אימרי", 0.002513698243236),
            ("איתי", 0.016324916680789),
            ("איתיאל", 0.00043777890753),
            ("איתמר", 0.012413150313506),
            ("איתן", 0.017610009602892),
            ("אלדר", 0.00043777890753),
            ("אלון", 0.008247189741852),
            ("אלחנן", 0.002880867649551),
            ("אליאב", 0.003149183754166),
            ("אליאור", 0.00097441111676),
            ("אליאל", 0.00043777890753),
            ("אליאס", 0.000381291306558),
            ("אליה", 0.008614359148167),
            ("אליהו", 0.005973563802745),
            ("אלימלך", 0.000960289216517),
            ("אליעזר", 0.002541942043721),
            ("אלירז", 0.000367169406315),
            ("אלירן", 0.00063548551093),
            ("אלישע", 0.000833192114331),
            ("אלכס", 0.000649607411173),
            ("אלכסנדר", 0.000395413206801),
            ("אלמוג", 0.001779359430605),
            ("אלעד", 0.001835847031577),
            ("אלעזר", 0.002414844941535),
            ("אלקנה", 0.000564876009716),
            ("אלרואי", 0.003756425464611),
            ("אלרועי", 0.000564876009716),
            ("אמיר", 0.000183584703158),
            ("אמיר", 0.000395413206801),
            ("אמיר", 0.000946167316274),
            ("אמיר", 0.004956786985257),
            ("אמיתי", 0.002739648647122),
            ("אמרי", 0.001256849121618),
            ("אניל", 0.000240072304129),
            ("אסף", 0.003276280856352),
            ("אפק", 0.000508388408744),
            ("אפרים", 0.001341580523075),
            ("אראל", 0.000621363610687),
            ("ארבל", 0.001398068124047),
            ("ארד", 0.000790826413602),
            ("ארז", 0.000367169406315),
            ("ארז", 0.001299214822347),
            ("ארי", 0.002330113540078),
            ("אריאל", 0.01769474100435),
            ("אריה", 0.002061797435463),
            ("אשר", 0.00160989662769),
            ("בארי", 0.003050330452466),
            ("בועז", 0.001228605321132),
            ("בן", 0.006637293114161),
            ("בניה", 0.003488109359995),
            ("בניהו", 0.000466022708016),
            ("בנימין", 0.005931198102017),
            ("בצלאל", 0.000381291306558),
            ("בר", 0.001793481330848),
            ("ברוך", 0.001496921425747),
            ("ברק", 0.00063548551093),
            ("גבע", 0.000960289216517),
            ("גבריאל", 0.002118285036435),
            ("ג'וד", 0.000593119810202),
            ("ג'וד", 0.001087386318703),
            ("גוד", 0.002767892447608),
            ("ג'וד", 0.007004462520477),
            ("ג'וזף", 0.000324803705587),
            ("ג'וליאן", 0.000183584703158),
            ("גור", 0.000691973111902),
            ("ג'ורג'", 0.000395413206801),
            ("גיא", 0.008120092639666),
            ("גיל", 0.000790826413602),
            ("גילי", 0.000423657007287),
            ("גל", 0.001680506128905),
            ("גלעד", 0.001835847031577),
            ("גפן", 0.000748460712874),
            ("דב", 0.00107326441846),
            ("דביר", 0.00302208665198),
            ("דוד", 0.019770660340055),
            ("דולב", 0.000790826413602),
            ("דור", 0.003346890357567),
            ("דורון", 0.000578997909959),
            ("דילן", 0.000395413206801),
            ("דין", 0.000621363610687),
            ("דן", 0.000155340902672),
            ("דן", 0.002499576342993),
            ("דניאל", 0.000296559905101),
            ("דניאל", 0.01574591877083),
            ("דרור", 0.00151104332599),
            ("הדר", 0.001482799525504),
            ("הילל", 0.001595774727447),
            ("הלל", 0.005521662994973),
            ("הראל", 0.009729989267356),
            ("ורד", 0.000225950403886),
            ("זאב", 0.000932045416031),
            ("זוהר", 0.001285092922104),
            ("זיו", 0.00214652883692),
            ("זיין", 0.001270971021861),
            ("ח'אלד", 0.00321979325538),
            ("חגי", 0.000550754109473),
            ("חוסין", 0.00141219002429),
            ("חיים", 0.008713212449867),
            ("חמזה", 0.001624018527933),
            ("חנוך", 0.000494266508501),
            ("חסן", 0.002160650737163),
            ("טוביה", 0.000550754109473),
            ("טוהר", 0.000706095012145),
            ("טום", 0.001214483420889),
            ("טומי", 0.000593119810202),
            ("טל", 0.001779359430605),
            ("יאיר", 0.010831497486302),
            ("יאמן", 0.001680506128905),
            ("יאן", 0.000480144608258),
            ("יאסין", 0.001440433824775),
            ("יגל", 0.002344235440321),
            ("ידידיה", 0.002118285036435),
            ("יהב", 0.003078574252951),
            ("יהודה", 0.011226910693103),
            ("יהונתן", 0.015915381573745),
            ("יהושע", 0.002527820143479),
            ("יהל", 0.001299214822347),
            ("יהלי", 0.003233915155623),
            ("יואב", 0.005620516296673),
            ("יואל", 0.001680506128905),
            ("יובל", 0.005027396486471),
            ("יוגב", 0.00043777890753),
            ("יוחאי", 0.000578997909959),
            ("יוחנן", 0.00043777890753),
            ("יונתן", 0.011198666892617),
            ("יוסף", 0.000169462802915),
            ("יוסף", 0.000240072304129),
            ("יוסף", 0.008995650454725),
            ("יוסף", 0.016861548890019),
            ("יותם", 0.002527820143479),
            ("יזן", 0.001934700333277),
            ("יחזקאל", 0.00117211772016),
            ("יחיא", 0.001849968931819),
            ("יחיאל", 0.00151104332599),
            ("ינאי", 0.004942665085014),
            ("ינון", 0.002965599051008),
            ("יניב", 0.000409535107044),
            ("יעקב", 0.009532282663955),
            ("יפתח", 0.000932045416031),
            ("יצחק", 0.009292210359826),
            ("יקיר", 0.000494266508501),
            ("ירדן", 0.001807603231091),
            ("ירין", 0.002697282946393),
            ("ישי", 0.005549906795458),
            ("ישכר", 0.000381291306558),
            ("ישעיה", 0.000409535107044),
            ("ישראל", 0.009913573970513),
            ("יששכר", 0.000395413206801),
            ("כפיר", 0.001835847031577),
            ("כרים", 0.00248545444275),
            ("כריסטיאן", 0.000169462802915),
            ("כרם", 0.002259504038863),
            ("כרמל", 0.000649607411173),
            ("לאון", 0.000494266508501),
            ("לביא", 0.008600237247924),
            ("לוי", 0.001694628029148),
            ("ליאב", 0.001991187934248),
            ("ליאו", 0.00151104332599),
            ("ליאור", 0.004264813873355),
            ("ליאל", 0.001355702423318),
            ("ליאם", 0.000183584703158),
            ("ליאם", 0.005634638196916),
            ("לידור", 0.000946167316274),
            ("ליית", 0.000211828503643),
            ("ליעד", 0.001751115630119),
            ("ליעם", 0.000522510308987),
            ("לירוי", 0.00312093995368),
            ("לירון", 0.000593119810202),
            ("לירן", 0.000578997909959),
            ("לני", 0.000649607411173),
            ("מאור", 0.004744958481613),
            ("מאיר", 0.00570524769813),
            ("מג'ד", 0.000268316104615),
            ("מג'ד", 0.002033553634977),
            ("מוחמד", 0.038552787663108),
            ("מוסא", 0.001383946223804),
            ("מוסטפא", 0.002287747839349),
            ("מחמוד", 0.004688470880642),
            ("מיכאל", 0.009376941761283),
            ("מילאן", 0.000169462802915),
            ("מלאכי", 0.002287747839349),
            ("מנחם", 0.005210981189629),
            ("מעיין", 0.002880867649551),
            ("מרדכי", 0.00550754109473),
            ("מרום", 0.000494266508501),
            ("משה", 0.014305484946054),
            ("מתן", 0.004024741569226),
            ("מתנאל", 0.000649607411173),
            ("מתניה", 0.000451900807773),
            ("נאור", 0.001242727221375),
            ("נבו", 0.003036208552223),
            ("נדב", 0.006128904705417),
            ("נהוראי", 0.00667965881489),
            ("נוה", 0.003135061853923),
            ("נועם", 0.019968366943456),
            ("נח", 0.000466022708016),
            ("נחמן", 0.002753770547365),
            ("נטע", 0.001002654917246),
            ("ניב", 0.00087555781506),
            ("ניל", 0.000282438004858),
            ("ניסים", 0.000423657007287),
            ("ניצן", 0.00043777890753),
            ("ניר", 0.000946167316274),
            ("ניתאי", 0.005747613398859),
            ("נפתלי", 0.001878212732305),
            ("נריה", 0.002796136248094),
            ("נתן", 0.004589617578941),
            ("נתנאל", 0.006425464610518),
            ("סאלח", 0.001186239620403),
            ("סארי", 0.000169462802915),
            ("סהר", 0.001934700333277),
            ("סולימאן", 0.000282438004858),
            ("סולימאן", 0.001779359430605),
            ("סיני", 0.000508388408744),
            ("סמיר", 0.000155340902672),
            ("סער", 0.000621363610687),
            ("סתיו", 0.000466022708016),
            ("עבד", 0.006623171213919),
            ("עבדאללה", 0.002005309834491),
            ("עברי", 0.001369824323561),
            ("עדי", 0.001426311924533),
            ("עדיאל", 0.000917923515788),
            ("עדן", 0.000691973111902),
            ("עובדיה", 0.001496921425747),
            ("עוז", 0.002753770547365),
            ("עומר", 0.007922386036265),
            ("עומר", 0.009984183471728),
            ("עומרי", 0.000240072304129),
            ("עומרי", 0.004857933683556),
            ("עופר", 0.000663729311416),
            ("עופרי", 0.00097441111676),
            ("עידו", 0.01228605321132),
            ("עידן", 0.004151838671412),
            ("עילאי", 0.007781167033836),
            ("עילי", 0.001468677625261),
            ("עלי", 0.006001807603231),
            ("עמיחי", 0.001143873919675),
            ("עמית", 0.00809184883918),
            ("עמנואל", 0.00097441111676),
            ("ענבר", 0.000409535107044),
            ("עקיבא", 0.001101508218946),
            ("ערן", 0.000381291306558),
            ("עתי", 0.001482799525504),
            ("פאר", 0.000649607411173),
            ("פלג", 0.00160989662769),
            ("פנחס", 0.001722871829633),
            ("צבי", 0.002598429644693),
            ("צור", 0.000847314014574),
            ("קדם", 0.000889679715302),
            ("קוסאי", 0.001482799525504),
            ("קורן", 0.000903801615545),
            ("ראובן", 0.001242727221375),
            ("ראם", 0.000225950403886),
            ("ראם", 0.00151104332599),
            ("רביד", 0.000395413206801),
            ("רואי", 0.00117211772016),
            ("רוי", 0.002203016437892),
            ("רום", 0.002654917245665),
            ("רון", 0.002626673445179),
            ("רוני", 0.000494266508501),
            ("רועי", 0.005055640286957),
            ("רותם", 0.001991187934248),
            ("רז", 0.001440433824775),
            ("ריאן", 0.000296559905101),
            ("ריאן", 0.001525165226233),
            ("ריף", 0.000578997909959),
            ("רם", 0.000183584703158),
            ("רן", 0.000621363610687),
            ("רני", 0.001157995819918),
            ("רעי", 0.000381291306558),
            ("רפאל", 0.007710557532622),
            ("שאול", 0.000804948313845),
            ("שגב", 0.000508388408744),
            ("שגיא", 0.001285092922104),
            ("שוהם", 0.000946167316274),
            ("שון", 0.001525165226233),
            ("שחר", 0.003855278766311),
            ("שי", 0.002541942043721),
            ("שילה", 0.002824380048579),
            ("שיר", 0.000480144608258),
            ("שלו", 0.001468677625261),
            ("שלום", 0.002880867649551),
            ("שליו", 0.001751115630119),
            ("שלמה", 0.007526972829464),
            ("שמואל", 0.010294865277072),
            ("שמחה", 0.001299214822347),
            ("שמעון", 0.007767045133593),
            ("שניאור", 0.001383946223804),
            ("שקד", 0.001736993729876),
            ("שרבל", 0.000508388408744),
            ("תבור", 0.000409535107044),
            ("תום", 0.001962944133763),
            ("תומר", 0.002669039145907),
            ("תיים", 0.000211828503643),
            ("תמיר", 0.000720216912388),
        )
    )

    first_names = first_names_male.copy()
    first_names.update(first_names_female)

    # Top 500 most common surenames in Israel
    # http://www.ynet.co.il/articles/0,7340,L-4477619,00.html
    last_names = OrderedDict(
        (
            ("אבו אל היג'א", 0.0004185954),
            ("אבוטבול", 0.0003645757),
            ("אבו טיר", 0.0003470250),
            ("אבו כף", 0.0005751840),
            ("אבו ליל", 0.0005678902),
            ("אבו מוך", 0.0003430362),
            ("אבו סאלח", 0.0004113016),
            ("אבו סנינה", 0.0003522675),
            ("אבו עראר", 0.0005006506),
            ("אבו ראס", 0.0003642338),
            ("אבו ריא", 0.0002835462),
            ("אבו רמילה", 0.0003918135),
            ("אביב", 0.0003988794),
            ("אביטבול", 0.0004328411),
            ("אביטל", 0.0004519873),
            ("אביטן", 0.0005171756),
            ("אבני", 0.0003463412),
            ("אבראהים", 0.0006235054),
            ("אברגל", 0.0003034902),
            ("אברהם", 0.0021808444),
            ("אברהמי", 0.0004725011),
            ("אברמוב", 0.0008053944),
            ("אברמוביץ", 0.0004369438),
            ("אגבאריה", 0.0020710956),
            ("אדלר", 0.0005522770),
            ("אדרי", 0.0013994967),
            ("אהרון", 0.0005232157),
            ("אהרוני", 0.0006942780),
            ("אהרן", 0.0005895437),
            ("אוזן", 0.0004632699),
            ("אוחיון", 0.0016352914),
            ("אוחנה", 0.0012190893),
            ("אופיר", 0.0003285626),
            ("אור", 0.0002745430),
            ("אורן", 0.0006651028),
            ("אזברגה", 0.0004979154),
            ("אזולאי", 0.0019325135),
            ("אחמד", 0.0003112399),
            ("אטיאס", 0.0010128117),
            ("אטרש", 0.0003216107),
            ("איבגי", 0.0003057695),
            ("איוב", 0.0003391614),
            ("אילוז", 0.0004629280),
            ("איסקוב", 0.0003056556),
            ("איפרגן", 0.0003224085),
            ("אלבז", 0.0010615889),
            ("אלון", 0.0009669975),
            ("אלוני", 0.0003267392),
            ("אלוש", 0.0002914099),
            ("אלטורי", 0.0002840021),
            ("אליאס", 0.0005734745),
            ("אליהו", 0.0010782279),
            ("אלימלך", 0.0004399069),
            ("אלמוג", 0.0003135192),
            ("אלמלח", 0.0003681087),
            ("אלנבארי", 0.0002708961),
            ("אלסייד", 0.0003250297),
            ("אלפסי", 0.0005746142),
            ("אלקובי", 0.0004033240),
            ("אלקיים", 0.0004139228),
            ("אלקרינאוי", 0.0003684506),
            ("אמארה", 0.0004154044),
            ("אמיר", 0.0003546607),
            ("אמסלם", 0.0008538297),
            ("אמר", 0.0002875350),
            ("אנגל", 0.0003220666),
            ("אסדי", 0.0003464552),
            ("אסולין", 0.0009318961),
            ("אסעד", 0.0002932333),
            ("אסרף", 0.0006086899),
            ("אפשטיין", 0.0003689064),
            ("ארביב", 0.0004209887),
            ("ארז", 0.0003954604),
            ("ארליך", 0.0002710100),
            ("אשכנזי", 0.0012333350),
            ("אשר", 0.0004242937),
            ("בדארנה", 0.0004214445),
            ("בדיר", 0.0002950568),
            ("בדר", 0.0002760245),
            ("בדראן", 0.0003989933),
            ("בוזגלו", 0.0004477706),
            ("בוחבוט", 0.0003604730),
            ("בוסקילה", 0.0004288523),
            ("ביטון", 0.0030260127),
            ("בכר", 0.0010549789),
            ("בלום", 0.0003422385),
            ("בן דוד", 0.0014205803),
            ("בן הרוש", 0.0003634361),
            ("בן חיים", 0.0004988271),
            ("בן חמו", 0.0009408994),
            ("בן יוסף", 0.0003320956),
            ("בן לולו", 0.0003196733),
            ("בן משה", 0.0004303338),
            ("בן סימון", 0.0004376276),
            ("בן עזרא", 0.0003485066),
            ("בן עמי", 0.0004467449),
            ("בן שבת", 0.0002754547),
            ("בן שושן", 0.0006107413),
            ("בנימין", 0.0006523387),
            ("בסול", 0.0002932333),
            ("בצלאל", 0.0003156845),
            ("בקר", 0.0003121516),
            ("בר", 0.0011435301),
            ("בראון", 0.0003769980),
            ("ברגר", 0.0005738164),
            ("ברדה", 0.0003977397),
            ("ברוך", 0.0008745715),
            ("ברזילי", 0.0003418966),
            ("ברכה", 0.0004992830),
            ("ברמן", 0.0003711857),
            ("ברנס", 0.0002786457),
            ("ברנשטיין", 0.0004130111),
            ("ברק", 0.0006729665),
            ("ברקוביץ", 0.0006409421),
            ("בשארה", 0.0003734650),
            ("בשיר", 0.0002883328),
            ("גאבר", 0.0005383732),
            ("גאנם", 0.0005768935),
            ("גבאי", 0.0016158033),
            ("גבארה", 0.0002936892),
            ("ג'בארין", 0.0016596800),
            ("גבע", 0.0002820647),
            ("גדיר", 0.0004091363),
            ("גואטה", 0.0005055511),
            ("גוטליב", 0.0004181395),
            ("גוטמן", 0.0005919370),
            ("גולאני", 0.0002900423),
            ("גולדברג", 0.0008165630),
            ("גולדמן", 0.0005264068),
            ("גולדנברג", 0.0004056033),
            ("גולדשטיין", 0.0008946294),
            ("גולן", 0.0011855834),
            ("גור", 0.0003531792),
            ("גורדון", 0.0002858255),
            ("גורן", 0.0003817845),
            ("גיל", 0.0002803552),
            ("גל", 0.0006617978),
            ("גליק", 0.0003310699),
            ("גלעד", 0.0002821787),
            ("גמליאל", 0.0003642338),
            ("גנאים", 0.0005610523),
            ("גרבאן", 0.0003214968),
            ("גרוס", 0.0006403723),
            ("גרוסמן", 0.0003800750),
            ("גרין", 0.0003725533),
            ("גרינברג", 0.0009478513),
            ("דאוד", 0.0003074790),
            ("דביר", 0.0004175697),
            ("דבש", 0.0002795574),
            ("דגן", 0.0005030438),
            ("דדון", 0.0007198063),
            ("דהאן", 0.0003006411),
            ("דהן", 0.0022558337),
            ("דהרי", 0.0002755687),
            ("דוד", 0.0016551214),
            ("דוידוב", 0.0007180968),
            ("דויטש", 0.0003989933),
            ("דורון", 0.0003173940),
            ("דיאב", 0.0004985992),
            ("דיין", 0.0010681989),
            ("דמרי", 0.0003776818),
            ("דניאל", 0.0007061304),
            ("דנינו", 0.0004338668),
            ("דקל", 0.0003405290),
            ("דראושה", 0.0005869225),
            ("דרור", 0.0004386533),
            ("דרורי", 0.0003034902),
            ("דרעי", 0.0005292559),
            ("הדר", 0.0003775678),
            ("הופמן", 0.0003833800),
            ("הורביץ", 0.0002907261),
            ("הורוביץ", 0.0003901040),
            ("הייב", 0.0005921649),
            ("הירש", 0.0003818985),
            ("הלוי", 0.0005028159),
            ("הלל", 0.0003923833),
            ("הראל", 0.0007852225),
            ("הרוש", 0.0006835652),
            ("הררי", 0.0004925590),
            ("הרשקוביץ", 0.0006489197),
            ("וולף", 0.0003986514),
            ("ווקנין", 0.0003724394),
            ("וייס", 0.0008692151),
            ("וינברג", 0.0003423525),
            ("וינר", 0.0003119237),
            ("ויס", 0.0003285626),
            ("ויסמן", 0.0002757966),
            ("ויצמן", 0.0005245833),
            ("וקנין", 0.0009326939),
            ("ותד", 0.0003587635),
            ("זגורי", 0.0003629802),
            ("זהבי", 0.0004176837),
            ("זהר", 0.0003346028),
            ("זוהר", 0.0005770075),
            ("זועבי", 0.0012752743),
            ("זידאן", 0.0005832756),
            ("זיו", 0.0005641294),
            ("זילברמן", 0.0004159742),
            ("זינגר", 0.0003651456),
            ("זכריה", 0.0003278788),
            ("זמיר", 0.0003829242),
            ("חאג'", 0.0003408709),
            ("חאג' יחיא", 0.0003617266),
            ("חאג יחיא", 0.0003882806),
            ("חביב", 0.0004484544),
            ("חביבאללה", 0.0004379695),
            ("חג'אזי", 0.0005489720),
            ("חדאד", 0.0005056651),
            ("חדד", 0.0016215016),
            ("חוג'יראת", 0.0005729047),
            ("חוסין", 0.0003514697),
            ("חורי", 0.0005095399),
            ("ח'ורי", 0.0005477183),
            ("חזן", 0.0012562420),
            ("חטיב", 0.0003936369),
            ("ח'טיב", 0.0015462843),
            ("חי", 0.0003430362),
            ("חיון", 0.0006327366),
            ("חיים", 0.0007797522),
            ("חיימוב", 0.0004451494),
            ("ח'לאילה", 0.0004562040),
            ("חלבי", 0.0007260744),
            ("ח'ליל", 0.0003452016),
            ("חלפון", 0.0003063393),
            ("חמדאן", 0.0004278266),
            ("חמו", 0.0004457192),
            ("חמוד", 0.0003670830),
            ("חן", 0.0013292939),
            ("חסון", 0.0007411178),
            ("חסן", 0.0008594141),
            ("טאהא", 0.0008251104),
            ("טוויל", 0.0003101002),
            ("טויטו", 0.0004448075),
            ("טולדנו", 0.0003334631),
            ("טייב", 0.0002708961),
            ("טל", 0.0013330548),
            ("יאסין", 0.0006589487),
            ("יהודה", 0.0006080061),
            ("יונה", 0.0004435538),
            ("יונס", 0.0004857211),
            ("יוסופוב", 0.0004702218),
            ("יוסף", 0.0018478371),
            ("יחזקאל", 0.0006923406),
            ("יחיא", 0.0003449737),
            ("ימין", 0.0002870792),
            ("יעקב", 0.0011190275),
            ("יעקבי", 0.0004216725),
            ("יעקובוב", 0.0005550121),
            ("יעקובוביץ", 0.0002968802),
            ("יעקובי", 0.0003576238),
            ("יפה", 0.0003034902),
            ("יפרח", 0.0008173608),
            ("יפת", 0.0003267392),
            ("יצחק", 0.0011618786),
            ("יצחקי", 0.0007125125),
            ("ירושלמי", 0.0002743150),
            ("ישראל", 0.0007288096),
            ("ישראלי", 0.0007002042),
            ("כהן", 0.0193348220),
            ("כהנא", 0.0003551166),
            ("כחלון", 0.0004289663),
            ("כספי", 0.0003211549),
            ("כץ", 0.0018738212),
            ("כרמי", 0.0003342609),
            ("לב", 0.0007200342),
            ("לביא", 0.0010139513),
            ("להב", 0.0003570540),
            ("לוגסי", 0.0005278883),
            ("לוי", 0.0111999624),
            ("לוין", 0.0013806924),
            ("ליבוביץ", 0.0005249252),
            ("ליברמן", 0.0005201387),
            ("ליפשיץ", 0.0005541004),
            ("לנדאו", 0.0003262833),
            ("לרנר", 0.0003750606),
            ("מאור", 0.0003620685),
            ("מאיר", 0.0009089891),
            ("מדר", 0.0003455435),
            ("מוזס", 0.0003091885),
            ("מויאל", 0.0005749561),
            ("מוסא", 0.0004717033),
            ("מוסקוביץ", 0.0003259414),
            ("מועלם", 0.0005220761),
            ("מור", 0.0011423905),
            ("מוראד", 0.0002749988),
            ("מושקוביץ", 0.0003134052),
            ("מזור", 0.0003338050),
            ("מזרחי", 0.0033303007),
            ("מחאג'נה", 0.0012883803),
            ("מחאמיד", 0.0018262976),
            ("מחמוד", 0.0002998433),
            ("מטר", 0.0003922694),
            ("מיכאלי", 0.0005314213),
            ("מילר", 0.0006881239),
            ("מימון", 0.0009289330),
            ("מכלוף", 0.0003361983),
            ("מלול", 0.0006253289),
            ("מלכה", 0.0019342230),
            ("מלמד", 0.0004647514),
            ("ממן", 0.0009764567),
            ("מנדל", 0.0002873071),
            ("מנחם", 0.0004933568),
            ("מנסור", 0.0008198680),
            ("מנצור", 0.0003814426),
            ("מנשה", 0.0004680564),
            ("מסארוה", 0.0008443706),
            ("מסארווה", 0.0002802412),
            ("מסיקה", 0.0003017807),
            ("מסרי", 0.0005342704),
            ("מרגלית", 0.0002824066),
            ("מרדכי", 0.0004645235),
            ("מרום", 0.0003129493),
            ("מרעי", 0.0005625339),
            ("מרציאנו", 0.0003146588),
            ("מרקוביץ", 0.0004444656),
            ("משה", 0.0012522532),
            ("משולם", 0.0003482787),
            ("משיח", 0.0003645757),
            ("נאור", 0.0003116957),
            ("נאסר", 0.0005325609),
            ("נבון", 0.0002796714),
            ("נגר", 0.0006358137),
            ("נוימן", 0.0003699321),
            ("נחום", 0.0010065436),
            ("נחמיאס", 0.0003637780),
            ("נחמני", 0.0004122133),
            ("ניסן", 0.0002992735),
            ("ניר", 0.0003601311),
            ("נסאר", 0.0006750178),
            ("נסים", 0.0005396268),
            ("נעים", 0.0006975830),
            ("נתן", 0.0003872549),
            ("נתשה", 0.0003447457),
            ("סאלח", 0.0005592289),
            ("סאלם", 0.0002705542),
            ("סבאג", 0.0002772781),
            ("סבג", 0.0008170189),
            ("סבח", 0.0002966523),
            ("סבן", 0.0004323852),
            ("סגל", 0.0012155563),
            ("סואעד", 0.0012098581),
            ("סויסה", 0.0010544091),
            ("סולומון", 0.0006611140),
            ("סופר", 0.0007159315),
            ("סימן טוב", 0.0002800133),
            ("סיני", 0.0002869652),
            ("סלאמה", 0.0008069899),
            ("סלומון", 0.0004725011),
            ("סלימאן", 0.0006335344),
            ("סלמאן", 0.0002842300),
            ("סלע", 0.0006118809),
            ("סעד", 0.0004322713),
            ("סעדה", 0.0003199012),
            ("סעדי", 0.0004304478),
            ("סעיד", 0.0005107935),
            ("ספיר", 0.0004119854),
            ("סרוסי", 0.0003727812),
            ("סרור", 0.0003260554),
            ("סרחאן", 0.0004681704),
            ("סרסור", 0.0002731754),
            ("עאזם", 0.0003548887),
            ("עאמר", 0.0005807683),
            ("עאסלה", 0.0004797949),
            ("עבאס", 0.0005121611),
            ("עבאסי", 0.0003230923),
            ("עבדאללה", 0.0004449214),
            ("עבד אל קאדר", 0.0002770502),
            ("עבוד", 0.0003461133),
            ("עדוי", 0.0003625244),
            ("עואד", 0.0005034997),
            ("עואודה", 0.0003056556),
            ("עובד", 0.0003107840),
            ("עובדיה", 0.0009488770),
            ("עודה", 0.0006648749),
            ("עווד", 0.0002817228),
            ("עוז", 0.0003095304),
            ("עוזרי", 0.0003601311),
            ("עומר", 0.0004549504),
            ("עזאם", 0.0003739209),
            ("עזר", 0.0002926635),
            ("עזרא", 0.0008366210),
            ("עזרן", 0.0003022366),
            ("עטיה", 0.0005034997),
            ("עיסא", 0.0006968992),
            ("עלי", 0.0005897716),
            ("עליאן", 0.0004195071),
            ("עמאש", 0.0007673299),
            ("עמירה", 0.0002892445),
            ("עמית", 0.0002748849),
            ("עמר", 0.0016504488),
            ("עמרם", 0.0003889644),
            ("עתאמנה", 0.0002793295),
            ("פאר", 0.0003968280),
            ("פדידה", 0.0003054276),
            ("פוגל", 0.0002887887),
            ("פולק", 0.0004996249),
            ("פוקס", 0.0005276604),
            ("פורמן", 0.0002810390),
            ("פורת", 0.0004169999),
            ("פז", 0.0004270288),
            ("פחימה", 0.0003316397),
            ("פינטו", 0.0004175697),
            ("פינקלשטיין", 0.0002802412),
            ("פישמן", 0.0003597892),
            ("פישר", 0.0005738164),
            ("פלג", 0.0005474904),
            ("פלד", 0.0006111971),
            ("פלדמן", 0.0009019232),
            ("פנחס", 0.0004459471),
            ("פרי", 0.0004665749),
            ("פריד", 0.0004208747),
            ("פרידמן", 0.0021022082),
            ("פרנקל", 0.0005776913),
            ("פרץ", 0.0032042548),
            ("פרקש", 0.0002779619),
            ("צברי", 0.0004600788),
            ("צדוק", 0.0005442994),
            ("צור", 0.0007644808),
            ("צמח", 0.0003528373),
            ("צרפתי", 0.0006094877),
            ("קאופמן", 0.0004456052),
            ("קאסם", 0.0004601928),
            ("קדוש", 0.0008008358),
            ("קוגן", 0.0005499976),
            ("קורן", 0.0007404340),
            ("קינן", 0.0003089606),
            ("קליין", 0.0013318012),
            ("קמחי", 0.0003147728),
            ("קפלן", 0.0006849328),
            ("קרמר", 0.0003504440),
            ("קרן", 0.0004678285),
            ("ראובן", 0.0005415642),
            ("רביבו", 0.0004157463),
            ("רבינוביץ", 0.0007378128),
            ("רגב", 0.0003989933),
            ("רובין", 0.0008423192),
            ("רובינשטיין", 0.0004026402),
            ("רוזן", 0.0006486918),
            ("רוזנברג", 0.0010279691),
            ("רוזנטל", 0.0004416164),
            ("רוזנפלד", 0.0005364357),
            ("רוט", 0.0005014483),
            ("רוטמן", 0.0003188756),
            ("רוטנברג", 0.0003187616),
            ("רון", 0.0003961442),
            ("רונן", 0.0003698181),
            ("רז", 0.0007521725),
            ("רזניק", 0.0003017807),
            ("רחמים", 0.0006912009),
            ("ריאן", 0.0003526093),
            ("רפאל", 0.0002712380),
            ("שאהין", 0.0004059452),
            ("שאול", 0.0004735268),
            ("שביט", 0.0003130633),
            ("שבתאי", 0.0003979676),
            ("שגב", 0.0004646375),
            ("שגיא", 0.0003531792),
            ("שדה", 0.0004417304),
            ("שוויקי", 0.0005047533),
            ("שוורץ", 0.0007591244),
            ("שולמן", 0.0002952847),
            ("שוקרון", 0.0005164918),
            ("שור", 0.0003898761),
            ("שורץ", 0.0009575384),
            ("שושן", 0.0006843630),
            ("שחאדה", 0.0007848806),
            ("שחר", 0.0009679092),
            ("שטיין", 0.0004781994),
            ("שטיינברג", 0.0003252576),
            ("שטרית", 0.0005996866),
            ("שטרן", 0.0009997056),
            ("שי", 0.0003206990),
            ("שיבלי", 0.0003172800),
            ("שיטרית", 0.0004501638),
            ("שכטר", 0.0005425899),
            ("שלבי", 0.0003711857),
            ("שלו", 0.0005757539),
            ("שלום", 0.0011007931),
            ("שלמה", 0.0004264590),
            ("שם טוב", 0.0004130111),
            ("שמואל", 0.0006326227),
            ("שמואלי", 0.0004719313),
            ("שמיר", 0.0004115295),
            ("שמעון", 0.0003597892),
            ("שמעוני", 0.0005021321),
            ("שמש", 0.0010336674),
            ("שני", 0.0004502778),
            ("שניידר", 0.0004392232),
            ("שפירא", 0.0013031958),
            ("שפר", 0.0003430362),
            ("שקד", 0.0004860630),
            ("שרביט", 0.0003365402),
            ("שרון", 0.0007520585),
            ("שריקי", 0.0003716416),
            ("שרעבי", 0.0010047201),
            ("שרף", 0.0003082768),
            ("ששון", 0.0009562848),
            ("תורג'מן", 0.0004513035),
            ("תורגמן", 0.0005209364),
            ("תמיר", 0.0002928914),
        )
    )

    # Source :https://he.transperfect.com/services/languages.html
    language_names = (
        "אוג'יבווי",
        "אוזבקית",
        "אויגור",
        "אוסטית",
        "אוקראינית",
        "אורדו",
        "אורומו",
        "אורייה",
        "אזרבייג'נית",
        "איבאנאג",
        "איגבו",
        "איטלקית",
        "אילונגו",
        "אילוקנו",
        "אינדונזית",
        "אינוקטיטוט",
        "איסלנדית",
        "אירית",
        "אלבנית",
        "אמהרית",
        "אנגלית",
        "אנגלית-פידג'ין",
        "אסטונית",
        "אסמית",
        "אפריקאנס",
        "אקאן",
        "ארמנית",
        "אשורית",
        "בהדיני",
        "בולגרית",
        "בוסנית",
        "בורמזית",
        "ביסאיה",
        "בלרוסית",
        "במברה",
        "בנגלית",
        "בסקית",
        "ברבנס",
        "בשקירית",
        "ג'קרטנז",
        "גאלית",
        "גוג'ראטית",
        "גוואנשי",
        "גוראני",
        "גליציאנית",
        "גנדה",
        "גרוזינית",
        "גרמנית",
        "דארי",
        "דזונקה",
        "דיבהי",
        "דיולה",
        "דינקה",
        "דנית",
        "דקוטה",
        "האוסה",
        "האקה",
        "הולנדית",
        "הונגרית",
        "היליגיינון",
        "הינדי",
        "הינדית",
        "הינדית פיג'יאנית",
        "המונג",
        "וולוף",
        "וולשית",
        "וייטנאמית",
        "ונדה",
        "זולו",
        "ח'לח'י",
        "חמרית",
        "חסניאית",
        "טג'יקית",
        "טגלוג",
        "טונגאית",
        "טורקית",
        "טורקמנית",
        "טיבטית",
        "טייוואני",
        "טלוגו",
        "טמילית",
        "טסוואנה",
        "טשילובה",
        "יאו",
        "יאווה",
        "יאוית",
        "יוונית",
        "יופיק",
        "יורובה",
        "יידיש",
        "יפנית",
        "כורדית",
        "כשדית",
        "לאו",
        "לאו",
        "לוגוסה",
        "לוגנדה",
        "לוקסמבורגית",
        "לטבית",
        "לטינית",
        "ליטאית",
        "לינגלה",
        "לקוטה",
        "מאאי",
        "מאורית",
        "מאנדינקה",
        "מולדובנית",
        "מונגולית",
        "מיין",
        "מיקסטקו",
        "מירפורי",
        "מלאית",
        "מלגשית",
        "מלטזית",
        "מליאלאם",
        "מנדינגו",
        "מנדרינית",
        "מקדונית",
        "מראטהי",
        "מרשלזית",
        "נבאחו",
        "נוארית",
        "נורבגית",
        "נייאנג'ה",
        "נפאלית",
        "נפוליטנית",
        "סבואנו",
        "סווהילית",
        "סוטו",
        "סומאלית",
        "סונדנזית",
        "סונינקה",
        "סוסו",
        "סוראני",
        "סילהטי",
        "סינדהי",
        "סינהלה",
        "סיסוואטי/סוואזי",
        "סיצ'ואן",
        "סיציליאנית",
        "סלובנית",
        "סלובקית",
        "סמואית",
        "סנגו",
        "סנסקריט",
        "ספרדית",
        "סרבית",
        "עברית",
        "ערבית",
        "פאהארי",
        "פאנטה",
        "פארואזית",
        "פוג'ואו",
        "פוזהו",
        "פוטווארי",
        "פוטיאן",
        "פולאני",
        "פולאר",
        "פולה",
        "פולנית",
        "פורטוגזית",
        "פטואה",
        "פינית",
        "פלמית",
        "פמפנגה",
        "פנג'אבי",
        "פריזית",
        "פרסית",
        "פשטו",
        "צ'אוזו",
        "צ'בקאנו",
        "צ'וקסית",
        "צ'ין",
        "צ'כית",
        "צ'מורואית",
        "צונגה",
        "ציילונית",
        "צרפתית",
        "צרפתית קנדית",
        "קאנדה",
        "קארן",
        "קווה",
        "קוטוקולי",
        "קוסה",
        "קוסובן",
        "קוריאנית",
        "קורמנג'י",
        "קזחית",
        "קטלנית",
        "קינירואנדה",
        "קיקויו",
        "קירגיזית",
        "קירונדי",
        "קירונדי",
        "קמבודית",
        "קנג'ובל",
        "קנטונזית",
        "קצ'ואה",
        "קרואטית",
        "קרי",
        "קריאולית האיטית",
        "קריו",
        "קשמירית",
        "רומאני",
        "רומאנש",
        "רומנית",
        "רוסית",
        "שבדית",
        "שונה",
        "שנחאית",
        "שפת הסימנים האמריקאית",
        "תאילנדית",
        "תיגרינית",
    )
