import { type COMMERCIAL, type FEDRAMP_MODERATE } from './constants';
export type Perimeter = typeof FEDRAMP_MODERATE | typeof COMMERCIAL;
export declare const AllowedDomains: readonly [
    "admin",
    "analytics",
    "api",
    "api.media",
    "api-private",
    "as",
    "atl-global",
    "atlaskit",
    "auth",
    "automation",
    "cassi.internal",
    "cc-import-sources.services",
    "confluence",
    "confluence-chats-integr.services",
    "confluence-cloud-bamboo.internal",
    "confluence-questions.services",
    "data-portal.internal",
    "design",
    "developer",
    "extranet",
    "go",
    "id",
    "id-mail-assets",
    "integrations",
    "ja",
    "jira",
    "jsd-widget",
    "jsd-widget-staging",
    "marketplace",
    "my",
    "my-reminders.services",
    "partners",
    "permalink",
    "permalink.stg",
    "schema",
    "start",
    "support",
    "surveys",
    "team",
    "wac-cdn",
    "xxid",
    "home"
];
export type DomainKey = (typeof AllowedDomains)[number];
export type DomainConfig = {
    [key in DomainKey]: string;
};
