"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useLazyRef;
var _react = require("react");
var uniqueReferencedValue = {};

/**
 * Executes the initializer function once and saves its result into a ref.
 *
 * ```js
 * const ref = useLazyRef(() => 10);
 * ```
 *
 * @param initializer
 */
function useLazyRef(initializer) {
  var ref = (0, _react.useRef)(uniqueReferencedValue);
  if (ref.current === uniqueReferencedValue) {
    ref.current = initializer();
  }
  return ref;
}