"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _getDistanceThresholds = _interopRequireDefault(require("./get-distance-thresholds"));
var _getValue = _interopRequireDefault(require("./get-value"));
// Source: https://github.com/atlassian/react-beautiful-dnd
var _default = exports.default = function _default(_ref) {
  var container = _ref.container,
    distanceToEdges = _ref.distanceToEdges,
    dragStartTime = _ref.dragStartTime,
    axis = _ref.axis,
    shouldUseTimeDampening = _ref.shouldUseTimeDampening;
  var thresholds = (0, _getDistanceThresholds.default)(container, axis);
  var isCloserToEnd = distanceToEdges[axis.end] < distanceToEdges[axis.start];
  if (isCloserToEnd) {
    return (0, _getValue.default)({
      distanceToEdge: distanceToEdges[axis.end],
      thresholds: thresholds,
      dragStartTime: dragStartTime,
      shouldUseTimeDampening: shouldUseTimeDampening
    });
  }
  return -1 * (0, _getValue.default)({
    distanceToEdge: distanceToEdges[axis.start],
    thresholds: thresholds,
    dragStartTime: dragStartTime,
    shouldUseTimeDampening: shouldUseTimeDampening
  });
};