import { scroll } from './internal/scroll';
const scrollElement = (element, change) => {
  element.scrollBy(change.x, change.y);
};
const scrollWindow = change => {
  window.scrollBy(change.x, change.y);
};
export const createAutoScroller = () => {
  let dragging = null;
  function tryScroll(fakeScrollCallback) {
    if (dragging == null) {
      return;
    }
    scroll({
      input: dragging.latestInput,
      dragStartTime: dragging.dragStartTime,
      shouldUseTimeDampening: dragging.shouldUseTimeDampening,
      behavior: dragging.behavior,
      scrollElement: fakeScrollCallback !== null && fakeScrollCallback !== void 0 ? fakeScrollCallback : scrollElement,
      scrollWindow: fakeScrollCallback !== null && fakeScrollCallback !== void 0 ? fakeScrollCallback : scrollWindow
    });
  }

  // Every animation frame use the latest user input to scroll
  // We do this loop manually rather than in response to `onDrag`
  // events as `onDrag` can drop to 50-100ms between events when
  // the user is not actively moving their pointer
  function loop() {
    if (!dragging) {
      return;
    }
    dragging.loopFrameId = requestAnimationFrame(() => {
      tryScroll();
      loop();
    });
  }
  const start = ({
    input,
    behavior = 'window-then-container'
  }) => {
    const dragStartTime = Date.now();
    dragging = {
      dragStartTime,
      latestInput: input,
      loopFrameId: null,
      shouldUseTimeDampening: false,
      behavior
    };

    // we only use time dampening when auto scrolling starts on lift.
    const fakeScrollCallback = () => {
      if (dragging) {
        dragging.shouldUseTimeDampening = true;
      }
    };
    tryScroll(fakeScrollCallback);
    loop();
  };
  function updateInput({
    input
  }) {
    if (!dragging) {
      return;
    }
    dragging.latestInput = input;
  }
  const stop = () => {
    // can be called defensively
    if (!dragging) {
      return;
    }
    if (dragging.loopFrameId) {
      cancelAnimationFrame(dragging.loopFrameId);
    }
    dragging = null;
  };
  return {
    start,
    updateInput,
    stop
  };
};
export const autoScroller = createAutoScroller();