// Source: https://github.com/atlassian/react-beautiful-dnd

import { canScrollWindow } from './can-scroll';
import getScroll from './get-scroll';
export default (({
  viewport,
  center,
  dragStartTime,
  shouldUseTimeDampening
}) => {
  const scroll = getScroll({
    dragStartTime,
    container: viewport.container,
    center,
    shouldUseTimeDampening
  });
  return scroll && canScrollWindow(viewport, scroll) ? scroll : null;
});