"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCleanupFn = useCleanupFn;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("react");
var noop = function noop() {};
function createCleanupManager() {
  var cleanupFn = noop;
  var setCleanupFn = function setCleanupFn(newCleanupFn) {
    cleanupFn = newCleanupFn;
  };
  var runCleanupFn = function runCleanupFn() {
    cleanupFn();
    cleanupFn = noop;
  };
  return {
    setCleanupFn: setCleanupFn,
    runCleanupFn: runCleanupFn
  };
}
function useCleanupFn() {
  var _useState = (0, _react.useState)(createCleanupManager),
    _useState2 = (0, _slicedToArray2.default)(_useState, 1),
    cleanupManager = _useState2[0];

  /**
   * Run the cleanup function on unmount.
   */
  (0, _react.useEffect)(function () {
    return cleanupManager.runCleanupFn;
  }, [cleanupManager.runCleanupFn]);
  return cleanupManager;
}