import { useMemo } from 'react';

// eslint-disable-next-line import/no-extraneous-dependencies

/**
 * Private symbol that is intentionally not exported from this file.
 */
const privateKey = Symbol('DroppableData');

/**
 * Data that is attached to drags.
 */

/**
 * Checks if the passed data satisfies `DroppableData` using the private symbol.
 */
export function isDroppableData(data) {
  return data[privateKey] === true;
}

/**
 * Adds the private symbol to the passed data.
 *
 * The symbol allows us to quickly check if an object satisfies `DroppableData`.
 */
export function useDroppableData({
  contextId,
  droppableId,
  getIsDropDisabled
}) {
  return useMemo(() => {
    return {
      [privateKey]: true,
      contextId,
      droppableId,
      getIsDropDisabled
    };
  }, [contextId, droppableId, getIsDropDisabled]);
}