/**
 * The lifecycle methods owned by this provided are used to align internal
 * timings with those of the rbd lifecycle.
 *
 * The events are intentionally distinct to those exposed by rbd to avoid
 * any confusion around whether events are fired internally or externally
 * first.
 */
import React, { type ReactNode } from 'react';
import type { DraggableId, DraggableLocation, DragStart, DragUpdate } from 'react-beautiful-dnd';
import type { CleanupFn } from '../internal-types';
import type { DroppableRegistryEntry } from './droppable-registry';
/**
 * The data associated with each type of lifecycle event.
 */
type DispatchData = {
    onPendingDragStart: {
        start: DragStart;
        droppable: DroppableRegistryEntry;
    };
    onPrePendingDragUpdate: {
        update: DragUpdate;
        targetLocation: DraggableLocation | null;
    };
    onPendingDragUpdate: DispatchData['onPrePendingDragUpdate'] & {
        droppable: DroppableRegistryEntry | null;
    };
    onBeforeDragEnd: {
        draggableId: DraggableId;
    };
};
type LifecycleResponders = {
    [Key in keyof DispatchData]: (args: DispatchData[Key]) => void;
};
type LifecycleEvent = keyof LifecycleResponders;
type AddResponder = <Event extends LifecycleEvent>(event: Event, responder: LifecycleResponders[Event]) => CleanupFn;
type Dispatch = <Event extends LifecycleEvent>(event: Event, data: DispatchData[Event]) => void;
type LifecycleManager = {
    addResponder: AddResponder;
    dispatch: Dispatch;
};
/**
 * Creates a new lifecycle manager, returning methods for interfacing with it.
 */
export declare function useLifecycle(): LifecycleManager;
type MonitorForLifecycle = (args: Partial<LifecycleResponders>) => CleanupFn;
export declare function LifecycleContextProvider({ children, lifecycle, }: {
    children: ReactNode;
    lifecycle: LifecycleManager;
}): React.JSX.Element;
export declare function useMonitorForLifecycle(): MonitorForLifecycle;
export {};
