"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"useTableServerSide",{enumerable:true,get:function(){return useTableServerSide}});const _react=require("react");const _useRowFactoryBuilder=require("../hooks/useRowFactoryBuilder");const _useFillers=require("../hooks/useFillers");const _useColumns=require("../hooks/useColumns");const _getPageIndexWithNewSize=require("../utils/getPageIndexWithNewSize");const _constants=require("../constants");const _genericTypes=require("../../../genericTypes");const _helper=require("../../../helper");const _selectSlice=require("../TableClientSide/state/selectSlice");function _define_property(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _object_spread(target){for(var i=1;i<arguments.length;i++){var source=arguments[i]!=null?arguments[i]:{};var ownKeys=Object.keys(source);if(typeof Object.getOwnPropertySymbols==="function"){ownKeys=ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function(sym){return Object.getOwnPropertyDescriptor(source,sym).enumerable}))}ownKeys.forEach(function(key){_define_property(target,key,source[key])})}return target}function ownKeys(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);if(enumerableOnly){symbols=symbols.filter(function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable})}keys.push.apply(keys,symbols)}return keys}function _object_spread_props(target,source){source=source!=null?source:{};if(Object.getOwnPropertyDescriptors){Object.defineProperties(target,Object.getOwnPropertyDescriptors(source))}else{ownKeys(Object(source)).forEach(function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key))})}return target}function useTableServerSide({data=[],metadata,onTableUpdate,config,onSelect}){var _config_sorting,_config_meta;const[paging,setPaging]=(0,_helper.useMemoizedState)((metadata===null||metadata===void 0?void 0:metadata.paging)||_constants.defaultPagingState);const[sorting,setSorting]=(0,_helper.useMemoizedState)((metadata===null||metadata===void 0?void 0:metadata.sorting)||((_config_sorting=config.sorting)===null||_config_sorting===void 0?void 0:_config_sorting.default)||_constants.defaultSortingState);const selectionState=(0,_selectSlice.useSelect)();(0,_react.useEffect)(()=>{if(!onSelect)return;const selectedData=selectionState.selected.map(id=>data.find(d=>config.rowIdentifierAccessor(d)===id)).filter(x=>x!==undefined);onSelect(selectedData)},[selectionState.selected]);function getSort(id){const isCurrentlySorted=sorting.column===id;const result={column:id,direction:_genericTypes.ESortDirection.ASC};if(isCurrentlySorted){result.direction=sorting.direction===_genericTypes.ESortDirection.ASC?_genericTypes.ESortDirection.DESC:_genericTypes.ESortDirection.ASC}return result}const handleUpdate=(0,_react.useCallback)(args=>{onTableUpdate({paging:args.paging||paging,sorting:args.sorting||sorting})},[paging,sorting]);const rowIds=data.map(row=>row.id);const columns=(0,_useColumns.useColumns)(config,{sorting,sortBy:id=>{setSorting(getSort(id));handleUpdate({sorting:getSort(id)})},selectAll:selectionState.selectAll,selected:selectionState.selected,rowIds:rowIds});const rowFactory=(0,_useRowFactoryBuilder.useRowFactoryBuilder)(config,selectionState,rowIds);const rows=[...data].map(rowFactory);const fillers=(0,_useFillers.useFillers)(config,rows,paging.size);(0,_react.useEffect)(()=>{var _metadata_paging,_metadata_paging1,_metadata_paging2,_metadata_paging3,_metadata_sorting,_metadata_sorting1;if(!metadata)return;setPaging({size:(metadata===null||metadata===void 0?void 0:(_metadata_paging=metadata.paging)===null||_metadata_paging===void 0?void 0:_metadata_paging.size)||_constants.defaultPagingState.size,index:(metadata===null||metadata===void 0?void 0:(_metadata_paging1=metadata.paging)===null||_metadata_paging1===void 0?void 0:_metadata_paging1.index)||_constants.defaultPagingState.index,totalDisplayableResults:(metadata===null||metadata===void 0?void 0:(_metadata_paging2=metadata.paging)===null||_metadata_paging2===void 0?void 0:_metadata_paging2.totalDisplayableResults)||_constants.defaultPagingState.totalDisplayableResults,totalResults:metadata===null||metadata===void 0?void 0:(_metadata_paging3=metadata.paging)===null||_metadata_paging3===void 0?void 0:_metadata_paging3.totalResults});setSorting({column:(metadata===null||metadata===void 0?void 0:(_metadata_sorting=metadata.sorting)===null||_metadata_sorting===void 0?void 0:_metadata_sorting.column)||_constants.defaultSortingState.column,direction:(metadata===null||metadata===void 0?void 0:(_metadata_sorting1=metadata.sorting)===null||_metadata_sorting1===void 0?void 0:_metadata_sorting1.direction)||_constants.defaultSortingState.direction})},[metadata]);(0,_react.useEffect)(()=>{selectionState.clearSelected()},[paging.totalDisplayableResults,paging.totalResults]);return{head:{columns},body:{rows,fillers,meta:{noDataTextContent:(_config_meta=config.meta)===null||_config_meta===void 0?void 0:_config_meta.noDataTextContent}},paging:{size:paging.size,totalDisplayableResults:paging.totalDisplayableResults,index:paging.index,totalResults:paging.totalResults,actions:{gotoPageIndex:index=>{setPaging(_object_spread_props(_object_spread({},paging),{index}));handleUpdate({paging:_object_spread_props(_object_spread({},paging),{index})})},setPageSize:size=>{const newPaging=_object_spread_props(_object_spread({},paging),{size,index:(0,_getPageIndexWithNewSize.getPageIndexWithNewSize)({newSize:size,oldIndex:paging.index,oldSize:paging.size})});setPaging(newPaging);handleUpdate({paging:newPaging})}}},selection:selectionState}}
//# sourceMappingURL=useTableServerSide.js.map