'use client';
import { useState } from 'react';
import { useIsomorphicEffect } from '../use-isomorphic-effect/use-isomorphic-effect.mjs';

function useOrientation() {
  const [orientation, setOrientation] = useState({ angle: 0, type: "landscape-primary" });
  const handleOrientationChange = (event) => {
    const target = event.currentTarget;
    setOrientation({ angle: target?.angle || 0, type: target?.type || "landscape-primary" });
  };
  useIsomorphicEffect(() => {
    window.screen.orientation?.addEventListener("change", handleOrientationChange);
    return () => window.screen.orientation?.removeEventListener("change", handleOrientationChange);
  }, []);
  return orientation;
}

export { useOrientation };
//# sourceMappingURL=use-orientation.mjs.map
