import { workerData, parentPort } from 'node:worker_threads';
import debugWrap from 'debug';
import { P as PLUGIN_NAME, a as getFilter, i as initializeESLint, l as lintFiles, s as shouldIgnoreModule, b as getFilePath } from './shared/vite-plugin-eslint2.B7EWfSXj.mjs';
import '@rollup/pluginutils';

const debug = debugWrap(`${PLUGIN_NAME}:worker`);
const options = workerData.options;
const filter = getFilter(options);
let eslintInstance;
let formatter;
let outputFixes;
const initPromise = initializeESLint(options).then((result) => {
  eslintInstance = result.eslintInstance;
  formatter = result.formatter;
  outputFixes = result.outputFixes;
  return result;
});
(async () => {
  debug("==== worker start ====");
  debug("Initialize ESLint");
  const { eslintInstance: eslintInstance2, formatter: formatter2, outputFixes: outputFixes2 } = await initPromise;
  if (options.lintOnStart) {
    debug("Lint on start");
    lintFiles({
      files: options.include,
      eslintInstance: eslintInstance2,
      formatter: formatter2,
      outputFixes: outputFixes2,
      options
    });
  }
})();
parentPort?.on("message", async (id) => {
  if (!eslintInstance) await initPromise;
  debug("==== worker message event ====");
  debug(`id: ${id}`);
  const shouldIgnore = await shouldIgnoreModule(id, filter, eslintInstance);
  debug(`should ignore: ${shouldIgnore}`);
  if (shouldIgnore) return;
  const filePath = getFilePath(id);
  debug(`filePath: ${filePath}`);
  lintFiles({
    files: options.lintDirtyOnly ? filePath : options.include,
    eslintInstance,
    formatter,
    outputFixes,
    options
  });
});
