/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.zip.CRC32;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class Hash
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _value = new QName("", "value");
    private static final QName _algorithm = new QName("", "algorithm");
    private static final QName _version = new QName("", "version");
    private static final QName _match = new QName("", "match");
    private static final QName _crc = new QName("", "crc");
    private static final QName _md = new QName("", "md");
    private static final QName _sha = new QName("", "sha");
    private static final QName _hmac = new QName("cx", "http://xmlcalabash.com/ns/extensions", "hmac");
    private static final QName _accessKey = new QName("cx", "http://xmlcalabash.com/ns/extensions", "accessKey");
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private Hashtable<QName, String> params = new Hashtable();
    protected static final String logger = "org.xproc.library.hash";
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private String hash = null;

    public Hash(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void setParameter(QName qName, RuntimeValue runtimeValue) {
        this.params.put(qName, runtimeValue.getString());
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String string = this.getOption(_value).getString();
        QName qName = this.getOption(_algorithm).getQName();
        String string2 = null;
        if (this.getOption(_version) != null) {
            string2 = this.getOption(_version).getString();
        }
        if (_crc.equals((Object)qName)) {
            this.hash = this.crc(string, string2);
        } else if (_md.equals((Object)qName)) {
            this.hash = this.md(string, string2);
        } else if (_sha.equals((Object)qName)) {
            this.hash = this.sha(string, string2);
        } else if (_hmac.equals((Object)qName)) {
            this.hash = Hash.hmac(string, this.params.get(_accessKey));
        } else {
            throw XProcException.dynamicError(36);
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), this.getOption(_match));
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6);
        }
        this.result.write(this.matcher.getResult());
    }

    private String crc(String string, String string2) {
        if (string2 == null) {
            string2 = "32";
        }
        if (!"32".equals(string2)) {
            throw XProcException.dynamicError(36);
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        return Long.toHexString(cRC32.getValue());
    }

    private String md(String string, String string2) {
        MessageDigest messageDigest = null;
        if (string2 == null) {
            string2 = "5";
        }
        try {
            messageDigest = MessageDigest.getInstance("MD" + string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw XProcException.dynamicError(36);
        }
        byte[] byArray = messageDigest.digest(string.getBytes());
        String string3 = "";
        for (byte by : byArray) {
            String string4 = Integer.toHexString(by & 0xFF);
            if (string4.length() < 2) {
                string4 = "0" + string4;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    private String sha(String string, String string2) {
        MessageDigest messageDigest = null;
        if (string2 == null) {
            string2 = "1";
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-" + string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw XProcException.dynamicError(36);
        }
        byte[] byArray = messageDigest.digest(string.getBytes());
        String string3 = "";
        for (byte by : byArray) {
            String string4 = Integer.toHexString(by & 0xFF);
            if (string4.length() < 2) {
                string4 = "0" + string4;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    private static String hmac(String string, String string2) {
        String string3 = "";
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(string2.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(secretKeySpec);
            byte[] byArray = mac.doFinal(string.getBytes());
            string3 = Base64.encodeBytes(byArray);
        }
        catch (Exception exception) {
            throw XProcException.dynamicError(36, "Failed to generate HMAC : " + exception.getMessage());
        }
        return string3;
    }

    @Override
    public boolean processStartDocument(XdmNode xdmNode) throws SaxonApiException {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode xdmNode) throws SaxonApiException {
    }

    @Override
    public boolean processStartElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addText(this.hash);
        return false;
    }

    @Override
    public void processEndElement(XdmNode xdmNode) throws SaxonApiException {
    }

    @Override
    public void processText(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addText(this.hash);
    }

    @Override
    public void processComment(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addComment(this.hash);
    }

    @Override
    public void processPI(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addPI(xdmNode.getNodeName().getLocalName(), this.hash);
    }

    @Override
    public void processAttribute(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addAttribute(xdmNode.getNodeName(), this.hash);
    }
}

