%define ver       2.25.2
%define rel       1
%define prefix    /usr

Summary: VFlib version 2.25.2
Name: VFlib2
Version: %ver
Release: %rel
Copyright: LGPL
Group: Other
Vendor: The TypeHack Project
Packager: Hirotsugu Kakugawa
Url: http://TypeHack.aial.hiroshima-u.ac.jp/VFlib/
Source: ftp://TypeHack.aial.hiroshima-u.ac.jp/pub/TypeHack/VFlib2-%{ver}.tar.gz
BuildRoot: /var/tmp/VFlib2-root
Requires: freetype >= 1.2

%description
VFlib is a font library written in C language with several functions
to obtain bitmaps of fonts.  Unique feature of VFlib is that fonts
in different formats are accessed by unified interface.

%prep
%setup -n VFlib2-%{ver}

%build
rm -rf $RPM_BUILD_ROOT
./configure --prefix=%prefix \
            --with-freetype \
              --with-freetype-includedir=/usr/include \
              --with-freetype-libdir=/usr/lib 

make

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%install
mkdir -p $RPM_BUILD_ROOT/%{prefix}/bin
mkdir -p $RPM_BUILD_ROOT/%{prefix}/lib
mkdir -p $RPM_BUILD_ROOT/%{prefix}/info
mkdir -p $RPM_BUILD_ROOT/%{prefix}/include
mkdir -p $RPM_BUILD_ROOT/%{prefix}/share
make prefix=${RPM_BUILD_ROOT}%prefix install

%files
%defattr(-,root,root,-)
%doc README.* CHANGES COPYING* DISTRIB.txt

%{prefix}/bin/*
%{prefix}/lib/*
%{prefix}/include/*
%{prefix}/share/VFlib/*
#%{prefix}/info/*

