/*
 * odbcauth.cxx
 *
 * ODBC based authenticator modules for GNU Gatekeeper. 
 * H.235 based and alias based authentication schemes are supported.
 * Please see docs/odbcdauth.txt for more details.
 *
 * Copyright (c) 2003 - Farooq S. Khan
 *
 * This work is published under the GNU Public License (GPL)
 * see file COPYING for details.
 * We also explicitely grant the right to link this code
 * with the OpenH323 library.

  10/03/2003 - Farooq.Khan created.
*/

#if (_MSC_VER >= 1200)
#pragma warning( disable : 4786 ) // warning about too long debug symbol off
#pragma warning( disable : 4800 ) // warning about forcing value to bool
#endif

#include <ptlib.h>
#include <h323pdu.h>
#include <h225.h>
#include <h235.h>
#include <h235auth.h>
#include "gkauth.h"
#include "gk_const.h"
#include "h323util.h"
#include "stl_supp.h"
#include "RasTbl.h"
#include "Toolkit.h"

#ifndef ODBCCON_H
#include "odbcsupp.h"
#endif




class ODBCPasswordAuth : public SimplePasswordAuth, private ODBCsupp {
public:
	ODBCPasswordAuth(PConfig * config, const char *);

private:

     bool ODBCPasswordAuth::GetPassword(const PString & id, PString & passwd);
	static PString OID_CAT;

};

class ODBCAliasAuth : public GkAuthenticator, private ODBCsupp {
public:
	ODBCAliasAuth(PConfig *, const char *);
	virtual ~ODBCAliasAuth();

protected:
	virtual int Check(const H225_RegistrationRequest & ,  unsigned &);

private:
	virtual PString GetConfigString(const PString & alias);

};

// OID for CAT (Cisco Access Token) algorithm
PString ODBCPasswordAuth::OID_CAT( "1.2.840.113548.10.1.2.1" );
static GkAuthInit<ODBCAliasAuth> A_A("ODBCAliasAuth");

// class ODBCPasswordAuth
ODBCPasswordAuth::ODBCPasswordAuth(PConfig * config, const char *name)
      : SimplePasswordAuth(config, name), ODBCsupp(config, name)
{
}

bool ODBCPasswordAuth::GetPassword(const PString & id, PString & passwd)
{
	PString abc;
	return ColFetch(id,  passwd);
}

static GkAuthInit<ODBCPasswordAuth> O_A_A("ODBCPasswordAuth");

// class ODBCAliasAuth
ODBCAliasAuth::ODBCAliasAuth(PConfig * config, const char *name)
      : GkAuthenticator(config, name), ODBCsupp(config, name)
{
	PConfig * abcd = config;
//	CallTable  * CallTbl = CallTable::Instance();
}


ODBCAliasAuth::~ODBCAliasAuth()
{
}

PString ODBCAliasAuth::GetConfigString(const PString & alias)
{
	PString result;
      PTRACE(2,"ODBC\t alias :" << alias);
	ColFetch(alias, result);
    PTRACE(2,"ODBC\t result :" << result);
	return result;
}

int ODBCAliasAuth::Check(const H225_RegistrationRequest & request, unsigned & rejectReason)
{ 
        const H225_RegistrationRequest & rrq = request;
        PString H323ID ;
        PString ALIAS ;
        PString Result ;
		int ss;


       for (ss = 0; ss < rrq.m_terminalAlias.GetSize() ; ss++)
	   {
             H323ID = H323GetAliasAddressString(rrq.m_terminalAlias[ss]);
             PTRACE(2,"ODBC\tH323ID :" << H323ID);
	   }

         if ((rrq.m_terminalAlias.GetSize()) > 1)
		{
          
             H323ID = H323GetAliasAddressString(rrq.m_terminalAlias[0]);
              if ((rrq.m_terminalAlias.GetSize()) > 1)
                 ALIAS  = H323GetAliasAddressString(rrq.m_terminalAlias[1]);
	         ColFetch(H323ID, Result);
             PTRACE(2,"ODBC\tH323ID :" << H323ID);
             PTRACE(2,"ODBC\tALIAS :" << ALIAS);
             PTRACE(2,"ODBC\tResult :" << Result);
             if (strcmp(ALIAS,Result) == 0)
		       return (e_ok);
		}

    
    return(e_fail);
}                                               

#ifdef NEVER
namespace { // anonymous namespace
	GkAuthCreator<ODBCPasswordAuth> ODBCPasswordAuthCreator("ODBCPasswordAuth");
	GkAuthCreator<ODBCAliasAuth> ODBCAliasAuthCreator("ODBCAliasAuth");
} // end of anonymous namespace
#endif 




