//////////////////////////////////////////////////////////////////
//
// ODBC Connection and basic queries for GNU Gatekeeper
//
// Copyright (c) Farooq S. Khan 2003
//
// This work is published under the GNU Public License (GPL)
// see file COPYING for details.
// We also explicitely grant the right to link this code
// with the OpenH323 library.
//
// initial author: Farooq S. Khan (fskhan@ezvoip.net)
// initial version: 10/02/2003
//
//////////////////////////////////////////////////////////////////
 
#define HAS_ODBC
#ifdef HAS_ODBC
#ifdef WIN32
#include <ptlib/socket.h>
#pragma comment(lib, "odbc32.lib")
#endif

#ifndef ODBCCON_H
#include "odbcsupp.h"
#endif

bool ODBCConnect(st_ODBCCon  *odbc_connection, SQLCHAR * DSName, SQLCHAR * user, SQLCHAR * password);
void ODBCerror(SQLRETURN rc, SQLSMALLINT htype, SQLHANDLE handle);
void ODBCdisconnect(st_ODBCCon  * odbc_connection);
// Select a ROW, of 32 Columns and 64 chars max.
bool ODBCSelectRow(st_ODBCCon  * odbc_connection, SQLCHAR * SQLStmt, ONECOL *  result);
// Select only one Col
bool ODBCSelectCol(st_ODBCCon  * odbc_connection, SQLCHAR * SQLStmt, const char * H323ID,  SQLCHAR * result);
// Execute a SELECT statement which returns only one column
int dbError( HENV henv,HDBC hdbc,HSTMT hstmt);



#define abcd "select * from t_wb_gateway where GATEWAY_H323_ID = \'fsk\' and GATEWAY_PHONE = \'1510\' ";
bool ODBCsupp::RowFetch(const PString & TableName,ONEROW * result)
{
	ONECOL aRow[MAX_COLUMNS];
    bool  rc;
    char * SQLStmt = abcd;
	
	memset (&aRow,0,sizeof(ONEROW));
    rc = ODBCSelectRow(odbc_connection, (SQLCHAR*)SQLStmt, (ONECOL *)&aRow);
   
	return rc;
}


bool ODBCsupp::ColFetch(const PString & H323ID, PString & ALIAS)
{
	const char * sqlstmt = (const char *)m_clause;
	char local_res[MAX_COL_DATA_LEN+1];
	if (!odbc_connection) 
		return false;

	local_res[0] = 0;
	if (ODBCSelectCol(odbc_connection, (SQLCHAR *) sqlstmt, (const char *) H323ID, (SQLCHAR *) &local_res))
	{
		return false;
	}
	if (strlen(local_res) ==0)
		return false;
	ALIAS.sprintf("%s",local_res);
	return true;
}


ODBCsupp::ODBCsupp(PConfig *cfg, const char *section)
      : odbc_connection(0), m_config(cfg), m_section(section)
{
    odbc_connection = new struct st_ODBCCon  ;
	odbc_connection->henv = new SQLHENV;
	odbc_connection->hdbc = new SQLHDBC;
	odbc_connection->hstmt = new SQLHSTMT;
	*odbc_connection->henv = NULL;
	*odbc_connection->hdbc = NULL;
	*odbc_connection->hstmt = NULL;

	Init();
}


ODBCsupp::~ODBCsupp()
{
	PWaitAndSignal lock(m_mutex);
	if (odbc_connection)
	Cleanup();
}

bool ODBCsupp::Init()
{
	
	const char * cdsn;
	const char * cuser;
	const char * cpass;
	
	PString DSName = m_config->GetString(m_section, "DSName", "myodbc3");
	PString user   = m_config->GetString(m_section, "User", "");
	PString passwd = m_config->GetString(m_section, "Password", "");

    
    cdsn = DSName;
	cuser = user;
	cpass = passwd;

	if (ODBCConnect(odbc_connection, (SQLCHAR*)cdsn, (SQLCHAR*)cuser, (SQLCHAR*)cpass)) 
	{

	   PTRACE(2, "ODBC\tUbable to connect to server " << DSName << ", User " << user);
		Cleanup();
		return false;
	}
	
	PTRACE(2, "ODBC\tConnected to server " << DSName << ", User " << user);
	
	m_clause.sprintf(
		"select GATEWAY_PHONE from T_WB_GATEWAY where GATEWAY_H323_ID = ? ");

	PTRACE(4, "ODBC\tReady for query '" << m_clause << '\'');
	return true;
}


void ODBCsupp::Cleanup()
{
    ODBCdisconnect(odbc_connection);
	delete odbc_connection->henv ;
	delete odbc_connection->hdbc ;
	delete odbc_connection->hstmt ;
    delete odbc_connection;
	odbc_connection = (st_ODBCCon  *) 0;
}

			
// Local functions.
bool ODBCConnect(st_ODBCCon  * odbc_connection, SQLCHAR * DSName, SQLCHAR *  user, SQLCHAR *  password)
{
    SQLRETURN rc =0;
	SQLRETURN  frc =0 ;
    SQLHSTMT    hstmt = 0;

  
    rc = SQLAllocHandle(SQL_HANDLE_ENV,SQL_NULL_HANDLE,odbc_connection->henv);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }
  
    rc = SQLSetEnvAttr(*(odbc_connection->henv),SQL_ATTR_ODBC_VERSION,(SQLPOINTER)SQL_OV_ODBC3,0);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    rc = SQLAllocHandle(SQL_HANDLE_DBC,*(odbc_connection->henv), odbc_connection->hdbc);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    rc = SQLConnect(*(odbc_connection->hdbc), DSName, SQL_NTS, user, SQL_NTS,  password, SQL_NTS);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
		return true;
	   }

    rc = SQLSetConnectAttr(*(odbc_connection->hdbc),SQL_ATTR_AUTOCOMMIT,(SQLPOINTER)SQL_AUTOCOMMIT_ON,0);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    rc = SQLAllocHandle(SQL_HANDLE_STMT,*(odbc_connection->hdbc),odbc_connection->hstmt);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }
     if (frc == SQL_SUCCESS || frc == SQL_SUCCESS_WITH_INFO)
	  return false;
	return true;
}

void ODBCerror(SQLRETURN rc, SQLSMALLINT htype, SQLHANDLE handle)
{
  SQLRETURN lrc;

  if( rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO ) 
  {
    SQLCHAR     szSqlState[6],szErrorMsg[SQL_MAX_MESSAGE_LENGTH];
    SQLINTEGER  pfNativeError;
    SQLSMALLINT pcbErrorMsg;
    
    lrc = SQLGetDiagRec(htype, handle,1,    
                        (SQLCHAR *)&szSqlState,
                        (SQLINTEGER *)&pfNativeError,
                        (SQLCHAR *)&szErrorMsg,
                         SQL_MAX_MESSAGE_LENGTH-1,
                        (SQLSMALLINT *)&pcbErrorMsg);

    if(lrc == SQL_SUCCESS || lrc == SQL_SUCCESS_WITH_INFO)
	{
	      PTRACE(2, "ODBC\tODBC Error: " << szSqlState <<" " << pfNativeError << " " << szErrorMsg) ;
	}
  }
}

void ODBCdisconnect(st_ODBCCon  * odbc_connection)
{
    SQLRETURN   rc;
    SQLRETURN   frc = 0;
    SQLHSTMT    hstmt = 0;

    if (*(odbc_connection->hstmt))
      rc = SQLFreeStmt(*(odbc_connection->hstmt), SQL_DROP);
      
	if (*(odbc_connection->hdbc))
      rc = SQLDisconnect(*(odbc_connection->hdbc));
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

	if (*(odbc_connection->hdbc))
      rc = SQLFreeConnect(*(odbc_connection->hdbc));

	if (*(odbc_connection->henv))
        rc = SQLFreeEnv(*(odbc_connection->henv));
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }
}

// This function will select a single column result of a SQL statement into result
// max size of result is 70 characters size is define in odbccon.h as MAX_COL_DATA_LEN
bool ODBCSelectCol(st_ODBCCon  * odbc_connection, SQLCHAR * SQLStmt, const char * H323ID, SQLCHAR * result)
{
    SQLRETURN   rc;
    SQLRETURN   frc = 0;
    SQLHSTMT    hstmt;

    rc = SQLAllocHandle(SQL_HANDLE_STMT,*(odbc_connection->hdbc),&hstmt);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }
	if (rc) return false;

    /* prepare the insert statement with parameters */
    rc = SQLPrepare(hstmt,SQLStmt,SQL_NTS);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    rc = SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, 
                          SQL_C_CHAR, SQL_CHAR, 0,0,
                          (void *)H323ID, MAX_COL_DATA_LEN, NULL);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }


    rc = SQLExecute(hstmt);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }


    rc = SQLBindCol(hstmt,1, SQL_C_CHAR, result,
                      MAX_COL_DATA_LEN,NULL);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    rc = SQLFetch(hstmt);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    /* Free statement param resorces */
    rc = SQLFreeStmt(hstmt, SQL_RESET_PARAMS);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }
    
    /* Free statement cursor resorces */
    rc = SQLFreeStmt(hstmt, SQL_CLOSE);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    /* commit the transaction */
    rc = SQLEndTran(SQL_HANDLE_DBC, *odbc_connection->hdbc, SQL_COMMIT); 
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    rc = SQLFreeStmt(hstmt, SQL_DROP);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

     if (frc == SQL_SUCCESS || frc == SQL_SUCCESS_WITH_INFO)
	  return false;
	return true;
}

/* This function will execute a SQL statement of type
     
	    SELECT * FROM aTable WHERE aCOLUMN = 'ColVal' and bCOLUMN = 'ColVal';

   Result must be one row. It will fetch the first row.
   Error handling can be improved further here.
*/
bool ODBCSelectRow(st_ODBCCon  * odbc_connection, SQLCHAR * SQLStmt, ONECOL *  result)
{
    SQLRETURN   rc;
    SQLRETURN   frc = 0;
	SQLCHAR     szColName[MAX_NAME_LEN];
    SQLUINTEGER nRowCount=0, pcColDef;
    SQLSMALLINT nIndex,ncol,pfSqlType, pcbScale, pfNullable;
    SQLHSTMT    hstmt;
	ONECOL * aCol = result;


    rc = SQLAllocHandle(SQL_HANDLE_STMT,*(odbc_connection->hdbc),&hstmt);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    rc = SQLExecDirect(hstmt,SQLStmt,SQL_NTS);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    /* get total number of columns from the resultset */
    rc = SQLNumResultCols(hstmt,&ncol);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    for(nIndex = 1; nIndex <= ncol; nIndex++)
    {
	  // This function is to help do PTRACE below for debugging
      rc = SQLDescribeCol(hstmt,nIndex,szColName, MAX_NAME_LEN, NULL,
                          &pfSqlType,&pcColDef,&pcbScale,&pfNullable);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }
//  
      PTRACE(4, "ODBC\tODBC Col Name: " << szColName ) ;
      rc = SQLBindCol(hstmt,nIndex, SQL_C_CHAR, (SQLCHAR *) aCol,
                      MAX_COL_DATA_LEN+1,NULL);
      aCol++;
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }
    }
	
    // Fetch a single row
    rc = SQLFetch(hstmt);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    /* Free statement param resorces */
    rc = SQLFreeStmt(hstmt, SQL_RESET_PARAMS);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }
    
    /* Free statement cursor resorces */
    rc = SQLFreeStmt(hstmt, SQL_CLOSE);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    rc = SQLFreeStmt(hstmt, SQL_DROP);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    /* commit the transaction */
    rc = SQLEndTran(SQL_HANDLE_DBC, *odbc_connection->hdbc, SQL_COMMIT); 
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    if (frc == SQL_SUCCESS || frc == SQL_SUCCESS_WITH_INFO)
	  return true;
	return false;
}


bool ODBCsupp::ExecThisQuery(SQLCHAR * theSQL)
{
	SQLRETURN   rc;
	SQLRETURN   frc = 0;
    SQLHSTMT    hstmt =0;

    rc = SQLAllocHandle(SQL_HANDLE_STMT,*(odbc_connection->hdbc),&hstmt);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }
	if (rc) return true;

 
    try
    {
       rc = SQLExecDirect(hstmt, theSQL, SQL_NTS);
        if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
        {
               if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
	           if (rc) frc = rc;
        }
    /* Free statement param resorces */
        rc = SQLFreeStmt(hstmt, SQL_RESET_PARAMS);
        if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
        {
               if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
	           if (rc) frc = rc;
        }
    
       /* Free statement cursor resorces */
        rc = SQLFreeStmt(hstmt, SQL_CLOSE);
        if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
        {
               if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
	           if (rc) frc = rc;
        }
		rc = SQLEndTran(SQL_HANDLE_DBC, *(odbc_connection->hdbc), SQL_COMMIT); 
        if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
        {
               if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
	           if (rc) frc = rc;
        }
      rc = SQLFreeStmt(hstmt, SQL_DROP);
        if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
        {
               if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
	           if (rc) frc = rc;
        }
    }
    catch(...)
    {
		frc = 1;
    }

     if (frc == SQL_SUCCESS || frc == SQL_SUCCESS_WITH_INFO)
	  return false;
	return true;

}


int dbError( HENV henv,HDBC hdbc,HSTMT hstmt)
{
    int retVal = 0;
    char  buf[250];
    SQLCHAR   sqlstate[32];

	memset(buf,0,sizeof(buf));

    if (!SQLError( henv, hdbc, hstmt, sqlstate, NULL,(SQLCHAR *  )buf, sizeof(buf), NULL))
    {
        PTRACE(2, "ODBC\tODBC Error: " << buf ) ;
    }
    else
    {
        retVal= 1;
    }
	return retVal;

}


// Select N Output columns[MAX_COL_DATA_LEN] where input Condions are N Columns[MAX_COL_DATA_LEN]
// Each column is MAX_COL_DATA_LEN long
bool ODBCsupp::FetchNxN(SQLCHAR * SQLStmt,  ONECOL *  InVars, int InVarsCount,  ONECOL *  OutVars, int OutVarsCount)
{
    SQLRETURN   rc;
    SQLRETURN   frc = 0;
    SQLHSTMT    hstmt;
	int nindex;
	ONECOL * ICol = InVars;
	ONECOL * OCol = OutVars;
	 
	memset (OutVars,0,(OutVarsCount* sizeof(ONECOL)));
    rc = SQLAllocHandle(SQL_HANDLE_STMT,*(odbc_connection->hdbc),&hstmt);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

    /* prepare the insert statement with parameters */
    rc = SQLPrepare(hstmt,SQLStmt,SQL_NTS);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

	for (nindex = 1; nindex <= InVarsCount; nindex++)
	{
        rc = SQLBindParameter(hstmt, nindex, SQL_PARAM_INPUT, 
                          SQL_C_CHAR, SQL_CHAR, 0,0,
                          (void *)ICol, MAX_COL_DATA_LEN, NULL);
		ICol++;
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }
	}


    rc = SQLExecute(hstmt);
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }


	for (nindex = 1; nindex <= OutVarsCount; nindex++)
	{
      rc = SQLBindCol(hstmt,nindex, SQL_C_CHAR, OCol,
                      MAX_COL_DATA_LEN,NULL);
	  OCol++;
       if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
       {
           if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
           frc = rc;
       }

	}

     rc = SQLFetch(hstmt);
     if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
     {
         if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
         frc = rc;
     }
    /* Free statement param resorces */
     rc = SQLFreeStmt(hstmt, SQL_RESET_PARAMS);
     if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
     {
         if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
         frc = rc;
     }
    
    /* Free statement cursor resorces */
    rc = SQLFreeStmt(hstmt, SQL_CLOSE);
     if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
     {
         if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
         frc = rc;
     }

    /* commit the transaction */
     rc = SQLEndTran(SQL_HANDLE_DBC, *odbc_connection->hdbc, SQL_COMMIT); 
     if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
     {
         if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
         frc = rc;
     }

     rc = SQLFreeStmt(hstmt, SQL_DROP);
     if(rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO )
     {
         if(dbError(odbc_connection->henv,odbc_connection->hdbc,hstmt) != 1)
         frc = rc;
     }

     if (frc == SQL_SUCCESS || frc == SQL_SUCCESS_WITH_INFO)
	  return false;
	return true;
}


/* ifdef  HAS_ODBC */
#endif  
