/*
 * GdiffRange widget header
 *
 * GdiffRange shows some colored rectangles that are related to 
 * each different portion.
 * In addition, a slider, which acts as one on scrollbar, are shown.
 * This is one part of GdiffOverview widget, and is referred to
 * only by GdiffOverview.
 *
 * Once values(ranges) and essential informations(color etc) are set,
 * everything are taken care of by itself.
 * That is, this widget has no signal, no additional interfaces.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_RANGE_H__
#define __GDIFF_RANGE_H__

#include <gdk/gdk.h>
#include <gtk/gtkadjustment.h>
#include <gtk/gtkwidget.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GDIFF_TYPE_RANGE			(gdiff_range_get_type())
#define GDIFF_RANGE(obj)			GTK_CHECK_CAST(obj, gdiff_range_get_type(), GdiffRange)
#define GDIFF_RANGE_CLASS(klass)	GTK_CHECK_CLASS_CAST(klass, gdiff_range_get_type(), GdiffRangeClass)
#define GDIFF_IS_RANGE(obj)			GTK_CHECK_TYPE(obj, gdiff_range_get_type())
#define GDIFF_IS_RANGE_CLASS(klass)	(GTK_CHECK_CLASS_TYPE((klass), GDIFF_TYPE_RANGE))
	
typedef struct _GdiffRange       GdiffRange;
typedef struct _GdiffRangeClass  GdiffRangeClass;
typedef struct _PaintRange PaintRange;

struct _GdiffRange {
	GtkWidget widget;

	gint slider_y;
	gint slider_length;
	GtkAdjustment *adjustment;
	gfloat old_value;
	gfloat old_lower;
	gfloat old_upper;
	gfloat old_page_size;

	/* for slider */
	GdkGC *xor_gc;
	/* for ranges */
	GdkGC *range_gc;
	GdkColor *range_fg;
	GdkColor *range_bg;
	
	/* range display */
	GSList *range_list;/* Singly linked list of PaintRange */
};

struct _GdiffRangeClass {
  GtkWidgetClass parent_class;
};

struct _PaintRange {
	gdouble begin;/* 0.0 - 1.0 */
	gdouble end;/* 0.0 - 1.0 */
};


GtkType gdiff_range_get_type(void);
GtkWidget* gdiff_range_new(GtkAdjustment *adjustment);
void gdiff_range_size(GdiffRange *range, gint width, gint height);
void gdiff_range_set_adjustment(GdiffRange *range, GtkAdjustment *adjustment);

/* Insert a paint area, specified by begin and end (0.0 - 1.0) */
void gdiff_range_insert_paintrange(GdiffRange *range, gdouble begin, gdouble end);

/* sets the color, the color must already be allocated */
void gdiff_range_set_foreground(GdiffRange *range, GdkColor *color);
void gdiff_range_set_background(GdiffRange *range, GdkColor *color);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GDIFF_RANGE_H__ */
