/*
 * GUI right-click menu module
 *
 * Almost every callback function internally calls the related action routine
 * defined in actions.[ch].
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gnome.h>
#include "diff.h"
#include "gui.h"
#include "rmenu.h"
#include "actions.h"
#include "onepaneview.h"
#include "multipaneview.h"


/* Keys for gtk_object_[get|set]_data() for menu item
   I need this, because two items share the same callback, edit_file_cb. */
#define RMENU_PANE_KEY		"pane"

/* Private function declarations */
static void mode_change_cb(GtkWidget *w, gpointer data);
static void show_linenum_cb(GtkWidget *w, gpointer data);
static void text_wrap_cb(GtkWidget *w, gpointer data);
static void go_dirview_cb(GtkWidget *w, gpointer data);
static void edit_file_cb(GtkWidget *w, gpointer data);


/* Private variables */
/* The right-click menu definitions */
static GnomeUIInfo fview_rmenu[] = {
	{GNOME_APP_UI_ITEM, N_("_Pane mode"), NULL,
	 mode_change_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
	{GNOME_APP_UI_ITEM, N_("_Line number"), NULL,
	 show_linenum_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
	{GNOME_APP_UI_ITEM, N_("_Text wrap"), NULL,
	 text_wrap_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
	{GNOME_APP_UI_ITEM, N_("_Go directory view"), NULL,
	 go_dirview_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
#define RMENUITEM_EDIT_BASE		4
	{GNOME_APP_UI_ITEM, N_("_Edit file1"), NULL,
	 edit_file_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
	{GNOME_APP_UI_ITEM, N_("_Edit file2"), NULL,
	 edit_file_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
	{GNOME_APP_UI_ITEM, N_("_Edit file3"), NULL,
	 edit_file_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
	GNOMEUIINFO_END
};


/**
 * rmenu_create:
 * Create right-click menu for the file view, and return it.
 **/
GtkWidget*
rmenu_create(const GtkWidget *fview, gpointer data)
{
	GtkWidget *rmenu;
	int n;

	rmenu = gnome_popup_menu_new(fview_rmenu);
	/* Set index to menu item, to be used in the callback function */
	for (n = 0; n < MAX_NUM_COMPARE_FILES; n++) {
		gtk_object_set_data(GTK_OBJECT(fview_rmenu[RMENUITEM_EDIT_BASE + n].widget),
							RMENU_PANE_KEY, GINT_TO_POINTER(n));
	}

	if (GDIFF_IS_MULTIPVIEW(fview)) {
		int cur = GPOINTER_TO_INT(data);
		for (n = 0; n < MAX_NUM_COMPARE_FILES; n++) {
			if (n == cur)
				continue;
			gtk_widget_hide(fview_rmenu[RMENUITEM_EDIT_BASE + n].widget);
		}
	}
	return rmenu;
}


/* ---The followings are private functions--- */
/**
 * mode_change_cb:
 * XXX: only take care of ONEPANE_VIEW and TWOPANE_VIEW now.
 **/
static void
mode_change_cb(GtkWidget *w, gpointer data)
{
	if (GDIFF_IS_ONEPVIEW(data)) {
		act_fv_mode_change(GTK_WIDGET(data), MULTIPANE2_VIEW);
	} else if (GDIFF_IS_MULTIPVIEW(data)) {
		act_fv_mode_change(GTK_WIDGET(data), ONEPANE2_VIEW);
	}
}

/**
 * show_linenum_cb:
 **/
static void
show_linenum_cb(GtkWidget *w, gpointer data)
{
	gboolean to_show;
	
	if (GDIFF_IS_ONEPVIEW(data))
		to_show = !GDIFF_ONEPVIEW_PREF(data).show_line_num;
	else if (GDIFF_IS_MULTIPVIEW(data))
		to_show = !GDIFF_MULTIPVIEW_PREF(data).show_line_num;
	else
		return;
	
	act_fv_show_linenum(GTK_WIDGET(data), to_show);
}

/**
 * text_wrap_cb:
 **/
static void
text_wrap_cb(GtkWidget *w, gpointer data)
{
	act_fv_toggle_textwrap(GTK_WIDGET(data));
}

/**
 * go_dirview_cb:
 **/
static void
go_dirview_cb(GtkWidget *w, gpointer data)
{
	act_fv_go_dirview(GTK_WIDGET(data));
}

/**
 * edit_file_cb:
 **/
static void
edit_file_cb(GtkWidget *w, gpointer data)
{
	const DiffFiles *dfiles;
	WhichFile n;
	const FileInfo *fi;
	char *filename;
	
	if (GDIFF_IS_ONEPVIEW(data))
		dfiles = GDIFF_ONEPVIEW_DFILES(data);
	else if (GDIFF_IS_MULTIPVIEW(data))
		dfiles = GDIFF_MULTIPVIEW_DFILES(data);
	else
		return;
	
	n = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(w), RMENU_PANE_KEY));
	fi = dfiles_get_fileinfo((DiffFiles*)dfiles, n, FALSE);
	filename = fi->fname;

	act_fv_edit_file(GTK_WIDGET(data), filename);
}
