;;;
;;; irchat-pj-mode-line-format.el
;;; last modify : Sun, 3 Jan 1999 by simm@irc.fan.gr.jp / irchat-PJ Project
;;; (date format modification by simm@irc.fan.gr.jp, Sun, 27 Jun 1999)
;;; see file irchat-copyright.el for change log and copyright info
;;;

(provide 'irchat-pj-mode-line-format)

;;
;; irchat-pj-Commands-mode-line-format
;;

(defvar irchat-pj-Commands-mode-line-format-default
  (if (featurep 'meadow)
      '("" irchat-away-indicator irchat-freeze-indicator ""
        ((if (boundp 'MULE) mc-flag kanji-flag)
         ((minibuffer-window-selected
           (display-minibuffer-mode "m" " ") " ")
          mw32-ime-mode-line-state-indicator))
        " IRCHAT: Commands" irchat-private-indicator
        " {" irchat-chanbuf-indicator "} "
        irchat-nickname " on " irchat-servername
        (skk-mode skk-input-mode-string)
        " -%-")
    '("" irchat-away-indicator irchat-freeze-indicator ""
      ((if (boundp 'MULE) mc-flag kanji-flag)
       ((minibuffer-window-selected
         (display-minibuffer-mode "m" " ") " ")
        "["
        (minibuffer-window-selected
         (display-minibuffer-mode
          mode-line-egg-mode-in-minibuffer
          mode-line-egg-mode)
         mode-line-egg-mode)
        " ] " mode-line-canna-mode))
      " IRCHAT: Commands" irchat-private-indicator
      " {" irchat-chanbuf-indicator "} "
      irchat-nickname " on " irchat-servername
      (skk-mode skk-input-mode-string)
      " -%-")))

(defvar irchat-pj-Commands-mode-line-format-for-egg
  '("" irchat-away-indicator irchat-freeze-indicator ""
    ((if (boundp 'MULE) mc-flag kanji-flag)
     ((minibuffer-window-selected
       (display-minibuffer-mode "m" " ") " ")
      "["
      (minibuffer-window-selected
       (display-minibuffer-mode
	mode-line-egg-mode-in-minibuffer
	mode-line-egg-mode)
       mode-line-egg-mode)
      " ]"))
    " IRCHAT: Commands" irchat-private-indicator
    " {" irchat-chanbuf-indicator "} "
    irchat-nickname " on " irchat-servername " -%-"))

(defvar irchat-pj-Commands-mode-line-format-for-canna
  '("" irchat-away-indicator irchat-freeze-indicator ""
    ((if (boundp 'MULE) mc-flag kanji-flag)
     ((minibuffer-window-selected
       (display-minibuffer-mode "m" " ") " ")
      "-" mode-line-canna-mode))
    " IRCHAT: Commands" irchat-private-indicator
    " {" irchat-chanbuf-indicator "} "
    irchat-nickname " on " irchat-servername " -%-"))

(defvar irchat-pj-Commands-mode-line-format-for-mw32
  '("" irchat-away-indicator irchat-freeze-indicator ""
    ((if (boundp 'MULE) mc-flag kanji-flag)
     ((minibuffer-window-selected
       (display-minibuffer-mode "m" " ") " ")
      mw32-ime-mode-line-state-indicator))
    " IRCHAT: Commands" irchat-private-indicator
    " {" irchat-chanbuf-indicator "} "
    irchat-nickname " on " irchat-servername
    " -%-"))

(defvar irchat-pj-Commands-mode-line-format-simple
  '("" irchat-away-indicator irchat-freeze-indicator ""
    " IRCHAT: Commands" irchat-private-indicator
    " {" irchat-chanbuf-indicator "} "
    irchat-nickname " on " irchat-servername
    (skk-mode skk-input-mode-string)
    " -%-"))

(defvar irchat-pj-Commands-mode-line-format-alternative
  (if (featurep 'meadow)
      '("" irchat-away-indicator irchat-freeze-indicator ""
        ((if (boundp 'MULE) mc-flag kanji-flag)
         ((minibuffer-window-selected
           (display-minibuffer-mode "m" " ") " ")
          mw32-ime-mode-line-state-indicator))
        " irchat-pj: Commands" irchat-private-indicator
        " <" irchat-servername "> " irchat-nickname
        " (" irchat-chanbuf-indicator (skk-mode skk-input-mode-string) ")"
        " -%-")
    '("" irchat-away-indicator irchat-freeze-indicator ""
      ((if (boundp 'MULE) mc-flag kanji-flag)
       ((minibuffer-window-selected
         (display-minibuffer-mode "m" " ") " ")
        "["
        (minibuffer-window-selected
         (display-minibuffer-mode
          mode-line-egg-mode-in-minibuffer
          mode-line-egg-mode)
         mode-line-egg-mode)
        " ]"))
      " irchat-pj: Commands" irchat-private-indicator
      " <" irchat-servername "> " irchat-nickname
      " (" irchat-chanbuf-indicator (skk-mode skk-input-mode-string) ")"
      " -%-")))

(defvar irchat-pj-Commands-mode-line-format-alt-egg
  '("" irchat-away-indicator irchat-freeze-indicator ""
    ((if (boundp 'MULE) mc-flag kanji-flag)
     ((minibuffer-window-selected
       (display-minibuffer-mode "m" " ") " ")
      "["
      (minibuffer-window-selected
       (display-minibuffer-mode
	mode-line-egg-mode-in-minibuffer
	mode-line-egg-mode)
       mode-line-egg-mode)
      " ] " mode-line-canna-mode))
    " irchat-pj: Commands" irchat-private-indicator
    " <" irchat-servername "> " irchat-nickname
    " (" irchat-chanbuf-indicator ")"
    " -%-"))

(defvar irchat-pj-Commands-mode-line-format-alt-canna
  '("" irchat-away-indicator irchat-freeze-indicator ""
    ((if (boundp 'MULE) mc-flag kanji-flag)
     ((minibuffer-window-selected
       (display-minibuffer-mode "m" " ") " ")
      "-" mode-line-canna-mode))
    " irchat-pj: Commands" irchat-private-indicator
    " <" irchat-servername "> " irchat-nickname
    " (" irchat-chanbuf-indicator (skk-mode skk-input-mode-string) ")"
    " -%-"))

(defvar irchat-pj-Commands-mode-line-format-alt-mw32
  '("" irchat-away-indicator irchat-freeze-indicator ""
    ((if (boundp 'MULE) mc-flag kanji-flag)
     ((minibuffer-window-selected
       (display-minibuffer-mode "m" " ") " ")
        mw32-ime-mode-line-state-indicator))
    " irchat-pj: Commands" irchat-private-indicator
    " <" irchat-servername "> " irchat-nickname
    " (" irchat-chanbuf-indicator  ")"
    " -%-"))

(defvar irchat-pj-Commands-mode-line-format-alt-simple
  '("" irchat-away-indicator irchat-freeze-indicator ""
    " irchat-pj: Commands" irchat-private-indicator
    " <" irchat-servername "> " irchat-nickname
    " (" irchat-chanbuf-indicator (skk-mode skk-input-mode-string) ")"
    " -%-"))

(defvar irchat-pj-Commands-mode-line-format-minor-mode
  '("" irchat-away-indicator irchat-freeze-indicator ""
    " irchat-pj: Commands" irchat-private-indicator
    " <" irchat-servername "> " irchat-nickname
    " (" irchat-chanbuf-indicator minor-mode-alist ")"
    " -%-"))

(defvar irchat-pj-Commands-mode-line-format 'irchat-pj-Commands-mode-line-format-default
  "Mode line format for irchat-pj Command buffer.

We irchat-PJ project provides below:
\(for most use\)
  irchat-pj-Commands-mode-line-format-default
  irchat-pj-Commands-mode-line-format-alternative
\(for minor-mode kana-kanji converting system, like SKK10\)
  irchat-pj-Commands-mode-line-format-minor-mode
\(for non-kana-kanji-conversion, or SKK user\)
  irchat-pj-Commands-mode-line-format-simple
  irchat-pj-Commands-mode-line-format-alt-simple
\(for Wnn user\)
  irchat-pj-Commands-mode-line-format-for-egg
  irchat-pj-Commands-mode-line-format-alt-egg
\(for Canna user\)
  irchat-pj-Commands-mode-line-format-for-canna
  irchat-pj-Commands-mode-line-format-alt-canna
So, choose above, or select your defined mode line.

ex.
\(setq irchat-pj-Commands-mode-line-format 'irchat-pj-Commands-mode-line-format-minor-mode\)

Default is irchat-pj-Commands-mode-line-format-default.
")

;;
;; irchat-pj-Dialogue-mode-line-format
;;

(defvar irchat-pj-Dialogue-mode-line-format-default
  '("" irchat-away-indicator irchat-freeze-indicator
    " {" irchat-chanbufs-indicator "} "
    (-3 . "%p") " -%-"))

(defvar irchat-pj-Dialogue-mode-line-format-alternative
  '("" irchat-away-indicator irchat-freeze-indicator
    " (" irchat-chanbufs-indicator ") "
    (-3 . "%p") " -%-"))

(defvar irchat-pj-Dialogue-mode-line-format-minor-mode
  '("" irchat-away-indicator irchat-freeze-indicator
    " (" irchat-chanbufs-indicator minor-mode-alist ") "
    (-3 . "%p") " -%-"))

(defvar irchat-pj-Dialogue-mode-line-format 'irchat-pj-Dialogue-mode-line-format-default
  "Mode line format for irchat-pj Dialogue buffer.

We irchat-PJ project provides below:
  irchat-pj-Dialogue-mode-line-format-default
  irchat-pj-Dialogue-mode-line-format-alternative
  irchat-pj-Dialogue-mode-line-format-minor-mode
So, choose above, or select your defined mode line.

ex.
\(setq irchat-pj-Dialogue-mode-line-format 'irchat-pj-Dialogue-mode-line-format-minor-mode\)

Default is irchat-pj-Dialogue-mode-line-format-default.
")

;;
;; irchat-pj-Other-mode-line-format
;;

(defvar irchat-pj-Other-mode-line-format-default
  '("" irchat-away-indicator "-"
    " {" irchat-chanbufs-indicator "} "
    (-3 . "%p") " -%-"))

(defvar irchat-pj-Other-mode-line-format-alternative
  '("" irchat-away-indicator "-"
    " (" irchat-chanbufs-indicator ") "
    (-3 . "%p") " -%-"))

(defvar irchat-pj-Other-mode-line-format-minor-mode
  '("" irchat-away-indicator "-"
    " (" irchat-chanbufs-indicator minor-mode-alist ") "
    (-3 . "%p") " -%-"))

(defvar irchat-pj-Other-mode-line-format 'irchat-pj-Other-mode-line-format-default
  "Mode line format for irchat-pj Other buffer.

We irchat-PJ project provides below:
  irchat-pj-Other-mode-line-format-default
  irchat-pj-Other-mode-line-format-alternative
  irchat-pj-Other-mode-line-format-minor-mode
So, choose above, or select your defined mode line.

ex.
\(setq irchat-pj-Other-mode-line-format 'irchat-pj-Other-mode-line-format-minor-mode\)

Default is irchat-pj-Other-mode-line-format-default.
")

;;
;; irchat-pj-Channel-mode-line-format
;;

(defvar irchat-pj-Channel-mode-line-format-default
  '("" irchat-beep-indicator-local irchat-freeze-indicator-local
    irchat-suppress-indicator-local
    "IRCHAT: Current" 
    " {" irchat-chanbuf-indicator "} "
    (-3 . "%p") " -%-"))

(defvar irchat-pj-Channel-mode-line-format-alternative
  '("" irchat-beep-indicator-local irchat-freeze-indicator-local
    irchat-suppress-indicator-local
    "irchat-pj: Current" 
    " (" irchat-chanbuf-indicator ") "
    (-3 . "%p") " -%-"))

(defvar irchat-pj-Channel-mode-line-format-minor-mode
  '("" irchat-beep-indicator-local irchat-freeze-indicator-local
    irchat-suppress-indicator-local
    "irchat-pj: Current" 
    " (" irchat-chanbuf-indicator minor-mode-alist ") "
    (-3 . "%p") " -%-"))

(defvar irchat-pj-Channel-mode-line-format 'irchat-pj-Channel-mode-line-format-default
  "Mode line format for irchat-pj Channel buffer.

We irchat-PJ project provides below:
  irchat-pj-Channel-mode-line-format-default
  irchat-pj-Channel-mode-line-format-alternative
  irchat-pj-Channel-mode-line-format-minor-mode
So, choose above, or select your defined mode line.

ex.
\(setq irchat-pj-Channel-mode-line-format 'irchat-pj-Channel-mode-line-format-minor-mode\)

Default is irchat-pj-Channel-mode-line-format-default.
")
