/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: thread_proxy.h,v 1.3.2.1 2004/06/11 12:02:34 fuyu Exp $
 */

#ifndef _THREAD_PROXY_H_
#define _THREAD_PROXY_H_

#include "ochusha_bbs_thread.h"

#include <glib-object.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define THREAD_PROXY_TYPE		(thread_proxy_get_type())
#define THREAD_PROXY(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), THREAD_PROXY_TYPE, ThreadProxy))
#define THREAD_PROXY_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), THREAD_PROXY_TYPE, ThreadProxyClass))
#define IS_THREAD_PROXY(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), THREAD_PROXY_TYPE))
#define IS_THREAD_PROXY_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), THREAD_PROXY_TYPE))
#define THREAD_PROXY_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), THREAD_PROXY_TYPE, ThreadProxyClass))


typedef struct _ThreadProxy ThreadProxy;
typedef struct _ThreadProxyClass ThreadProxyClass;


struct _ThreadProxy
{
  OchushaBBSThread parent_object;

  OchushaBBSThread *real_thread;
};


struct _ThreadProxyClass
{
  OchushaBBSThreadClass parent_class;
};


GType thread_proxy_get_type(void) G_GNUC_CONST;
OchushaBBSThread *thread_proxy_new(const char *url, const gchar *title);
OchushaBBSThread *thread_proxy_new_with_thread(OchushaBBSThread *thread);
OchushaBBSThread *thread_proxy_get_real_thread(ThreadProxy *proxy);
void thread_proxy_set_real_thread(ThreadProxy *proxy,
				  OchushaBBSThread *thread);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _THREAD_PROXY_H_ */
