proglib   = $(WEB2CLIB_builddir)/lib.a
kpathlib  = $(KPATHMAIN_builddir)/libkpathsea.la
KPSEWHICH = $(KPATHMAIN_builddir)/kpsewhich
TANGLE    = $(WEB2CMAIN_builddir)/tangle
OTANGLE   = $(OMEGAWARE_builddir)/otangle
TIE       = $(WEB2CMAIN_builddir)/tie
TEX_WEB   = $(WEB2CMAIN_srcdir)/tex.web
TEXMFMP_C = $(WEB2CLIB_srcdir)/texmfmp.c
KLIBTOOL  = KLIBTOOL_CONFIG_DIR=$(TEXKMAIN_builddir) \
            $(TEXKMAIN_srcdir)/klibtool
WEB2C     = OMEGAWEB_srcdir=$(OMEGAWEB_srcdir) \
            WEB2CSRC_builddir=$(WEB2CSRC_builddir) \
            WEB2CSRC_srcdir=$(WEB2CSRC_srcdir) \
            srcdir=$(srcdir) \
            $(SHELL) $(OMEGASRC_srcdir)/convert

AM_YFLAGS = -d

# XLOADLIBES is for the installer.
LIBS          = -lm
WEBLIBS       = $(proglib) $(kpathlib)
LOADLIBES     = $(WEBLIBS) $(LIBS) $(XLOADLIBES)
kpathsea_link = $(KLIBTOOL) link $(LINK)

# Dependencies for the libraries
$(proglib): $(WEB2CLIB_srcdir)/*.c
	cd $(WEB2CLIB_builddir) && $(MAKE)

$(kpathlib): $(KPATHMAIN_srcdir)/*.c $(KPATHMAIN_srcdir)/*.h
	cd $(KPATHMAIN_builddir) && $(MAKE)

$(KPSEWHICH): $(kpathlib)

# Dependencies for the web2c programs
web2c_aux      = $(WEB2CSRC_srcdir)/common.defines
web2c_dependencies = $(WEB2CSRC_builddir)/fixwrites \
                     $(WEB2CSRC_builddir)/splitup \
                     $(WEB2CSRC_builddir)/web2c
WEBPROGRAMS    = $(web2c_aux) $(web2c_programs)

# The web2c program consists of several executables.
$(WEB2CSRC_builddir)/fixwrites: $(WEB2CSRC_srcdir)/fixwrites.c
	cd $(WEB2CSRC_builddir) && $(MAKE) fixwrites
$(WEB2CSRC_builddir)/splitup: $(WEB2CSRC_srcdir)/splitup.c
	cd $(WEB2CSRC_builddir) && $(MAKE) splitup
$(WEB2CSRC_builddir)/web2c: $(WEB2CSRC_srcdir)/main.c \
                            $(WEB2CSRC_srcdir)/web2c.h \
                            $(WEB2CSRC_srcdir)/web2c.l \
                            $(WEB2CSRC_srcdir)/web2c.y
	cd $(WEB2CSRC_builddir) && $(MAKE) web2c

$(OTANGLE): $(OMEGAWARE_srcdir)/otangle.web $(OMEGAWARE_srcdir)/otangle.ch
	cd $(OMEGAWARE_builddir) && $(MAKE) otangle

$(TIE): $(WEB2CMAIN_srcdir)/tiedir/tie.w $(WEB2CMAIN_srcdir)/tiedir/tie-w2c.ch
	cd $(WEB2CMAIN_builddir) && $(MAKE) tie

