=begin

  rbbr/ui/gtk/browselist.rb 

  $Author: mutoh $
  $Date: 2003/12/06 13:56:57 $

  Copyright (C) 2002,2003 Ruby-GNOME2 Project

  Copyright (C) 2000-2002 Hiroshi Igarashi <iga@ruby-lang.org>

  This program is free software.
  You can distribute/modify this program under
  the terms of the Ruby Distribute License.

=end

module RBBR
module UI
module GTK

  class BrowseList < Gtk::TreeView
    include Observable
    include GetText
    GetText.bindtextdomain("rbbr", nil, nil, "UTF-8")

    def initialize(labels)
      @labels = labels
      @model = Gtk::ListStore.new(*labels.collect{|label| label.class})
      super(@model)
      
      renderer = Gtk::CellRendererText.new
      labels.each_index do |cnt|
        column = Gtk::TreeViewColumn.new(labels[cnt], renderer, :text => cnt)
        column.sort_column_id = cnt
        append_column(column)
      end
      
      selection.mode = Gtk::SELECTION_SINGLE
      selection.signal_connect('changed') do |e|
        iter = selection.selected
        changed
        notify_selection(@modul, iter) if iter
      end

      set_rules_hint(true)
    end

    private
    def notify_selection(m, text)
      # should be overridden in sub classes
    end

    public
    def update(modul)
      freeze_notify
      @model.clear
      update_list(modul)
      thaw_notify
      @modul = modul
    end
    
    def append(data)
      iter = @model.append
      data.each_index do |cnt|
        iter[cnt] = data[cnt]
      end
    end
    
    def update_list(modul)
      # should be overridden in sub classes
    end
  end

  class SignalList < BrowseList
    def initialize
      super([_("Name"), _("Return type"), _("Parameters")])
    end
    
    def update_list(modul)
      if modul < GLib::Instantiatable or modul < GLib::Interface
        modul.signals(false).each{|signal_name|
	  signal = modul.signal(signal_name)
          append([signal.name, signal.return_type.name,
                   signal.param_types.map{|t| t.name}.join(", ") ])
        }
      end
    end
    def notify_selection(modul, iter)
      notify_observers(modul, [iter.get_value(0), '::'])
    end
  end

  class PropertyList < BrowseList
    def initialize
      super([_("Name"), _("Type"), _("GType"), _("Flags"), _("Default")])
    end
    
    def append_prop(prop)
      flags = ''
      flags << 'r' if prop.readable?
      flags << 'w' if prop.writable?
      append([prop.name, prop.value_type.to_class.inspect,
               prop.value_type.name, flags,
               prop.value_default.inspect])
      
    end

    def update_list(modul)
      if modul <= GLib::Object
        modul.properties(false).sort.each do |prop_name|
          append_prop(modul.property(prop_name))
        end
      end
    end

    def notify_selection(modul, iter)
      name = iter[0]
      str = modul.property(name).blurb || ''
      notify_observers(modul, [iter.get_value(0), '::'], [], str)
    end
  end

=begin
  #not yet.
  class StyleList < PropertyList
    def update_list(modul)
      if modul <= Gtk::Widget
        modul.style_properties.sort.each do |prop_name|
          append_prop(modul.style_property(prop_name))
        end
      end
    end
  end
=end
end;end;end
