=begin

  rbbr/ui/gtk/browser.rb 

  $Author: mutoh $
  $Date: 2003/12/16 17:00:28 $

  Copyright (C) 2002,2003 Ruby-GNOME2 Project

  Copyright (C) 2000-2002 Hiroshi Igarashi <iga@ruby-lang.org>

  This program is free software.
  You can distribute/modify this program under
  the terms of the Ruby Distribute License.

=end

module RBBR
module UI
module GTK
  class Browser < Gtk::Window
    include WindowUtils
    include GetText
    GetText.bindtextdomain("rbbr", nil, nil, "UTF-8")

    if RUBY_VERSION > "1.8.0"
      def regexp_warn?(str)
        class << (warning = "")
          alias write <<
        end 
        verbose, $VERBOSE = $VERBOSE, true
        stderr, $stderr = $stderr, warning
        Regexp.compile(str)
        warning[__FILE__.size..-1].sub(/\A:\d+:\s*/, '').chomp unless warning.empty?
      rescue RegexpError
        $!
      ensure
        $stderr = stderr
        $VERBOSE = verbose
      end
    else
      def regexp_warn?(str)
        Regexp.compile(str)
        nil
      rescue RegexpError
        $!
      end
    end

    def create_menubar
      cal_req = Proc.new{ 
        LibrarySelectionDialog.new(self, @conf, [@modulelist, @moduletree])
      }

      cal_load = Proc.new{
        fs = Gtk::FileSelection.new(_("Select a Ruby script"))
        fs.set_transient_for(self)
        filename = nil
        fs.show_all
        fs.run
        filename = fs.filename
        begin
          if FileTest.file?(filename)
            load(filename)
            dag = RBBR::MetaInfo::ModuleDAG.full_module_dag
            @moduleview.get_nth_page(@moduleview.page).child.update(dag)
          end
        rescue Exception
          show_error_message("Ruby Browser", $!)
        end
        fs.destroy
      }

      cal_quit = Proc.new{ save_conf; Gtk.main_quit }
      cal_expand = Proc.new{ @moduletree.expand_all }
      cal_fold = Proc.new{ @moduletree.collapse_all }
      cal_update = Proc.new{ @moduletree.update(RBBR::MetaInfo::ModuleDAG.full_module_dag) }
      cal_stockbrowser = Proc.new{
        stockbrowser = RBBR::UI::GTK::StockDialog.new(self)
        stockbrowser.run
        stockbrowser.destroy
      }
      cal_about = Proc.new{
        aboutdialog = RBBR::UI::GTK::AboutDialog.new(self, @database)
        aboutdialog.run
        aboutdialog.destroy
      }

      accelgroup = Gtk::AccelGroup.new
      add_accel_group(accelgroup)
      ifp = Gtk::ItemFactory.new(Gtk::ItemFactory::TYPE_MENU_BAR, "<main>", accelgroup)

      ifp.create_items([
                         [_("/_File")],
                         [_("/_File/_Require Library..."), "<StockItem>", "<control>R", Gtk::Stock::ADD, cal_req],
                         [_("/_File/_Load Script..."), "<StockItem>", "<control>L", Gtk::Stock::OPEN, cal_load],
                         [_("/_File/_Separator"), "<Separator>"],
                         [_("/_File/_Quit"), "<StockItem>", "<control>Q", Gtk::Stock::QUIT, cal_quit],
                         [_("/_View")],
                         [_("/_View/_Expand All"), "<StockItem>", "<control>E", Gtk::Stock::GOTO_BOTTOM, cal_expand],
                         [_("/_View/_Collapse All"), "<StockItem>", "<control>F", Gtk::Stock::GOTO_TOP, cal_fold],
                         [_("/_View/Update Information"), "<StockItem>", "<control>U", Gtk::Stock::REFRESH, cal_update],
                         [_("/_View/Stock Item and Icon Browser ..."), "<Item>", "<control>I", "", cal_stockbrowser],
                         [_("/_Help")],
                         [_("/_Help/_About"), "<StockItem>", "<control>A", Gtk::Stock::HELP, cal_about]
                       ])

      ifp.get_widget("<main>")
    end

    def initialize 
      super

      @conf = ConfManager.new

      @conf["main.x"] ||= 0
      @conf["main.y"] ||= 0
      @conf["main.width"] ||= 500
      @conf["main.height"] ||= 400
      @conf["leftpane.width"] ||= 250
      
      signal_connect("delete-event") do
        save_conf
        false
      end
      
      signal_connect("destroy") do
        Gtk.main_quit
      end

      # setting size, position
      set_default_size(@conf["main.width"], @conf["main.height"])
      move(@conf["main.x"], @conf["main.y"])

      # create document @database
      @database = Doc::MultiDatabase.new

      # create vbox
      vbox = Gtk::VBox.new(false, 0)
      add(vbox)

      # create menu
      vbox.pack_start(create_menubar, false, false, 0)

      # create main box
      main_paned = Gtk::HPaned.new
      vbox.pack_start(main_paned, true, true, 0)
      @index_paned = Gtk::VBox.new
      @index_paned.set_size_request(@conf["leftpane.width"], -1)
      main_paned.add(@index_paned)

      # create search entry
      search_box = Gtk::HBox.new
      search_entry = Gtk::Entry.new
      search_entry.activates_default = true
      search_box.pack_start(search_entry, true, true, 5)
      search_button = Gtk::Button.new(_("Find"))
      search_box.pack_start(search_button)
      @index_paned.pack_start(search_box, false, false, 5)
      search_button.signal_connect("clicked") do 
        target = search_entry.text
        if str = regexp_warn?(target)
          show_warn_message("Ruby Browser", str)
        else
          @moduleview.get_nth_page(@moduleview.page).child.search(target)
        end
      end

      # create left pane
      @moduleview = Gtk::Notebook.new
      @index_paned.pack_start(@moduleview)
      dag = RBBR::MetaInfo::ModuleDAG.full_module_dag
      @modulelist = RBBR::UI::GTK::ModuleListView.new(search_entry)
      @moduletree = RBBR::UI::GTK::ModuleTreeView.new(search_entry)

      [[@modulelist, _("List")], [@moduletree, _("Tree")]].each do |widget, text|
        scwin = Gtk::ScrolledWindow.new
        scwin.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC)
        scwin.add(widget)
        @moduleview.append_page(scwin, Gtk::Label.new(text))
        Thread.start do
          widget.realize
          if Gtk::MAJOR_VERSION >= 0 and Gtk::MINOR_VERSION > 8
            widget.window.set_cursor(Gdk::Cursor.new(Gdk::Cursor::WATCH)) 
          end
          widget.update(dag)
          widget.window.set_cursor(Gdk::Cursor.new(Gdk::Cursor::LEFT_PTR))
          widget.window.set_cursor(nil) if Gtk::MAJOR_VERSION >= 0 and Gtk::MINOR_VERSION > 8
        end
      end

      # create module display
      @module_display = ModuleDisplay.new(@database, @conf)
      @modulelist.add_observer(@module_display)
      @moduletree.add_observer(@module_display)
      main_paned.add2(@module_display)

      # set icon
      set_icon(Gdk::Pixbuf.new(File.join(RBBR::Config::DATA_DIR, "icon.png")))

      search_button.set_flags(Gtk::Widget::CAN_DEFAULT|Gtk::Widget::HAS_DEFAULT)
      search_button.grab_default
      set_default(search_button)
    end

    def save_conf
      p "save config..." if $DEBUG
      #Save config
      @module_display.save_conf

      @conf["main.width"] = allocation.width
      @conf["main.height"] = allocation.height
      @conf["leftpane.width"] = @index_paned.allocation.width

      x, y = window.root_origin
      @conf["main.x"] = x < 0 ? 2 : x
      @conf["main.y"] = y < 0 ? 2 : y
    end
  end
end;end;end
