=begin
  rbbr/ui/gtk/docviewer.rb 

  $Author: mutoh $
  $Date: 2003/11/28 17:10:09 $

  Copyright (C) 2002,2003 Ruby-GNOME2 Project

  Copyright (C) 2000-2002 Hiroshi Igarashi <iga@ruby-lang.org>

  This program is free software.
  You can distribute/modify this program under
  the terms of the Ruby Distribute License.

=end

module RBBR
module UI
module GTK

  class DocViewer < Gtk::TextView
    include GetText
    GetText.bindtextdomain("rbbr", nil, nil, "UTF-8")

    def initialize( database )
      super()
      @database = database
      set_wrap_mode(Gtk::TextTag::WRAP_WORD)

      buffer.create_tag('title', 
                        :weight =>Pango::FontDescription::WEIGHT_BOLD,
                        :foreground => '#005500')
      
      buffer.create_tag("name", 
                        :weight => Pango::FontDescription::WEIGHT_BOLD,
                        :stretch => Pango::FontDescription::STRETCH_ULTRA_EXPANDED,
                        :foreground => '#994400')
      
      buffer.create_tag("args", :style => Pango::FontDescription::STYLE_ITALIC)
      buffer.create_tag("normal", :foreground => 'black')
      buffer.create_tag("item", :foreground => '#000099')
      buffer.create_tag("nodata", :foreground => 'darkgray')
      set_left_margin(3)
    end

    def update(modul, specs = nil, args = [], desc = nil)
      freeze_notify
      buffer.text = ""
      spec = [modul, specs[0]].join(specs[1]) if specs
      begin
        unless desc
          if spec 
            desc = @database.lookup_method(spec)
          elsif modul
            desc = @database.lookup_class(modul.inspect)
            spec = modul.inspect
          end
        end
        iter = buffer.get_iter_at_offset(0)
        if specs
          if args.size > 0
            if specs[0] == "[]"
              if specs[1] == "."
                buffer.insert_with_tags(iter, modul.inspect + "[", 'title')
              else
                buffer.insert_with_tags(iter, modul.inspect + specs[1] + "[", 'title')
              end
              buffer.insert_with_tags(iter, args.join(', '), 'args', 'title')
              buffer.insert_with_tags(iter, "]", 'title')
            elsif specs[0] == "[]="
              args.pop
              buffer.insert_with_tags(iter, modul.inspect + specs[1] + "[", 'title')
              buffer.insert_with_tags(iter, args.join(', '), 'args', 'title')
              buffer.insert_with_tags(iter, "]= val", 'title')
            elsif /^([\&\!\^\%\+\*\-\/<>\!]|<<|\=\=|\=~|<\=>)$/ =~ specs[0]
              buffer.insert_with_tags(iter, spec, 'title')
              buffer.insert_with_tags(iter, " val", 'args', 'title')
            else
              buffer.insert_with_tags(iter, spec, 'title')
              buffer.insert_with_tags(iter, "(", 'title')
              buffer.insert_with_tags(iter, args.join(', '), 'args', 'title')
              buffer.insert_with_tags(iter, ")", 'title')
            end
          else
            buffer.insert_with_tags(iter, spec, 'title')
          end
          buffer.insert(iter, "\n\n")
        end
          
        if desc and desc.size > 0
          desc.split("\n").each do |line|
            if /^---/ =~ line
              buffer.insert_with_tags(iter, "#{$'}\n", 'name')
            elsif /^\s*\*/ =~ line
              buffer.insert_with_tags(iter, "   *#{$'}\n", 'item')
            elsif /^\s{4}/ =~ line
              buffer.insert_with_tags(iter, "  #{$'}\n", 'normal')
            else
              buffer.insert_with_tags(iter, "  #{line}\n", 'normal')
            end
          end
        elsif spec
          buffer.insert_with_tags(iter, _("(no document)\n"), 'nodata')
        end
      rescue RBBR::Doc::LookupError
      ensure
        thaw_notify
      end
    end
  end
end;end;end
