=begin

  rbbr/ui/gtk/moduledisplay.rb 

  $Author: mutoh $
  $Date: 2003/11/28 17:10:09 $

  Copyright (C) 2002,2003 Ruby-GNOME2 Project

  Copyright (C) 2000-2002 Hiroshi Igarashi <iga@ruby-lang.org>

  This program is free software.
  You can distribute/modify this program under
  the terms of the Ruby Distribute License.

=end

module RBBR
module UI
module GTK

  class ModuleDisplay < Gtk::VPaned
    include GetText
    GetText.bindtextdomain("rbbr", nil, nil, "UTF-8")  

    def initialize(database, conf)
      super()

      @database = database
      @conf = conf

      @conf["moduledisplay.position"] ||= 200

      @docviewer = DocViewer.new(database)

      # create display paned
      @display_box = Gtk::VBox.new(false, 0)

      # create module label
      @module_label = ModuleLabel.new
      @display_box.pack_start(@module_label, false, true, 0)

      # create notebook
      notebook = Gtk::Notebook.new
      notebook.set_tab_pos(Gtk::POS_TOP)
      notebook.set_scrollable(true)
      notebook.set_homogeneous(false)
      notebook.set_show_tabs(true)
      @display_box.pack_start(notebook, true, true, 0)

      # create lists
      @lists = [ 
        [MethodList.new, _("Methods")],
        [ConstantList.new, _("Constants")],
        [PropertyList.new, _("Properties")],
        [SignalList.new, _("Signals")],
#        [StyleList.new, _("Styles")],
      ]
      @lists.each_with_index do |(list, label), index|
        scwin = Gtk::ScrolledWindow.new
        scwin.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC)
        scwin.add(list)
        notebook.append_page(scwin, Gtk::Label.new(label))
        notebook.set_tab_label_packing(scwin, true, true, Gtk::PACK_START)
        
        list.add_observer(@docviewer)
      end

      #main pane
      @mainpane = Gtk::ScrolledWindow.new 
      @mainpane.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC)

      @mainpane.add(@docviewer)

      add1(@display_box)
      add2(@mainpane)

      set_position(@conf["moduledisplay.position"])
      notebook.show_all
      @docviewer.show_all
    end

    def update(*args)
      @module_label.update(*args)
      @lists.each do |list, label|
        list.update(*args)
      end
      @docviewer.update(*args)
    end

    def save_conf
      @conf["moduledisplay.position"] = position
    end
  end
end;end;end
