=begin

  rbbr/ui/gtk/modulelistview.rb 

  $Author: mutoh $
  $Date: 2003/11/28 17:10:10 $

  Copyright (C) 2003 Ruby-GNOME2 Project

  This program is free software.
  You can distribute/modify this program under
  the terms of the Ruby Distribute License.

=end

module RBBR
module UI
module GTK

  class ModuleListView < Gtk::TreeView
    include Observable
    include GetText
    GetText.bindtextdomain("rbbr", nil, nil, "UTF-8")
    
    def initialize(search_entry)
      @model = Gtk::ListStore.new(String, Module)
      @column = Gtk::TreeViewColumn.new(_("Classes / Modules"), 
                                        Gtk::CellRendererText.new, :text => 0)
      super(@model)

      append_column(@column)
      selection.set_mode(Gtk::SELECTION_SINGLE)
      @search_entry = search_entry
    end
    
    def update(dag)
      @dag = dag
      build_tree
    end

    def search(target_name)
      build_tree(target_name)
    end
    
    private
    def build_tree(target_name = nil)
      @model.clear
      freeze_notify
      
      subclasses = []
      @dag.each do |parent, klass, _|
        if /#{target_name}/i =~ klass.inspect and /^(RBBR|ReFe|RI|\#\<)(::)?/ !~ klass.inspect
          subclasses << klass
        end
      end
      subclasses.uniq.sort{|x, y| x.inspect <=> y.inspect}.each do |c|
        iter = @model.append
        iter[0] = c.inspect
        iter[1] = c
      end
      selection.signal_connect("changed") do |e|
        iter = selection.selected
        if iter
          klass = iter[1]
          if Module === klass
            changed
            notify_observers(klass)
          end
        else
          notify_observers(nil)
        end
      end
      thaw_notify
    end
  end

end;end;end
