=begin

  rbbr/ui/gtk/moduletreeview.rb 

  $Author: mutoh $
  $Date: 2003/11/28 17:10:10 $

  Copyright (C) 2003 Ruby-GNOME2 Project

  This program is free software.
  You can distribute/modify this program under
  the terms of the Ruby Distribute License.

=end

module RBBR
module UI
module GTK

  class ModuleTreeView < Gtk::TreeView
    include Observable
    include GetText
    GetText.bindtextdomain("rbbr", nil, nil, "UTF-8")
   
    def initialize(search_entry)
      @model = Gtk::TreeStore.new(String, Module)
      @column = Gtk::TreeViewColumn.new(_("Classes / Modules"), 
                                        Gtk::CellRendererText.new, :text => 0)
      super(@model)

      append_column(@column)
      selection.set_mode(Gtk::SELECTION_SINGLE)
      @search_entry = search_entry
    end
    
    def update(dag)
      @dag = dag
      build_tree
    end

    def search(target_name, start_iter = nil)
      start_iter = selection.selected unless start_iter
      start_iter = @model.iter_first unless start_iter
      start = false
      @model.each do |m, path, iter|
        if start
          if iter.get_value(0) =~ /#{target_name}/i
            expand_path = ""
            path.indices.each {|v|
              expand_path += ":" if expand_path.size > 0
              expand_path += v.to_s
              expand_row(Gtk::TreePath.new(expand_path), false)
            }
            selection.select_path(path)
            scroll_to_cell(path, @column, true, 0.5, 0.5)
            row_activated(path, @column)
            set_cursor(path, @column, false)
            return
          end
        elsif iter == start_iter
          start = true
        end
      end
      
      dialog = Gtk::MessageDialog.new(nil, Gtk::Dialog::MODAL,
                                      Gtk::MessageDialog::INFO,
                                      Gtk::MessageDialog::BUTTONS_OK_CANCEL,
                                      "The text you entered was not found. Wrap arround?")
      ret = dialog.run
      dialog.destroy
      if ret == Gtk::Dialog::RESPONSE_OK
        search(target_name, @model.iter_first)
      else
        @search_entry.grab_focus
      end
    end
    
    private
    def build_tree
      @model.clear
      freeze_notify
      root = @model.append(nil)
      root.set_value(0, _("<root>"))
      root.set_value(1, nil)
      append_children(root, Object)
      
      root_module_iter = @model.append(root)
      root_module_iter.set_value(0, _("<modules>"))
      root_module_iter.set_value(1, nil)
      
      root_modules = (@dag.roots - [Object]).sort{|x, y| x.inspect <=> y.inspect}
      root_modules.each do |root_module|
        append_children(root_module_iter, root_module)
      end

      selection.signal_connect("changed") do |e|
        iter = selection.selected
        if iter
	  klass = iter.get_value(1)
	  if Module === klass
	    changed
	    notify_observers(klass)
	  end
        end
      end
      
      expand_row(root.path, false)
      thaw_notify
    end
    
    def append_children(titer, klass)
      return if klass.inspect =~ /^(RBBR|ReFe|RI)(::)?/
      child_iter = @model.append(titer)
      child_iter.set_value(0, klass.inspect)
      child_iter.set_value(1, klass)
      subclasses = @dag.arc(klass)
      subclasses.sort{|x, y| x.inspect <=> y.inspect}.each do |c|
        append_children(child_iter, c)
      end
    end
end

end;end;end
