/*
   +----------------------------------------------------------------------+
   | Turck MMCache for PHP Version 4                                      |
   +----------------------------------------------------------------------+
   | Copyright (c) 2002-2003 TurckSoft, St. Petersburg                    |
   | http://www.turcksoft.com                                             |
   +----------------------------------------------------------------------+
   | This program is free software; you can redistribute it and/or        |
   | modify it under the terms of the GNU General Public License          |
   | as published by the Free Software Foundation; either version 2       |
   | of the License, or (at your option) any later version.               |
   |                                                                      |
   | This program is distributed in the hope that it will be useful,      |
   | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
   | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        |
   | GNU General Public License for more details.                         |
   |                                                                      |
   | You should have received a copy of the GNU General Public License    |
   | along with this program; if not, write to the Free Software          |
   | Foundation, Inc., 59 Temple Place - Suite 330, Boston,               |
   | MA  02111-1307, USA.                                                 |
   |                                                                      |
   | A copy is availble at http://www.gnu.org/copyleft/gpl.txt            |
   +----------------------------------------------------------------------+
   | Author: Dmitry Stogov <mmcache@turckware.ru>                         |
   +----------------------------------------------------------------------+
   $Id: mmcache.h,v 1.44 2003/10/28 13:50:11 dstogov Exp $
*/

#ifndef INCLUDED_MMCACHE_H
#define INCLUDED_MMCACHE_H

#include "php.h"
#include "zend.h"
#include "zend_API.h"
#include "zend_extensions.h"

#ifndef ZEND_WIN32
#  if ZEND_MODULE_API_NO >= 20001222
#    include "config.h"
#  else
#    include "php_config.h"
#  endif
#endif

#ifndef ZEND_WIN32
/* UnDefine if your filesystem doesn't support inodes */
#  define MMCACHE_USE_INODE
#endif

/* Define some of the following macros if you like to debug Turck MMCache */
/*#define DEBUG*/
/*#define TEST_PERFORMANCE*/
/*#define PROFILE_OPCODES*/

#ifdef WITH_MMCACHE_CRASH_DETECTION
#  include <signal.h>
#endif

#if defined(DEBUG) || defined(TEST_PERFORMANCE)  || defined(PROFILE_OPCODES)
/* Here you can chage debuging log filename */
#define DEBUG_LOGFILE     "/var/log/httpd/mmcache_log"
#define DEBUG_LOGFILE_CGI "/tmp/mmcache_log"
#endif

#define MMCACHE_MM_FILE "/tmp/mmcache"

#ifdef HAVE_MMCACHE
/*
 * Where to cache
 */
typedef enum _mmcache_cache_place {
  mmcache_shm_and_disk, /* in shm and in disk */
  mmcache_shm,          /* in shm, but if it is not possible then on disk */
  mmcache_shm_only,     /* in shm only  */
  mmcache_disk_only,    /* on disk only */
  mmcache_none          /* don't cache  */
} mmcache_cache_place;

extern mmcache_cache_place mmcache_content_cache_place;

unsigned int mmcache_crc32(const char *p, size_t n);
int mmcache_put(const char* key, int key_len, zval* val, time_t ttl, mmcache_cache_place where TSRMLS_DC);
int mmcache_get(const char* key, int key_len, zval* return_value, mmcache_cache_place where  TSRMLS_DC);
int mmcache_rm(const char* key, int key_len, mmcache_cache_place where  TSRMLS_DC);
size_t mmcache_gc(TSRMLS_D);
#  ifdef WITH_MMCACHE_EXECUTOR
ZEND_DLEXPORT void mmcache_execute(zend_op_array *op_array TSRMLS_DC);
#  endif
#  ifdef WITH_MMCACHE_OPTIMIZER
void mmcache_optimize(zend_op_array *op_array);
#  endif
#ifdef WITH_MMCACHE_ENCODER
PHP_FUNCTION(mmcache_encode);
#endif
#ifdef WITH_MMCACHE_LOADER
zend_op_array* mmcache_load(char* src, int src_len TSRMLS_DC);
PHP_FUNCTION(mmcache_load);
PHP_FUNCTION(_mmcache_loader_file);
PHP_FUNCTION(_mmcache_loader_line);
#endif
#ifdef WITH_MMCACHE_CONTENT_CACHING
void mmcache_content_cache_startup();
void mmcache_content_cache_shutdown();

PHP_FUNCTION(_mmcache_output_handler);
PHP_FUNCTION(mmcache_cache_page);
PHP_FUNCTION(mmcache_rm_page);
PHP_FUNCTION(mmcache_cache_output);
PHP_FUNCTION(mmcache_cache_result);
#endif
#endif

/*
 * conditional filter
 */
typedef struct _mm_cond_entry {
  char     *str;
  int       len;
  zend_bool not;
  struct  _mm_cond_entry  *next;
} mm_cond_entry;

/*
 * Globals (different for each process/thread)
 */
ZEND_BEGIN_MODULE_GLOBALS(mmcache)
  void          *used_entries;     /* list of files which are used     */
                                   /* by process/thread                */
  zend_bool     enabled;
  zend_bool     optimizer_enabled;
  zend_bool     compression_enabled;
  zend_bool     compiler;
  zend_bool     encoder;
  zend_bool     compress;
  zend_bool     compress_content;
  zend_bool     in_request;
  zend_llist*   content_headers;
  char          *cache_dir;
  char          *mem;
  HashTable     strings;
  zend_class_entry *class_entry;
  mm_cond_entry *cond_list;
  zend_uint      refcount_helper;
  char          hostname[32];
#ifdef WITH_MMCACHE_CRASH_DETECTION
#ifdef SIGSEGV
  void (*original_sigsegv_handler)(int);
#endif
#ifdef SIGFPE
  void (*original_sigfpe_handler)(int);
#endif
#ifdef SIGBUS
  void (*original_sigbus_handler)(int);
#endif
#ifdef SIGILL
  void (*original_sigill_handler)(int);
#endif
#ifdef SIGABRT
  void (*original_sigabrt_handler)(int);
#endif
#endif
#if defined(DEBUG) || defined(TEST_PERFORMANCE)  || defined(PROFILE_OPCODES)
  int  xpad;
#endif
#ifdef WITH_MMCACHE_SESSIONS
  char *session;
#endif
#ifdef PROFILE_OPCODES
  int  profile_level;
  long self_time[256];
#endif
ZEND_END_MODULE_GLOBALS(mmcache)

ZEND_EXTERN_MODULE_GLOBALS(mmcache)

#ifdef ZTS
#  define MMCG(v) TSRMG(mmcache_globals_id, zend_mmcache_globals*, v)
#else
#  define MMCG(v) (mmcache_globals.v)
#endif

#define MMCACHE_EXTENSION_NAME "Turck MMCache"
#define MMCACHE_LOADER_EXTENSION_NAME "Turck Loader"

#endif /*#ifndef INCLUDED_MMCACHE_H*/
