#ifndef TERMS_H
#define TERMS_H

extern int LINES, COLS;

#define CODE_ASCII	'\0'
#define CODE_EUC	'E'
#define CODE_SJIS	'S'
#define CODE_JIS_n	'n'
#define CODE_JIS_m	'm'
#define CODE_JIS_N	'N'
#define CODE_JIS_j	'j'
#define CODE_JIS_J	'J'
#define CODE_INNER_EUC	'I'
#define CODE_UNKNOWN	'U'

#define STR_ASCII	"US_ASCII"
#define STR_EUC		"EUC-JP"
#define STR_SJIS	"Shift_JIS"
#define STR_JIS_n	"ISO-2022-JP (JIS X 0208 + US_ASCII)"
#define STR_JIS_m	"ISO-2022-JP (JIS C 6226 + US_ASCII)"
#define STR_JIS_N	"ISO-2022-JP (JIS X 0208 + JIS X 0201)"
#define STR_JIS_j	"ISO-2022-JP (JIS C 6226 + JIS X 0201)"
#define STR_JIS_J	"ISO-2022-JP (JIS C 6226 + '\033(H')"
#define STR_INNER_EUC	"EUC-JP (internal)"

#define CODE_JIS(x) ((x)==CODE_JIS_n||(x)==CODE_JIS_m||(x)==CODE_JIS_N||(x)==CODE_JIS_j||(x)==CODE_JIS_J)

#ifdef HAVE_MOE

enum {
  GETCH_MODE_CLR = 1,
  GETCH_MODE_RST,
  GETCH_MODE_SKIP,
};

#define ZERO_WIDTH_SPACE 0x200B
#define ZERO_WIDTH_SPACE_STRING "&#x200B;"

enum {
  tty_char_conv_none,
  tty_char_conv_done,
  tty_char_conv_short,
};

enum {
  tty_wcwidth_none,
  tty_wcwidth_0,
  tty_wcwidth_1,
  tty_wcwidth_2,
};

#define TTY_WCWIDTH_BIT (2)
#define TTY_WCWIDTH_MASK (~(~0U << TTY_WCWIDTH_BIT))
#define TTY_WCWIDTH_MAX (TTY_WCWIDTH_MASK - tty_wcwidth_0)
#define TTY_WCWIDTH_LO_BIT (14)
#define TTY_WCWIDTH_LO_MASK (~(~0U << TTY_WCWIDTH_LO_BIT))
#define TTY_WCWIDTH_HI_BIT (MB_MBC_LEN_MAX * 6 - TTY_WCWIDTH_LO_BIT)
#define TTY_WCWIDTH_HI_MASK (~(~0U << TTY_WCWIDTH_HI_BIT))

#define TTY_CHAR_CONV_LEN_MAX (256)

#endif

#define CLEAR_READ_FD_KEEPHOOK (1U << 0)
#define CLEAR_READ_FD_KEEPFD (1U << 1)

#ifdef USE_MOUSE
/* Addition:mouse event */

/* unified (and unique!) mouse event codes. we need BTN1 to BTN5 to be
 * contiguous, because of how the keymap file is parsed. */
enum {
  MOUSE_BTN_RESET = -1,
  MOUSE_BTN1_DOWN,
  MOUSE_BTN2_DOWN,
  MOUSE_BTN3_DOWN,
  MOUSE_BTN4_DOWN,
  MOUSE_BTN5_DOWN,
  MOUSE_BTN_UP,
  /* not used outside of process_mouse() */
  MOUSE_BTN1_MOVE,
  MOUSE_BTN2_MOVE,
  MOUSE_BTN3_MOVE,
};

/* terminal-specific mouse codes follow */
#define MOUSE_BTN_UP_TERM 3    /* all terminals */

#define MOUSE_BTN1_MOVE_XTERM 32
#define MOUSE_BTN2_MOVE_XTERM 33
#define MOUSE_BTN3_MOVE_XTERM 34
#define MOUSE_BTN4_DOWN_XTERM 64
#define MOUSE_BTN5_DOWN_XTERM 65

#define MOUSE_BTN4_DOWN_RXVT 3
#define MOUSE_BTN5_DOWN_RXVT 4

#ifdef __CYGWIN__
extern int is_xterm;
#define NEED_CYGWIN_ON  (1<<2)
#define NEED_CYGWIN_OFF (1<<3)
#endif
#define NEED_XTERM_ON	(1)
#define NEED_XTERM_OFF	(1<<1)
#endif

#ifdef USE_IMAGE
#include "w3mimgdisplay.h"
#endif

#endif				/* not TERMS_H */
