/*
 *  Main module
 *
 *  1998/04/25
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <locale.h>
#include <ctype.h>
#include <signal.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Xatom.h>
#include <X11/Xresource.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "xyaku.h"
#include "xpopup.h"
#include "addin.h"


/* Global variables */
XtAppContext	app;
Display	*dpy;
AppResourcesRec appResources;	/* application specific resources */


/* Private function prototype */
static void usage(char *progname);
static void quit(void);
#if XtSpecificationRelease > 5
static void unix_sig_handler(int sig);
static void xt_sighup_handler(XtPointer client_data, XtSignalId *id);
#endif
static int x_error(Display *p_dpy, XErrorEvent *p_err);


/* application specific resources */
#define offset(field) XtOffset(struct _appRes *, field)
static XtResource      appResourceList[] = {
	{XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
	 offset(foreground_pixel),
	 XtRString, (XtPointer)XtDefaultForeground},
	{"fontSet", "FontSet", XtRFontSet, sizeof(XFontSet),
	 offset(fontset),
	 XtRString, (XtPointer)XtDefaultFontSet},
	{"configPath", "ConfigPath", XtRString, sizeof(String),
	 offset(confpath),
	 XtRImmediate, NULL},
	{"maxWidth", "MaxWidth", XtRDimension, sizeof(Dimension),
	 offset(max_width),
	 XtRDimension, 0},
	{"parseMsg", "ParseMsg", XtRInt, sizeof(int),
	 offset(parse_msg),
	 XtRInt, NULL},
};


/* application specific options */
static XrmOptionDescRec	options[] = {
	{"-config", "*configPath", XrmoptionSepArg, NULL},
	{"-parsemsg", "*parseMsg", XrmoptionSepArg, NULL},
};


/* resource fallbacks */
static String fallbacks[] = {
	"*background:	ivory1",
	"*borderWidth:	1",
	"*borderColor:	ivory2",
	"*overrideRedirect:	True",
	"*fontSet:		-*-fixed-medium-r-normal--14-*-iso8859-1,\
-*-fixed-medium-r-*--14-*-jisx0201.1976-0,\
-*-fixed-medium-r-*--14-*-jisx0208.1983-0",
	NULL,
};

static XtActionsRec actions[] = {
	{"quit",	(XtActionProc)quit}
};

#if XtSpecificationRelease > 5
/* I can pass closure to Xt signal handlers */
static XtSignalId xt_sighup;
#endif

int
main(int argc, char **argv)
{
	XPopup *xpop;
	Widget	pop_w;
	Atom	wm_delete_window;
	

	/* Initialize */
	XtSetLanguageProc(NULL, NULL, NULL);
	pop_w = XtVaAppInitialize(&app, "Xyaku", options, XtNumber(options), 
							  &argc, argv,
							  fallbacks,
							  XtNwidth, 1, XtNheight, 1,
							  NULL);
	if (argc != 1)
		usage(argv[0]);

	dpy = XtDisplay(pop_w);

	/* Get application resources */
	XtGetApplicationResources(pop_w, (XtPointer)&appResources,
							  appResourceList, XtNumber(appResourceList),
							  NULL, 0);
	
	/* Mainly, to avoid multiple XGrabKey request */
	XSetErrorHandler(x_error);

	/* Set passive keyboard grab */
	new_config_path(appResources.confpath);
	init_addin_info(appResources.parse_msg);

	/* Not mapped when realized */
	XtSetMappedWhenManaged(pop_w, FALSE);

	xpop = xpopup_new(pop_w, &appResources);

	/* To deal with WM */
	XtAppAddActions(app, actions, XtNumber(actions));
	XtOverrideTranslations(pop_w, XtParseTranslationTable("<Message>WM_PROTOCOLS: quit()"));
	wm_delete_window = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
	XSetWMProtocols(dpy, XtWindow(pop_w), &wm_delete_window, 1);

	/* Unix signal handler */
#if XtSpecificationRelease > 5
	signal(SIGHUP, unix_sig_handler);/* reload config file, and clear cache */
	xt_sighup = XtAppAddSignal(app, xt_sighup_handler, xpop);
#endif
	
	mainloop(xpop);

	return 0;
}


static void 
usage(char *progname)
{
	static char	*mesg =
		"usage: %s \n"
		"[toolkit options]\n"
		"[-config {rc-file}]	Specify config file(xyakurc) path\n"
		"[-parsemsg [1|0]]	Enable parser messages\n";

	fprintf(stderr,	mesg, progname);

	exit(0);
}


static void
quit(void)
{
	finalize_addin_info();
	delete_config_path();
	
	XtDestroyApplicationContext(app);
	exit(0);
}

/**
* unix_sig_handler:
* A handler of SIGHUP and SIGUSR1.
* SIGHUP: reload config file. clear cache(X11R6 only).
**/
static void
unix_sig_handler(int sig)
{
#if XtSpecificationRelease > 5
	if (sig == SIGHUP)
		XtNoticeSignal(xt_sighup);
#endif
}

#if XtSpecificationRelease > 5
static void
xt_sighup_handler(XtPointer client_data, XtSignalId *id)
{
	XPopup *xpop = client_data;
	
	refresh_addin_info();
	xpopup_set_addin_cmd(xpop, NULL, NULL, 0, 0, 0);
	xpopup_clear_cache(xpop);
}
#endif

#include <X11/Xproto.h>
static int
x_error(Display *p_dpy, XErrorEvent *p_err)
{
	char	err_message[256];

	XGetErrorText(dpy, p_err->error_code, err_message, sizeof(err_message));
	fprintf(stderr, "%s\n", err_message);

	/* Another program has already grabbed this keycode */
	if (p_err->request_code == X_GrabKey &&
		p_err->error_code == BadAccess) {
		fprintf(stderr, "Another process has already grabbed this keycode.\n");
	}

	XtDestroyApplicationContext(app);
	exit(1);
}
