/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#include <qcolor.h>

#include "kmtmessagewidget.h"


MessageWidget::MessageWidget(QWidget* parent, const char* name)
  : QTextEdit(parent, name)
{
  setReadOnly(true);
}

MessageWidget::~MessageWidget( )
{
}

void MessageWidget::appendMessage(const QString& str, QColor col)
{
  QColor oldColor = color( );
  setColor(col);
  append(str);
  setColor(oldColor);
  setCursorPosition(lines( ), 0);
}

// *******************************
// ***** SLOT implementation *****
// *******************************
void MessageWidget::slotMessage(const QString& msg)
{
  appendMessage(msg, color( ));
}

void MessageWidget::slotError(const QString& err)
{
  appendMessage(err, Qt::red);
}

#include "kmtmessagewidget.moc"
