/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "kmathtool.h"
#include "version.h"


static const char description[] =
  I18N_NOOP("KMathTool is a collection of little math tools.");

static KCmdLineOptions options[] =
{
  KCmdLineLastOption
};

int main(int argc, char **argv)
{
  KAboutData about("kmathtool", I18N_NOOP("KMathTool"), KMATHTOOL_VERSION,
    description, KAboutData::License_GPL, I18N_NOOP("(c) 2002-2003, The KMathTool developers"), 0,
    "http://edu.kde.org/kmathtool/");

  about.addAuthor("Birgit Schulz", I18N_NOOP("Original author"), "B.Schulz@Superlehrer.de");
  about.addAuthor("Marco Wegner", I18N_NOOP("Current maintainer"), "mail@marcowegner.de");

  about.setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names"),
    I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));

  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions(options);

  KApplication app;

  KMathTool* kmathtool = new KMathTool;
  app.setMainWidget(kmathtool);
  kmathtool->show( );

  return app.exec( );
}
